/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.standalone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.errors.AlreadyExistsException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.AbstractHerder;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.HerderConnectorContext;
import org.apache.kafka.connect.runtime.SinkConnectorConfig;
import org.apache.kafka.connect.runtime.SourceConnectorConfig;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.MemoryConfigBackingStore;
import org.apache.kafka.connect.storage.MemoryStatusBackingStore;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneHerder
extends AbstractHerder {
    private static final Logger log = LoggerFactory.getLogger(StandaloneHerder.class);
    private ClusterConfigState configState = ClusterConfigState.EMPTY;

    public StandaloneHerder(Worker worker) {
        this(worker, worker.workerId(), (StatusBackingStore)new MemoryStatusBackingStore(), new MemoryConfigBackingStore());
    }

    StandaloneHerder(Worker worker, String workerId, StatusBackingStore statusBackingStore, MemoryConfigBackingStore configBackingStore) {
        super(worker, workerId, statusBackingStore, configBackingStore);
        configBackingStore.setUpdateListener(new ConfigUpdateListener());
    }

    @Override
    public synchronized void start() {
        log.info("Herder starting");
        this.startServices();
        log.info("Herder started");
    }

    @Override
    public synchronized void stop() {
        log.info("Herder stopping");
        for (String connName : this.configState.connectors()) {
            this.removeConnectorTasks(connName);
            try {
                this.worker.stopConnector(connName);
            }
            catch (ConnectException e) {
                log.error("Error shutting down connector {}: ", (Object)connName, (Object)e);
            }
        }
        this.stopServices();
        log.info("Herder stopped");
    }

    @Override
    public int generation() {
        return 0;
    }

    @Override
    public synchronized void connectors(Callback<Collection<String>> callback) {
        callback.onCompletion(null, this.configState.connectors());
    }

    @Override
    public synchronized void connectorInfo(String connName, Callback<ConnectorInfo> callback) {
        ConnectorInfo connectorInfo = this.createConnectorInfo(connName);
        if (connectorInfo == null) {
            callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
            return;
        }
        callback.onCompletion(null, connectorInfo);
    }

    private ConnectorInfo createConnectorInfo(String connector) {
        if (!this.configState.contains(connector)) {
            return null;
        }
        Map<String, String> config = this.configState.connectorConfig(connector);
        return new ConnectorInfo(connector, config, this.configState.tasks(connector));
    }

    @Override
    public void connectorConfig(String connName, final Callback<Map<String, String>> callback) {
        this.connectorInfo(connName, new Callback<ConnectorInfo>(){

            @Override
            public void onCompletion(Throwable error, ConnectorInfo result) {
                if (error != null) {
                    callback.onCompletion(error, null);
                    return;
                }
                callback.onCompletion(null, result.config());
            }
        });
    }

    @Override
    public synchronized void putConnectorConfig(String connName, Map<String, String> config, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback) {
        try {
            boolean created = false;
            if (this.configState.contains(connName)) {
                if (!allowReplace) {
                    callback.onCompletion((Throwable)new AlreadyExistsException("Connector " + connName + " already exists"), null);
                    return;
                }
                if (config == null) {
                    this.removeConnectorTasks(connName);
                }
                this.worker.stopConnector(connName);
                if (config == null) {
                    this.configBackingStore.removeConnectorConfig(connName);
                    this.onDeletion(connName);
                }
            } else {
                if (config == null) {
                    callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found", null), null);
                    return;
                }
                created = true;
            }
            if (config != null) {
                this.startConnector(config);
                this.updateConnectorTasks(connName);
            }
            if (config != null) {
                callback.onCompletion(null, new Herder.Created<ConnectorInfo>(created, this.createConnectorInfo(connName)));
            } else {
                callback.onCompletion(null, new Herder.Created<Object>(false, null));
            }
        }
        catch (ConnectException e) {
            callback.onCompletion(e, null);
        }
    }

    @Override
    public synchronized void requestTaskReconfiguration(String connName) {
        if (!this.worker.connectorNames().contains(connName)) {
            log.error("Task that requested reconfiguration does not exist: {}", (Object)connName);
            return;
        }
        this.updateConnectorTasks(connName);
    }

    @Override
    public synchronized void taskConfigs(String connName, Callback<List<TaskInfo>> callback) {
        if (!this.configState.contains(connName)) {
            callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found", null), null);
            return;
        }
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
        for (ConnectorTaskId taskId : this.configState.tasks(connName)) {
            result.add(new TaskInfo(taskId, this.configState.taskConfig(taskId)));
        }
        callback.onCompletion(null, result);
    }

    @Override
    public void putTaskConfigs(String connName, List<Map<String, String>> configs, Callback<Void> callback) {
        throw new UnsupportedOperationException("Kafka Connect in standalone mode does not support externally setting task configurations.");
    }

    @Override
    public synchronized void restartTask(ConnectorTaskId taskId, Callback<Void> cb) {
        Map<String, String> taskConfig;
        if (!this.configState.contains(taskId.connector())) {
            cb.onCompletion((Throwable)new NotFoundException("Connector " + taskId.connector() + " not found", null), null);
        }
        if ((taskConfig = this.configState.taskConfig(taskId)) == null) {
            cb.onCompletion((Throwable)new NotFoundException("Task " + taskId + " not found", null), null);
        }
        TargetState targetState = this.configState.targetState(taskId.connector());
        try {
            this.worker.stopAndAwaitTask(taskId);
            this.worker.startTask(taskId, new TaskConfig(taskConfig), this, targetState);
            cb.onCompletion(null, null);
        }
        catch (Exception e) {
            log.error("Failed to restart task {}", (Object)taskId, (Object)e);
            cb.onCompletion(e, null);
        }
    }

    @Override
    public synchronized void restartConnector(String connName, Callback<Void> cb) {
        if (!this.configState.contains(connName)) {
            cb.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found", null), null);
        }
        Map<String, String> config = this.configState.connectorConfig(connName);
        try {
            this.worker.stopConnector(connName);
            this.startConnector(config);
            cb.onCompletion(null, null);
        }
        catch (Exception e) {
            log.error("Failed to restart connector {}", (Object)connName, (Object)e);
            cb.onCompletion(e, null);
        }
    }

    private String startConnector(Map<String, String> connectorProps) {
        ConnectorConfig connConfig = new ConnectorConfig(connectorProps);
        String connName = connConfig.getString("name");
        this.configBackingStore.putConnectorConfig(connName, connectorProps);
        TargetState targetState = this.configState.targetState(connName);
        this.worker.startConnector(connConfig, new HerderConnectorContext(this, connName), this, targetState);
        return connName;
    }

    private List<Map<String, String>> recomputeTaskConfigs(String connName) {
        Map<String, String> config = this.configState.connectorConfig(connName);
        if (this.worker.isSinkConnector(connName)) {
            SinkConnectorConfig connConfig = new SinkConnectorConfig(config);
            return this.worker.connectorTaskConfigs(connName, connConfig.getInt("tasks.max"), connConfig.getList("topics"));
        }
        SourceConnectorConfig connConfig = new SourceConnectorConfig(config);
        return this.worker.connectorTaskConfigs(connName, connConfig.getInt("tasks.max"), null);
    }

    private void createConnectorTasks(String connName, TargetState initialState) {
        for (ConnectorTaskId taskId : this.configState.tasks(connName)) {
            Map<String, String> taskConfigMap = this.configState.taskConfig(taskId);
            TaskConfig config = new TaskConfig(taskConfigMap);
            try {
                this.worker.startTask(taskId, config, this, initialState);
            }
            catch (Throwable e) {
                log.error("Failed to add task {}: ", (Object)taskId, (Object)e);
            }
        }
    }

    private void removeConnectorTasks(String connName) {
        List<ConnectorTaskId> tasks = this.configState.tasks(connName);
        if (!tasks.isEmpty()) {
            this.worker.stopTasks(tasks);
            this.worker.awaitStopTasks(tasks);
            this.configBackingStore.removeTaskConfigs(connName);
        }
    }

    private void updateConnectorTasks(String connName) {
        List<Map<String, String>> oldTaskConfigs;
        if (!this.worker.isRunning(connName)) {
            log.info("Skipping reconfiguration of connector {} since it is not running", (Object)connName);
            return;
        }
        List<Map<String, String>> newTaskConfigs = this.recomputeTaskConfigs(connName);
        if (!newTaskConfigs.equals(oldTaskConfigs = this.configState.allTaskConfigs(connName))) {
            this.removeConnectorTasks(connName);
            this.configBackingStore.putTaskConfigs(connName, newTaskConfigs);
            this.createConnectorTasks(connName, this.configState.targetState(connName));
        }
    }

    private class ConfigUpdateListener
    implements ConfigBackingStore.UpdateListener {
        private ConfigUpdateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorConfigRemove(String connector) {
            StandaloneHerder standaloneHerder = StandaloneHerder.this;
            synchronized (standaloneHerder) {
                StandaloneHerder.this.configState = StandaloneHerder.this.configBackingStore.snapshot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorConfigUpdate(String connector) {
            StandaloneHerder standaloneHerder = StandaloneHerder.this;
            synchronized (standaloneHerder) {
                StandaloneHerder.this.configState = StandaloneHerder.this.configBackingStore.snapshot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskConfigUpdate(Collection<ConnectorTaskId> tasks) {
            StandaloneHerder standaloneHerder = StandaloneHerder.this;
            synchronized (standaloneHerder) {
                StandaloneHerder.this.configState = StandaloneHerder.this.configBackingStore.snapshot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorTargetStateChange(String connector) {
            StandaloneHerder standaloneHerder = StandaloneHerder.this;
            synchronized (standaloneHerder) {
                StandaloneHerder.this.configState = StandaloneHerder.this.configBackingStore.snapshot();
                TargetState targetState = StandaloneHerder.this.configState.targetState(connector);
                StandaloneHerder.this.worker.setTargetState(connector, targetState);
                if (targetState == TargetState.STARTED) {
                    StandaloneHerder.this.updateConnectorTasks(connector);
                }
            }
        }
    }
}

