/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryOffsetBackingStore
implements OffsetBackingStore {
    private static final Logger log = LoggerFactory.getLogger(MemoryOffsetBackingStore.class);
    protected Map<ByteBuffer, ByteBuffer> data = new HashMap<ByteBuffer, ByteBuffer>();
    protected ExecutorService executor = Executors.newSingleThreadExecutor();

    @Override
    public void configure(WorkerConfig config) {
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop() {
    }

    @Override
    public Future<Map<ByteBuffer, ByteBuffer>> get(final Collection<ByteBuffer> keys, final Callback<Map<ByteBuffer, ByteBuffer>> callback) {
        return this.executor.submit(new Callable<Map<ByteBuffer, ByteBuffer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<ByteBuffer, ByteBuffer> call() throws Exception {
                HashMap<ByteBuffer, ByteBuffer> result = new HashMap<ByteBuffer, ByteBuffer>();
                MemoryOffsetBackingStore memoryOffsetBackingStore = MemoryOffsetBackingStore.this;
                synchronized (memoryOffsetBackingStore) {
                    for (ByteBuffer key : keys) {
                        result.put(key, MemoryOffsetBackingStore.this.data.get(key));
                    }
                }
                if (callback != null) {
                    callback.onCompletion(null, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> set(final Map<ByteBuffer, ByteBuffer> values, final Callback<Void> callback) {
        return this.executor.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                MemoryOffsetBackingStore memoryOffsetBackingStore = MemoryOffsetBackingStore.this;
                synchronized (memoryOffsetBackingStore) {
                    for (Map.Entry entry : values.entrySet()) {
                        MemoryOffsetBackingStore.this.data.put((ByteBuffer)entry.getKey(), (ByteBuffer)entry.getValue());
                    }
                    MemoryOffsetBackingStore.this.save();
                }
                if (callback != null) {
                    callback.onCompletion(null, null);
                }
                return null;
            }
        });
    }

    protected void save() {
    }
}

