/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r=e!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\f\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\t9\"$D\u0001\u0019\u0015\tIB!A\u0003vi&d7/\u0003\u0002\u001c1\t9Aj\\4hS:<\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0019\u0002\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#aA%oi\"1!\u0006\u0001Q\u0001\n\r\na\u0002\u001d:pIV\u001cWM]\"pk:$\b\u0005C\u0004-\u0001\t\u0007I\u0011\u0001\u0012\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u\u0011\u0019q\u0003\u0001)A\u0005G\u0005q1m\u001c8tk6,'oQ8v]R\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\tAI\u0001\fg\u0016\u0014h/\u001a:D_VtG\u000f\u0003\u00043\u0001\u0001\u0006IaI\u0001\rg\u0016\u0014h/\u001a:D_VtG\u000f\t\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0003\u0015!x\u000e]5d+\u00051\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0011a\u0017M\\4\u000b\u0003m\nAA[1wC&\u0011Q\b\u000f\u0002\u0007'R\u0014\u0018N\\4\t\r}\u0002\u0001\u0015!\u00037\u0003\u0019!x\u000e]5dA!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0013\u0001\u00029beRDaa\u0011\u0001!\u0002\u0013\u0019\u0013!\u00029beR\u0004\u0003bB#\u0001\u0005\u0004%\tAR\u0001\u0003iB,\u0012a\u0012\t\u0003\u0011:k\u0011!\u0013\u0006\u0003\u0015.\u000baaY8n[>t'BA\u0003M\u0015\tie\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u001f&\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004R\u0001\u0001\u0006IaR\u0001\u0004iB\u0004\u0003bB*\u0001\u0005\u0004%\tAI\u0001\u0006a\u0006\u0014HO\r\u0005\u0007+\u0002\u0001\u000b\u0011B\u0012\u0002\rA\f'\u000f\u001e\u001a!\u0011\u001d9\u0006A1A\u0005\u0002\u0019\u000b1\u0001\u001e93\u0011\u0019I\u0006\u0001)A\u0005\u000f\u0006!A\u000f\u001d\u001a!\u0011\u0015Y\u0006\u0001\"\u0011]\u0003\u0015\u0019X\r^+q)\u0005i\u0006C\u0001\u0013_\u0013\tyVE\u0001\u0003V]&$\bF\u0001.b!\t\u0011G-D\u0001d\u0015\tYa\"\u0003\u0002fG\n1!)\u001a4pe\u0016DQa\u001a\u0001\u0005\u0002q\u000bQ\u0003^3tiNKW\u000e\u001d7f\u0007>t7/^7qi&|g\u000e\u000b\u0002gSB\u0011!M[\u0005\u0003W\u000e\u0014A\u0001V3ti\")Q\u000e\u0001C\u00019\u0006IB/Z:u\u0003V$xnQ8n[&$xJ\u001c*fE\u0006d\u0017M\\2fQ\ta\u0017\u000eC\u0003q\u0001\u0011\u0005A,\u0001\u000euKN$8i\\7nSR\u001c\u0006/Z2jM&,Gm\u00144gg\u0016$8\u000f\u000b\u0002pS\")1\u000f\u0001C\u00019\u0006qA/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001c\bF\u0001:j\u0011\u00151\b\u0001\"\u0001]\u0003\u0005\"Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;DC2d'-Y2lQ\t)\u0018\u000eC\u0003z\u0001\u0011\u0005A,\u0001\u000buKN$XK\\:vEN\u001c'/\u001b2f)>\u0004\u0018n\u0019\u0015\u0003q&DQ\u0001 \u0001\u0005\u0002q\u000bQ\u0005^3tiB\u000bWo]3Ti\u0006$XMT8u!J,7/\u001a:wK\u0012\u0014\u0015PU3cC2\fgnY3)\u0005mLg!B@\u0001\u0011\u0005\u0005!\u0001\t+fgR\u001cuN\\:v[\u0016\u0014(+Z1tg&<g.\\3oi2K7\u000f^3oKJ\u001cRA`A\u0002\u0003\u0013\u00012aNA\u0003\u0013\r\t9\u0001\u000f\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005A1m\u001c8tk6,'OC\u0002\u0002\u0014-\u000bqa\u00197jK:$8/\u0003\u0003\u0002\u0018\u00055!!G\"p]N,X.\u001a:SK\n\fG.\u00198dK2K7\u000f^3oKJDa!\b@\u0005\u0002\u0005mACAA\u000f!\r\tyB`\u0007\u0002\u0001!A\u00111\u0005@A\u0002\u0013\u0005!%A\bdC2d7\u000fV8BgNLwM\\3e\u0011%\t9C a\u0001\n\u0003\tI#A\ndC2d7\u000fV8BgNLwM\\3e?\u0012*\u0017\u000fF\u0002^\u0003WA\u0011\"!\f\u0002&\u0005\u0005\t\u0019A\u0012\u0002\u0007a$\u0013\u0007C\u0004\u00022y\u0004\u000b\u0015B\u0012\u0002!\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012\u0004\u0003\u0002CA\u001b}\u0002\u0007I\u0011\u0001\u0012\u0002\u001d\r\fG\u000e\\:U_J+go\\6fI\"I\u0011\u0011\b@A\u0002\u0013\u0005\u00111H\u0001\u0013G\u0006dGn\u001d+p%\u00164xn[3e?\u0012*\u0017\u000fF\u0002^\u0003{A\u0011\"!\f\u00028\u0005\u0005\t\u0019A\u0012\t\u000f\u0005\u0005c\u0010)Q\u0005G\u0005y1-\u00197mgR{'+\u001a<pW\u0016$\u0007\u0005C\u0004\u0002Fy$\t!a\u0012\u0002)=t\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\ri\u0016\u0011\n\u0005\t\u0003\u0017\n\u0019\u00051\u0001\u0002N\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005=\u0013QK$\u000e\u0005\u0005E#bAA*u\u0005!Q\u000f^5m\u0013\u0011\t9&!\u0015\u0003\u0015\r{G\u000e\\3di&|g\u000eC\u0004\u0002\\y$\t!!\u0018\u0002'=t\u0007+\u0019:uSRLwN\\:SKZ|7.\u001a3\u0015\u0007u\u000by\u0006\u0003\u0005\u0002L\u0005e\u0003\u0019AA'\u0011\u001d\t\u0019\u0007\u0001C\t\u0003K\n1b]3oIJ+7m\u001c:egR\u0019Q,a\u001a\t\u000f\u0005%\u0014\u0011\ra\u0001G\u0005Qa.^7SK\u000e|'\u000fZ:\t\u000f\u0005\r\u0004\u0001\"\u0005\u0002nQ)Q,a\u001c\u0002r!9\u0011\u0011NA6\u0001\u0004\u0019\u0003BB#\u0002l\u0001\u0007q\tC\u0004\u0002d\u0001!\t\"!\u001e\u0015\u000fu\u000b9(!%\u0002\u0014\"A\u0011\u0011PA:\u0001\u0004\tY(\u0001\u0005qe>$WoY3s!!\ti(!!\u0002\u0006\u0006\u0015UBAA@\u0015\u0011\tI(!\u0005\n\t\u0005\r\u0015q\u0010\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b\u0011\n9)a#\n\u0007\u0005%UEA\u0003BeJ\f\u0017\u0010E\u0002%\u0003\u001bK1!a$&\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005%\u00141\u000fa\u0001G!1Q)a\u001dA\u0002\u001dCq!a&\u0001\t#\tI*A\fd_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:egR\tR,a'\u0002$\u0006\u0015\u0016\u0011VAW\u0003o\u000b9-!3\t\u0011\u0005=\u0011Q\u0013a\u0001\u0003;\u0003\u0002\"a\u0003\u0002 \u0006\u0015\u0015QQ\u0005\u0005\u0003C\u000biA\u0001\u0005D_:\u001cX/\\3s\u0011\u001d\tI'!&A\u0002\rBq!a*\u0002\u0016\u0002\u00071%\u0001\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\t\u0013\u0005-\u0016Q\u0013I\u0001\u0002\u0004\u0019\u0013\u0001G:uCJ$\u0018N\\4LKf\fe\u000e\u001a,bYV,\u0017J\u001c3fq\"Q\u0011qVAK!\u0003\u0005\r!!-\u0002#M$\u0018M\u001d;j]\u001e$\u0016.\\3ti\u0006l\u0007\u000fE\u0002%\u0003gK1!!.&\u0005\u0011auN\\4\t\u0015\u0005e\u0016Q\u0013I\u0001\u0002\u0004\tY,A\u0007uS6,7\u000f^1naRK\b/\u001a\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*\u0019\u0011\u0011Y%\u0002\rI,7m\u001c:e\u0013\u0011\t)-a0\u0003\u001bQKW.Z:uC6\u0004H+\u001f9f\u0011!)\u0015Q\u0013I\u0001\u0002\u00049\u0005\"CAf\u0003+\u0003\n\u00111\u0001$\u00039i\u0017\r\u001f)pY2\u0014VmY8sINDq!a4\u0001\t#\t\t.\u0001\bd_:\u001cX/\\3SK\u000e|'\u000fZ:\u0016\r\u0005M\u0017Q]A})!\t).!@\u0003\u0002\t\r\u0001CBA(\u0003/\fY.\u0003\u0003\u0002Z\u0006E#!C!se\u0006LH*[:u!!\tY!!8\u0002b\u0006]\u0018\u0002BAp\u0003\u001b\u0011abQ8ogVlWM\u001d*fG>\u0014H\r\u0005\u0003\u0002d\u0006\u0015H\u0002\u0001\u0003\t\u0003O\fiM1\u0001\u0002j\n\t1*\u0005\u0003\u0002l\u0006E\bc\u0001\u0013\u0002n&\u0019\u0011q^\u0013\u0003\u000f9{G\u000f[5oOB\u0019A%a=\n\u0007\u0005UXEA\u0002B]f\u0004B!a9\u0002z\u0012A\u00111`Ag\u0005\u0004\tIOA\u0001W\u0011!\ty!!4A\u0002\u0005}\b\u0003CA\u0006\u0003?\u000b\t/a>\t\u000f\u0005%\u0014Q\u001aa\u0001G!I\u00111ZAg!\u0003\u0005\ra\t\u0005\b\u0005\u000f\u0001A\u0011\u0003B\u0005\u0003M\tw/Y5u\u0007>lW.\u001b;DC2d'-Y2l+\u0019\u0011YAa\u0005\u0003\u0018Q9QL!\u0004\u0003\u001a\t\u0005\u0005\u0002CA\b\u0005\u000b\u0001\rAa\u0004\u0011\u0011\u0005-\u0011q\u0014B\t\u0005+\u0001B!a9\u0003\u0014\u0011A\u0011q\u001dB\u0003\u0005\u0004\tI\u000f\u0005\u0003\u0002d\n]A\u0001CA~\u0005\u000b\u0011\r!!;\t\u0011\tm!Q\u0001a\u0001\u0005;\tabY8n[&$8)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0002 \t}aA\u0002B\u0011\u0001!\u0011\u0019CA\u000eD_VtGoQ8ogVlWM]\"p[6LGoQ1mY\n\f7m[\n\u0007\u0005?\t\u0019A!\n\u0011\t\u0005-!qE\u0005\u0005\u0005S\tiA\u0001\u000bPM\u001a\u001cX\r^\"p[6LGoQ1mY\n\f7m\u001b\u0005\b;\t}A\u0011\u0001B\u0017)\t\u0011i\u0002C\u0005\u00032\t}\u0001\u0019!C\u0001E\u0005a1/^2dKN\u001c8i\\;oi\"Q!Q\u0007B\u0010\u0001\u0004%\tAa\u000e\u0002!M,8mY3tg\u000e{WO\u001c;`I\u0015\fHcA/\u0003:!I\u0011Q\u0006B\u001a\u0003\u0003\u0005\ra\t\u0005\t\u0005{\u0011y\u0002)Q\u0005G\u0005i1/^2dKN\u001c8i\\;oi\u0002B\u0011B!\u0011\u0003 \u0001\u0007I\u0011\u0001\u0012\u0002\u0013\u0019\f\u0017\u000e\\\"pk:$\bB\u0003B#\u0005?\u0001\r\u0011\"\u0001\u0003H\u0005ia-Y5m\u0007>,h\u000e^0%KF$2!\u0018B%\u0011%\tiCa\u0011\u0002\u0002\u0003\u00071\u0005\u0003\u0005\u0003N\t}\u0001\u0015)\u0003$\u0003)1\u0017-\u001b7D_VtG\u000f\t\u0005\t\u0005#\u0012y\u0002\"\u0011\u0003T\u0005QqN\\\"p[BdW\r^3\u0015\u000bu\u0013)F!\u001a\t\u0011\t]#q\na\u0001\u00053\nqa\u001c4gg\u0016$8\u000fE\u0004\u0002P\tmsIa\u0018\n\t\tu\u0013\u0011\u000b\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0006\u0005CJAAa\u0019\u0002\u000e\t\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u0011\t\u001d$q\na\u0001\u0005S\n\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\t\t-$1\u0010\b\u0005\u0005[\u00129H\u0004\u0003\u0003p\tUTB\u0001B9\u0015\r\u0011\u0019HB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019J1A!\u001f&\u0003\u001d\u0001\u0018mY6bO\u0016LAA! \u0003\u0000\tIQ\t_2faRLwN\u001c\u0006\u0004\u0005s*\u0003\"\u0003BB\u0005\u000b\u0001\n\u00111\u0001$\u0003\u0015\u0019w.\u001e8u\r\u0019\u00119\t\u0001\u0005\u0003\n\nA2i\u001c8tk6,'/Q:tS\u001etW.\u001a8u!>dG.\u001a:\u0014\t\t\u0015%1\u0012\t\u0004/\t5\u0015b\u0001BH1\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0011-\tyA!\"\u0003\u0002\u0003\u0006I!!(\t\u0017\tU%Q\u0011B\u0001B\u0003%!qS\u0001\u0012i>\u0004\u0018nY:U_N+(m]2sS\n,\u0007C\u0002B6\u00053\u0013i*\u0003\u0003\u0003\u001c\n}$\u0001\u0002'jgR\u0004BAa(\u0003&:\u0019AE!)\n\u0007\t\rV%\u0001\u0004Qe\u0016$WMZ\u0005\u0004{\t\u001d&b\u0001BRK!9QD!\"\u0005\u0002\t-FC\u0002BW\u0005_\u0013\t\f\u0005\u0003\u0002 \t\u0015\u0005\u0002CA\b\u0005S\u0003\r!!(\t\u0011\tU%\u0011\u0016a\u0001\u0005/C!B!.\u0003\u0006\u0002\u0007I\u0011\u0002B\\\u0003M\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8u+\t\u0011I\fE\u0003\u0003 \nmv)\u0003\u0003\u0003>\n\u001d&aA*fi\"Q!\u0011\u0019BC\u0001\u0004%IAa1\u0002/A\f'\u000f^5uS>t\u0017i]:jO:lWM\u001c;`I\u0015\fHcA/\u0003F\"Q\u0011Q\u0006B`\u0003\u0003\u0005\rA!/\t\u0013\t%'Q\u0011Q!\n\te\u0016\u0001\u00069beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\b\u0005\u000b\u0003\u0003H\n5\u0007c\u0001\u0013\u0003P&\u0019!\u0011[\u0013\u0003\u0011Y|G.\u0019;jY\u0016D!B!6\u0003\u0006\u0002\u0007I\u0011\u0002Bl\u0003I!x\u000e]5dgN+(m]2sSB$\u0018n\u001c8\u0016\u0005\t]\u0005B\u0003Bn\u0005\u000b\u0003\r\u0011\"\u0003\u0003^\u00061Bo\u001c9jGN\u001cVOY:de&\u0004H/[8o?\u0012*\u0017\u000fF\u0002^\u0005?D!\"!\f\u0003Z\u0006\u0005\t\u0019\u0001BL\u0011%\u0011\u0019O!\"!B\u0013\u00119*A\nu_BL7m]*vEN\u001c'/\u001b9uS>t\u0007\u0005\u0003\u0006\u0003h\n\u0015\u0005\u0019!C\u0005\u0005S\f1c];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\u0005.\u00198hK\u0012,\"Aa;\u0011\u0007\u0011\u0012i/C\u0002\u0003p\u0016\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0003t\n\u0015\u0005\u0019!C\u0005\u0005k\fqc];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\u0005.\u00198hK\u0012|F%Z9\u0015\u0007u\u00139\u0010\u0003\u0006\u0002.\tE\u0018\u0011!a\u0001\u0005WD\u0011Ba?\u0003\u0006\u0002\u0006KAa;\u0002)M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3!Q\u0011\u0011IP!4\t\u0015\r\u0005!Q\u0011b\u0001\n\u0003\u0019\u0019!A\tsK\n\fG.\u00198dK2K7\u000f^3oKJ,\"a!\u0002\u0013\r\r\u001d\u00111AA\u0005\r\u001d\u0019Iaa\u0003\u0001\u0007\u000b\u0011A\u0002\u0010:fM&tW-\\3oizB\u0011b!\u0004\u0003\u0006\u0002\u0006Ia!\u0002\u0002%I,'-\u00197b]\u000e,G*[:uK:,'\u000f\t\u0005\t\u0007#\u0011)\t\"\u0001\u0004\u0014\u0005\u00112m\u001c8tk6,'/Q:tS\u001etW.\u001a8u)\t\u0011I\f\u0003\u0005\u0004\u0018\t\u0015E\u0011AB\r\u0003%\u0019XOY:de&\u0014W\rF\u0002^\u00077A\u0001b!\b\u0004\u0016\u0001\u0007!qS\u0001\u0015]\u0016<Hk\u001c9jGN$vnU;cg\u000e\u0014\u0018NY3\t\u0011\r\u0005\"Q\u0011C\u0001\u0007G\t1$[:Tk\n\u001c8M]5cKJ+\u0017/^3tiB\u0013xnY3tg\u0016$GC\u0001Bv\u0011\u001d\u00199C!\"\u0005Bq\u000ba\u0001Z8X_J\\\u0007bBB\u0016\u0001\u0011\u00051QF\u0001\u001bSN\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8u-\u0006d\u0017\u000e\u001a\u000b\u0007\u0005W\u001cyca\u0011\t\u0011\rE2\u0011\u0006a\u0001\u0007g\t1\"Y:tS\u001etW.\u001a8ugB11QGB \u0005sk!aa\u000e\u000b\t\re21H\u0001\b[V$\u0018M\u00197f\u0015\r\u0019i$J\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB!\u0007o\u0011aAQ;gM\u0016\u0014\b\u0002CA&\u0007S\u0001\rA!/\t\u0013\r\u001d\u0003!%A\u0005\u0012\r%\u0013!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TCAB&U\r\u00193QJ\u0016\u0003\u0007\u001f\u0002Ba!\u0015\u0004\\5\u001111\u000b\u0006\u0005\u0007+\u001a9&A\u0005v]\u000eDWmY6fI*\u00191\u0011L\u0013\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004^\rM#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1\u0011\r\u0001\u0012\u0002\u0013E11M\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007KRC!!-\u0004N!I1\u0011\u000e\u0001\u0012\u0002\u0013E11N\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$HEN\u000b\u0003\u0007[RC!a/\u0004N!I1\u0011\u000f\u0001\u0012\u0002\u0013E11O\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u0007kR3aRB'\u0011%\u0019I\bAI\u0001\n#\u0019I%A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$\u0003\bC\u0005\u0004~\u0001\t\n\u0011\"\u0005\u0004\u0000\u0005i\u0012m^1ji\u000e{W.\\5u\u0007\u0006dGNY1dW\u0012\"WMZ1vYR$3'\u0006\u0004\u0004J\r\u000551\u0011\u0003\t\u0003O\u001cYH1\u0001\u0002j\u0012A\u00111`B>\u0005\u0004\tI\u000fC\u0005\u0004\b\u0002\t\n\u0011\"\u0005\u0004\n\u0006A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\r\r%31RBG\t!\t9o!\"C\u0002\u0005%H\u0001CA~\u0007\u000b\u0013\r!!;")
public abstract class BaseConsumerTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int part2;
    private final TopicPartition tp2;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return IntegrationTestHarness$class.generateConfigs(this);
    }

    @Override
    @After
    public void tearDown() {
        IntegrationTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        ((KafkaConsumer)this.consumers().apply(0)).seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().apply(0)).commitAsync((OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().apply(0), commitCallback, this.awaitCommitCallback$default$3());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int numRecords = 10000;
        this.sendRecords(numRecords);
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, consumer0){
            private final KafkaConsumer consumer0$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer0$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer0$1 = consumer0$1;
            }
        };
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$1;
            private final scala.collection.immutable.Set assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$1.poll(50L);
                java.util.Set set = this.consumer0$1.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$1 = consumer0$1;
                this.assignment$1 = assignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$1;
            private final scala.collection.immutable.Set newAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ConsumerRecords records = this.consumer0$1.poll(50L);
                java.util.Set set = this.consumer0$1.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$1 = consumer0$1;
                this.newAssignment$1 = newAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        Assert.assertEquals((long)300L, (long)consumer0.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)consumer0.committed(this.tp2()).offset());
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        this.sendRecords(5, this.tp());
        this.sendRecords(7, this.tp2());
        ((KafkaConsumer)this.consumers().apply(0)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).asJava());
        ((KafkaConsumer)this.consumers().apply(0)).poll(50L);
        long pos1 = ((KafkaConsumer)this.consumers().apply(0)).position(this.tp());
        long pos2 = ((KafkaConsumer)this.consumers().apply(0)).position(this.tp2());
        ((KafkaConsumer)this.consumers().apply(0)).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertNull((Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()));
        Assert.assertEquals((long)pos1, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp()));
        Assert.assertEquals((long)pos2, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp2()));
        ((KafkaConsumer)this.consumers().apply(0)).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertEquals((long)5L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().apply(0)).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(7L))}))).asJava(), (OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().apply(0), commitCallback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((long)7L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        java.util.Map topics = ((KafkaConsumer)this.consumers().head()).listTopics();
        Assert.assertNotNull((Object)topics);
        Assert.assertEquals((long)5L, (long)topics.size());
        Assert.assertEquals((long)5L, (long)topics.keySet().size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic1)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic2)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testPartitionReassignmentCallback() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        while (listener.callsToAssigned() == 0) {
            consumer0.poll(50L);
        }
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer0.partitionsFor("__consumer_offsets")).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.apply(0)).leader());
        int coordinator = ((PartitionInfo)parts.apply(0)).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        while (listener.callsToAssigned() < 2) {
            consumer0.poll(50L);
        }
        Assert.assertEquals((long)2L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)2L, (long)listener.callsToRevoked());
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        while (listener.callsToAssigned() == 0) {
            consumer0.poll(50L);
        }
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        this.sendRecords(5);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer0, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer0.pause((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic2"}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer0, 0, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    public void sendRecords(int numRecords) {
        this.sendRecords(numRecords, this.tp());
    }

    public void sendRecords(int numRecords, TopicPartition tp) {
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().apply(0)), numRecords, tp);
    }

    public void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes()));
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        });
        producer.flush();
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, startingKeyAndValueIndex, startingTimestamp, timestampType, tp, records, now){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final int startingKeyAndValueIndex$1;
            private final long startingTimestamp$1;
            private final TimestampType timestampType$1;
            private final TopicPartition tp$2;
            private final ArrayList records$1;
            private final long now$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.get(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.tp$2.topic(), (Object)record.topic());
                Assert.assertEquals((long)this.tp$2.partition(), (long)record.partition());
                TimestampType timestampType = this.timestampType$1;
                TimestampType timestampType2 = TimestampType.CREATE_TIME;
                if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                    Assert.assertEquals((Object)this.timestampType$1, (Object)record.timestampType());
                    long timestamp = this.startingTimestamp$1 + (long)i;
                    Assert.assertEquals((long)timestamp, (long)record.timestamp());
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)this.startingTimestamp$1), BoxesRunTime.boxToLong((long)this.now$1)})), (record.timestamp() >= this.startingTimestamp$1 && record.timestamp() <= this.now$1 ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)offset, (long)record.offset());
                int keyAndValueIndex = this.startingKeyAndValueIndex$1 + i;
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.startingKeyAndValueIndex$1 = startingKeyAndValueIndex$1;
                this.startingTimestamp$1 = startingTimestamp$1;
                this.timestampType$1 = timestampType$1;
                this.tp$2 = tp$2;
                this.records$1 = records$1;
                this.now$1 = now$1;
            }
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayList<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayList<ConsumerRecord<K, V>> records = new ArrayList<ConsumerRecord<K, V>>();
        int maxIters = numRecords * 300;
        int iters = 0;
        while (records.size() < numRecords) {
            Iterable polledRecords = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala();
            Assert.assertTrue((polledRecords.size() <= maxPollRecords ? 1 : 0) != 0);
            polledRecords.foreach((Function1)new Serializable(this, records){
                public static final long serialVersionUID = 0L;
                private final ArrayList records$2;

                public final boolean apply(ConsumerRecord<K, V> record) {
                    return this.records$2.add(record);
                }
                {
                    this.records$2 = records$2;
                }
            });
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Failed to consume the expected records after ").append((Object)BoxesRunTime.boxToInteger((int)iters)).append((Object)" iterations.").toString());
            }
            ++iters;
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void awaitCommitCallback(Consumer<K, V> consumer, CountConsumerCommitCallback commitCallback, int count) {
        long started = System.currentTimeMillis();
        while (commitCallback.successCount() < count && System.currentTimeMillis() - started < 10000L) {
            consumer.poll(50L);
        }
        Assert.assertEquals((long)count, (long)commitCallback.successCount());
    }

    public <K, V> int awaitCommitCallback$default$3() {
        return 1;
    }

    public boolean isPartitionAssignmentValid(Buffer<scala.collection.immutable.Set<TopicPartition>> assignments, scala.collection.immutable.Set<TopicPartition> partitions) {
        boolean allNonEmptyAssignments = assignments.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(scala.collection.immutable.Set<TopicPartition> assignment) {
                return assignment.size() > 0;
            }
        });
        if (allNonEmptyAssignments) {
            scala.collection.immutable.Set uniqueAssignedPartitions;
            int n = 0;
            int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, scala.collection.immutable.Set<TopicPartition> x$3) {
                    return x$2 + x$3.size();
                }
            }));
            if (totalPartitionsInAssignments != partitions.size()) {
                return false;
            }
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Set set2 = uniqueAssignedPartitions = (scala.collection.immutable.Set)assignments.$div$colon((Object)set, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Set<TopicPartition> apply(scala.collection.immutable.Set<TopicPartition> x$5, scala.collection.immutable.Set<TopicPartition> x$6) {
                    return (scala.collection.immutable.Set)x$5.$plus$plus(x$6);
                }
            });
            scala.collection.immutable.Set<TopicPartition> set3 = partitions;
            return !(set2 != null ? !set2.equals(set3) : set3 != null);
        }
        return false;
    }

    public BaseConsumerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.part2 = 1;
        this.tp2 = new TopicPartition(this.topic(), this.part2());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile scala.collection.immutable.Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private scala.collection.immutable.Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public scala.collection.immutable.Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subsribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(50L);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsAssigned called.";
                }
            });
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsRevoked called.";
                }
            });
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

