/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import kafka.coordinator.AwaitingSync$;
import kafka.coordinator.Dead$;
import kafka.coordinator.GroupMetadata;
import kafka.coordinator.GroupState;
import kafka.coordinator.MemberMetadata;
import kafka.coordinator.PreparingRebalance$;
import kafka.coordinator.Stable$;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001\u001d\u0011\u0011c\u0012:pkBlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0001\u0004%\t!G\u0001\u0006OJ|W\u000f]\u000b\u00025A\u0011acG\u0005\u00039\t\u0011Qb\u0012:pkBlU\r^1eCR\f\u0007b\u0002\u0010\u0001\u0001\u0004%\taH\u0001\nOJ|W\u000f]0%KF$\"\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bOu\t\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007S\u0001\u0001\u000b\u0015\u0002\u000e\u0002\r\u001d\u0014x.\u001e9!\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0015\u0019X\r^+q)\u0005\u0001\u0003F\u0001\u0016/!\ty\u0013'D\u00011\u0015\tYa\"\u0003\u00023a\t1!)\u001a4pe\u0016DQ\u0001\u000e\u0001\u0005\u00021\n!\u0004^3ti\u000e\u000bgNU3cC2\fgnY3XQ\u0016t7\u000b^1cY\u0016D#a\r\u001c\u0011\u0005=:\u0014B\u0001\u001d1\u0005\u0011!Vm\u001d;\t\u000bi\u0002A\u0011\u0001\u0017\u0002AQ,7\u000f^\"b]J+'-\u00197b]\u000e,w\u000b[3o\u0003^\f\u0017\u000e^5oONKhn\u0019\u0015\u0003sYBQ!\u0010\u0001\u0005\u00021\n\u0011\u0006^3ti\u000e\u000bgN\\8u%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,\u0007F\u0001\u001f7\u0011\u0015\u0001\u0005\u0001\"\u0001-\u0003m!Xm\u001d;DC:tw\u000e\u001e*fE\u0006d\u0017M\\2f/\",g\u000eR3bI\"\u0012qH\u000e\u0005\u0006\u0007\u0002!\t\u0001L\u0001)i\u0016\u001cHo\u0015;bE2,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u0003\u0005ZBQA\u0012\u0001\u0005\u00021\na\u0006^3ti\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2U_B\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+sC:\u001c\u0018\u000e^5p]\"\u0012QI\u000e\u0005\u0006\u0013\u0002!\t\u0001L\u0001'i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{G)Z1e)J\fgn]5uS>t\u0007F\u0001%7\u0011\u0015a\u0005\u0001\"\u0001-\u0003\t\"Xm\u001d;Bo\u0006LG/\u001b8h'ft7\rV8Ti\u0006\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\u00121J\u000e\u0005\u0006\u001f\u0002!\t\u0001L\u0001$i\u0016\u001cHo\u0015;bE2,Gk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\u0011qe'\u0015*\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA\u0001\\1oO*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005UIE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:DQ\u0001\u0018\u0001\u0005\u00021\n\u0011\u0006^3tiN#\u0018M\u00197f)>\fu/Y5uS:<7+\u001f8d\u00132dWmZ1m)J\fgn]5uS>t\u0007\u0006B.7#JCQa\u0018\u0001\u0005\u00021\n1\b^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\u0011qf'\u0015*\t\u000b\t\u0004A\u0011\u0001\u0017\u0002_Q,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\t\u00054\u0014K\u0015\u0005\u0006K\u0002!\t\u0001L\u00010i\u0016\u001cH/Q<bSRLgnZ*z]\u000e$v.Q<bSRLgnZ*z]\u000eLE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0005IZ\n&\u000bC\u0003i\u0001\u0011\u0005A&A\u0010uKN$H)Z1e)>$U-\u00193JY2,w-\u00197Ue\u0006t7/\u001b;j_:DCa\u001a\u001cR%\")1\u000e\u0001C\u0001Y\u0005\tC/Z:u\t\u0016\fG\rV8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\"!NN)S\u0011\u0015q\u0007\u0001\"\u0001-\u00035\"Xm\u001d;EK\u0006$Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0005[Z\n&\u000bC\u0003r\u0001\u0011\u0005A&A\u0014uKN$H)Z1e)>\fu/Y5uS:<7+\u001f8d\u00132dWmZ1m)J\fgn]5uS>t\u0007\u0006\u000297#JCQ\u0001\u001e\u0001\u0005\u00021\n!\u0003^3tiN+G.Z2u!J|Go\\2pY\"\u00121O\u000e\u0005\u0006o\u0002!\t\u0001L\u0001$i\u0016\u001cHoU3mK\u000e$\bK]8u_\u000e|GNU1jg\u0016\u001c\u0018J\u001a(p\u001b\u0016l'-\u001a:tQ\u00111h'\u0015*\t\u000bi\u0004A\u0011\u0001\u0017\u0002WQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\\\"i_>\u001cXm]\"p[B\fG/\u001b2mKB\u0013x\u000e^8d_2D#!\u001f\u001c\t\u000bu\u0004A\u0011\u0001\u0017\u0002+Q,7\u000f^*vaB|'\u000f^:Qe>$xnY8mg\"\u0012AP\u000e\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003-\t7o]3siN#\u0018\r^3\u0015\u000b\u0001\n)!a\u0002\t\u000bay\b\u0019\u0001\u000e\t\u000f\u0005%q\u00101\u0001\u0002\f\u0005YA/\u0019:hKR\u001cF/\u0019;f!\r1\u0012QB\u0005\u0004\u0003\u001f\u0011!AC$s_V\u00048\u000b^1uK\u0002")
public class GroupMetadataTest
extends JUnitSuite {
    private GroupMetadata group = null;

    public GroupMetadata group() {
        return this.group;
    }

    public void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", "consumer"));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenAwaitingSync() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testAwaitingSyncToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingSyncToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testStableToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingSyncToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String groupId = "groupId";
        String clientId = "clientId";
        String clientHost = "clientHost";
        int sessionTimeoutMs = 10000;
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, groupId, clientId, clientHost, sessionTimeoutMs, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(memberId, member);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, groupId, clientId, clientHost, sessionTimeoutMs, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(otherMemberId, otherMember);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, groupId, clientId, clientHost, sessionTimeoutMs, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(lastMemberId, lastMember);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        throw this.fail();
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String groupId = "groupId";
        String clientId = "clientId";
        String clientHost = "clientHost";
        int sessionTimeoutMs = 10000;
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, groupId, clientId, clientHost, sessionTimeoutMs, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, groupId, clientId, clientHost, sessionTimeoutMs, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(memberId, member);
        this.group().add(otherMemberId, otherMember);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        String groupId = "groupId";
        String clientId = "clientId";
        String clientHost = "clientHost";
        int sessionTimeoutMs = 10000;
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, groupId, clientId, clientHost, sessionTimeoutMs, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(memberId, member);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, groupId, clientId, clientHost, sessionTimeoutMs, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(otherMemberId, otherMember);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, AwaitingSync$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$1;

            public final void apply(GroupState otherState) {
                Assert.assertFalse((boolean)this.group$1.is(otherState));
            }
            {
                this.group$1 = group$1;
            }
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }
}

