/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.BaseMessageSetTestCases$class;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$H+Z:u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005]\u0011\u0015m]3NKN\u001c\u0018mZ3TKR$Vm\u001d;DCN,7\u000fC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u00111\u0003\u0001\u0005\u00067\u0001!\t\u0005H\u0001\u0011GJ,\u0017\r^3NKN\u001c\u0018mZ3TKR$\"!\b\u0011\u0011\u0005Mq\u0012BA\u0010\u0003\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\")\u0011E\u0007a\u0001E\u0005AQ.Z:tC\u001e,7\u000fE\u0002$[Ar!\u0001\n\u0016\u000f\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0011A\u0002\u001fs_>$h(C\u0001*\u0003\u0015\u00198-\u00197b\u0013\tYC&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003%J!AL\u0018\u0003\u0007M+\u0017O\u0003\u0002,YA\u00111#M\u0005\u0003e\t\u0011q!T3tg\u0006<W\rC\u00035\u0001\u0011\u0005Q'\u0001\buKN$h+\u00197jI\nKH/Z:\u0015\u0003Y\u0002\"a\u000e\u001d\u000e\u00031J!!\u000f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003gm\u0002\"\u0001\u0010 \u000e\u0003uR!a\u0003\b\n\u0005}j$\u0001\u0002+fgRDQ!\u0011\u0001\u0005\u0002U\nQ\u0004^3tiZ\u000bG.\u001b3CsR,7oV5uQ\u000e{W\u000e\u001d:fgNLwN\u001c\u0015\u0003\u0001nBQ\u0001\u0012\u0001\u0005\u0002U\n!\u0002^3ti\u0016\u000bX/\u00197tQ\t\u00195\bC\u0003H\u0001\u0011\u0005Q'\u0001\u0007uKN$\u0018\n^3sCR|'\u000f\u000b\u0002Gw!)!\n\u0001C\u0001k\u0005\u0001C/Z:u\u001b\u0016\u001c8/Y4f/&$\b\u000e\u0015:pm&$W\rZ(gMN,GoU3rQ\tI5\bC\u0003N\u0001\u0011\u0005Q'A\tuKN$Hj\\4BaB,g\u000e\u001a+j[\u0016D#\u0001T\u001e\t\u000bA\u0003A\u0011A\u001b\u0002\u001dQ,7\u000f^\"sK\u0006$X\rV5nK\"\u0012qj\u000f\u0005\u0006'\u0002!\t!N\u0001\u0016i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7fQ\t\u00116\bC\u0003W\u0001\u0011\u0005Q'\u0001\u000fuKN$\u0018IY:pYV$Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;)\u0005U[\u0004\"B-\u0001\t\u0003)\u0014\u0001\b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e\u001e\u0015\u00031nBQ\u0001\u0018\u0001\u0005\u0002U\n\u0001\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe6+7o]1hK\u001a{'/\\1u\u0007>tg/\u001a:tS>t\u0007FA.<\u0011\u0015y\u0006\u0001\"\u00016\u0003A!Xm\u001d;Xe&$XMR;mYf$v\u000e\u000b\u0002_w!)!\r\u0001C\u0001G\u0006y2\r[3dW^\u0013\u0018\u000e^3Gk2d\u0017\u0010V8XSRDW*Z:tC\u001e,7+\u001a;\u0015\u0005Y\"\u0007\"B3b\u0001\u0004i\u0012AC7fgN\fw-Z*fi\")q\r\u0001C\u0001Q\u0006a1\r[3dW>3gm]3ugR\u0019a'\u001b6\t\u000b\u00052\u0007\u0019A\u000f\t\u000b-4\u0007\u0019\u00017\u0002\u0015\t\f7/Z(gMN,G\u000f\u0005\u00028[&\u0011a\u000e\f\u0002\u0005\u0019>tw\rC\u0003q\u0001\u0011\u0005\u0011/A\u000bwKJLg-_*iC2dwn^%uKJ\fGo\u001c:\u0015\u0005Y\u0012\b\"B3p\u0001\u0004i\u0002\"\u0002;\u0001\t\u0013)\u0018aC4fi6+7o]1hKN$B!\b<|{\"9qo\u001dI\u0001\u0002\u0004A\u0018AC7bO&\u001cg+\u00197vKB\u0011q'_\u0005\u0003u2\u0012AAQ=uK\"9Ap\u001dI\u0001\u0002\u0004a\u0017!\u0003;j[\u0016\u001cH/Y7q\u0011\u001dq8\u000f%AA\u0002}\fQaY8eK\u000e\u00042aEA\u0001\u0013\r\t\u0019A\u0001\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eD\u0011\"a\u0002\u0001#\u0003%I!!\u0003\u0002+\u001d,G/T3tg\u0006<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0002\u0016\u0004q\u000651FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eA&\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u0005\u0002!%A\u0005\n\u0005\r\u0012!F4fi6+7o]1hKN$C-\u001a4bk2$HEM\u000b\u0003\u0003KQ3\u0001\\A\u0007\u0011%\tI\u0003AI\u0001\n\u0013\tY#A\u000bhKRlUm]:bO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00055\"fA@\u0002\u000e\u0001")
public class ByteBufferMessageSetTest
extends JUnitSuite
implements BaseMessageSetTestCases {
    private final Message[] messages;

    @Override
    public Message[] messages() {
        return this.messages;
    }

    @Override
    public void kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq(Message[] x$1) {
        this.messages = x$1;
    }

    @Override
    @Test
    public void testWrittenEqualsRead() {
        BaseMessageSetTestCases$class.testWrittenEqualsRead(this);
    }

    @Override
    @Test
    public void testIteratorIsConsistent() {
        BaseMessageSetTestCases$class.testIteratorIsConsistent(this);
    }

    @Override
    @Test
    public void testSizeInBytes() {
        BaseMessageSetTestCases$class.testSizeInBytes(this);
    }

    @Override
    @Test
    public void testWriteTo() {
        BaseMessageSetTestCases$class.testWriteTo(this);
    }

    @Override
    @Test
    public void testWriteToChannelThatConsumesPartially() {
        BaseMessageSetTestCases$class.testWriteToChannelThatConsumesPartially(this);
    }

    @Override
    public void checkWriteToWithMessageSet(MessageSet messageSet) {
        BaseMessageSetTestCases$class.checkWriteToWithMessageSet(this, messageSet);
    }

    @Override
    public void checkWriteWithMessageSet(MessageSet set, Function1<GatheringByteChannel, Object> write2) {
        BaseMessageSetTestCases$class.checkWriteWithMessageSet(this, set, write2);
    }

    public ByteBufferMessageSet createMessageSet(Seq<Message> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, messages2);
    }

    @Test
    public void testValidBytes() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages2.sizeInBytes() + 2);
        buffer.put(messages2.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (long)messages2.validBytes(), (long)messagesPlus.validBytes());
        Assert.assertEquals((String)"Valid bytes on an empty ByteBufferMessageSet should return 0", (long)0L, (long)MessageSet$.MODULE$.Empty().validBytes());
    }

    @Test
    public void testValidBytesWithCompression() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages2.sizeInBytes() + 2);
        buffer.put(messages2.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (long)messages2.validBytes(), (long)messagesPlus.validBytes());
    }

    @Test
    public void testEquals() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBufferMessageSet moreMessages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages2.equals((Object)moreMessages));
        messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        moreMessages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages2.equals((Object)moreMessages));
    }

    @Test
    public void testIterator() {
        List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("msg1".getBytes()), new Message("msg2".getBytes()), new Message("msg3".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        ByteBufferMessageSet messageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        this.verifyShallowIterator(messageSet2);
        Nil$ emptyMessageList = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)emptyMessageList);
        ByteBufferMessageSet regularMessgeSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer = ByteBuffer.allocate(emptyMessageSet.buffer().limit() + regularMessgeSet.buffer().limit());
        buffer.put(emptyMessageSet.buffer());
        buffer.put(regularMessgeSet.buffer());
        buffer.rewind();
        ByteBufferMessageSet mixedMessageSet = new ByteBufferMessageSet(buffer);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        Nil$ emptyMessageList2 = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)emptyMessageList2);
        ByteBufferMessageSet regularMessgeSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer2 = ByteBuffer.allocate(emptyMessageSet2.buffer().limit() + regularMessgeSet2.buffer().limit());
        buffer2.put(emptyMessageSet2.buffer());
        buffer2.put(regularMessgeSet2.buffer());
        buffer2.rewind();
        ByteBufferMessageSet mixedMessageSet2 = new ByteBufferMessageSet(buffer2);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        this.verifyShallowIterator(mixedMessageSet2);
    }

    @Test
    public void testMessageWithProvidedOffsetSeq() {
        Seq offsets = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 2L}));
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, offsets, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("goodbye".getBytes())}));
        Iterator iter = messages2.iterator();
        Assert.assertEquals((String)"first offset should be 0", (long)0L, (long)((MessageAndOffset)iter.next()).offset());
        Assert.assertEquals((String)"second offset should be 2", (long)2L, (long)((MessageAndOffset)iter.next()).offset());
    }

    @Test
    public void testLogAppendTime() {
        long startTime = System.currentTimeMillis();
        ByteBufferMessageSet messages2 = this.getMessages(Message$.MODULE$.MagicValue_V1(), 0L, (CompressionCodec)NoCompressionCodec$.MODULE$);
        byte x$1 = Message$.MODULE$.MagicValue_V0();
        DefaultCompressionCodec$ x$2 = DefaultCompressionCodec$.MODULE$;
        long x$3 = this.getMessages$default$2();
        ByteBufferMessageSet compressedMessagesWithRecompresion = this.getMessages(x$1, x$3, (CompressionCodec)x$2);
        ByteBufferMessageSet compressedMessagesWithoutRecompression = this.getMessages(Message$.MODULE$.MagicValue_V1(), -1L, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        kafka.common.LongRef x$4 = new kafka.common.LongRef(0L);
        long x$5 = System.currentTimeMillis();
        NoCompressionCodec$ x$6 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$7 = NoCompressionCodec$.MODULE$;
        byte x$8 = 1;
        TimestampType x$9 = TimestampType.LOG_APPEND_TIME;
        long x$10 = 1000L;
        boolean x$11 = messages2.validateMessagesAndAssignOffsets$default$5();
        Tuple2 tuple2 = messages2.validateMessagesAndAssignOffsets(x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$11, x$8, x$9, x$10);
        if (tuple2 != null) {
            ByteBufferMessageSet validatedMessages;
            ByteBufferMessageSet byteBufferMessageSet;
            ByteBufferMessageSet validatedMessages2 = byteBufferMessageSet = (validatedMessages = (ByteBufferMessageSet)tuple2._1());
            kafka.common.LongRef x$12 = new kafka.common.LongRef(0L);
            long x$13 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$14 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$15 = DefaultCompressionCodec$.MODULE$;
            byte x$16 = 1;
            TimestampType x$17 = TimestampType.LOG_APPEND_TIME;
            long x$18 = 1000L;
            boolean x$19 = compressedMessagesWithRecompresion.validateMessagesAndAssignOffsets$default$5();
            Tuple2 tuple22 = compressedMessagesWithRecompresion.validateMessagesAndAssignOffsets(x$12, x$13, (CompressionCodec)x$14, (CompressionCodec)x$15, x$19, x$16, x$17, x$18);
            if (tuple22 != null) {
                ByteBufferMessageSet validatedCompressedMessages;
                ByteBufferMessageSet byteBufferMessageSet2;
                ByteBufferMessageSet validatedCompressedMessages2 = byteBufferMessageSet2 = (validatedCompressedMessages = (ByteBufferMessageSet)tuple22._1());
                kafka.common.LongRef x$20 = new kafka.common.LongRef(0L);
                long x$21 = System.currentTimeMillis();
                DefaultCompressionCodec$ x$22 = DefaultCompressionCodec$.MODULE$;
                DefaultCompressionCodec$ x$23 = DefaultCompressionCodec$.MODULE$;
                byte x$24 = 1;
                TimestampType x$25 = TimestampType.LOG_APPEND_TIME;
                long x$26 = 1000L;
                boolean x$27 = compressedMessagesWithoutRecompression.validateMessagesAndAssignOffsets$default$5();
                Tuple2 tuple23 = compressedMessagesWithoutRecompression.validateMessagesAndAssignOffsets(x$20, x$21, (CompressionCodec)x$22, (CompressionCodec)x$23, x$27, x$24, x$25, x$26);
                if (tuple23 != null) {
                    ByteBufferMessageSet validatedCompressedMessagesWithoutRecompression;
                    ByteBufferMessageSet byteBufferMessageSet3;
                    ByteBufferMessageSet validatedCompressedMessagesWithoutRecompression2 = byteBufferMessageSet3 = (validatedCompressedMessagesWithoutRecompression = (ByteBufferMessageSet)tuple23._1());
                    long now = System.currentTimeMillis();
                    Assert.assertEquals((String)"message set size should not change", (long)messages2.size(), (long)validatedMessages2.size());
                    validatedMessages2.foreach((Function1)new Serializable(this, startTime, now){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ByteBufferMessageSetTest $outer;
                        private final long startTime$1;
                        private final long now$1;

                        public final void apply(MessageAndOffset messageAndOffset) {
                            this.$outer.kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(messageAndOffset.message(), this.startTime$1, this.now$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.startTime$1 = startTime$1;
                            this.now$1 = now$1;
                        }
                    });
                    Assert.assertEquals((String)"message set size should not change", (long)compressedMessagesWithRecompresion.size(), (long)validatedCompressedMessages2.size());
                    validatedCompressedMessages2.foreach((Function1)new Serializable(this, startTime, now){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ByteBufferMessageSetTest $outer;
                        private final long startTime$1;
                        private final long now$1;

                        public final void apply(MessageAndOffset messageAndOffset) {
                            this.$outer.kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(messageAndOffset.message(), this.startTime$1, this.now$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.startTime$1 = startTime$1;
                            this.now$1 = now$1;
                        }
                    });
                    Assert.assertTrue((String)"MessageSet should still valid", (boolean)((MessageAndOffset)validatedCompressedMessages2.shallowIterator().next()).message().isValid());
                    Assert.assertEquals((String)"message set size should not change", (long)compressedMessagesWithoutRecompression.size(), (long)validatedCompressedMessagesWithoutRecompression2.size());
                    validatedCompressedMessagesWithoutRecompression2.foreach((Function1)new Serializable(this, startTime, now){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ByteBufferMessageSetTest $outer;
                        private final long startTime$1;
                        private final long now$1;

                        public final void apply(MessageAndOffset messageAndOffset) {
                            this.$outer.kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(messageAndOffset.message(), this.startTime$1, this.now$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.startTime$1 = startTime$1;
                            this.now$1 = now$1;
                        }
                    });
                    Assert.assertTrue((String)"MessageSet should still valid", (boolean)((MessageAndOffset)validatedCompressedMessagesWithoutRecompression2.shallowIterator().next()).message().isValid());
                    return;
                }
                throw new MatchError((Object)tuple23);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testCreateTime() {
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messages2 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)NoCompressionCodec$.MODULE$);
        ByteBufferMessageSet compressedMessages = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        kafka.common.LongRef x$28 = new kafka.common.LongRef(0L);
        long x$29 = System.currentTimeMillis();
        NoCompressionCodec$ x$30 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$31 = NoCompressionCodec$.MODULE$;
        byte x$32 = 1;
        TimestampType x$33 = TimestampType.CREATE_TIME;
        long x$34 = 1000L;
        boolean x$35 = messages2.validateMessagesAndAssignOffsets$default$5();
        Tuple2 tuple2 = messages2.validateMessagesAndAssignOffsets(x$28, x$29, (CompressionCodec)x$30, (CompressionCodec)x$31, x$35, x$32, x$33, x$34);
        if (tuple2 != null) {
            ByteBufferMessageSet validatedMessages;
            ByteBufferMessageSet byteBufferMessageSet;
            ByteBufferMessageSet validatedMessages2 = byteBufferMessageSet = (validatedMessages = (ByteBufferMessageSet)tuple2._1());
            kafka.common.LongRef x$36 = new kafka.common.LongRef(0L);
            long x$37 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$38 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$39 = DefaultCompressionCodec$.MODULE$;
            byte x$40 = 1;
            TimestampType x$41 = TimestampType.CREATE_TIME;
            long x$42 = 1000L;
            boolean x$43 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
            Tuple2 tuple22 = compressedMessages.validateMessagesAndAssignOffsets(x$36, x$37, (CompressionCodec)x$38, (CompressionCodec)x$39, x$43, x$40, x$41, x$42);
            if (tuple22 != null) {
                ByteBufferMessageSet validatedCompressedMessages;
                ByteBufferMessageSet byteBufferMessageSet2;
                ByteBufferMessageSet validatedCompressedMessages2 = byteBufferMessageSet2 = (validatedCompressedMessages = (ByteBufferMessageSet)tuple22._1());
                validatedMessages2.foreach((Function1)new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final long now$2;

                    public final void apply(MessageAndOffset messageAndOffset) {
                        messageAndOffset.message().ensureValid();
                        Assert.assertEquals((long)messageAndOffset.message().timestamp(), (long)this.now$2);
                        Assert.assertEquals((Object)messageAndOffset.message().timestampType(), (Object)TimestampType.CREATE_TIME);
                    }
                    {
                        this.now$2 = now$2;
                    }
                });
                validatedCompressedMessages2.foreach((Function1)new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final long now$2;

                    public final void apply(MessageAndOffset messageAndOffset) {
                        messageAndOffset.message().ensureValid();
                        Assert.assertEquals((long)messageAndOffset.message().timestamp(), (long)this.now$2);
                        Assert.assertEquals((Object)messageAndOffset.message().timestampType(), (Object)TimestampType.CREATE_TIME);
                    }
                    {
                        this.now$2 = now$2;
                    }
                });
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testInvalidCreateTime() {
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messages2 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now - 1001L, (CompressionCodec)NoCompressionCodec$.MODULE$);
        ByteBufferMessageSet compressedMessages = this.getMessages(Message$.MODULE$.MagicValue_V1(), now - 1001L, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        try {
            kafka.common.LongRef x$44 = new kafka.common.LongRef(0L);
            long x$45 = System.currentTimeMillis();
            NoCompressionCodec$ x$46 = NoCompressionCodec$.MODULE$;
            NoCompressionCodec$ x$47 = NoCompressionCodec$.MODULE$;
            byte x$48 = 1;
            TimestampType x$49 = TimestampType.CREATE_TIME;
            long x$50 = 1000L;
            boolean x$51 = messages2.validateMessagesAndAssignOffsets$default$5();
            messages2.validateMessagesAndAssignOffsets(x$44, x$45, (CompressionCodec)x$46, (CompressionCodec)x$47, x$51, x$48, x$49, x$50);
            throw this.fail("Should throw InvalidMessageException.");
        }
        catch (InvalidTimestampException invalidTimestampException) {
            try {
                kafka.common.LongRef x$52 = new kafka.common.LongRef(0L);
                long x$53 = System.currentTimeMillis();
                DefaultCompressionCodec$ x$54 = DefaultCompressionCodec$.MODULE$;
                DefaultCompressionCodec$ x$55 = DefaultCompressionCodec$.MODULE$;
                byte x$56 = 1;
                TimestampType x$57 = TimestampType.CREATE_TIME;
                long x$58 = 1000L;
                boolean x$59 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
                compressedMessages.validateMessagesAndAssignOffsets(x$52, x$53, (CompressionCodec)x$54, (CompressionCodec)x$55, x$59, x$56, x$57, x$58);
                throw this.fail("Should throw InvalidMessageException.");
            }
            catch (InvalidTimestampException invalidTimestampException2) {
                return;
            }
        }
    }

    @Test
    public void testAbsoluteOffsetAssignment() {
        byte x$60 = Message$.MODULE$.MagicValue_V0();
        NoCompressionCodec$ x$61 = NoCompressionCodec$.MODULE$;
        long x$62 = this.getMessages$default$2();
        ByteBufferMessageSet messages2 = this.getMessages(x$60, x$62, (CompressionCodec)x$61);
        byte x$63 = Message$.MODULE$.MagicValue_V0();
        DefaultCompressionCodec$ x$64 = DefaultCompressionCodec$.MODULE$;
        long x$65 = this.getMessages$default$2();
        ByteBufferMessageSet compressedMessages = this.getMessages(x$63, x$65, (CompressionCodec)x$64);
        this.checkOffsets(messages2, 0L);
        int offset = 1234567;
        kafka.common.LongRef x$66 = new kafka.common.LongRef((long)offset);
        long x$67 = System.currentTimeMillis();
        NoCompressionCodec$ x$68 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$69 = NoCompressionCodec$.MODULE$;
        byte x$70 = 0;
        TimestampType x$71 = TimestampType.CREATE_TIME;
        long x$72 = 1000L;
        boolean x$73 = messages2.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets((ByteBufferMessageSet)messages2.validateMessagesAndAssignOffsets(x$66, x$67, (CompressionCodec)x$68, (CompressionCodec)x$69, x$73, x$70, x$71, x$72)._1(), offset);
        this.checkOffsets(compressedMessages, 0L);
        kafka.common.LongRef x$74 = new kafka.common.LongRef((long)offset);
        long x$75 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$76 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$77 = DefaultCompressionCodec$.MODULE$;
        byte x$78 = 0;
        TimestampType x$79 = TimestampType.CREATE_TIME;
        long x$80 = 1000L;
        boolean x$81 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets((ByteBufferMessageSet)compressedMessages.validateMessagesAndAssignOffsets(x$74, x$75, (CompressionCodec)x$76, (CompressionCodec)x$77, x$81, x$78, x$79, x$80)._1(), offset);
    }

    @Test
    public void testRelativeOffsetAssignment() {
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messages2 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)NoCompressionCodec$.MODULE$);
        ByteBufferMessageSet compressedMessages = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        this.checkOffsets(messages2, 0L);
        int offset = 1234567;
        kafka.common.LongRef x$82 = new kafka.common.LongRef((long)offset);
        long x$83 = System.currentTimeMillis();
        NoCompressionCodec$ x$84 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$85 = NoCompressionCodec$.MODULE$;
        TimestampType x$86 = TimestampType.CREATE_TIME;
        long x$87 = 5000L;
        boolean x$88 = messages2.validateMessagesAndAssignOffsets$default$5();
        byte x$89 = messages2.validateMessagesAndAssignOffsets$default$6();
        Tuple2 tuple2 = messages2.validateMessagesAndAssignOffsets(x$82, x$83, (CompressionCodec)x$84, (CompressionCodec)x$85, x$88, x$89, x$86, x$87);
        if (tuple2 != null) {
            ByteBufferMessageSet messageWithOffset;
            ByteBufferMessageSet byteBufferMessageSet;
            ByteBufferMessageSet messageWithOffset2 = byteBufferMessageSet = (messageWithOffset = (ByteBufferMessageSet)tuple2._1());
            this.checkOffsets(messageWithOffset2, offset);
            this.checkOffsets(compressedMessages, 0L);
            kafka.common.LongRef x$90 = new kafka.common.LongRef((long)offset);
            long x$91 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$92 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$93 = DefaultCompressionCodec$.MODULE$;
            TimestampType x$94 = TimestampType.CREATE_TIME;
            long x$95 = 5000L;
            boolean x$96 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
            byte x$97 = compressedMessages.validateMessagesAndAssignOffsets$default$6();
            Tuple2 tuple22 = compressedMessages.validateMessagesAndAssignOffsets(x$90, x$91, (CompressionCodec)x$92, (CompressionCodec)x$93, x$96, x$97, x$94, x$95);
            if (tuple22 != null) {
                ByteBufferMessageSet compressedMessagesWithOffset;
                ByteBufferMessageSet byteBufferMessageSet2;
                ByteBufferMessageSet compressedMessagesWithOffset2 = byteBufferMessageSet2 = (compressedMessagesWithOffset = (ByteBufferMessageSet)tuple22._1());
                this.checkOffsets(compressedMessagesWithOffset2, offset);
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testOffsetAssignmentAfterMessageFormatConversion() {
        byte x$98 = Message$.MODULE$.MagicValue_V0();
        NoCompressionCodec$ x$99 = NoCompressionCodec$.MODULE$;
        long x$100 = this.getMessages$default$2();
        ByteBufferMessageSet messagesV0 = this.getMessages(x$98, x$100, (CompressionCodec)x$99);
        byte x$101 = Message$.MODULE$.MagicValue_V0();
        DefaultCompressionCodec$ x$102 = DefaultCompressionCodec$.MODULE$;
        long x$103 = this.getMessages$default$2();
        ByteBufferMessageSet compressedMessagesV0 = this.getMessages(x$101, x$103, (CompressionCodec)x$102);
        this.checkOffsets(messagesV0, 0L);
        int offset = 1234567;
        kafka.common.LongRef x$104 = new kafka.common.LongRef((long)offset);
        long x$105 = System.currentTimeMillis();
        NoCompressionCodec$ x$106 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$107 = NoCompressionCodec$.MODULE$;
        byte x$108 = 1;
        TimestampType x$109 = TimestampType.LOG_APPEND_TIME;
        long x$110 = 1000L;
        boolean x$111 = messagesV0.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets((ByteBufferMessageSet)messagesV0.validateMessagesAndAssignOffsets(x$104, x$105, (CompressionCodec)x$106, (CompressionCodec)x$107, x$111, x$108, x$109, x$110)._1(), offset);
        this.checkOffsets(compressedMessagesV0, 0L);
        kafka.common.LongRef x$112 = new kafka.common.LongRef((long)offset);
        long x$113 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$114 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$115 = DefaultCompressionCodec$.MODULE$;
        byte x$116 = 1;
        TimestampType x$117 = TimestampType.LOG_APPEND_TIME;
        long x$118 = 1000L;
        boolean x$119 = compressedMessagesV0.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets((ByteBufferMessageSet)compressedMessagesV0.validateMessagesAndAssignOffsets(x$112, x$113, (CompressionCodec)x$114, (CompressionCodec)x$115, x$119, x$116, x$117, x$118)._1(), offset);
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messagesV1 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)NoCompressionCodec$.MODULE$);
        ByteBufferMessageSet compressedMessagesV1 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        this.checkOffsets(messagesV1, 0L);
        kafka.common.LongRef x$120 = new kafka.common.LongRef((long)offset);
        long x$121 = System.currentTimeMillis();
        NoCompressionCodec$ x$122 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$123 = NoCompressionCodec$.MODULE$;
        byte x$124 = 0;
        TimestampType x$125 = TimestampType.CREATE_TIME;
        long x$126 = 5000L;
        boolean x$127 = messagesV1.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets((ByteBufferMessageSet)messagesV1.validateMessagesAndAssignOffsets(x$120, x$121, (CompressionCodec)x$122, (CompressionCodec)x$123, x$127, x$124, x$125, x$126)._1(), offset);
        this.checkOffsets(compressedMessagesV1, 0L);
        kafka.common.LongRef x$128 = new kafka.common.LongRef((long)offset);
        long x$129 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$130 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$131 = DefaultCompressionCodec$.MODULE$;
        byte x$132 = 0;
        TimestampType x$133 = TimestampType.CREATE_TIME;
        long x$134 = 5000L;
        boolean x$135 = compressedMessagesV1.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets((ByteBufferMessageSet)compressedMessagesV1.validateMessagesAndAssignOffsets(x$128, x$129, (CompressionCodec)x$130, (CompressionCodec)x$131, x$135, x$132, x$133, x$134)._1(), offset);
    }

    @Test
    public void testWriteFullyTo() {
        this.checkWriteFullyToWithMessageSet(this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))));
        this.checkWriteFullyToWithMessageSet(this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages())));
    }

    public void checkWriteFullyToWithMessageSet(ByteBufferMessageSet messageSet) {
        this.checkWriteWithMessageSet((MessageSet)messageSet, (Function1<GatheringByteChannel, Object>)new Serializable(this, messageSet){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet messageSet$1;

            public final long apply(GatheringByteChannel channel) {
                return this.messageSet$1.writeFullyTo(channel);
            }
            {
                this.messageSet$1 = messageSet$1;
            }
        });
    }

    public void checkOffsets(ByteBufferMessageSet messages2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (messages2.size() > 0 ? 1 : 0) != 0);
        LongRef offset = LongRef.create((long)baseOffset);
        messages2.foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(MessageAndOffset entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    public void verifyShallowIterator(ByteBufferMessageSet messageSet) {
        Set shallowOffsets = messageSet.shallowIterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(MessageAndOffset msgAndOff) {
                return msgAndOff.offset();
            }
        }).toSet();
        Set deepOffsets = messageSet.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(MessageAndOffset msgAndOff) {
                return msgAndOff.offset();
            }
        }).toSet();
        Assert.assertTrue((boolean)shallowOffsets.subsetOf((GenSet)deepOffsets));
    }

    private ByteBufferMessageSet getMessages(byte magicValue, long timestamp, CompressionCodec codec) {
        return magicValue == Message$.MODULE$.MagicValue_V0() ? new ByteBufferMessageSet(codec, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0()), new Message("there".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0()), new Message("beautiful".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0())})) : new ByteBufferMessageSet(codec, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), timestamp, Message$.MODULE$.MagicValue_V1()), new Message("there".getBytes(), timestamp, Message$.MODULE$.MagicValue_V1()), new Message("beautiful".getBytes(), timestamp, Message$.MODULE$.MagicValue_V1())}));
    }

    private byte getMessages$default$1() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    private long getMessages$default$2() {
        return Message$.MODULE$.NoTimestamp();
    }

    private CompressionCodec getMessages$default$3() {
        return NoCompressionCodec$.MODULE$;
    }

    public final void kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(Message message, long startTime$1, long now$1) {
        message.ensureValid();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp of message ", " should be between ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, BoxesRunTime.boxToLong((long)startTime$1), BoxesRunTime.boxToLong((long)now$1)})), (message.timestamp() >= startTime$1 && message.timestamp() <= now$1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)message.timestampType());
    }

    public ByteBufferMessageSetTest() {
        BaseMessageSetTestCases$class.$init$(this);
    }
}

