/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.admin.ZkSecurityMigrator$;
import kafka.security.auth.ZkAuthorizationTest$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.ACL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001%\u00111CW6BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\t\u0005,H\u000f\u001b\u0006\u0003\u000b\u0019\t\u0001b]3dkJLG/\u001f\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u000b)i\u0001\"a\u0003\n\u000e\u00031Q!!\u0004\b\u0002\u000b),h.\u001b;\u000b\u0005=\u0001\u0012!C:dC2\fG/Z:u\u0015\u0005\t\u0012aA8sO&\u00111\u0003\u0004\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\tQ8.\u0003\u0002\u001a-\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003\tAqA\n\u0001C\u0002\u0013\u0005q%\u0001\u0005kC\u0006\u001ch)\u001b7f+\u0005A\u0003CA\u00150\u001d\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059Z\u0003BB\u001a\u0001A\u0003%\u0001&A\u0005kC\u0006\u001ch)\u001b7fA!9Q\u0007\u0001b\u0001\n\u00031\u0014\u0001D1vi\"\u0004&o\u001c<jI\u0016\u0014X#A\u001c\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u00021s!1q\b\u0001Q\u0001\n]\nQ\"Y;uQB\u0013xN^5eKJ\u0004\u0003\"B!\u0001\t\u0003\u0012\u0015!B:fiV\u0003H#A\"\u0011\u0005)\"\u0015BA#,\u0005\u0011)f.\u001b;)\u0005\u0001;\u0005C\u0001%K\u001b\u0005I%BA\u0007\u0011\u0013\tY\u0015J\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u001b\u0002!\tEQ\u0001\ti\u0016\f'\u000fR8x]\"\u0012Aj\u0014\t\u0003\u0011BK!!U%\u0003\u000b\u00053G/\u001a:\t\u000bM\u0003A\u0011\u0001\"\u0002/Q,7\u000f^%t5.\u001cVmY;sSRLXI\\1cY\u0016$\u0007F\u0001*V!\tAe+\u0003\u0002X\u0013\n!A+Z:u\u0011\u0015I\u0006\u0001\"\u0001C\u0003-!Xm\u001d;[WV#\u0018\u000e\\:)\u0005a+\u0006\"\u0002/\u0001\t\u0003\u0011\u0015a\u0004;fgRT6.T5he\u0006$\u0018n\u001c8)\u0005m+\u0006\"B0\u0001\t\u0003\u0011\u0015a\u0005;fgRT6.\u00118uS6KwM]1uS>t\u0007F\u00010V\u0011\u0015\u0011\u0007\u0001\"\u0001C\u0003)!Xm\u001d;EK2,G/\u001a\u0015\u0003CVCQ!\u001a\u0001\u0005\u0002\t\u000b1\u0003^3ti\u0012+G.\u001a;f%\u0016\u001cWO]:jm\u0016D#\u0001Z+\t\u000b!\u0004A\u0011A5\u0002\u0015Q,7\u000f^\"ie>|G/F\u0001DQ\t9W\u000bC\u0003m\u0001\u0011%Q.A\u0007uKN$X*[4sCRLwN\u001c\u000b\u0005\u0007:\u0004X\u000fC\u0003pW\u0002\u0007\u0001&A\u0003{WV\u0013H\u000eC\u0003rW\u0002\u0007!/A\u0004gSJ\u001cHOW6\u0011\u0005m\u0019\u0018B\u0001;\u001d\u0005\u001dQ6.\u0016;jYNDQA^6A\u0002I\f\u0001b]3d_:$'l\u001b\u0005\u0006q\u0002!I!_\u0001\u0007m\u0016\u0014\u0018NZ=\u0015\u0005il\bC\u0001\u0016|\u0013\ta8FA\u0004C_>dW-\u00198\t\u000by<\b\u0019\u0001\u0015\u0002\tA\fG\u000f\u001b\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u00031I7/Q2m\u0007>\u0014(/Z2u)\u0015Q\u0018QAA\u0015\u0011\u001d\t9a a\u0001\u0003\u0013\tA\u0001\\5tiB1\u00111BA\t\u0003+i!!!\u0004\u000b\u0007\u0005=1(\u0001\u0003vi&d\u0017\u0002BA\n\u0003\u001b\u0011A\u0001T5tiB!\u0011qCA\u0013\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00023bi\u0006TA!a\b\u0002\"\u0005I!p\\8lK\u0016\u0004XM\u001d\u0006\u0004\u0003G\u0001\u0012AB1qC\u000eDW-\u0003\u0003\u0002(\u0005e!aA!D\u0019\"1\u00111F@A\u0002i\faa]3dkJ,\u0007bBA\u0018\u0001\u0011%\u0011\u0011G\u0001\fSN\f5\r\\*fGV\u0014X\rF\u0002{\u0003gA\u0001\"!\u000e\u0002.\u0001\u0007\u0011QC\u0001\u0004C\u000ed\u0007bBA\u001d\u0001\u0011%\u00111H\u0001\u000eSN\f5\r\\+og\u0016\u001cWO]3\u0015\u0007i\fi\u0004\u0003\u0005\u00026\u0005]\u0002\u0019AA\u000b\u0011\u0019\t\t\u0005\u0001C\u0005\u0005\u0006\tB-\u001a7fi\u0016\fE\u000e\\+og\u0016\u001cWO]3\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H\u0005yA-\u001a7fi\u0016\u0014VmY;sg&4X\r\u0006\u0004\u0002J\u0005M\u0013q\u000b\t\u0006\u0003\u0017\nyE_\u0007\u0003\u0003\u001bR1!a\u0004,\u0013\u0011\t\t&!\u0014\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002V\u0005\r\u0003\u0019\u0001:\u0002\u000fi\\W\u000b^5mg\"1a0a\u0011A\u0002!\u0002")
public class ZkAuthorizationTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final String jaasFile;
    private final String authProvider;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZkAuthorizationTest zkAuthorizationTest = this;
        synchronized (zkAuthorizationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    @Override
    @Before
    public void setUp() {
        Configuration.setConfiguration(null);
        System.setProperty("java.security.auth.login.config", this.jaasFile());
        System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testIsZkSecurityEnabled() {
        Assert.assertTrue((boolean)JaasUtils.isZkSecurityEnabled());
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        Assert.assertFalse((boolean)JaasUtils.isZkSecurityEnabled());
        try {
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
            JaasUtils.isZkSecurityEnabled();
            throw this.fail("Should have thrown an exception");
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testZkUtils() {
        Assert.assertTrue((boolean)this.zkUtils().isSecure());
        this.zkUtils().persistentZkPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final void apply(String path) {
                ZkUtils qual$1 = this.$outer.zkUtils();
                String x$1 = path;
                List x$2 = qual$1.makeSurePersistentPathExists$default$2();
                qual$1.makeSurePersistentPathExists(x$1, x$2);
                if (!path.equals(ZkUtils$.MODULE$.ConsumersPath())) {
                    List aclList = (List)this.$outer.zkUtils().zkConnection().getAcl(path).getKey();
                    Assert.assertTrue((aclList.size() == 2 ? 1 : 0) != 0);
                    ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(aclList).asScala()).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ACL check$ifrefutable$1) {
                            ACL aCL = check$ifrefutable$1;
                            boolean bl = aCL != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testZkUtils$1 $outer;

                        public final void apply(ACL acl) {
                            Assert.assertTrue((boolean)this.$outer.kafka$security$auth$ZkAuthorizationTest$$anonfun$$$outer().kafka$security$auth$ZkAuthorizationTest$$isAclSecure(acl));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
            }

            public /* synthetic */ ZkAuthorizationTest kafka$security$auth$ZkAuthorizationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ZkUtils qual$2 = this.zkUtils();
        String x$3 = "/a";
        String x$4 = "";
        List x$5 = qual$2.createEphemeralPathExpectConflict$default$3();
        qual$2.createEphemeralPathExpectConflict(x$3, x$4, x$5);
        this.verify("/a");
        ZkUtils qual$3 = this.zkUtils();
        String x$6 = "/b";
        String x$7 = qual$3.createPersistentPath$default$2();
        List x$8 = qual$3.createPersistentPath$default$3();
        qual$3.createPersistentPath(x$6, x$7, x$8);
        this.verify("/b");
        ZkUtils qual$4 = this.zkUtils();
        String x$9 = "/c";
        String x$10 = "";
        List x$11 = qual$4.createSequentialPersistentPath$default$3();
        String seqPath = qual$4.createSequentialPersistentPath(x$9, x$10, x$11);
        this.verify(seqPath);
        ZkUtils qual$5 = this.zkUtils();
        String x$12 = "/a";
        String x$13 = "updated";
        List x$14 = qual$5.updateEphemeralPath$default$3();
        qual$5.updateEphemeralPath(x$12, x$13, x$14);
        String valueA = (String)this.zkUtils().zkClient().readData("/a");
        Assert.assertTrue((boolean)valueA.equals("updated"));
        ZkUtils qual$6 = this.zkUtils();
        String x$15 = "/b";
        String x$16 = "updated";
        List x$17 = qual$6.updatePersistentPath$default$3();
        qual$6.updatePersistentPath(x$15, x$16, x$17);
        String valueB = (String)this.zkUtils().zkClient().readData("/b");
        Assert.assertTrue((boolean)valueB.equals("updated"));
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leaving testZkUtils";
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkMigration() {
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);
        try {
            this.testMigration(this.zkConnect(), unsecureZkUtils, this.zkUtils());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        unsecureZkUtils.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkAntiMigration() {
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);
        try {
            this.testMigration(this.zkConnect(), this.zkUtils(), unsecureZkUtils);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        unsecureZkUtils.close();
    }

    @Test
    public void testDelete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.zkConnect()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{"--zookeeper.acl=secure", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()}))}));
        this.deleteAllUnsecure();
    }

    @Test
    public void testDeleteRecursive() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.zkConnect()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.zkUtils().securePersistentZkPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final void apply(String path) {
                this.$outer.info((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final String path$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$2}));
                    }
                    {
                        this.path$2 = path$2;
                    }
                });
                ZkUtils qual$7 = this.$outer.zkUtils();
                String x$18 = path;
                List x$19 = qual$7.makeSurePersistentPathExists$default$2();
                qual$7.makeSurePersistentPathExists(x$18, x$19);
                ZkUtils qual$8 = this.$outer.zkUtils();
                String x$20 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/fpjwashere"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
                String x$21 = "";
                List x$22 = qual$8.createPersistentPath$default$3();
                qual$8.createPersistentPath(x$20, x$21, x$22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.zkUtils().zkConnection().setAcl("/", this.zkUtils().DefaultAcls(), -1);
        this.deleteAllUnsecure();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testChroot() {
        String zkUrl = new StringBuilder().append((Object)this.zkConnect()).append((Object)"/kafka").toString();
        ZkUtils qual$9 = this.zkUtils();
        String x$23 = "/kafka";
        String x$24 = qual$9.createPersistentPath$default$2();
        List x$25 = qual$9.createPersistentPath$default$3();
        qual$9.createPersistentPath(x$23, x$24, x$25);
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(zkUrl, 6000, 6000, false);
        ZkUtils secureZkUtils = ZkUtils$.MODULE$.apply(zkUrl, 6000, 6000, true);
        try {
            this.testMigration(zkUrl, unsecureZkUtils, secureZkUtils);
        }
        catch (Throwable throwable) {
            void var7_7;
            void var6_6;
            var6_6.close();
            var7_7.close();
            throw throwable;
        }
        unsecureZkUtils.close();
        secureZkUtils.close();
    }

    private void testMigration(String zkUrl, ZkUtils firstZk, ZkUtils secondZk) {
        boolean bl;
        block4: {
            String string;
            block3: {
                block2: {
                    this.info((Function0<String>)new Serializable(this, zkUrl){
                        public static final long serialVersionUID = 0L;
                        private final String zkUrl$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkUrl$1}));
                        }
                        {
                            this.zkUrl$1 = zkUrl$1;
                        }
                    });
                    firstZk.securePersistentZkPaths().foreach((Function1)new Serializable(this, firstZk){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ZkAuthorizationTest $outer;
                        private final ZkUtils firstZk$1;

                        public final void apply(String path) {
                            this.$outer.info((Function0<String>)new Serializable(this, path){
                                public static final long serialVersionUID = 0L;
                                private final String path$3;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$3}));
                                }
                                {
                                    this.path$3 = path$3;
                                }
                            });
                            this.firstZk$1.makeSurePersistentPathExists(path, this.firstZk$1.makeSurePersistentPathExists$default$2());
                            this.firstZk$1.createPersistentPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/fpjwashere"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), "", this.firstZk$1.createPersistentPath$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.firstZk$1 = firstZk$1;
                        }
                    });
                    bl = secondZk.isSecure();
                    if (!bl) break block2;
                    firstZk.createPersistentPath(ZkUtils$.MODULE$.ConsumersPath(), firstZk.createPersistentPath$default$2(), firstZk.createPersistentPath$default$3());
                    string = "secure";
                    break block3;
                }
                if (bl) break block4;
                secondZk.createPersistentPath(ZkUtils$.MODULE$.ConsumersPath(), secondZk.createPersistentPath$default$2(), secondZk.createPersistentPath$default$3());
                string = "unsecure";
            }
            String secureOpt = string;
            ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.acl=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secureOpt})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkUrl}))}));
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Done with migration";
                }
            });
            secondZk.securePersistentZkPaths().foreach((Function1)new Serializable(this, secondZk){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkAuthorizationTest $outer;
                private final ZkUtils secondZk$1;

                public final void apply(String path) {
                    List listParent = (List)this.secondZk$1.zkConnection().getAcl(path).getKey();
                    Assert.assertTrue((String)path, (boolean)this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(listParent, this.secondZk$1.isSecure()));
                    String childPath = new StringBuilder().append((Object)path).append((Object)"/fpjwashere").toString();
                    List listChild = (List)this.secondZk$1.zkConnection().getAcl(childPath).getKey();
                    Assert.assertTrue((String)childPath, (boolean)this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(listChild, this.secondZk$1.isSecure()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.secondZk$1 = secondZk$1;
                }
            });
            List consumersAcl = (List)firstZk.zkConnection().getAcl(ZkUtils$.MODULE$.ConsumersPath()).getKey();
            Assert.assertTrue((String)ZkUtils$.MODULE$.ConsumersPath(), (boolean)this.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(consumersAcl, false));
            return;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private boolean verify(String path) {
        List list = (List)this.zkUtils().zkConnection().getAcl(path).getKey();
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final boolean apply(ACL acl) {
                return this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclSecure(acl);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(List<ACL> list, boolean secure) {
        boolean bl;
        block2: {
            boolean bl2;
            block7: {
                block3: {
                    boolean bl3;
                    block6: {
                        Object object;
                        IterableLike iterableLike;
                        block5: {
                            block4: {
                                boolean bl4;
                                block1: {
                                    block0: {
                                        bl = secure;
                                        if (!bl) break block0;
                                        bl4 = list.size() == 2;
                                        break block1;
                                    }
                                    if (bl) break block2;
                                    bl4 = list.size() == 1;
                                }
                                boolean isListSizeCorrect = bl4;
                                if (!isListSizeCorrect) break block3;
                                iterableLike = (IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala();
                                bl3 = secure;
                                if (!bl3) break block4;
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkAuthorizationTest $outer;

                                    public final boolean apply(ACL acl) {
                                        return this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclSecure(acl);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                };
                                break block5;
                            }
                            if (bl3) break block6;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ZkAuthorizationTest $outer;

                                public final boolean apply(ACL acl) {
                                    return this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclUnsecure(acl);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                        }
                        if (!iterableLike.forall((Function1)object)) break block3;
                        bl2 = true;
                        break block7;
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl3));
                }
                bl2 = false;
            }
            return bl2;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean kafka$security$auth$ZkAuthorizationTest$$isAclSecure(ACL acl) {
        boolean bl;
        this.info((Function0<String>)new Serializable(this, acl){
            public static final long serialVersionUID = 0L;
            private final ACL acl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.acl$1}));
            }
            {
                this.acl$1 = acl$1;
            }
        });
        int n = acl.getPerms();
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 31: {
                bl = acl.getId().getScheme().equals("sasl");
                break;
            }
            case 1: {
                bl = acl.getId().getScheme().equals("world");
            }
        }
        return bl;
    }

    public boolean kafka$security$auth$ZkAuthorizationTest$$isAclUnsecure(ACL acl) {
        boolean bl;
        this.info((Function0<String>)new Serializable(this, acl){
            public static final long serialVersionUID = 0L;
            private final ACL acl$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.acl$2}));
            }
            {
                this.acl$2 = acl$2;
            }
        });
        int n = acl.getPerms();
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 31: {
                bl = acl.getId().getScheme().equals("world");
            }
        }
        return bl;
    }

    private void deleteAllUnsecure() {
        System.setProperty("zookeeper.sasl.client", "false");
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);
        Try<Object> result = this.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(unsecureZkUtils, "/");
        unsecureZkUtils.close();
        System.clearProperty("zookeeper.sasl.client");
        Try<Object> try_ = result;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw this.fail(e.getMessage());
        }
        throw new MatchError(try_);
    }

    public Try<Object> kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(ZkUtils zkUtils, String path) {
        Try try_;
        this.info((Function0<String>)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
        ObjectRef result = ObjectRef.create((Object)new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        zkUtils.getChildren(path).foreach((Function1)new Serializable(this, zkUtils, path, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;
            private final ZkUtils zkUtils$1;
            private final String path$1;
            private final ObjectRef result$1;

            public final void apply(String child) {
                Try<Object> try_;
                block4: {
                    Try try_2;
                    block3: {
                        block2: {
                            String string = this.path$1;
                            Try<Object> try_3 = "/".equals(string) ? this.$outer.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(this.zkUtils$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{child}))) : this.$outer.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(this.zkUtils$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, child})));
                            try_ = try_3;
                            if (!(try_ instanceof Success)) break block2;
                            try_2 = (Try)this.result$1.elem;
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        try_2 = new Failure(e);
                    }
                    this.result$1.elem = try_2;
                    return;
                }
                throw new MatchError(try_);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.zkUtils$1 = zkUtils$1;
                this.path$1 = path$1;
                this.result$1 = result$1;
            }
        });
        String string = path;
        if ("/".equals(string)) {
            try_ = (Try)result.elem;
        } else {
            Try try_2;
            try {
                zkUtils.deletePath(string);
                try_2 = new Failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Have been able to delete ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}))));
            }
            catch (Exception exception) {
                try_2 = (Try)result.elem;
            }
            try_ = try_2;
        }
        return try_;
    }

    public ZkAuthorizationTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.jaasFile = JaasTestUtils$.MODULE$.writeZkFile();
        this.authProvider = "zookeeper.authProvider.1";
    }
}

