/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001\u001d\u00111#\u00123hK\u000e\u000b7/\u001a*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!\u0011\u0002CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\t9BC\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$A\bhK:,'/\u0019;f\u0007>tg-[4t)\u0005\u0001\u0003cA\u0011)U5\t!E\u0003\u0002$I\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003K\u0019\n!bY8mY\u0016\u001cG/[8o\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015#\u0005\u0011a\u0015n\u001d;\u0011\u0005qY\u0013B\u0001\u0017\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000b9\u0002A\u0011B\u0018\u0002\u0019M|7m[3u'\u0016\u0014h/\u001a:\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0003\u0002\u000f9,Go^8sW&\u0011QG\r\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\u0006o\u0001!I\u0001O\u0001\bG>tg.Z2u)\rI\u0014i\u0011\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n1A\\3u\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\rM{7m[3u\u0011\u001d\u0011e\u0007%AA\u0002A\n\u0011a\u001d\u0005\b\tZ\u0002\n\u00111\u0001F\u0003!\u0001(o\u001c;pG>d\u0007C\u0001$N\u001b\u00059%B\u0001#I\u0015\tI%*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b-S!\u0001\u0014\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tquI\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\")\u0001\u000b\u0001C\u0005#\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0011\u0011f\u000b\u00171\u0011\u0005M#V\"\u0001\u0014\n\u0005U3#\u0001B+oSRDQaV(A\u0002e\naa]8dW\u0016$\b\"B-P\u0001\u0004Q\u0016a\u0002:fcV,7\u000f\u001e\t\u0004'nk\u0016B\u0001/'\u0005\u0015\t%O]1z!\t\u0019f,\u0003\u0002`M\t!!)\u001f;f\u0011\u001d\tw\n%AA\u0002\t\f!!\u001b3\u0011\u0007M\u001bW-\u0003\u0002eM\t1q\n\u001d;j_:\u0004\"a\u00154\n\u0005\u001d4#!B*i_J$\b\"B5\u0001\t\u0013Q\u0017a\u0004:fG\u0016Lg/\u001a*fgB|gn]3\u0015\u0005i[\u0007\"B,i\u0001\u0004I\u0004\"B7\u0001\t\u0013q\u0017!\u0005:fcV,7\u000f^!oIJ+7-Z5wKR\u0019!l\u001c9\t\u000bec\u0007\u0019\u0001.\t\u000f\u0005d\u0007\u0013!a\u0001E\")!\u000f\u0001C\u0005g\u0006\u0011\"/Z9vKN$\b*Z1eKJ\u0014\u0015\u0010^3t)\u0019QFO\u001e=\u0002\u0004!)Q/\u001da\u0001K\u00061\u0011\r]5LKfDQa^9A\u0002\u0015\f!\"\u00199j-\u0016\u00148/[8o\u0011\u001dI\u0018\u000f%AA\u0002i\f\u0001b\u00197jK:$\u0018\n\u001a\t\u0003wzt!a\u0015?\n\u0005u4\u0013A\u0002)sK\u0012,g-C\u0002\u0000\u0003\u0003\u0011aa\u0015;sS:<'BA?'\u0011%\t)!\u001dI\u0001\u0002\u0004\t9!A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\t\u0004'\u0006%\u0011bAA\u0006M\t\u0019\u0011J\u001c;\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012\u0005\u0001b/\u001a:jMf$\u0015n]2p]:,7\r\u001e\u000b\u0004%\u0006M\u0001BB-\u0002\u000e\u0001\u0007!\fC\u0004\u0002\u0018\u0001!\t!!\u0007\u0002EQ,7\u000f\u001e)s_\u0012,8-\u001a*fcV,7\u000f^,ji\"tU\u000f\u001c7DY&,g\u000e^%e)\u0005\u0011\u0006\u0006BA\u000b\u0003;\u0001B!a\b\u0002$5\u0011\u0011\u0011\u0005\u0006\u0003\u00179IA!!\n\u0002\"\t!A+Z:u\u0011\u001d\tI\u0003\u0001C\u0001\u00033\tQ\u0003^3ti\"+\u0017\rZ3s\u001f:d\u0017PU3rk\u0016\u001cH\u000f\u000b\u0003\u0002(\u0005u\u0001bBA\u0018\u0001\u0011\u0005\u0011\u0011D\u0001\u0019i\u0016\u001cH/\u00138wC2LG-\u00119j\u0017\u0016L(+Z9vKN$\b\u0006BA\u0017\u0003;Aq!!\u000e\u0001\t\u0003\tI\"\u0001\u000fuKN$\u0018J\u001c<bY&$\u0017\t]5WKJ\u001c\u0018n\u001c8SKF,Xm\u001d;)\t\u0005M\u0012Q\u0004\u0005\b\u0003w\u0001A\u0011AA\r\u0003i!Xm\u001d;NC24wN]7fI\"+\u0017\rZ3s%\u0016\fX/Z:uQ\u0011\tI$!\b\t\u0013\u0005\u0005\u0003!%A\u0005\n\u0005\r\u0013!E2p]:,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\t\u0016\u0004a\u0005\u001d3FAA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Mc%\u0001\u0006b]:|G/\u0019;j_:LA!a\u0016\u0002N\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005m\u0003!%A\u0005\n\u0005u\u0013!E2p]:,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\f\u0016\u0004\u000b\u0006\u001d\u0003\"CA2\u0001E\u0005I\u0011BA3\u0003U\u0019XM\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM*\"!a\u001a+\u0007\t\f9\u0005C\u0005\u0002l\u0001\t\n\u0011\"\u0003\u0002f\u0005Y\"/Z9vKN$\u0018I\u001c3SK\u000e,\u0017N^3%I\u00164\u0017-\u001e7uIIB\u0011\"a\u001c\u0001#\u0003%I!!\u001d\u00029I,\u0017/^3ti\"+\u0017\rZ3s\u0005f$Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u000f\u0016\u0004u\u0006\u001d\u0003\"CA<\u0001E\u0005I\u0011BA=\u0003q\u0011X-];fgRDU-\u00193fe\nKH/Z:%I\u00164\u0017-\u001e7uIQ*\"!a\u001f+\t\u0005\u001d\u0011q\t")
public class EdgeCaseRequestTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    @TraitSetter
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    @TraitSetter
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        EdgeCaseRequestTest edgeCaseRequestTest = this;
        synchronized (edgeCaseRequestTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public List<KafkaConfig> generateConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(props)}));
    }

    private SocketServer socketServer() {
        return ((KafkaServer)this.servers().head()).socketServer();
    }

    private Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(protocol));
    }

    private SocketServer connect$default$1() {
        return this.socketServer();
    }

    private SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request, Option<Object> id) {
        Option<Object> option;
        block4: {
            DataOutputStream outgoing;
            block3: {
                block2: {
                    outgoing = new DataOutputStream(socket.getOutputStream());
                    option = id;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    short id2 = BoxesRunTime.unboxToShort((Object)some.x());
                    outgoing.writeInt(request.length + 2);
                    outgoing.writeShort(id2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                outgoing.writeInt(request.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            outgoing.write(request);
            outgoing.flush();
            return;
        }
        throw new MatchError(option);
    }

    private Option<Object> sendRequest$default$3() {
        return None$.MODULE$;
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] requestAndReceive(byte[] request, Option<Object> id) {
        byte[] byArray;
        Socket plainSocket = this.connect(this.connect$default$1(), this.connect$default$2());
        try {
            this.sendRequest(plainSocket, request, id);
            byArray = this.receiveResponse(plainSocket);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        plainSocket.close();
        return byArray;
    }

    private Option<Object> requestAndReceive$default$2() {
        return None$.MODULE$;
    }

    private byte[] requestHeaderBytes(short apiKey, short apiVersion, String clientId, int correlationId) {
        int size2 = 8 + Type.NULLABLE_STRING.sizeOf((Object)clientId);
        ByteBuffer buffer = ByteBuffer.allocate(size2);
        buffer.putShort(apiKey);
        buffer.putShort(apiVersion);
        buffer.putInt(correlationId);
        Type.NULLABLE_STRING.write(buffer, (Object)clientId);
        return buffer.array();
    }

    private String requestHeaderBytes$default$3() {
        return "";
    }

    private int requestHeaderBytes$default$4() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDisconnect(byte[] request) {
        Socket plainSocket = this.connect(this.connect$default$1(), this.connect$default$2());
        try {
            this.sendRequest(plainSocket, this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()), this.sendRequest$default$3());
            Assert.assertEquals((String)"The server should disconnect", (long)-1L, (long)plainSocket.getInputStream().read());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        plainSocket.close();
    }

    @Test
    public void testProduceRequestWithNullClientId() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int correlationId = -1;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        byte[] headerBytes = this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)2, null, correlationId);
        byte[] messageBytes = "message".getBytes();
        ProduceRequest request = new ProduceRequest(1, 10000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)ByteBuffer.wrap(messageBytes))}))).asJava());
        ByteBuffer byteBuffer = ByteBuffer.allocate(headerBytes.length + request.sizeOf());
        byteBuffer.put(headerBytes);
        request.writeTo(byteBuffer);
        byte[] serializedBytes = byteBuffer.array();
        byte[] response = this.requestAndReceive(serializedBytes, this.requestAndReceive$default$2());
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer);
        ProduceResponse produceResponse = ProduceResponse.parse((ByteBuffer)responseBuffer);
        Assert.assertEquals((String)"The response should parse completely", (long)0L, (long)responseBuffer.remaining());
        Assert.assertEquals((String)"The correlationId should match request", (long)correlationId, (long)responseHeader.correlationId());
        Assert.assertEquals((String)"One partition response should be returned", (long)1L, (long)produceResponse.responses().size());
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)produceResponse.responses().get(topicPartition);
        Assert.assertNotNull((Object)partitionResponse);
        Assert.assertEquals((String)"There should be no error", (long)0L, (long)partitionResponse.errorCode);
    }

    @Test
    public void testHeaderOnlyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiKeyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiVersionRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)-1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testMalformedHeaderRequest() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putShort(ApiKeys.PRODUCE.id);
        buffer.putShort((short)1);
        byte[] serializedBytes = buffer.array();
        this.verifyDisconnect(serializedBytes);
    }

    public EdgeCaseRequestTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
    }
}

