/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.BrokerMetadata;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001\u001d\u0011!dU3sm\u0016\u0014x)\u001a8fe\u0006$XM\u0011:pW\u0016\u0014\u0018\n\u001a+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!\u0011\u0002CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002\u00011A\u0005\u0002}\ta\u0001\u001d:paN\fT#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001B;uS2T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f%\u0002\u0001\u0019!C\u0001U\u0005Q\u0001O]8qgFzF%Z9\u0015\u0005-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#\u0001B+oSRDqA\r\u0015\u0002\u0002\u0003\u0007\u0001%A\u0002yIEBa\u0001\u000e\u0001!B\u0013\u0001\u0013a\u00029s_B\u001c\u0018\u0007\t\u0005\bm\u0001\u0001\r\u0011\"\u00018\u0003\u001d\u0019wN\u001c4jOF*\u0012\u0001\u000f\t\u00039eJ!A\u000f\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\by\u0001\u0001\r\u0011\"\u0001>\u0003-\u0019wN\u001c4jOFzF%Z9\u0015\u0005-r\u0004b\u0002\u001a<\u0003\u0003\u0005\r\u0001\u000f\u0005\u0007\u0001\u0002\u0001\u000b\u0015\u0002\u001d\u0002\u0011\r|gNZ5hc\u0001BqA\u0011\u0001A\u0002\u0013\u0005q$\u0001\u0004qe>\u00048O\r\u0005\b\t\u0002\u0001\r\u0011\"\u0001F\u0003)\u0001(o\u001c9te}#S-\u001d\u000b\u0003W\u0019CqAM\"\u0002\u0002\u0003\u0007\u0001\u0005\u0003\u0004I\u0001\u0001\u0006K\u0001I\u0001\baJ|\u0007o\u001d\u001a!\u0011\u001dQ\u0005\u00011A\u0005\u0002]\nqaY8oM&<'\u0007C\u0004M\u0001\u0001\u0007I\u0011A'\u0002\u0017\r|gNZ5he}#S-\u001d\u000b\u0003W9CqAM&\u0002\u0002\u0003\u0007\u0001\b\u0003\u0004Q\u0001\u0001\u0006K\u0001O\u0001\tG>tg-[43A!9!\u000b\u0001b\u0001\n\u0003\u0019\u0016a\u00052s_.,'/T3uCB\u0013x\u000e]:GS2,W#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]#\u0013\u0001\u00027b]\u001eL!!\u0017,\u0003\rM#(/\u001b8h\u0011\u0019Y\u0006\u0001)A\u0005)\u0006!\"M]8lKJlU\r^1Qe>\u00048OR5mK\u0002BQ!\u0018\u0001\u0005By\u000bQa]3u+B$\u0012a\u000b\u0015\u00039\u0002\u0004\"!Y2\u000e\u0003\tT!a\u0003\b\n\u0005\u0011\u0014'A\u0002\"fM>\u0014X\rC\u0003g\u0001\u0011\u0005a,\u0001\ruKN$\u0018)\u001e;p\u000f\u0016tWM]1uK\n\u0013xn[3s\u0013\u0012D#!\u001a5\u0011\u0005\u0005L\u0017B\u00016c\u0005\u0011!Vm\u001d;\t\u000b1\u0004A\u0011\u00010\u0002EQ,7\u000f^+tKJ\u001cuN\u001c4jO\u0006sGmR3oKJ\fG/\u001a3Ce>\\WM]%eQ\tY\u0007\u000eC\u0003p\u0001\u0011\u0005a,\u0001\u000fuKN$H)[:bE2,w)\u001a8fe\u0006$X\r\u001a\"s_.,'/\u00133)\u00059D\u0007\"\u0002:\u0001\t\u0003q\u0016\u0001\b;fgRlU\u000f\u001c;ja2,Gj\\4ESJ\u001cX*\u001a;b!J|\u0007o\u001d\u0015\u0003c\"DQ!\u001e\u0001\u0005\u0002y\u000b\u0001\u0007^3ti\u000e{gn]5ti\u0016tGO\u0011:pW\u0016\u0014\u0018\n\u001a$s_6,6/\u001a:D_:4\u0017nZ!oI6+G/\u0019)s_B\u001c\bF\u0001;i\u0011\u0015A\b\u0001\"\u0001_\u0003}!Xm\u001d;Ce>\\WM]'fi\u0006$\u0017\r^1P]&#7i\u001c7mSNLwN\u001c\u0015\u0003o\"DQa\u001f\u0001\u0005\u0002q\fAC^3sS\u001aL(I]8lKJlU\r^1eCR\fG#B?\u0002\u0002\u0005%\u0002C\u0001\u0017\u007f\u0013\tyXFA\u0004C_>dW-\u00198\t\u000f\u0005\r!\u00101\u0001\u0002\u0006\u00059An\\4ESJ\u001c\bCBA\u0004\u0003/\tiB\u0004\u0003\u0002\n\u0005Ma\u0002BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=a!\u0001\u0004=e>|GOP\u0005\u0002]%\u0019\u0011QC\u0017\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003+i\u0003\u0003BA\u0010\u0003Kq1\u0001LA\u0011\u0013\r\t\u0019#L\u0001\u0007!J,G-\u001a4\n\u0007e\u000b9CC\u0002\u0002$5Bq!a\u000b{\u0001\u0004\ti#\u0001\u0005ce>\\WM]%e!\ra\u0013qF\u0005\u0004\u0003ci#aA%oi\u0002")
public class ServerGenerateBrokerIdTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private Properties props1;
    private KafkaConfig config1;
    private Properties props2;
    private KafkaConfig config2;
    private final String brokerMetaPropsFile;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ServerGenerateBrokerIdTest serverGenerateBrokerIdTest = this;
        synchronized (serverGenerateBrokerIdTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Test
    public void testAutoGenerateBrokerId() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2);
        server1.startup();
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        server1 = new KafkaServer(this.config1(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3());
        server1.startup();
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server1.shutdown();
        CoreUtils$.MODULE$.delete(server1.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$4 = this.config1();
        Option x$5 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$6 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        KafkaServer server1 = new KafkaServer(x$4, x$6, x$5);
        KafkaConfig x$7 = this.config2();
        Option x$8 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$9 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        KafkaServer server2 = new KafkaServer(x$7, x$9, x$8);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        KafkaServer server3 = new KafkaServer(config3, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3());
        server1.startup();
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server2.startup();
        Assert.assertEquals((long)server2.config().brokerId(), (long)0L);
        server3.startup();
        Assert.assertEquals((long)server3.config().brokerId(), (long)1002L);
        server1.shutdown();
        server2.shutdown();
        server3.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        CoreUtils$.MODULE$.delete(server1.config().logDirs());
        CoreUtils$.MODULE$.delete(server2.config().logDirs());
        CoreUtils$.MODULE$.delete(server3.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testDisableGeneratedBrokerId() {
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        KafkaServer server3 = new KafkaServer(config3, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3());
        server3.startup();
        Assert.assertEquals((long)server3.config().brokerId(), (long)3L);
        server3.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        CoreUtils$.MODULE$.delete(server3.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder().append((Object)this.props1().getProperty("log.dir")).append((Object)",").append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).append((Object)",").append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$10 = this.config1();
        Option x$11 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$12 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        KafkaServer server1 = new KafkaServer(x$10, x$12, x$11);
        server1.startup();
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder().append((Object)this.props1().getProperty("log.dir")).append((Object)",").append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$13 = this.config1();
        Option x$14 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$15 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        server1 = new KafkaServer(x$13, x$15, x$14);
        server1.startup();
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        CoreUtils$.MODULE$.delete(server1.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$16 = this.config1();
        Option x$17 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$18 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        KafkaServer server1 = new KafkaServer(x$16, x$18, x$17);
        server1.startup();
        server1.shutdown();
        KafkaConfig x$19 = this.config2();
        Option x$20 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$21 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        server1 = new KafkaServer(x$19, x$21, x$20);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {
            // empty catch block
        }
        server1.shutdown();
        CoreUtils$.MODULE$.delete(server1.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testBrokerMetadataOnIdCollision() {
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        KafkaServer serverA = new KafkaServer(configA, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3());
        serverA.startup();
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        KafkaServer serverB = new KafkaServer(configB, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3());
        this.intercept((Function0)new Serializable(this, serverB){
            public static final long serialVersionUID = 0L;
            private final KafkaServer serverB$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.serverB$1.startup();
            }
            {
                this.serverB$1 = serverB$1;
            }
        }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
        serverB.config().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerGenerateBrokerIdTest $outer;

            public final void apply(String logDir) {
                File brokerMetaFile = new File(new StringBuilder().append((Object)logDir).append((Object)File.separator).append((Object)this.$outer.brokerMetaPropsFile()).toString());
                Assert.assertFalse((boolean)brokerMetaFile.exists());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig newConfigB = KafkaConfig$.MODULE$.fromProps(propsB);
        KafkaServer newServerB = new KafkaServer(newConfigB, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3());
        newServerB.startup();
        serverA.shutdown();
        newServerB.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)newServerB.config().logDirs(), 2));
        CoreUtils$.MODULE$.delete(serverA.config().logDirs());
        CoreUtils$.MODULE$.delete(newServerB.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                logDirs.foreach((Function1)new Serializable(this, brokerId, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ServerGenerateBrokerIdTest $outer;
                    private final int brokerId$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String logDir) {
                        Some some;
                        BrokerMetadata brokerMetadata;
                        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder().append((Object)logDir).append((Object)File.separator).append((Object)this.$outer.brokerMetaPropsFile()).toString())).read();
                        Option option = brokerMetadataOpt;
                        if (option instanceof Some && (brokerMetadata = (BrokerMetadata)(some = (Some)option).x()) != null) {
                            BrokerMetadata brokerMetadata2 = brokerMetadata;
                            if (brokerMetadata2.brokerId() != this.brokerId$1) {
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.brokerId$1 = brokerId$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public ServerGenerateBrokerIdTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.props1 = null;
        this.config1 = null;
        this.props2 = null;
        this.config2 = null;
        this.brokerMetaPropsFile = "meta.properties";
    }
}

