/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.util.Locale;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;

public class WordCountProcessorDemo {
    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.put("application.id", "streams-wordcount-processor");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("zookeeper.connect", "localhost:2181");
        props.put("key.serde", Serdes.String().getClass());
        props.put("value.serde", Serdes.String().getClass());
        props.put("auto.offset.reset", "earliest");
        TopologyBuilder builder = new TopologyBuilder();
        builder.addSource("Source", new String[]{"streams-file-input"});
        builder.addProcessor("Process", (ProcessorSupplier)new MyProcessorSupplier(), new String[]{"Source"});
        builder.addStateStore(Stores.create((String)"Counts").withStringKeys().withIntegerValues().inMemory().build(), new String[]{"Process"});
        builder.addSink("Sink", "streams-wordcount-processor-output", new String[]{"Process"});
        KafkaStreams streams = new KafkaStreams(builder, props);
        streams.start();
        Thread.sleep(5000L);
        streams.close();
    }

    private static class MyProcessorSupplier
    implements ProcessorSupplier<String, String> {
        private MyProcessorSupplier() {
        }

        public Processor<String, String> get() {
            return new Processor<String, String>(){
                private ProcessorContext context;
                private KeyValueStore<String, Integer> kvStore;

                public void init(ProcessorContext context) {
                    this.context = context;
                    this.context.schedule(1000L);
                    this.kvStore = (KeyValueStore)context.getStateStore("Counts");
                }

                public void process(String dummy, String line) {
                    String[] words;
                    for (String word : words = line.toLowerCase(Locale.getDefault()).split(" ")) {
                        Integer oldValue = (Integer)this.kvStore.get((Object)word);
                        if (oldValue == null) {
                            this.kvStore.put((Object)word, (Object)1);
                            continue;
                        }
                        this.kvStore.put((Object)word, (Object)(oldValue + 1));
                    }
                    this.context.commit();
                }

                public void punctuate(long timestamp) {
                    try (KeyValueIterator iter = this.kvStore.all();){
                        System.out.println("----------- " + timestamp + " ----------- ");
                        while (iter.hasNext()) {
                            KeyValue entry = (KeyValue)iter.next();
                            System.out.println("[" + (String)entry.key + ", " + entry.value + "]");
                            this.context.forward(entry.key, (Object)((Integer)entry.value).toString());
                        }
                    }
                }

                public void close() {
                    this.kvStore.close();
                }
            };
        }
    }
}

