/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.MemoryLRUCache;

public class MemoryNavigableLRUCache<K, V>
extends MemoryLRUCache<K, V> {
    public MemoryNavigableLRUCache(String name, final int maxCacheSize, Serde<K> keySerde, Serde<V> valueSerde) {
        super(keySerde, valueSerde);
        this.name = name;
        this.keys = new TreeSet();
        this.map = new LinkedHashMap<K, V>(maxCacheSize + 1, 1.01f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > maxCacheSize) {
                    Object key = eldest.getKey();
                    MemoryNavigableLRUCache.this.keys.remove(key);
                    if (MemoryNavigableLRUCache.this.listener != null) {
                        MemoryNavigableLRUCache.this.listener.apply(key, eldest.getValue());
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public MemoryNavigableLRUCache<K, V> whenEldestRemoved(MemoryLRUCache.EldestEntryRemovalListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new CacheIterator(((NavigableSet)this.keys).subSet(from, true, to, false).iterator(), this.map);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new CacheIterator(this.keys.iterator(), this.map);
    }

    private static class CacheIterator<K, V>
    implements KeyValueIterator<K, V> {
        private final Iterator<K> keys;
        private final Map<K, V> entries;
        private K lastKey;

        public CacheIterator(Iterator<K> keys, Map<K, V> entries) {
            this.keys = keys;
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            this.lastKey = this.keys.next();
            return new KeyValue<K, V>(this.lastKey, this.entries.get(this.lastKey));
        }

        @Override
        public void remove() {
            this.keys.remove();
            this.entries.remove(this.lastKey);
        }

        @Override
        public void close() {
        }
    }
}

