/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminClient;
import kafka.admin.TopicCommand;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.collection.JavaConversions;

@InterfaceStability.Unstable
public class StreamsResetter {
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_ERROR = 1;
    private static OptionSpec<String> bootstrapServerOption;
    private static OptionSpec<String> zookeeperOption;
    private static OptionSpec<String> applicationIdOption;
    private static OptionSpec<String> inputTopicsOption;
    private static OptionSpec<String> intermediateTopicsOption;
    private OptionSet options = null;
    private final Properties consumerConfig = new Properties();
    private final List<String> allTopics = new LinkedList<String>();

    public int run(String[] args) {
        return this.run(args, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args, Properties config) {
        this.consumerConfig.clear();
        this.consumerConfig.putAll((Map<?, ?>)config);
        int exitCode = 0;
        AdminClient adminClient = null;
        ZkUtils zkUtils = null;
        try {
            this.parseArguments(args);
            adminClient = AdminClient.createSimplePlaintext((String)this.options.valueOf(bootstrapServerOption));
            String groupId = (String)this.options.valueOf(applicationIdOption);
            if (!adminClient.describeGroup(groupId).members().isEmpty()) {
                throw new IllegalStateException("Consumer group '" + groupId + "' is still active. " + "Make sure to stop all running application instances before running the reset tool.");
            }
            zkUtils = ZkUtils.apply((String)this.options.valueOf(zookeeperOption), 30000, 30000, JaasUtils.isZkSecurityEnabled());
            this.allTopics.clear();
            this.allTopics.addAll(JavaConversions.seqAsJavaList(zkUtils.getAllTopics()));
            this.resetInputAndInternalTopicOffsets();
            this.seekToEndIntermediateTopics();
            this.deleteInternalTopics(zkUtils);
        }
        catch (Throwable e) {
            exitCode = 1;
            System.err.println("ERROR: " + e.getMessage());
        }
        finally {
            if (adminClient != null) {
                adminClient.close();
            }
            if (zkUtils != null) {
                zkUtils.close();
            }
        }
        return exitCode;
    }

    private void parseArguments(String[] args) throws IOException {
        OptionParser optionParser = new OptionParser();
        applicationIdOption = optionParser.accepts("application-id", "The Kafka Streams application ID (application.id)").withRequiredArg().ofType(String.class).describedAs("id").required();
        bootstrapServerOption = optionParser.accepts("bootstrap-servers", "Comma-separated list of broker urls with format: HOST1:PORT1,HOST2:PORT2").withRequiredArg().ofType(String.class).defaultsTo((Object)"localhost:9092", (Object[])new String[0]).describedAs("urls");
        zookeeperOption = optionParser.accepts("zookeeper", "Format: HOST:POST").withRequiredArg().ofType(String.class).defaultsTo((Object)"localhost:2181", (Object[])new String[0]).describedAs("url");
        inputTopicsOption = optionParser.accepts("input-topics", "Comma-separated list of user input topics").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("list");
        intermediateTopicsOption = optionParser.accepts("intermediate-topics", "Comma-separated list of intermediate user topics").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("list");
        try {
            this.options = optionParser.parse(args);
        }
        catch (OptionException e) {
            optionParser.printHelpOn((OutputStream)System.err);
            throw e;
        }
    }

    private void resetInputAndInternalTopicOffsets() {
        List inputTopics = this.options.valuesOf(inputTopicsOption);
        if (inputTopics.size() == 0) {
            System.out.println("No input topics specified.");
        } else {
            System.out.println("Resetting offsets to zero for input topics " + inputTopics + " and all internal topics.");
        }
        Properties config = new Properties();
        config.putAll((Map<?, ?>)this.consumerConfig);
        config.setProperty("bootstrap.servers", (String)this.options.valueOf(bootstrapServerOption));
        config.setProperty("group.id", (String)this.options.valueOf(applicationIdOption));
        config.setProperty("enable.auto.commit", "false");
        for (String inTopic : inputTopics) {
            if (this.allTopics.contains(inTopic)) continue;
            System.out.println("Input topic " + inTopic + " not found. Skipping.");
        }
        for (String topic : this.allTopics) {
            if (!this.isInputTopic(topic) && !this.isInternalTopic(topic)) continue;
            System.out.println("Topic: " + topic);
            try {
                KafkaConsumer client = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
                Throwable throwable = null;
                try {
                    client.subscribe(Collections.singleton(topic));
                    client.poll(1L);
                    Set partitions = client.assignment();
                    client.seekToBeginning((Collection)partitions);
                    for (TopicPartition p : partitions) {
                        client.position(p);
                    }
                    client.commitSync();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            catch (RuntimeException e) {
                System.err.println("ERROR: Resetting offsets for topic " + topic + " failed.");
                throw e;
            }
        }
        System.out.println("Done.");
    }

    private boolean isInputTopic(String topic) {
        return this.options.valuesOf(inputTopicsOption).contains(topic);
    }

    private void seekToEndIntermediateTopics() {
        List intermediateTopics = this.options.valuesOf(intermediateTopicsOption);
        if (intermediateTopics.size() == 0) {
            System.out.println("No intermediate user topics specified, skipping seek-to-end for user topic offsets.");
            return;
        }
        System.out.println("Seek-to-end for intermediate user topics " + intermediateTopics);
        Properties config = new Properties();
        config.putAll((Map<?, ?>)this.consumerConfig);
        config.setProperty("bootstrap.servers", (String)this.options.valueOf(bootstrapServerOption));
        config.setProperty("group.id", (String)this.options.valueOf(applicationIdOption));
        config.setProperty("enable.auto.commit", "false");
        for (String topic : intermediateTopics) {
            if (this.allTopics.contains(topic)) {
                System.out.println("Topic: " + topic);
                try {
                    KafkaConsumer client = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
                    Throwable throwable = null;
                    try {
                        client.subscribe(Collections.singleton(topic));
                        client.poll(1L);
                        Set partitions = client.assignment();
                        client.seekToEnd((Collection)partitions);
                        for (TopicPartition p : partitions) {
                            client.position(p);
                        }
                        client.commitSync();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (client == null) continue;
                        if (throwable != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        client.close();
                        continue;
                    }
                }
                catch (RuntimeException e) {
                    System.err.println("ERROR: Seek-to-end for topic " + topic + " failed.");
                    throw e;
                }
            }
            System.out.println("Topic " + topic + " not found. Skipping.");
        }
        System.out.println("Done.");
    }

    private void deleteInternalTopics(ZkUtils zkUtils) {
        System.out.println("Deleting all internal/auto-created topics for application " + (String)this.options.valueOf(applicationIdOption));
        for (String topic : this.allTopics) {
            if (!this.isInternalTopic(topic)) continue;
            TopicCommand.TopicCommandOptions commandOptions = new TopicCommand.TopicCommandOptions(new String[]{"--zookeeper", (String)this.options.valueOf(zookeeperOption), "--delete", "--topic", topic});
            try {
                TopicCommand.deleteTopic(zkUtils, commandOptions);
            }
            catch (RuntimeException e) {
                System.err.println("ERROR: Deleting topic " + topic + " failed.");
                throw e;
            }
        }
        System.out.println("Done.");
    }

    private boolean isInternalTopic(String topicName) {
        return topicName.startsWith((String)this.options.valueOf(applicationIdOption) + "-") && (topicName.endsWith("-changelog") || topicName.endsWith("-repartition"));
    }

    public static void main(String[] args) {
        System.exit(new StreamsResetter().run(args));
    }
}

