/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtilities;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.TestAdminUtils;
import kafka.common.InvalidConfigException;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaId$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u000f\t\t2i\u001c8gS\u001e\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\n\u0019!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tIB$D\u0001\u001b\u0015\tYB!A\u0003vi&d7/\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u0015!\u0003\u0001\"\u0001&\u0003!\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'o\u00117jK:$8/\u00128uSRLH+\u001f9f)\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRD#aI\u0017\u0011\u00059\u0002T\"A\u0018\u000b\u0005-q\u0011BA\u00190\u0005\u0011!Vm\u001d;\t\u000bM\u0002A\u0011A\u0013\u0002OMDw.\u001e7e!\u0006\u00148/Z!sOVlWM\u001c;t\r>\u0014Hk\u001c9jGN,e\u000e^5usRK\b/\u001a\u0015\u0003e5BQA\u000e\u0001\u0005\u0002\u0015\n\u0001f\u001d5pk2$\u0007+\u0019:tK\u0006\u0013x-^7f]R\u001chi\u001c:Ce>\\WM]:F]RLG/\u001f+za\u0016D#!N\u0017\t\u000be\u0002A\u0011\u0001\u001e\u0002#Q,7\u000f^!sOVlWM\u001c;QCJ\u001cX\r\u0006\u0002'w!)A\b\u000fa\u0001{\u0005QQM\u001c;jif$\u0016\u0010]3\u0011\u0005y\neBA\u0014@\u0013\t\u0001\u0005&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!)\u0011\u0015)\u0005\u0001\"\u0001&\u0003\t\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g+:\u0014XmY8h]&\u001cX\rZ#oi&$\u0018\u0010V=qK\"\"A)L$I\u0003!)\u0007\u0010]3di\u0016$7%A%\u0011\u0005)\u0013fBA&Q\u001d\tau*D\u0001N\u0015\tqe!\u0001\u0004=e>|GOP\u0005\u0002S%\u0011\u0011\u000bK\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FK\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T!!\u0015\u0015\t\u000bY\u0003A\u0011A\u0013\u0002+MDw.\u001e7e\u0003\u0012$7\t\\5f]R\u001cuN\u001c4jO\"\u0012Q+\f\u0005\u00063\u0002!\t!J\u0001\u0015g\"|W\u000f\u001c3BI\u0012$v\u000e]5d\u0007>tg-[4)\u0005ak\u0003\"\u0002/\u0001\t\u0003)\u0013!F:i_VdG-\u00113e\u0005J|7.\u001a:D_:4\u0017n\u001a\u0015\u000376BQa\u0018\u0001\u0005\u0002\u0015\n\u0011e\u001d5pk2$7+\u001e9q_J$8i\\7nCN+\u0007/\u0019:bi\u0016$g+\u00197vKND#AX\u0017\t\u000b\t\u0004A\u0011A\u0013\u0002aMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,G-\u00128uSRLh*Y7fQ\u0011\tWf\u0012%\t\u000b\u0015\u0004A\u0011A\u0013\u0002YMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,GmQ8oM&<\u0007\u0006\u00023.\u000f\"CQ\u0001\u001b\u0001\u0005\u0002\u0015\n1g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0005J\f7m[3u\u0007>tg-[4)\t\u001dls\t\u0013\u0005\u0006W\u0002!\t!J\u0001\u0019g\"|W\u000f\u001c3EK2,G/\u001a\"s_.,'oQ8oM&<\u0007F\u00016.\u0011\u0015q\u0007\u0001\"\u0001&\u0003U!Xm\u001d;Rk>$\u0018mQ8oM&<WI\u001c;jifD#!\\\u0017\t\u000bE\u0004A\u0011A\u0013\u0002/Q,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1PaR\u001c\bF\u00019.\u0011\u0015!\b\u0001\"\u0001&\u0003e!Xm\u001d;Rk>$\u0018\rR3tGJL'-Z#oi&$\u0018.Z:)\u0005Ml\u0003")
public class ConfigCommandTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConfigCommandTest configCommandTest = this;
        synchronized (configCommandTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients");
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers");
    }

    public void testArgumentParse(String entityType) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldAddClientConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddTopicConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldSupportCommaSeparatedValues() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "a=b"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a="}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        TestAdminUtils configChange = new TestAdminUtils(this){

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return properties;
            }

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, clientId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String clientId$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)this.clientId$1), this.clientId$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientId$1 = clientId$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)QuotaId$.MODULE$.desanitize(sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, principal, sanitizedPrincipal){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String principal$1;
            private final String sanitizedPrincipal$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.sanitizedPrincipal$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, describeOpts, clientId, principal, sanitizedPrincipal, userClient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String[] describeOpts$1;
            private final String clientId$1;
            private final String principal$1;
            private final String sanitizedPrincipal$1;
            private final String userClient$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.userClient$1, (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), new StringBuilder().append((Object)this.sanitizedPrincipal$1).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)this.clientId$1).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])this.describeOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.describeOpts$1 = describeOpts$1;
                this.clientId$1 = clientId$1;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
                this.userClient$1 = userClient$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients").toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])describeOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.kafka$admin$ConfigCommandTest$$clientIdOpts$1(clientId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        try {
            this.checkEntity$2("clients", QuotaId$.MODULE$.sanitize("<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
            throw this.fail("Did not fail with invalid client-id");
        }
        catch (InvalidConfigException invalidConfigException) {
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", new StringBuilder().append((Object)QuotaId$.MODULE$.sanitize("CN=user1")).append((Object)"/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
            this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
            return;
        }
    }

    @Test
    public void testQuotaDescribeEntities() {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        this.checkEntities$1(opts, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        this.checkEntities$1(opts, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/<default>").toString()})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        this.checkEntities$1(opts, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-4").toString()})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        this.checkEntities$1(opts, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        Map userMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        Map defaultUserMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        this.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-2").toString()})), zkUtils);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String entityType, Option entityName, String[] otherArgs) {
        Option option;
        block4: {
            String[] stringArray;
            String[] optArray;
            block3: {
                block2: {
                    optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
                    option = entityName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    stringArray = (String[])((Object[])new String[]{"--entity-name", name});
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            String[] nameArray = stringArray;
            return new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])optArray).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])nameArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])otherArgs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        throw new MatchError((Object)option);
    }

    public final void kafka$admin$ConfigCommandTest$$checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$1(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$1(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            throw this.fail("Did not fail with invalid argument list");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final String[] kafka$admin$ConfigCommandTest$$clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()}).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkEntities$1(String[] opts, Map expectedFetches, Seq expectedEntityNames, ZkUtils zkUtils$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])opts).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1)new Serializable(this, zkUtils$1){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;

            public final IExpectationSetters<Seq<String>> apply(Tuple2<String, Seq<String>> x0$1) {
                Tuple2<String, Seq<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.zkUtils$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
                    return iExpectationSetters;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{zkUtils$1});
        Seq entities = entity.getAllEntities(zkUtils$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigCommand.ConfigEntity e) {
                return e.fullSanitizedName();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkUtils$1});
    }

    public ConfigCommandTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
    }
}

