/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtilities;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TestAdminUtils;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000f\ti\"+Z1tg&<g\u000eU1si&$\u0018n\u001c8t\u0007>lW.\u00198e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001A!\u0003\u0007\u0010\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m!\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001e\u0004\"a\b\u0011\u000e\u0003\tI!!\t\u0002\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002 \u0001!9q\u0005\u0001a\u0001\n\u0003A\u0013!B2bY2\u001cX#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\u0007%sG\u000fC\u00041\u0001\u0001\u0007I\u0011A\u0019\u0002\u0013\r\fG\u000e\\:`I\u0015\fHC\u0001\u001a6!\tQ3'\u0003\u00025W\t!QK\\5u\u0011\u001d1t&!AA\u0002%\n1\u0001\u001f\u00132\u0011\u0019A\u0004\u0001)Q\u0005S\u000511-\u00197mg\u0002BQA\u000f\u0001\u0005\u0002m\nQ\u0003^3tiJ\u000b7m[!xCJ,'+Z1tg&<g\u000eF\u00013Q\tIT\b\u0005\u0002?\u00016\tqH\u0003\u0002\f\u001d%\u0011\u0011i\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003D\u0001\u0011\u00051(\u0001\rtQ>,H\u000e\u001a$j]\u0012luN^5oOJ+\u0007\u000f\\5dCND#AQ\u001f\t\u000b\u0019\u0003A\u0011A\u001e\u0002UMDw.\u001e7e\r&tG-T8wS:<'+\u001a9mS\u000e\f7/T;mi&\u0004H.\u001a)beRLG/[8og\"\u0012Q)\u0010\u0005\u0006\u0013\u0002!\taO\u0001'g\"|W\u000f\u001c3GS:$Wj\u001c<j]\u001e\u0014V\r\u001d7jG\u0006\u001cX*\u001e7uSBdW\rV8qS\u000e\u001c\bF\u0001%>\u0011\u0015a\u0005\u0001\"\u0001<\u0003M\u001a\bn\\;mI\u001aKg\u000eZ'pm&twMU3qY&\u001c\u0017m]'vYRL\u0007\u000f\\3U_BL7m]!oIB\u000b'\u000f^5uS>t7\u000f\u000b\u0002L{!)q\n\u0001C\u0001w\u0005Q3\u000f[8vY\u00124\u0015N\u001c3Uo>luN^5oOJ+\u0007\u000f\\5dCNLenU1nKB\u000b'\u000f^5uS>t\u0007F\u0001(>\u0011\u0015\u0011\u0006\u0001\"\u0001<\u0003q\u001a\bn\\;mI:{Go\u0014<fe^\u0014\u0018\u000e^3F]RLG/_\"p]\u001aLwm],iK:,\u0006\u000fZ1uS:<G\u000b\u001b:piRdW\r\u001a*fa2L7-Y:)\u0005Ek\u0004\"B+\u0001\t\u0003Y\u0014!B:fiV\u0004\bF\u0001+X!\tq\u0004,\u0003\u0002Z\u007f\t1!)\u001a4pe\u0016\u0004")
public class ReassignPartitionsCommandTest
extends JUnitSuite
implements ZooKeeperTestHarness,
RackAwareTest {
    private int calls;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommandTest reassignPartitionsCommandTest = this;
        synchronized (reassignPartitionsCommandTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int calls() {
        return this.calls;
    }

    public void calls_$eq(int x$1) {
        this.calls = x$1;
    }

    @Test
    public void testRackAwareReassign() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkUtils());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--disable-rack-aware", "--topic", "foo"}));
        TopicCommand$.MODULE$.createTopic(this.zkUtils(), createOpts);
        String topicJson = "{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}";
        Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)rackInfo.keys().toSeq().sorted((Ordering)Ordering.Int$.MODULE$), topicJson, false);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map proposedAssignment = (Map)tuple2._1();
            Map currentAssignment = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)proposedAssignment, (Object)currentAssignment);
            Map proposedAssignment2 = (Map)tuple23._1();
            Map currentAssignment2 = (Map)tuple23._2();
            Map assignment = (Map)proposedAssignment2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$1) {
                    Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)replicas);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void shouldFindMovingReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"0:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"0:100,0:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultiplePartitions() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"0:102,1:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"0:100,0:101,1:100,1:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopics() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                block4: {
                    block3: {
                        String string;
                        block2: {
                            string = topic;
                            if (!"topic1".equals(string)) break block2;
                            Assert.assertEquals((Object)"0:100,0:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                            Assert.assertEquals((Object)"0:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!"topic2".equals(string)) break block4;
                        Assert.assertEquals((Object)"0:101,0:102", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                        Assert.assertEquals((Object)"0:100", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.calls_$eq(this.$outer.calls() + 1);
                    return;
                }
                throw this.$outer.fail("Unexpected topic $topic");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindMovingReplicasMultipleTopicsAndPartitions() {
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})))}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})))}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                block4: {
                    block3: {
                        String string;
                        block2: {
                            string = topic;
                            if (!"topic1".equals(string)) break block2;
                            Assert.assertEquals((Object)"0:102,1:102", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                            Assert.assertEquals((Object)"0:100,0:101,1:100,1:101", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!"topic2".equals(string)) break block4;
                        Assert.assertEquals((Object)"0:100,1:100", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                        Assert.assertEquals((Object)"0:101,0:102,1:101,1:102", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.calls_$eq(this.$outer.calls() + 1);
                    return;
                }
                throw this.$outer.fail();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)2L, (long)this.calls());
    }

    @Test
    public void shouldFindTwoMovingReplicasInSamePartition() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102, 103}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 104, 105}))), control}));
        TestAdminUtils mock = new TestAdminUtils(this){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"0:104,0:105", (Object)configChange.get(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
                Assert.assertEquals((Object)"0:100,0:101,0:102,0:103", (Object)configChange.get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Test
    public void shouldNotOverwriteEntityConfigsWhenUpdatingThrottledReplicas() {
        Tuple2 control = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})));
        ReassignPartitionsCommand assigner = new ReassignPartitionsCommand(null, null);
        scala.collection.immutable.Map existing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), control}));
        scala.collection.immutable.Map proposed = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), control}));
        Properties existingProperties = CoreUtils$.MODULE$.propsWith("some-key", "some-value");
        TestAdminUtils mock = new TestAdminUtils(this, existingProperties){
            private final /* synthetic */ ReassignPartitionsCommandTest $outer;
            private final Properties existingProperties$1;

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"some-value", (Object)configChange.getProperty("some-key"));
                this.$outer.calls_$eq(this.$outer.calls() + 1);
            }

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                return this.existingProperties$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.existingProperties$1 = existingProperties$1;
            }
        };
        assigner.assignThrottledReplicas((Map)existing, (Map)proposed, (AdminUtilities)mock);
        Assert.assertEquals((long)1L, (long)this.calls());
    }

    @Before
    public void setup() {
        this.calls_$eq(0);
    }

    public ReassignPartitionsCommandTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        RackAwareTest$class.$init$(this);
        this.calls = 0;
    }
}

