/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import kafka.api.BaseConsumerTest;
import kafka.api.PlaintextConsumerTest$;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012A\u0005;fgRl\u0015\r\u001f)pY2\u0014VmY8sIN$\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u00115A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgRDQa\t\u0001\u0005\u0002I\tQ\u0003^3ti6\u000b\u0007\u0010U8mY&sG/\u001a:wC2l5\u000f\u000b\u0002#5!)a\u0005\u0001C\u0001%\u0005)B/Z:u\u0003V$xnQ8n[&$xJ\\\"m_N,\u0007FA\u0013\u001b\u0011\u0015I\u0003\u0001\"\u0001\u0013\u0003\u0001\"Xm\u001d;BkR|7i\\7nSR|en\u00117pg\u0016\fe\r^3s/\u0006\\W-\u001e9)\u0005!R\u0002\"\u0002\u0017\u0001\t\u0003\u0011\u0012a\u0005;fgR\fU\u000f^8PM\u001a\u001cX\r\u001e*fg\u0016$\bFA\u0016\u001b\u0011\u0015y\u0003\u0001\"\u0001\u0013\u0003Q!Xm\u001d;He>,\boQ8ogVl\u0007\u000f^5p]\"\u0012aF\u0007\u0005\u0006e\u0001!\tAE\u0001\u0018i\u0016\u001cH\u000fU1ui\u0016\u0014hnU;cg\u000e\u0014\u0018\u000e\u001d;j_:D#!\r\u000e\t\u000bU\u0002A\u0011\u0001\n\u0002CQ,7\u000f^*vEN,\u0017/^3oiB\u000bG\u000f^3s]N+(m]2sSB$\u0018n\u001c8)\u0005QR\u0002\"\u0002\u001d\u0001\t\u0003\u0011\u0012!\u0007;fgR\u0004\u0016\r\u001e;fe:,fn];cg\u000e\u0014\u0018\u000e\u001d;j_:D#a\u000e\u000e\t\u000bm\u0002A\u0011\u0001\n\u0002%Q,7\u000f^\"p[6LG/T3uC\u0012\fG/\u0019\u0015\u0003uiAQA\u0010\u0001\u0005\u0002I\tq\u0002^3ti\u0006\u001b\u0018P\\2D_6l\u0017\u000e\u001e\u0015\u0003{iAQ!\u0011\u0001\u0005\u0002I\tq\u0004^3ti\u0016C\b/\u00198eS:<Gk\u001c9jGN+(m]2sSB$\u0018n\u001c8tQ\t\u0001%\u0004C\u0003E\u0001\u0011\u0005!#A\u0010uKN$8\u000b\u001b:j].Lgn\u001a+pa&\u001c7+\u001e2tGJL\u0007\u000f^5p]ND#a\u0011\u000e\t\u000b\u001d\u0003A\u0011\u0001\n\u0002#Q,7\u000f\u001e)beRLG/[8og\u001a{'\u000f\u000b\u0002G5!)!\n\u0001C\u0001%\u0005YB/Z:u!\u0006\u0014H/\u001b;j_:\u001chi\u001c:BkR|7I]3bi\u0016D#!\u0013\u000e\t\u000b5\u0003A\u0011\u0001\n\u0002;Q,7\u000f\u001e)beRLG/[8og\u001a{'/\u00138wC2LG\rV8qS\u000eDC\u0001\u0014\u000eP!\u0006AQ\r\u001f9fGR,GmI\u0001R!\t\u0011&,D\u0001T\u0015\t!V+\u0001\u0004feJ|'o\u001d\u0006\u0003-^\u000baaY8n[>t'BA\u0003Y\u0015\tIf$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u00037N\u0013Q#\u00138wC2LG\rV8qS\u000e,\u0005pY3qi&|g\u000eC\u0003^\u0001\u0011\u0005!#\u0001\u0005uKN$8+Z3lQ\ta&\u0004C\u0003a\u0001\u0011%\u0011-\u0001\ftK:$7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3t)\r\u0019\"m\u001a\u0005\u0006G~\u0003\r\u0001Z\u0001\u000b]Vl'+Z2pe\u0012\u001c\bC\u0001\u000bf\u0013\t1WCA\u0002J]RDQ\u0001[0A\u0002%\f!\u0001\u001e9\u0011\u0005)\\W\"A+\n\u00051,&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006]\u0002!\tAE\u0001\u0016i\u0016\u001cH\u000fU8tSRLwN\\!oI\u000e{W.\\5uQ\ti'\u0004C\u0003r\u0001\u0011\u0005!#A\u000euKN$\b+\u0019:uSRLwN\u001c)bkN,\u0017I\u001c3SKN,X.\u001a\u0015\u0003ajAQ\u0001\u001e\u0001\u0005\u0002I\ta\u0003^3ti\u001a+Go\u00195J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e\u0015\u0003gjAQa\u001e\u0001\u0005\u0002I\ta\u0005^3ti\u001a+Go\u00195SK\u000e|'\u000f\u001a'be\u001e,'\u000f\u00165b]\u001a+Go\u00195NCb\u0014\u0015\u0010^3tQ\t1(\u0004C\u0003{\u0001\u0011%10\u0001\tdQ\u0016\u001c7\u000eT1sO\u0016\u0014VmY8sIR\u00111\u0003 \u0005\u0006{f\u0004\r\u0001Z\u0001\u0013aJ|G-^2feJ+7m\u001c:e'&TX\rC\u0003\u0000\u0001\u0011\u0005!#\u0001\u0018uKN$h)\u001a;dQ\"{gn\\;sg\u001a+Go\u00195TSj,\u0017J\u001a'be\u001e,'+Z2pe\u0012tu\u000e\u001e$jeN$\bF\u0001@\u001b\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\t!f\u00195fG.4U\r^2i\u0011>tw.\u001e:t'&TX-\u00134MCJ<WMU3d_J$gj\u001c;GSJ\u001cH\u000fF\u0002\u0014\u0003\u0013Aq!a\u0003\u0002\u0004\u0001\u0007A-A\fmCJ<W\r\u0015:pIV\u001cWM\u001d*fG>\u0014HmU5{K\"1\u0011q\u0002\u0001\u0005\u0002I\t1\b^3ti\u001a+Go\u00195I_:|WO]:NCb\u0004\u0016M\u001d;ji&|gNR3uG\"\u0014\u0015\u0010^3t\u0013\u001ad\u0015M]4f%\u0016\u001cwN\u001d3O_R4\u0015N]:uQ\r\tiA\u0007\u0005\u0007\u0003+\u0001A\u0011\u0001\n\u0002_Q,7\u000f\u001e$fi\u000eD'+Z2pe\u0012d\u0015M]4feRC\u0017M\\'bqB\u000b'\u000f^5uS>tg)\u001a;dQ\nKH/Z:)\u0007\u0005M!\u0004\u0003\u0004\u0002\u001c\u0001!\tAE\u0001*i\u0016\u001cH\u000fT8x\u001b\u0006Dh)\u001a;dQNK'0\u001a$peJ+\u0017/^3ti\u0006sG\rU1si&$\u0018n\u001c8)\u0007\u0005e!\u0004\u0003\u0004\u0002\"\u0001!\tAE\u0001\u0019i\u0016\u001cHOU8v]\u0012\u0014vNY5o\u0003N\u001c\u0018n\u001a8nK:$\bfAA\u00105!1\u0011q\u0005\u0001\u0005\u0002I\tQ\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s%>,h\u000e\u001a*pE&t\u0017i]:jO:lWM\u001c;)\u0007\u0005\u0015\"\u0004\u0003\u0004\u0002.\u0001!\tAE\u0001#i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u0014H)\u001a4bk2$\u0018i]:jO:lWM\u001c;)\u0007\u0005-\"\u0004\u0003\u0004\u00024\u0001!\tAE\u0001-i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u00148+Z:tS>tG+[7f_V$xJ\\*u_B\u0004v\u000e\u001c7j]\u001eD3!!\r\u001b\u0011\u0019\tI\u0004\u0001C\u0001%\u00051C/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]\u000ecwn]3)\u0007\u0005]\"\u0004\u0003\u0004\u0002@\u0001!\tAE\u0001\u0011i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peND3!!\u0010\u001b\u0011\u0019\t)\u0005\u0001C\u0001%\u00059B/Z:u\u0003V$xnQ8n[&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0015\u0004\u0003\u0007R\u0002BBA&\u0001\u0011\u0005!#A\u0011uKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8sg^KG\u000f[,s_:<7*Z=WC2,X\rK\u0002\u0002JiAa!!\u0015\u0001\t\u0003\u0011\u0012!\t;fgR\u001cuN\\:v[\u0016lUm]:bO\u0016\u001cx+\u001b;i\u0007J,\u0017\r^3US6,\u0007BBA+\u0001\u0011\u0005!#\u0001\u0013uKN$8i\u001c8tk6,W*Z:tC\u001e,7oV5uQ2{w-\u00119qK:$G+[7fQ\r\t\u0019F\u0007\u0005\u0007\u00037\u0002A\u0011\u0001\n\u0002\u001dQ,7\u000f\u001e'jgR$v\u000e]5dg\"\u001a\u0011\u0011\f\u000e\t\r\u0005\u0005\u0004\u0001\"\u0001\u0013\u0003M!Xm\u001d;PM\u001a\u001cX\r^:G_J$\u0016.\\3tQ\r\tyF\u0007\u0005\u0007\u0003O\u0002A\u0011\u0001\n\u00027Q,7\u000f^#be2LWm\u001d;Pe2\u000bG/Z:u\u001f\u001a47/\u001a;tQ\r\t)G\u0007\u0005\u0007\u0003[\u0002A\u0011\u0001\n\u0002)Q,7\u000f^+ogV\u00147o\u0019:jE\u0016$v\u000e]5dQ\r\tYG\u0007\u0005\u0007\u0003g\u0002A\u0011\u0001\n\u0002KQ,7\u000f\u001e)bkN,7\u000b^1uK:{G\u000f\u0015:fg\u0016\u0014h/\u001a3CsJ+'-\u00197b]\u000e,\u0007fAA95!1\u0011\u0011\u0010\u0001\u0005\u0002I\t!\u0004^3ti\u000e{W.\\5u'B,7-\u001b4jK\u0012|eMZ:fiND3!a\u001e\u001b\u0011\u0019\ty\b\u0001C\u0001%\u0005IB/Z:u\u0003V$xnQ8n[&$xJ\u001c*fE\u0006d\u0017M\\2fQ\r\tiH\u0007\u0005\b\u0003\u000b\u0003A\u0011AAD\u0003\t\u0012XO\\'vYRL7i\u001c8tk6,'oU3tg&|g\u000eV5nK>,H\u000fV3tiR\u00191#!#\t\u0011\u0005-\u00151\u0011a\u0001\u0003\u001b\u000bQb\u00197pg\u0016\u001cuN\\:v[\u0016\u0014\bc\u0001\u000b\u0002\u0010&\u0019\u0011\u0011S\u000b\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015!G2sK\u0006$X\rV8qS\u000e\fe\u000eZ*f]\u0012\u0014VmY8sIN$\u0002\"!'\u0002(\u0006E\u0016Q\u0017\t\u0006\u00037\u000b\t+\u001b\b\u0004)\u0005u\u0015bAAP+\u00051\u0001K]3eK\u001aLA!a)\u0002&\n\u00191+\u001a;\u000b\u0007\u0005}U\u0003\u0003\u0005\u0002*\u0006M\u0005\u0019AAV\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0003\u0002\u001c\u00065\u0016\u0002BAX\u0003K\u0013aa\u0015;sS:<\u0007bBAZ\u0003'\u0003\r\u0001Z\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\u0005]\u00161\u0013a\u0001I\u0006\u0019\"/Z2pe\u0012\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0016\u0001I:vEN\u001c'/\u001b2f\u0007>t7/^7fe\u0006sGm\u0015;beR\u0004v\u000e\u001c7j]\u001e$b!a0\u0002H\u0006\u0015\b\u0003BAa\u0003\u0007l\u0011\u0001A\u0005\u0004\u0003\u000bT!\u0001G\"p]N,X.\u001a:BgNLwM\\7f]R\u0004v\u000e\u001c7fe\"A\u0011\u0011ZA]\u0001\u0004\tY-\u0001\u0005d_:\u001cX/\\3s!!\ti-!6\u0002Z\u0006eWBAAh\u0015\u0011\tI-!5\u000b\u0007\u0005Mw+A\u0004dY&,g\u000e^:\n\t\u0005]\u0017q\u001a\u0002\t\u0007>t7/^7feB)A#a7\u0002`&\u0019\u0011Q\\\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0007Q\t\t/C\u0002\u0002dV\u0011AAQ=uK\"A\u0011q]A]\u0001\u0004\tI/A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004b!a;\u0002|\u0006-f\u0002BAw\u0003otA!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g4\u0011A\u0002\u001fs_>$h(C\u0001\u0017\u0013\r\tI0F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti0a@\u0003\t1K7\u000f\u001e\u0006\u0004\u0003s,\u0002b\u0002B\u0002\u0001\u0011\u0005!QA\u0001\u0013gV\u00147o\u0019:jE\u0016\u001cuN\\:v[\u0016\u00148\u000f\u0006\u0004\u0003\b\t]!1\u0005\t\u0007\u0005\u0013\u0011\u0019\"a0\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\tq!\\;uC\ndWMC\u0002\u0003\u0012U\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ba\u0003\u0003\r\t+hMZ3s\u0011!\u0011IB!\u0001A\u0002\tm\u0011!D2p]N,X.\u001a:He>,\b\u000f\u0005\u0004\u0003\n\tM!Q\u0004\t\t\u0003\u001b\u0014y\"!7\u0002Z&!!\u0011EAh\u00055Y\u0015MZ6b\u0007>t7/^7fe\"A\u0011q\u001dB\u0001\u0001\u0004\tI\u000fC\u0004\u0003(\u0001!\tA!\u000b\u0002O\r\u0014X-\u0019;f\u0007>t7/^7fe\u001e\u0013x.\u001e9B]\u0012<\u0016-\u001b;G_J\f5o]5h]6,g\u000e\u001e\u000b\t\u0005W\u0011\tD!\u000e\u00038A9AC!\f\u0003\u001c\t\u001d\u0011b\u0001B\u0018+\t1A+\u001e9mKJBqAa\r\u0003&\u0001\u0007A-A\u0007d_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0005\t\u0003O\u0014)\u00031\u0001\u0002j\"A!\u0011\bB\u0013\u0001\u0004\tI*A\u0007tk\n\u001c8M]5qi&|gn\u001d\u0005\b\u0005{\u0001A\u0011\u0001B \u00031\nG\rZ\"p]N,X.\u001a:t)><%o\\;q\u0003:$w+Y5u\r>\u0014xI]8va\u0006\u001b8/[4o[\u0016tG\u000fF\u0006\u0014\u0005\u0003\u0012)Ea\u0012\u0003L\t5\u0003b\u0002B\"\u0005w\u0001\r\u0001Z\u0001\u0014]VlwJZ\"p]N,X.\u001a:t)>\fE\r\u001a\u0005\t\u00053\u0011Y\u00041\u0001\u0003\u001c!A!\u0011\nB\u001e\u0001\u0004\u00119!A\bd_:\u001cX/\\3s!>dG.\u001a:t\u0011!\t9Oa\u000fA\u0002\u0005%\b\u0002\u0003B\u001d\u0005w\u0001\r!!'\t\u000f\tE\u0003\u0001\"\u0001\u0003T\u00059b/\u00197jI\u0006$Xm\u0012:pkB\f5o]5h]6,g\u000e\u001e\u000b\n'\tU#q\u000bB-\u0005;B\u0001B!\u0013\u0003P\u0001\u0007!q\u0001\u0005\t\u0005s\u0011y\u00051\u0001\u0002\u001a\"A!1\fB(\u0001\u0004\tY+A\u0002ng\u001eD!Ba\u0018\u0003PA\u0005\t\u0019\u0001B1\u0003!9\u0018-\u001b;US6,\u0007c\u0001\u000b\u0003d%\u0019!QM\u000b\u0003\t1{gn\u001a\u0005\b\u0005S\u0002A\u0011\u0001B6\u0003Q\u001a\u0007.\u00198hK\u000e{gn];nKJ<%o\\;q'V\u00147o\u0019:jaRLwN\\!oIZ\u000bG.\u001b3bi\u0016\f5o]5h]6,g\u000e\u001e\u000b\b'\t5$q\u000eB9\u0011!\u0011IEa\u001aA\u0002\t\u001d\u0001\u0002CAt\u0005O\u0002\r!!;\t\u0011\te\"q\ra\u0001\u00033CqA!\u001e\u0001\t\u0003\u00119(A\u0018dQ\u0006tw-Z\"p]N,X.\u001a:Tk\n\u001c8M]5qi&|g.\u00118e-\u0006d\u0017\u000eZ1uK\u0006\u001b8/[4o[\u0016tG/\u0006\u0004\u0003z\t\r%q\u0013\u000b\n'\tm$1\u0014BO\u0005?C\u0001\"!3\u0003t\u0001\u0007!Q\u0010\t\t\u0003\u001b\f)Na \u0003\u0016B!!\u0011\u0011BB\u0019\u0001!\u0001B!\"\u0003t\t\u0007!q\u0011\u0002\u0002\u0017F!!\u0011\u0012BH!\r!\"1R\u0005\u0004\u0005\u001b+\"a\u0002(pi\"Lgn\u001a\t\u0004)\tE\u0015b\u0001BJ+\t\u0019\u0011I\\=\u0011\t\t\u0005%q\u0013\u0003\t\u00053\u0013\u0019H1\u0001\u0003\b\n\ta\u000b\u0003\u0005\u0002h\nM\u0004\u0019AAu\u0011!\u0011IDa\u001dA\u0002\u0005e\u0005\u0002\u0003BQ\u0005g\u0002\rAa)\u0002#I,'-\u00197b]\u000e,G*[:uK:,'\u000f\u0005\u0003\u0002N\n\u0015\u0016\u0002\u0002BT\u0003\u001f\u0014\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8fe\"I!1\u0016\u0001\u0012\u0002\u0013\u0005!QV\u0001\"m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005_SCA!\u0019\u00032.\u0012!1\u0017\t\u0005\u0005k\u0013y,\u0004\u0002\u00038*!!\u0011\u0018B^\u0003%)hn\u00195fG.,GMC\u0002\u0003>V\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tMa.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        this.sendRecords(numRecords);
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        KafkaConsumer x$9 = consumer0;
        int x$10 = numRecords;
        int x$11 = 0;
        int x$12 = maxPollRecords;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$16 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$9, x$10, x$11, x$13, x$14, x$15, x$16, x$12);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)3000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)2000)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener();
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(0L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
        Thread.sleep(3500L);
        consumer0.poll(0L);
        Assert.assertEquals((long)2L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)2L, (long)listener.callsToRevoked());
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$1;
            private final scala.collection.immutable.Set assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$1.poll(50L);
                java.util.Set set = this.consumer0$1.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$1 = consumer0$1;
                this.assignment$1 = assignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$2;
            private final scala.collection.immutable.Set assignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$2.poll(50L);
                java.util.Set set = this.consumer0$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$2 = consumer0$2;
                this.assignment$2 = assignment$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.wakeup();
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testGroupConsumption() {
        this.sendRecords(10);
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic2, 0));
        this.sendRecords(1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic3, 0));
        this.sendRecords(1000, new TopicPartition(topic3, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        ((KafkaConsumer)this.consumers().head()).subscribe(pattern, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().head()).poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().head()).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic4 = "tsomec";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic4, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic4, 0));
        this.sendRecords(1000, new TopicPartition(topic4, 1));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().head()).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().head()).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String fooTopic = "foo";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), fooTopic, 1, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(fooTopic, 0));
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer0.subscribe(pattern1, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        consumer0.poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;
            private final ObjectRef subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$3.poll(50L);
                java.util.Set set = this.consumer0$3.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$3 = consumer0$3;
                this.subscriptions$2 = subscriptions$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String barTopic = "bar";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), barTopic, 1, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(barTopic, 0));
        Pattern pattern2 = Pattern.compile("...");
        consumer0.subscribe(pattern2, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        consumer0.poll(50L);
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, subscriptions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;
            private final ObjectRef subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$3.poll(50L);
                java.util.Set set = this.consumer0$3.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$2.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$3 = consumer0$3;
                this.subscriptions$2 = subscriptions$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().head()).poll(50L);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$3 = subscriptions$3;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().head()).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().head()).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, "foo");
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, (Object)((KafkaConsumer)this.consumers().head()).committed(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)asyncMetadata)}))).asJava(), (OffsetCommitCallback)callback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), callback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((Object)asyncMetadata, (Object)((KafkaConsumer)this.consumers().head()).committed(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)nullMetadata)}))).asJava());
        Assert.assertEquals((Object)nullMetadata, (Object)((KafkaConsumer)this.consumers().head()).committed(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.poll(0L);
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)new Serializable(this, consumer, callback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$1;
            private final BaseConsumerTest.CountConsumerCommitCallback callback$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.consumer$1.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)this.callback$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.callback$1 = callback$1;
            }
        });
        this.awaitCommitCallback(consumer, callback, count);
        Assert.assertEquals((Object)new OffsetAndMetadata((long)count), (Object)consumer.committed(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$4 = subscriptions$4;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().head()).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expandedSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set expandedSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expandedSubscriptions).asJava(), ((KafkaConsumer)this.consumers().head()).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        scala.collection.immutable.Set shrunkenSubscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$5).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$5 = subscriptions$5;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().head()).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, shrunkenSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().head()).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().head()).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)shrunkenSubscriptions).asJava(), ((KafkaConsumer)this.consumers().head()).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "part-test", numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        java.util.List parts = ((KafkaConsumer)this.consumers().head()).partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        java.util.List partitions = ((KafkaConsumer)this.consumers().head()).partitionsFor("non-exist-topic");
        Assert.assertFalse((boolean)partitions.isEmpty());
    }

    @Test(expected=InvalidTopicException.class)
    public void testPartitionsForInvalidTopic() {
        ((KafkaConsumer)this.consumers().head()).partitionsFor(";3# ads,{234");
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        this.sendRecords((int)totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp2()), (float)0.0f);
        KafkaConsumer x$17 = consumer;
        int x$18 = 1;
        int x$19 = 0;
        TopicPartition x$20 = this.tp2();
        int x$21 = this.consumeAndVerifyRecords$default$4();
        long x$22 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$23 = this.consumeAndVerifyRecords$default$6();
        int x$24 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$17, x$18, x$19, x$21, x$22, x$23, x$20, x$24);
        consumer.seek(this.tp2(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        KafkaConsumer x$25 = consumer;
        int x$26 = 1;
        int x$27 = (int)mid;
        int x$28 = (int)mid;
        long x$29 = mid;
        TopicPartition x$30 = this.tp2();
        TimestampType x$31 = this.consumeAndVerifyRecords$default$6();
        int x$32 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        String x$33 = this.brokerList();
        SecurityProtocol x$34 = this.securityProtocol();
        Option<File> x$35 = this.trustStoreFile();
        Option<Properties> x$36 = this.saslProperties();
        int x$37 = 0;
        long x$38 = Long.MAX_VALUE;
        Some x$39 = new Some((Object)producerProps);
        int x$40 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$41 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$42 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$43 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$44 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$45 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$33, x$40, x$41, x$42, x$37, x$38, x$43, x$34, x$35, x$36, x$44, x$45, (Option<Properties>)x$39);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, tp, producer){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes()));
            }
            {
                this.tp$1 = tp$1;
                this.producer$1 = producer$1;
            }
        });
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        this.sendRecords(5);
        Assert.assertNull((Object)((KafkaConsumer)this.consumers().head()).committed(new TopicPartition(this.topic(), 15)));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return ((KafkaConsumer)this.$outer.consumers().head()).position(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)((KafkaConsumer)this.consumers().head()).position(this.tp()));
        ((KafkaConsumer)this.consumers().head()).commitSync();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)((KafkaConsumer)this.consumers().head()).position(this.tp()));
        ((KafkaConsumer)this.consumers().head()).commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(1)).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(1)), 1, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava();
        this.sendRecords(5);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        ((KafkaConsumer)this.consumers().head()).pause((Collection)partitions);
        this.sendRecords(5);
        Assert.assertTrue((boolean)((KafkaConsumer)this.consumers().head()).poll(0L).isEmpty());
        ((KafkaConsumer)this.consumers().head()).resume((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), 5, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int totalRecords = 2;
        this.sendRecords(totalRecords, this.tp());
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$4.poll(50L);
            }
            {
                this.consumer0$4 = consumer0$4;
            }
        }, ManifestFactory$.MODULE$.classType(NoOffsetForPartitionException.class));
        int outOfRangePos = totalRecords + 1;
        consumer0.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$4.poll(20000L);
            }
            {
                this.consumer0$4 = consumer0$4;
            }
        }, ManifestFactory$.MODULE$.classType(OffsetOutOfRangeException.class));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        ((KafkaProducer)this.producers().head()).send(record);
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = consumer0.poll(20000L);
        Assert.assertEquals((long)1L, (long)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        ((KafkaProducer)this.producers().head()).send(smallRecord);
        ((KafkaProducer)this.producers().head()).send(largeRecord);
        consumer0.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = consumer0.poll(20000L);
        Assert.assertEquals((long)1L, (long)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}));
        topics.foreach((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;

            public final scala.collection.immutable.Map<Object, Option<Object>> apply(String topicName) {
                return TestUtils$.MODULE$.createTopic(this.$outer.zkUtils(), topicName, this.partitionCount$1, this.$outer.serverCount(), (Seq<KafkaServer>)this.$outer.servers(), TestUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
            }
        });
        Seq partitions = (Seq)topics.flatMap((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final int partitionCount$1;

            public final IndexedSeq<TopicPartition> apply(String topic) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitionCount$1).map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final TopicPartition apply(int x$1) {
                        return new TopicPartition(this.topic$1, x$1);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.partitionCount$1 = partitionCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, partitions){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final Seq partitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.partitions$1.toSet()).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.partitions$1 = partitions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq producerRecords = (Seq)partitions.flatMap((Function1)new Serializable(this, partitionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int partitionCount$1;

            public final Seq<ProducerRecord<byte[], byte[]>> apply(TopicPartition x$2) {
                return this.$outer.sendRecords(this.partitionCount$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionCount$1 = partitionCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer0, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((TraversableOnce)producerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Integer, String, String, Long> apply(ProducerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp());
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set actual = ((TraversableOnce)consumerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple5<String, Object, String, String, Object> apply(ConsumerRecord<byte[], byte[]> record) {
                return new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp()));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$6;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$6.poll(50L);
                java.util.Set set = this.consumer0$6.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$6 = consumer0$6;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic3 = "topic3";
        this.createTopicAndSendRecords(topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$6;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$6.poll(50L);
                java.util.Set set = this.consumer0$6.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$6 = consumer0$6;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newExpectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$6;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$6.poll(50L);
                java.util.Set set = this.consumer0$6.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$6 = consumer0$6;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        Tuple2 tuple22;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) throw new MatchError(tuple2);
        Buffer rrConsumers = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)rrConsumers, (Object)consumerPollers);
        Buffer rrConsumers2 = (Buffer)tuple23._1();
        Buffer consumerPollers2 = (Buffer)tuple23._2();
        try {
            this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, this.consumers(), (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        catch (Throwable throwable) {
            void var10_10;
            var10_10.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$4) {
                    x$4.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers2.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerDefaultAssignment() {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 5, 100));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers(this.consumers(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, this.consumers(), consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller x$5) {
                    x$5.shutdown();
                }
            });
            throw throwable;
        }
        consumerPollers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = new KafkaProducer(producerProps, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$1.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$1 = testProducer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$6) {
                return x$6.get();
            }
        });
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        try {
            testProducer.send(null, null);
            throw this.fail("Should not allow sending a null record");
        }
        catch (Throwable throwable) {
            Assert.assertEquals((String)"Interceptor should be notified about exception", (long)1L, (long)MockProducerInterceptor.ON_ERROR_COUNT.intValue());
            Assert.assertEquals((String)"Interceptor should not receive metadata with an exception when record is null", (long)0L, (long)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue());
            this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
            KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
            testConsumer.seek(this.tp(), 0L);
            ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, appendStr, records){
                public static final long serialVersionUID = 0L;
                private final String appendStr$1;
                private final ArrayBuffer records$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new String((String)record.key()));
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), this.appendStr$1})).toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
                }
                {
                    this.appendStr$1 = appendStr$1;
                    this.records$1 = records$1;
                }
            });
            int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
            testConsumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
            Assert.assertEquals((long)2L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 1), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback();
            testConsumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(5L))}))).asJava(), (OffsetCommitCallback)commitCallback);
            this.awaitCommitCallback(testConsumer, commitCallback, this.awaitCommitCallback$default$3());
            Assert.assertEquals((long)5L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 2), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            testConsumer.close();
            testProducer.close();
            MockConsumerInterceptor.resetCounters();
            MockProducerInterceptor.resetCounters();
            return;
        }
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int numRecords = 100;
        KafkaProducer testProducer = new KafkaProducer(this.producerConfig(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, testProducer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaProducer testProducer$2;

            public final Future<RecordMetadata> apply(int i) {
                return this.testProducer$2.send(new ProducerRecord(this.$outer.tp().topic(), Predef$.MODULE$.int2Integer(this.$outer.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.testProducer$2 = testProducer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                return x$7.get();
            }
        });
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2})), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assert.assertEquals((long)10L, (long)testConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)20L, (long)testConsumer.committed(this.tp2()).offset());
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        this.producers().$plus$eq((Object)testProducer);
        testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$).getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)testConsumer);
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3());
        ConsumerRecord record = (ConsumerRecord)records.head();
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value will not be modified"})).s((Seq)Nil$.MODULE$), (Object)new String((byte[])record.value()));
    }

    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        this.sendRecords(numRecords, this.tp());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, 0, 0L, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages(numRecords, this.tp2());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        KafkaConsumer x$46 = (KafkaConsumer)this.consumers().head();
        int x$47 = numRecords;
        TopicPartition x$48 = this.tp2();
        int x$49 = 0;
        int x$50 = 0;
        long x$51 = 0L;
        TimestampType x$52 = this.consumeAndVerifyRecords$default$6();
        int x$53 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$46, x$47, x$49, x$50, x$51, x$52, x$48, x$53);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 2, 2, (Seq<KafkaServer>)this.servers(), topicProps);
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        this.sendRecords(numRecords, tp1);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1}))).asJava());
        KafkaConsumer x$54 = (KafkaConsumer)this.consumers().head();
        int x$55 = numRecords;
        TopicPartition x$56 = tp1;
        int x$57 = 0;
        int x$58 = 0;
        long x$59 = startTime;
        TimestampType x$60 = TimestampType.LOG_APPEND_TIME;
        int x$61 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$54, x$55, x$57, x$58, x$59, x$60, x$56, x$61);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        KafkaConsumer x$62 = (KafkaConsumer)this.consumers().head();
        int x$63 = numRecords;
        TopicPartition x$64 = tp2;
        int x$65 = 0;
        int x$66 = 0;
        long x$67 = startTime;
        TimestampType x$68 = TimestampType.LOG_APPEND_TIME;
        int x$69 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$62, x$63, x$65, x$66, x$67, x$68, x$64, x$69);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        java.util.Map topics = ((KafkaConsumer)this.consumers().head()).listTopics();
        Assert.assertNotNull((Object)topics);
        Assert.assertEquals((long)5L, (long)topics.size());
        Assert.assertEquals((long)5L, (long)topics.keySet().size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic1)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic2)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testOffsetsForTimes() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, numParts, 1, (Seq<KafkaServer>)this.servers(), props);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.intercept((Function0)new Serializable(this, topic1, consumer){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;
            private final KafkaConsumer consumer$3;

            public final java.util.Map<TopicPartition, OffsetAndTimestamp> apply() {
                return this.consumer$3.offsetsForTimes(Collections.singletonMap(new TopicPartition(this.topic1$1, 0), Predef$.MODULE$.long2Long(-1L)));
            }
            {
                this.topic1$1 = topic1$1;
                this.consumer$3 = consumer$3;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3})).foreach((Function1)new Serializable(this, numParts, timestampsToSearch, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final int numParts$1;
            public final HashMap timestampsToSearch$1;
            public final IntRef i$1;

            public final void apply(String topic) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numParts$1).foreach$mVc$sp((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testOffsetsForTimes$2 $outer;
                    private final String topic$2;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        TopicPartition tp = new TopicPartition(this.topic$2, part);
                        this.$outer.kafka$api$PlaintextConsumerTest$$anonfun$$$outer().sendRecords(100, tp);
                        this.$outer.timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(this.$outer.i$1.elem * 20)));
                        ++this.$outer.i$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$2 = topic$2;
                    }
                });
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numParts$1 = numParts$1;
                this.timestampsToSearch$1 = timestampsToSearch$1;
                this.i$1 = i$1;
            }
        });
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).offset());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).timestamp());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).offset());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).timestamp());
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 0)));
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 1)));
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).offset());
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).timestamp());
        Assert.assertEquals(null, timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @Test
    public void testEarliestOrLatestOffsets() {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        this.createTopicAndSendRecords(topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)this.servers(), props);
        this.sendRecords(100, new TopicPartition(topic1, 0));
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        java.util.Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t1p0));
        java.util.Map latests = consumer.endOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t1p0));
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener();
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        while (listener.callsToAssigned() == 0) {
            consumer0.poll(50L);
        }
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        this.sendRecords(5);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer0, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer0.pause((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic2"}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer0, 0, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        this.sendRecords(5, this.tp());
        this.sendRecords(7, this.tp2());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).asJava());
        ((KafkaConsumer)this.consumers().head()).poll(50L);
        long pos1 = ((KafkaConsumer)this.consumers().head()).position(this.tp());
        long pos2 = ((KafkaConsumer)this.consumers().head()).position(this.tp2());
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertNull((Object)((KafkaConsumer)this.consumers().head()).committed(this.tp2()));
        Assert.assertEquals((long)pos1, (long)((KafkaConsumer)this.consumers().head()).position(this.tp()));
        Assert.assertEquals((long)pos2, (long)((KafkaConsumer)this.consumers().head()).position(this.tp2()));
        ((KafkaConsumer)this.consumers().head()).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assert.assertEquals((long)3L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp()).offset());
        Assert.assertEquals((long)5L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
        BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(7L))}))).asJava(), (OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), commitCallback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((long)7L, (long)((KafkaConsumer)this.consumers().head()).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        int numRecords = 10000;
        this.sendRecords(numRecords);
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(this, consumer0){
            private final KafkaConsumer consumer0$7;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer0$7.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer0$7 = consumer0$7;
            }
        };
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set assignment$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$7.poll(50L);
                java.util.Set set = this.consumer0$7.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$7 = consumer0$7;
                this.assignment$3 = assignment$3;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$7;
            private final scala.collection.immutable.Set newAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ConsumerRecords records = this.consumer0$7.poll(50L);
                java.util.Set set = this.consumer0$7.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$7 = consumer0$7;
                this.newAssignment$1 = newAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        Assert.assertEquals((long)300L, (long)consumer0.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)consumer0.committed(this.tp2()).offset());
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers().foreach((Function1)new Serializable(this, topic1, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topic1$2;
            private final Buffer consumerPollers$4;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$4.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.topic(), this.topic1$2})))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$2 = topic1$2;
                this.consumerPollers$4 = consumerPollers$4;
            }
        });
        KafkaConsumer timeoutConsumer = new KafkaConsumer(this.consumerConfig());
        Object object = closeConsumer ? BoxedUnit.UNIT : this.consumers().$plus$eq((Object)timeoutConsumer);
        BaseConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        long maxSessionTimeout = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp()))).toLong();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after one consumer left"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), 3L * maxSessionTimeout);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(String topicName, int numPartitions, int recordsPerPartition) {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, topicName, recordsPerPartition, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topicName$1;
            private final int recordsPerPartition$1;
            private final ObjectRef parts$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.topicName$1, partition);
                this.$outer.sendRecords(this.recordsPerPartition$1, tp);
                this.parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)this.parts$1.elem).$plus((Object)tp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicName$1 = topicName$1;
                this.recordsPerPartition$1 = recordsPerPartition$1;
                this.parts$1 = parts$1;
            }
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConsumerTest.ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
        void var3_3;
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        BaseConsumerTest.ConsumerAssignmentPoller consumerPoller = new BaseConsumerTest.ConsumerAssignmentPoller(this, consumer, topicsToSubscribe);
        consumerPoller.start();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<BaseConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1)new Serializable(this, topicsToSubscribe, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final List topicsToSubscribe$2;
            private final Buffer consumerPollers$5;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$5.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicsToSubscribe$2 = topicsToSubscribe$2;
                this.consumerPollers$5 = consumerPollers$5;
            }
        });
        return var3_3;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1)new Serializable(this, consumerGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$2;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int i) {
                return this.consumerGroup$2.$plus$eq((Object)new KafkaConsumer(this.$outer.consumerConfig()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$2 = consumerGroup$2;
            }
        });
        this.consumers().$plus$plus$eq((TraversableOnce)consumerGroup);
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1)new Serializable(this, consumerGroup, consumerPollers, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$1;
            private final Buffer consumerPollers$2;
            private final List topicsToSubscribe$1;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(int i) {
                KafkaConsumer newConsumer = new KafkaConsumer(this.$outer.consumerConfig());
                this.consumerGroup$1.$plus$eq((Object)newConsumer);
                return this.consumerPollers$2.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)newConsumer, (List<String>)this.topicsToSubscribe$1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
                this.consumerPollers$2 = consumerPollers$2;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
            }
        });
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we added ", " consumer(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), BoxesRunTime.boxToInteger((int)numOfConsumersToAdd)})), this.validateGroupAssignment$default$4());
    }

    public void validateGroupAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, String msg, long waitTime) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerPollers$1;
            private final scala.collection.immutable.Set subscriptions$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.consumerPollers$1.foreach((Function1)new Serializable(this, assignments){
                    public static final long serialVersionUID = 0L;
                    private final Buffer assignments$1;

                    public final Buffer<scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller x$8) {
                        return this.assignments$1.$plus$eq(x$8.consumerAssignment());
                    }
                    {
                        this.assignments$1 = assignments$1;
                    }
                });
                return this.$outer.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments, (scala.collection.immutable.Set<TopicPartition>)this.subscriptions$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerPollers$1 = consumerPollers$1;
                this.subscriptions$6 = subscriptions$6;
            }
        }, msg, waitTime);
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1)new Serializable(this, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final List topicsToSubscribe$3;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.subscribe((List<String>)this.topicsToSubscribe$3);
            }
            {
                this.topicsToSubscribe$3 = topicsToSubscribe$3;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final Buffer consumerPollers$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumerPollers$3.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                        return poller.isSubscribeRequestProcessed();
                    }
                });
            }
            {
                this.consumerPollers$3 = consumerPollers$3;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to call subscribe on all consumers in the group for subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subscriptions})), 1000L);
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we changed subscription"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer, subscriptions){
            public static final long serialVersionUID = 0L;
            private final Consumer consumer$2;
            private final scala.collection.immutable.Set subscriptions$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ConsumerRecords records = this.consumer$2.poll(50L);
                java.util.Set set = this.consumer$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$7).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer$2 = consumer$2;
                this.subscriptions$7 = subscriptions$7;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), consumer.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }
}

