/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.coordinator.DelayedStore;
import kafka.coordinator.GroupMetadata;
import kafka.coordinator.GroupMetadata$;
import kafka.coordinator.GroupMetadataManager;
import kafka.coordinator.GroupState;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberMetadata;
import kafka.coordinator.OffsetConfig;
import kafka.coordinator.PreparingRebalance$;
import kafka.log.LogAppendInfo$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001\u001d\u0011\u0001d\u0012:pkBlU\r^1eCR\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0001\u0004%\t!F\u0001\u0005i&lW-F\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tIB!A\u0003vi&d7/\u0003\u0002\u001c1\tAQj\\2l)&lW\rC\u0004\u001e\u0001\u0001\u0007I\u0011\u0001\u0010\u0002\u0011QLW.Z0%KF$\"a\b\u0012\u0011\u0005%\u0001\u0013BA\u0011\u000b\u0005\u0011)f.\u001b;\t\u000f\rb\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0002\u0001\u0015)\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011\u001d9\u0003\u00011A\u0005\u0002!\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001*!\tQS&D\u0001,\u0015\taC!\u0001\u0004tKJ4XM]\u0005\u0003]-\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u00041\u0001\u0001\u0007I\u0011A\u0019\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0003?IBqaI\u0018\u0002\u0002\u0003\u0007\u0011\u0006\u0003\u00045\u0001\u0001\u0006K!K\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!9a\u0007\u0001a\u0001\n\u00039\u0014\u0001F4s_V\u0004X*\u001a;bI\u0006$\u0018-T1oC\u001e,'/F\u00019!\t\u0011\u0012(\u0003\u0002;\u0005\t!rI]8va6+G/\u00193bi\u0006l\u0015M\\1hKJDq\u0001\u0010\u0001A\u0002\u0013\u0005Q(\u0001\rhe>,\b/T3uC\u0012\fG/Y'b]\u0006<WM]0%KF$\"a\b \t\u000f\rZ\u0014\u0011!a\u0001q!1\u0001\t\u0001Q!\na\nQc\u001a:pkBlU\r^1eCR\fW*\u00198bO\u0016\u0014\b\u0005C\u0004C\u0001\u0001\u0007I\u0011A\"\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001#\u0011\u0005])\u0015B\u0001$\u0019\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJDq\u0001\u0013\u0001A\u0002\u0013\u0005\u0011*A\u0007tG\",G-\u001e7fe~#S-\u001d\u000b\u0003?)CqaI$\u0002\u0002\u0003\u0007A\t\u0003\u0004M\u0001\u0001\u0006K\u0001R\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003b\u0002(\u0001\u0001\u0004%\taT\u0001\bu.,F/\u001b7t+\u0005\u0001\u0006CA\fR\u0013\t\u0011\u0006DA\u0004[WV#\u0018\u000e\\:\t\u000fQ\u0003\u0001\u0019!C\u0001+\u0006Y!p[+uS2\u001cx\fJ3r)\tyb\u000bC\u0004$'\u0006\u0005\t\u0019\u0001)\t\ra\u0003\u0001\u0015)\u0003Q\u0003!Q8.\u0016;jYN\u0004\u0003b\u0002.\u0001\u0001\u0004%\taW\u0001\na\u0006\u0014H/\u001b;j_:,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0012\tqa\u00197vgR,'/\u0003\u0002b=\nI\u0001+\u0019:uSRLwN\u001c\u0005\bG\u0002\u0001\r\u0011\"\u0001e\u00035\u0001\u0018M\u001d;ji&|gn\u0018\u0013fcR\u0011q$\u001a\u0005\bG\t\f\t\u00111\u0001]\u0011\u00199\u0007\u0001)Q\u00059\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000f%\u0004!\u0019!C\u0001U\u00069qM]8va&#W#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00027b]\u001eT\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n11\u000b\u001e:j]\u001eDa\u0001\u001e\u0001!\u0002\u0013Y\u0017\u0001C4s_V\u0004\u0018\n\u001a\u0011\t\u000fY\u0004!\u0019!C\u0001o\u0006\u0001rM]8vaB\u000b'\u000f^5uS>t\u0017\nZ\u000b\u0002qB\u0011\u0011\"_\u0005\u0003u*\u00111!\u00138u\u0011\u0019a\b\u0001)A\u0005q\u0006\trM]8vaB\u000b'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000fy\u0004!\u0019!C\u0001U\u0006a\u0001O]8u_\u000e|G\u000eV=qK\"9\u0011\u0011\u0001\u0001!\u0002\u0013Y\u0017!\u00049s_R|7m\u001c7UsB,\u0007\u0005\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001x\u0003A\u0011XMY1mC:\u001cW\rV5nK>,H\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002=\u0002#I,'-\u00197b]\u000e,G+[7f_V$\b\u0005\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001x\u00039\u0019Xm]:j_:$\u0016.\\3pkRDq!!\u0005\u0001A\u0003%\u00010A\btKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\tQa]3u+B$\u0012a\b\u0015\u0005\u0003'\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000b),h.\u001b;\u000b\u0005\u0005\u0015\u0012aA8sO&!\u0011\u0011FA\u0010\u0005\u0019\u0011UMZ8sK\"9\u0011Q\u0006\u0001\u0005\u0002\u0005]\u0011\u0001\u0003;fCJ$un\u001e8)\t\u0005-\u0012\u0011\u0007\t\u0005\u0003;\t\u0019$\u0003\u0003\u00026\u0005}!!B!gi\u0016\u0014\bbBA\u001d\u0001\u0011\u0005\u0011qC\u0001\ri\u0016\u001cH/\u00113e\u000fJ|W\u000f\u001d\u0015\u0005\u0003o\ti\u0004\u0005\u0003\u0002\u001e\u0005}\u0012\u0002BA!\u0003?\u0011A\u0001V3ti\"9\u0011Q\t\u0001\u0005\u0002\u0005]\u0011a\u0005;fgR\u001cFo\u001c:f\u000b6\u0004H/_$s_V\u0004\b\u0006BA\"\u0003{Aq!a\u0013\u0001\t\u0003\t9\"\u0001\u000euKN$8\u000b^8sK\u001e\u0013x.\u001e9FeJ|'/T1qa&tw\r\u000b\u0003\u0002J\u0005u\u0002bBA)\u0001\u0011%\u00111K\u0001\u001dCN\u001cXM\u001d;Ti>\u0014Xm\u0012:pkB,%O]8s\u001b\u0006\u0004\b/\u001b8h)\u0015y\u0012QKA8\u0011!\t9&a\u0014A\u0002\u0005e\u0013aC1qa\u0016tG-\u0012:s_J\u0004B!a\u0017\u0002l5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0005qe>$xnY8m\u0015\u0011\t\u0019'!\u001a\u0002\r\r|W.\\8o\u0015\r)\u0011q\r\u0006\u0005\u0003S\n\u0019#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003[\niF\u0001\u0004FeJ|'o\u001d\u0005\t\u0003c\ny\u00051\u0001\u0002Z\u0005iQ\r\u001f9fGR,G-\u0012:s_JDq!!\u001e\u0001\t\u0003\t9\"\u0001\fuKN$8\u000b^8sK:{g.R7qif<%o\\;qQ\u0011\t\u0019(!\u0010\t\u000f\u0005m\u0004\u0001\"\u0001\u0002\u0018\u0005\u0001B/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r\u001e\u0015\u0005\u0003s\ni\u0004C\u0004\u0002\u0002\u0002!\t!a\u0006\u0002/Q,7\u000f^\"p[6LGo\u00144gg\u0016$h)Y5mkJ,\u0007\u0006BA@\u0003{Aq!a\"\u0001\t\u0013\tI)\u0001\u0010bgN,'\u000f^\"p[6LGo\u00144gg\u0016$XI\u001d:pe6\u000b\u0007\u000f]5oOR)q$a#\u0002\u000e\"A\u0011qKAC\u0001\u0004\tI\u0006\u0003\u0005\u0002r\u0005\u0015\u0005\u0019AA-\u0011\u001d\t\t\n\u0001C\u0001\u0003/\t\u0001\u0003^3ti\u0016C\b/\u001b:f\u001f\u001a47/\u001a;)\t\u0005=\u0015Q\b\u0005\b\u0003/\u0003A\u0011AA\f\u0003=!Xm\u001d;FqBL'/Z$s_V\u0004\b\u0006BAK\u0003{Aq!!(\u0001\t\u0003\t9\"\u0001\u0011uKN$X\t\u001f9je\u0016|eMZ:fiN<\u0016\u000e\u001e5BGRLg/Z$s_V\u0004\b\u0006BAN\u0003{Aq!a)\u0001\t\u0013\t)+A\nfqB,7\r^!qa\u0016tG-T3tg\u0006<W\rF\u0002 \u0003OC\u0001\"!+\u0002\"\u0002\u0007\u0011\u0011L\u0001\u0006KJ\u0014xN\u001d")
public class GroupMetadataManagerTest {
    private MockTime time = null;
    private ReplicaManager replicaManager = null;
    private GroupMetadataManager groupMetadataManager = null;
    private KafkaScheduler scheduler = null;
    private ZkUtils zkUtils = null;
    private Partition partition = null;
    private final String groupId;
    private final int groupPartitionId;
    private final String protocolType;
    private final int rebalanceTimeout;
    private final int sessionTimeout;

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public GroupMetadataManager groupMetadataManager() {
        return this.groupMetadataManager;
    }

    public void groupMetadataManager_$eq(GroupMetadataManager x$1) {
        this.groupMetadataManager = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupPartitionId() {
        return this.groupPartitionId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    @Before
    public void setUp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
        OffsetConfig offsetConfig = new OffsetConfig(Predef$.MODULE$.Integer2int(config.offsetMetadataMaxSize()), Predef$.MODULE$.Integer2int(config.offsetsLoadBufferSize()), (long)(Predef$.MODULE$.Integer2int(config.offsetsRetentionMinutes()) * 60) * 1000L, Predef$.MODULE$.Long2long(config.offsetsRetentionCheckIntervalMs()), Predef$.MODULE$.Integer2int(config.offsetsTopicPartitions()), Predef$.MODULE$.Integer2int(config.offsetsTopicSegmentBytes()), Predef$.MODULE$.Short2short(config.offsetsTopicReplicationFactor()), config.offsetsTopicCompressionCodec(), Predef$.MODULE$.Integer2int(config.offsetCommitTimeoutMs()), Predef$.MODULE$.Short2short(config.offsetCommitRequiredAcks()));
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ret.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Topic$.MODULE$.GroupMetadataTopicName()), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}))));
        this.zkUtils_$eq((ZkUtils)EasyMock.createNiceMock(ZkUtils.class));
        EasyMock.expect((Object)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Topic$.MODULE$.GroupMetadataTopicName()})))).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.groupMetadataManager_$eq(new GroupMetadataManager(0, ApiVersion$.MODULE$.latestVersion(), offsetConfig, this.replicaManager(), this.zkUtils(), (Time)this.time()));
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        EasyMock.reset((Object[])new Object[]{this.partition()});
    }

    @Test
    public void testAddGroup() {
        GroupMetadata group = new GroupMetadata("foo", GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(group));
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(new GroupMetadata("foo", GroupMetadata$.MODULE$.$lessinit$greater$default$2())));
    }

    @Test
    public void testStoreEmptyGroup() {
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreGroup(group, (Map)scala.collection.Map$.MODULE$.empty(), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$1;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$1(error, this.maybeError$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$1 = maybeError$1;
            }
        });
        this.groupMetadataManager().store(delayedStore);
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
    }

    @Test
    public void testStoreGroupErrorMapping() {
        this.assertStoreGroupErrorMapping(Errors.NONE, Errors.NONE);
        this.assertStoreGroupErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR_FOR_GROUP);
        this.assertStoreGroupErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.UNKNOWN);
        this.assertStoreGroupErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.UNKNOWN);
        this.assertStoreGroupErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.UNKNOWN);
        this.assertStoreGroupErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertStoreGroupErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        this.expectAppendMessage(appendError);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreGroup(group, (Map)scala.collection.Map$.MODULE$.empty(), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$2;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$2(error, this.maybeError$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$2 = maybeError$2;
            }
        });
        this.groupMetadataManager().store(delayedStore);
        Assert.assertEquals((Object)new Some((Object)expectedError), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testStoreNonEmptyGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult joinGroupResult) {
            }
        });
        group.add(memberId, member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreGroup(group, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$3;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$3(error, this.maybeError$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$3 = maybeError$3;
            }
        });
        this.groupMetadataManager().store(delayedStore);
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
    }

    @Test
    public void testCommitOffset() {
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$1;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$4(errors, this.commitErrors$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$1 = commitErrors$1;
            }
        });
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)maybeError);
        Assert.assertTrue((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
        Option maybePartitionResponse = cachedOffsets.get((Object)topicPartition);
        Assert.assertFalse((boolean)maybePartitionResponse.isEmpty());
        OffsetFetchResponse.PartitionData partitionResponse = (OffsetFetchResponse.PartitionData)maybePartitionResponse.get();
        Assert.assertEquals((long)Errors.NONE.code(), (long)partitionResponse.errorCode);
        Assert.assertEquals((long)offset, (long)partitionResponse.offset);
    }

    @Test
    public void testCommitOffsetFailure() {
        this.assertCommitOffsetErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR_FOR_GROUP);
        this.assertCommitOffsetErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertCommitOffsetErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        this.expectAppendMessage(appendError);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$2;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$5(errors, this.commitErrors$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$2 = commitErrors$2;
            }
        });
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)expectedError.code())), (Object)maybeError);
        Assert.assertFalse((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$1) {
                return x$1.offset;
            }
        }));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireOffset() {
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        EasyMock.expect((Object)this.replicaManager().getPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId())).andStubReturn((Object)new Some((Object)this.partition()));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$3;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$6(errors, this.commitErrors$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$3 = commitErrors$3;
            }
        });
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(2L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendMessagesToLeader((ByteBufferMessageSet)EasyMock.anyObject(ByteBufferMessageSet.class), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)group.offset(topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$2) {
                return x$2.offset();
            }
        }));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2})));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$3) {
                return x$3.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$4) {
                return x$4.offset;
            }
        }));
    }

    @Test
    public void testExpireGroup() {
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        EasyMock.expect((Object)this.replicaManager().getPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId())).andStubReturn((Object)new Some((Object)this.partition()));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$4;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$7(errors, this.commitErrors$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$4 = commitErrors$4;
            }
        });
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendMessagesToLeader((ByteBufferMessageSet)EasyMock.anyObject(ByteBufferMessageSet.class), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2})));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$5) {
                return x$5.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$6) {
                return x$6.offset;
            }
        }));
    }

    @Test
    public void testExpireOffsetsWithActiveGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult joinGroupResult) {
            }
        });
        group.add(memberId, member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        EasyMock.expect((Object)this.replicaManager().getPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId())).andStubReturn((Object)new Some((Object)this.partition()));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = this.groupMetadataManager().prepareStoreOffsets(group, memberId, group.generationId(), offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$5;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$8(errors, this.commitErrors$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$5 = commitErrors$5;
            }
        });
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendMessagesToLeader((ByteBufferMessageSet)EasyMock.anyObject(ByteBufferMessageSet.class), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition2));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2})));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$7) {
                return x$7.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$8) {
                return x$8.offset;
            }
        }));
    }

    private void expectAppendMessage(Errors error) {
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendMessages(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument){
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedArgument$1;

            public void answer() {
                ((Function1)this.capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.$outer.groupPartitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$1.code(), 0L, -1L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedArgument$1 = capturedArgument$1;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1())));
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$1(Errors error, ObjectRef maybeError$1) {
        maybeError$1.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$2(Errors error, ObjectRef maybeError$2) {
        maybeError$2.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$3(Errors error, ObjectRef maybeError$3) {
        maybeError$3.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$4(scala.collection.immutable.Map errors, ObjectRef commitErrors$1) {
        commitErrors$1.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$5(scala.collection.immutable.Map errors, ObjectRef commitErrors$2) {
        commitErrors$2.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$6(scala.collection.immutable.Map errors, ObjectRef commitErrors$3) {
        commitErrors$3.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$7(scala.collection.immutable.Map errors, ObjectRef commitErrors$4) {
        commitErrors$4.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$8(scala.collection.immutable.Map errors, ObjectRef commitErrors$5) {
        commitErrors$5.elem = new Some((Object)errors);
    }

    public GroupMetadataManagerTest() {
        this.groupId = "foo";
        this.groupPartitionId = 0;
        this.protocolType = "protocolType";
        this.rebalanceTimeout = 60000;
        this.sessionTimeout = 10000;
    }
}

