/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.AwaitingSync$;
import kafka.coordinator.Dead$;
import kafka.coordinator.Empty$;
import kafka.coordinator.GroupMetadata;
import kafka.coordinator.GroupMetadata$;
import kafka.coordinator.GroupState;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberMetadata;
import kafka.coordinator.PreparingRebalance$;
import kafka.coordinator.Stable$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011c\u0012:pkBlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%I!G\u0001\raJ|Go\\2pYRK\b/Z\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005Y\u0006twMC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"AB*ue&tw\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\u000eaJ|Go\\2pYRK\b/\u001a\u0011\t\u000f\u0015\u0002!\u0019!C\u00053\u00059qM]8va&#\u0007BB\u0014\u0001A\u0003%!$\u0001\u0005he>,\b/\u00133!\u0011\u001dI\u0003A1A\u0005\ne\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u000e\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003bB\u0017\u0001\u0005\u0004%I!G\u0001\u000bG2LWM\u001c;I_N$\bBB\u0018\u0001A\u0003%!$A\u0006dY&,g\u000e\u001e%pgR\u0004\u0003bB\u0019\u0001\u0005\u0004%IAM\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5/F\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\rIe\u000e\u001e\u0005\u0007u\u0001\u0001\u000b\u0011B\u001a\u0002'I,'-\u00197b]\u000e,G+[7f_V$Xj\u001d\u0011\t\u000fq\u0002!\u0019!C\u0005e\u0005\u00012/Z:tS>tG+[7f_V$Xj\u001d\u0005\u0007}\u0001\u0001\u000b\u0011B\u001a\u0002#M,7o]5p]RKW.Z8vi6\u001b\b\u0005C\u0004A\u0001\u0001\u0007I\u0011B!\u0002\u000b\u001d\u0014x.\u001e9\u0016\u0003\t\u0003\"AF\"\n\u0005\u0011\u0013!!D$s_V\u0004X*\u001a;bI\u0006$\u0018\rC\u0004G\u0001\u0001\u0007I\u0011B$\u0002\u0013\u001d\u0014x.\u001e9`I\u0015\fHC\u0001%L!\t!\u0014*\u0003\u0002Kk\t!QK\\5u\u0011\u001daU)!AA\u0002\t\u000b1\u0001\u001f\u00132\u0011\u0019q\u0005\u0001)Q\u0005\u0005\u00061qM]8va\u0002BQ\u0001\u0015\u0001\u0005\u0002E\u000bQa]3u+B$\u0012\u0001\u0013\u0015\u0003\u001fN\u0003\"\u0001\u0016,\u000e\u0003US!a\u0003\b\n\u0005]+&A\u0002\"fM>\u0014X\rC\u0003Z\u0001\u0011\u0005\u0011+\u0001\u000euKN$8)\u00198SK\n\fG.\u00198dK^CWM\\*uC\ndW\r\u000b\u0002Y7B\u0011A\u000bX\u0005\u0003;V\u0013A\u0001V3ti\")q\f\u0001C\u0001#\u0006\u0001C/Z:u\u0007\u0006t'+\u001a2bY\u0006t7-Z,iK:\fu/Y5uS:<7+\u001f8dQ\tq6\fC\u0003c\u0001\u0011\u0005\u0011+A\u0015uKN$8)\u00198o_R\u0014VMY1mC:\u001cWm\u00165f]B\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a\u0015\u0003CnCQ!\u001a\u0001\u0005\u0002E\u000b1\u0004^3ti\u000e\u000bgN\\8u%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8EK\u0006$\u0007F\u00013\\\u0011\u0015A\u0007\u0001\"\u0001R\u0003!\"Xm\u001d;Ti\u0006\u0014G.\u001a+p!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\r\u0016:b]NLG/[8oQ\t97\fC\u0003l\u0001\u0011\u0005\u0011+\u0001\u000euKN$8\u000b^1cY\u0016$v\u000eR3bIR\u0013\u0018M\\:ji&|g\u000e\u000b\u0002k7\")a\u000e\u0001C\u0001#\u0006qC/Z:u\u0003^\f\u0017\u000e^5oONKhn\u0019+p!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\r\u0016:b]NLG/[8oQ\ti7\fC\u0003r\u0001\u0011\u0005\u0011+\u0001\u0014uKN$\bK]3qCJLgn\u001a*fE\u0006d\u0017M\\2f)>$U-\u00193Ue\u0006t7/\u001b;j_:D#\u0001].\t\u000bQ\u0004A\u0011A)\u0002OQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.R7qif$&/\u00198tSRLwN\u001c\u0015\u0003gnCQa\u001e\u0001\u0005\u0002E\u000b\u0011\u0004^3ti\u0016k\u0007\u000f^=U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u0012ao\u0017\u0005\u0006u\u0002!\t!U\u0001#i\u0016\u001cH/Q<bSRLgnZ*z]\u000e$vn\u0015;bE2,GK]1og&$\u0018n\u001c8)\u0005e\\\u0006\"B?\u0001\t\u0003\t\u0016a\t;fgR\u001cF/\u00192mKR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0006yn{\u0018\u0011A\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u00111\u0001\t\u00047\u0005\u0015\u0011bAA\u00049\t)\u0012\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>t\u0007BBA\u0006\u0001\u0011\u0005\u0011+A\u0015uKN$8\u000b^1cY\u0016$v.Q<bSRLgnZ*z]\u000eLE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0007\u0003\u0013Yv0!\u0001\t\r\u0005E\u0001\u0001\"\u0001R\u0003m\"Xm\u001d;Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0007\u0003\u001fYv0!\u0001\t\r\u0005]\u0001\u0001\"\u0001R\u0003=\"Xm\u001d;Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,Gk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\u0019\t)bW@\u0002\u0002!1\u0011Q\u0004\u0001\u0005\u0002E\u000bq\u0006^3ti\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2U_\u0006;\u0018-\u001b;j]\u001e\u001c\u0016P\\2JY2,w-\u00197Ue\u0006t7/\u001b;j_:Dc!a\u0007\\\u007f\u0006\u0005\u0001BBA\u0012\u0001\u0011\u0005\u0011+A\u0010uKN$H)Z1e)>$U-\u00193JY2,w-\u00197Ue\u0006t7/\u001b;j_:Da!a\n\u0001\t\u0003\t\u0016!\t;fgR$U-\u00193U_N#\u0018M\u00197f\u00132dWmZ1m)J\fgn]5uS>t\u0007FBA\u00137~\f\t\u0001\u0003\u0004\u0002.\u0001!\t!U\u0001.i\u0016\u001cH\u000fR3bIR{\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007FBA\u00167~\f\t\u0001\u0003\u0004\u00024\u0001!\t!U\u0001(i\u0016\u001cH\u000fR3bIR{\u0017i^1ji&twmU=oG&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000e\u000b\u0004\u00022m{\u0018\u0011\u0001\u0005\u0007\u0003s\u0001A\u0011A)\u0002%Q,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0004\u0003oY\u0006BBA \u0001\u0011\u0005\u0011+A\u0012uKN$8+\u001a7fGR\u0004&o\u001c;pG>d'+Y5tKNLeMT8NK6\u0014WM]:)\r\u0005u2l`A\u0001\u0011\u0019\t)\u0005\u0001C\u0001#\u0006YC/Z:u'\u0016dWm\u0019;Qe>$xnY8m\u0007\"|wn]3t\u0007>l\u0007/\u0019;jE2,\u0007K]8u_\u000e|G\u000eK\u0002\u0002DmCa!a\u0013\u0001\t\u0003\t\u0016!\u0006;fgR\u001cV\u000f\u001d9peR\u001c\bK]8u_\u000e|Gn\u001d\u0015\u0004\u0003\u0013Z\u0006BBA)\u0001\u0011\u0005\u0011+\u0001\fuKN$\u0018J\\5u\u001d\u0016DHoR3oKJ\fG/[8oQ\r\tye\u0017\u0005\u0007\u0003/\u0002A\u0011A)\u0002AQ,7\u000f^%oSRtU\r\u001f;HK:,'/\u0019;j_:,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0004\u0003+Z\u0006BBA/\u0001\u0011\u0005\u0011+\u0001\tuKN$xJ\u001a4tKR\u001cu.\\7ji\"\u001a\u00111L.\t\r\u0005\r\u0004\u0001\"\u0001R\u0003]!Xm\u001d;PM\u001a\u001cX\r^\"p[6LGOR1jYV\u0014X\rK\u0002\u0002bmCa!!\u001b\u0001\t\u0003\t\u0016!\u000b;fgR|eMZ:fi\u000e{W.\\5u\r\u0006LG.\u001e:f/&$\b.\u00118pi\",'\u000fU3oI&tw\rK\u0002\u0002hmCa!a\u001c\u0001\t\u0003\t\u0016A\t;fgR|eMZ:fi\u000e{W.\\5u/&$\b.\u00118pi\",'\u000fU3oI&tw\rK\u0002\u0002nmCq!!\u001e\u0001\t\u0013\t9(A\u0006bgN,'\u000f^*uCR,G#\u0002%\u0002z\u0005m\u0004B\u0002!\u0002t\u0001\u0007!\t\u0003\u0005\u0002~\u0005M\u0004\u0019AA@\u0003-!\u0018M]4fiN#\u0018\r^3\u0011\u0007Y\t\t)C\u0002\u0002\u0004\n\u0011!b\u0012:pkB\u001cF/\u0019;f\u0001")
public class GroupMetadataTest
extends JUnitSuite {
    private final String protocolType;
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", GroupMetadata$.MODULE$.$lessinit$greater$default$2()));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenAwaitingSync() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingSyncToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingSyncToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testStableToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingSyncToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingSyncIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)AwaitingSync$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(memberId, member);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(otherMemberId, otherMember);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(lastMemberId, lastMember);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        throw this.fail();
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(memberId, member);
        this.group().add(otherMemberId, otherMember);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(memberId, member);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().add(otherMemberId, otherMember);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testInitNextGeneration() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult result) {
            }
        });
        this.group().add(memberId, member);
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocol());
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().protocol());
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocol());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocol());
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().completePendingOffsetWrite(partition, offset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(37L);
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().completePendingOffsetWrite(partition, secondOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(37L);
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().completePendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().completePendingOffsetWrite(partition, secondOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, AwaitingSync$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$1;

            public final void apply(GroupState otherState) {
                Assert.assertFalse((boolean)this.group$1.is(otherState));
            }
            {
                this.group$1 = group$1;
            }
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

