/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminUtils$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.network.Processor;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u00111\u0001B\u0001\fS:$Xm\u001a:bi&|gNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u0013\t\u0014xn[3s\u0013\u0012\fT#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG\u000f\u0003\u0004(\u0001\u0001\u0006I\u0001I\u0001\u000bEJ|7.\u001a:JIF\u0002\u0003bB\u0015\u0001\u0005\u0004%\taH\u0001\nEJ|7.\u001a:JIJBaa\u000b\u0001!\u0002\u0013\u0001\u0013A\u00032s_.,'/\u001333A!9Q\u0006\u0001b\u0001\n\u0003q\u0013\u0001G3oC\ndWmQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]V\tq\u0006\u0005\u0002\"a%\u0011\u0011G\t\u0002\b\u0005>|G.Z1o\u0011\u0019\u0019\u0004\u0001)A\u0005_\u0005IRM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8!\u0011\u001d)\u0004\u00011A\u0005\u0002Y\nAbY8oM&<\u0007K]8qgF*\u0012a\u000e\t\u0003quj\u0011!\u000f\u0006\u0003um\nA!\u001e;jY*\tA(\u0001\u0003kCZ\f\u0017B\u0001 :\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001B\u0003A\u0019wN\u001c4jOB\u0013x\u000e]:2?\u0012*\u0017\u000f\u0006\u0002C\u000bB\u0011\u0011eQ\u0005\u0003\t\n\u0012A!\u00168ji\"9aiPA\u0001\u0002\u00049\u0014a\u0001=%c!1\u0001\n\u0001Q!\n]\nQbY8oM&<\u0007K]8qgF\u0002\u0003b\u0002&\u0001\u0001\u0004%\tAN\u0001\rG>tg-[4Qe>\u00048O\r\u0005\b\u0019\u0002\u0001\r\u0011\"\u0001N\u0003A\u0019wN\u001c4jOB\u0013x\u000e]:3?\u0012*\u0017\u000f\u0006\u0002C\u001d\"9aiSA\u0001\u0002\u00049\u0004B\u0002)\u0001A\u0003&q'A\u0007d_:4\u0017n\u001a)s_B\u001c(\u0007\t\u0005\b%\u0002\u0001\r\u0011\"\u0001T\u0003\u001d\u0019wN\u001c4jON,\u0012\u0001\u0016\t\u0004+v\u0003gB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tIf!\u0001\u0004=e>|GOP\u0005\u0002G%\u0011ALI\u0001\ba\u0006\u001c7.Y4f\u0013\tqvLA\u0002TKFT!\u0001\u0018\u0012\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r$\u0011AB:feZ,'/\u0003\u0002fE\nY1*\u00194lC\u000e{gNZ5h\u0011\u001d9\u0007\u00011A\u0005\u0002!\f1bY8oM&<7o\u0018\u0013fcR\u0011!)\u001b\u0005\b\r\u001a\f\t\u00111\u0001U\u0011\u0019Y\u0007\u0001)Q\u0005)\u0006A1m\u001c8gS\u001e\u001c\b\u0005C\u0004n\u0001\u0001\u0007I\u0011\u00018\u0002\u000fM,'O^3sgV\tq\u000eE\u0002V;B\u0004\"!Y9\n\u0005I\u0014'aC&bM.\f7+\u001a:wKJDq\u0001\u001e\u0001A\u0002\u0013\u0005Q/A\u0006tKJ4XM]:`I\u0015\fHC\u0001\"w\u0011\u001d15/!AA\u0002=Da\u0001\u001f\u0001!B\u0013y\u0017\u0001C:feZ,'o\u001d\u0011\t\u000fi\u0004!\u0019!C\u0001w\u00061!/\u00198e_6,\u0012\u0001 \t\u0003{~l\u0011A \u0006\u0003u\tJ1!!\u0001\u007f\u0005\u0019\u0011\u0016M\u001c3p[\"9\u0011Q\u0001\u0001!\u0002\u0013a\u0018a\u0002:b]\u0012|W\u000e\t\u0005\n\u0003\u0013\u0001!\u0019!C\u0001\u0003\u0017\tQ\u0001^8qS\u000e,\"!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005<\u0003\u0011a\u0017M\\4\n\t\u0005]\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001b\ta\u0001^8qS\u000e\u0004\u0003\u0002CA\u0010\u0001\t\u0007I\u0011A\u0010\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0003G\u0001\u0001\u0015!\u0003!\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011%\t9\u0003\u0001b\u0001\n\u0003\tI#A\blC\u001a\\\u0017-\u00119jg2{wmZ3s+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\u000b1|w\r\u000e6\u000b\u0007\u0005Ub\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003s\tyC\u0001\u0004M_\u001e<WM\u001d\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002,\u0005\u00012.\u00194lC\u0006\u0003\u0018n\u001d'pO\u001e,'\u000f\t\u0005\n\u0003\u0003\u0002!\u0019!C\u0001\u0003S\taC\\3uo>\u00148\u000e\u0015:pG\u0016\u001c8o\u001c:M_\u001e<WM\u001d\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002,\u00059b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'\u000f\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0001\u0003S\t!c]=oGB\u0013x\u000eZ;dKJdunZ4fe\"A\u0011Q\n\u0001!\u0002\u0013\tY#A\nts:\u001c\u0007K]8ek\u000e,'\u000fT8hO\u0016\u0014\b\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0001\u0002*\u0005\u0011RM^3oi\"\u000bg\u000e\u001a7fe2{wmZ3s\u0011!\t)\u0006\u0001Q\u0001\n\u0005-\u0012aE3wK:$\b*\u00198eY\u0016\u0014Hj\\4hKJ\u0004\u0003bBA-\u0001\u0011\u0005\u00131L\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0005\"\"\u0011qKA0!\u0011\t\t'!\u001a\u000e\u0005\u0005\r$BA\u0006\u000f\u0013\u0011\t9'a\u0019\u0003\r\t+gm\u001c:f\u0011\u001d\tY\u0007\u0001C!\u00037\n\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003S\ny\u0007\u0005\u0003\u0002b\u0005E\u0014\u0002BA:\u0003G\u0012Q!\u00114uKJDq!a\u001e\u0001\t\u0013\tI(\u0001\u0007ti\u0006\u0014HO\u0011:pW\u0016\u00148\u000fF\u0002C\u0003wB\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\bG2,8\u000f^3s!\r)Vl\u000e\u0005\b\u0003\u0007\u0003A\u0011AAC\u0003\u0001\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0016\u0003\tCC!!!\u0002\nB!\u0011\u0011MAF\u0013\u0011\ti)a\u0019\u0003\tQ+7\u000f\u001e\u0005\b\u0003#\u0003A\u0011AAC\u0003\u0005\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3eQ\u0011\ty)!#\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u0006\u0006yC/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3e\u0005f$v\u000e]5d\u001fZ,'O]5eK\"\"\u0011QSAE\u0011\u001d\ti\n\u0001C\u0001\u0003\u000b\u000ba\u0006^3ti\u000ecW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3e\u0005f$v\u000e]5d\u001fZ,'O]5eK\"\"\u00111TAE\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u000b\u000bQ\u0006^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]&sg/\u00197jIR{\u0007/[2Pm\u0016\u0014(/\u001b3fQ\u0011\t\t+!#\t\u000f\u0005%\u0006\u0001\"\u0001\u0002\u0006\u0006\u0011c/\u001a:jMf,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012Dq!!,\u0001\t\u0003\t))A\u0012wKJLg-_+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\u0006q1\u000f[;uI><hnU3sm\u0016\u0014Hc\u0001\"\u00026\"11-a,A\u0002ADq!!/\u0001\t\u0013\tY,\u0001\nd_:\u001cX/\\3BY2lUm]:bO\u0016\u001cH\u0003BA_\u0003\u001f\u0004R!VA`\u0003\u0007L1!!1`\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0015\u00171\u001a\b\u0004C\u0005\u001d\u0017bAAeE\u00051\u0001K]3eK\u001aLA!a\u0006\u0002N*\u0019\u0011\u0011\u001a\u0012\t\u0011\u0005%\u0011q\u0017a\u0001\u0003\u0007\u0004")
public class UncleanLeaderElectionTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1;
    private Properties configProps2;
    private Seq<KafkaConfig> configs;
    private Seq<KafkaServer> servers;
    private final Random random;
    private final String topic;
    private final int partitionId;
    private final Logger kafkaApisLogger;
    private final Logger networkProcessorLogger;
    private final Logger syncProducerLogger;
    private final Logger eventHandlerLogger;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        UncleanLeaderElectionTest uncleanLeaderElectionTest = this;
        synchronized (uncleanLeaderElectionTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    public Logger syncProducerLogger() {
        return this.syncProducerLogger;
    }

    public Logger eventHandlerLogger() {
        return this.eventHandlerLogger;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final Object apply(Properties configProps) {
                configProps.put("controlled.shutdown.enable", String.valueOf(this.$outer.enableControlledShutdown()));
                configProps.put("controlled.shutdown.max.retries", String.valueOf(1));
                return configProps.put("controlled.shutdown.retry.backoff.ms", String.valueOf(1000));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
        this.syncProducerLogger().setLevel(Level.FATAL);
        this.eventHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.delete(server.config().logDirs());
            }
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        this.syncProducerLogger().setLevel(Level.ERROR);
        this.eventHandlerLogger().setLevel(Level.ERROR);
        ZooKeeperTestHarness$class.tearDown(this);
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(Properties props) {
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
                KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
                this.$outer.configs_$eq((Seq<KafkaConfig>)((Seq)this.$outer.configs().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{config})), Seq$.MODULE$.canBuildFrom())));
                this.$outer.servers_$eq((Seq<KafkaServer>)((Seq)this.$outer.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})), Seq$.MODULE$.canBuildFrom())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabled() {
        this.configProps1().put("unclean.leader.election.enable", String.valueOf(false));
        this.configProps2().put("unclean.leader.election.enable", String.valueOf(false));
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", String.valueOf(false));
        this.configProps2().put("unclean.leader.election.enable", String.valueOf(false));
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", String.valueOf(true));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), topicProps, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testCleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", String.valueOf(true));
        this.configProps2().put("unclean.leader.election.enable", String.valueOf(true));
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", String.valueOf(false));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), topicProps, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        this.intercept((Function0)new Serializable(this, topicProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final Properties topicProps$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), this.$outer.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.$outer.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.brokerId1()})))})), this.topicProps$1, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicProps$1 = topicProps$1;
            }
        }, ManifestFactory$.MODULE$.classType(ConfigException.class));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leaderIdOpt.isDefined());
        int leaderId = BoxesRunTime.unboxToInt((Object)leaderIdOpt.get());
        this.debug((Function0<String>)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int leaderId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderId$1 = leaderId$1;
            }
        });
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int followerId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerId$1 = followerId$1;
            }
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.startup();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkUtils x$1 = this.zkUtils();
        String x$2 = this.topic();
        int x$3 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$5, x$6, (Option<Object>)x$4);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "third"})), this.consumeAllMessages(this.topic()));
    }

    public void verifyUncleanLeaderElectionDisabled() {
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leaderIdOpt.isDefined());
        int leaderId = BoxesRunTime.unboxToInt((Object)leaderIdOpt.get());
        this.debug((Function0<String>)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int leaderId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$2)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderId$2 = leaderId$2;
            }
        });
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int followerId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$2)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerId$2 = followerId$2;
            }
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$2;
            }
            {
                this.followerId$2 = followerId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$2;
            }
            {
                this.leaderId$2 = leaderId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$2;
            }
            {
                this.followerId$2 = followerId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.startup();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkUtils x$7 = this.zkUtils();
        String x$8 = this.topic();
        int x$9 = this.partitionId();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, x$8, x$9, x$11, x$12, (Option<Object>)x$10);
        try {
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third");
            throw this.fail("Message produced while leader is down should fail, but it succeeded");
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExecutionException && (executionException = (ExecutionException)throwable2).getCause() instanceof TimeoutException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic()));
                ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                    public static final long serialVersionUID = 0L;
                    private final int leaderId$2;

                    public final boolean apply(KafkaServer server) {
                        return server.config().brokerId() == this.leaderId$2;
                    }
                    {
                        this.leaderId$2 = leaderId$2;
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(KafkaServer server) {
                        server.startup();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                ZkUtils x$13 = this.zkUtils();
                String x$14 = this.topic();
                int x$15 = this.partitionId();
                Some x$16 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
                long x$17 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
                Option<Object> x$18 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
                TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$13, x$14, x$15, x$17, x$18, (Option<Object>)x$16);
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third");
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                    public static final long serialVersionUID = 0L;
                    private final int leaderId$2;

                    public final boolean apply(KafkaServer server) {
                        return server.config().brokerId() == this.leaderId$2;
                    }
                    {
                        this.leaderId$2 = leaderId$2;
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ UncleanLeaderElectionTest $outer;

                    public final void apply(KafkaServer server) {
                        this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                ZkUtils x$19 = this.zkUtils();
                String x$20 = this.topic();
                int x$21 = this.partitionId();
                Some x$22 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
                long x$23 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
                Option<Object> x$24 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
                TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$19, x$20, x$21, x$23, x$24, (Option<Object>)x$22);
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second", "third"})), this.consumeAllMessages(this.topic()));
                return;
            }
            throw throwable;
        }
    }

    public void kafka$integration$UncleanLeaderElectionTest$$shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private List<String> consumeAllMessages(String topic) {
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), new StringBuilder().append((Object)"group").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString(), "id", 1000L);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(new ConsumerConfig(consumerProps));
        Map messageStream = consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> messages2 = TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)messageStream, TestUtils$.MODULE$.getMessages$default$2());
        consumerConnector.shutdown();
        return messages2;
    }

    public UncleanLeaderElectionTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.configProps1 = null;
        this.configProps2 = null;
        this.configs = (Seq)Seq$.MODULE$.empty();
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.random = new Random();
        this.topic = new StringBuilder().append((Object)"topic").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString();
        this.partitionId = 0;
        this.kafkaApisLogger = Logger.getLogger(KafkaApis.class);
        this.networkProcessorLogger = Logger.getLogger(Processor.class);
        this.syncProducerLogger = Logger.getLogger(SyncProducer.class);
        this.eventHandlerLogger = Logger.getLogger(DefaultEventHandler.class);
    }
}

