/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR3uG\"\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002\u00011A\u0005\nI\t\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002'A!A#H\u0010 \u001b\u0005)\"BA\t\u0017\u0015\t9\u0002$A\u0004dY&,g\u000e^:\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!AH\u000b\u0003\u001b-\u000bgm[1Qe>$WoY3s!\t\u0001cE\u0004\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013#\u0011\u001dQ\u0003\u00011A\u0005\n-\nA\u0002\u001d:pIV\u001cWM]0%KF$\"\u0001L\u0018\u0011\u0005\u0005j\u0013B\u0001\u0018#\u0005\u0011)f.\u001b;\t\u000fAJ\u0013\u0011!a\u0001'\u0005\u0019\u0001\u0010J\u0019\t\rI\u0002\u0001\u0015)\u0003\u0014\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005C\u00035\u0001\u0011\u0005S'A\u0003tKR,\u0006\u000fF\u0001-\u0011\u00159\u0004\u0001\"\u00116\u0003!!X-\u0019:E_^t\u0007\"B\u001d\u0001\t\u0013Q\u0014AE2sK\u0006$XMR3uG\"\u0014V-];fgR$RaO\"I\u0015r\u0003\"\u0001P!\u000e\u0003uR!AP \u0002\u0011I,\u0017/^3tiNT!\u0001\u0011\r\u0002\r\r|W.\\8o\u0013\t\u0011UH\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0003Eq\u0001\u0007Q)\u0001\tnCb\u0014Vm\u001d9p]N,')\u001f;fgB\u0011\u0011ER\u0005\u0003\u000f\n\u00121!\u00138u\u0011\u0015I\u0005\b1\u0001F\u0003Ei\u0017\r\u001f)beRLG/[8o\u0005f$Xm\u001d\u0005\u0006\u0017b\u0002\r\u0001T\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB\u0019Q*\u0016-\u000f\u00059\u001bfBA(S\u001b\u0005\u0001&BA)\u0007\u0003\u0019a$o\\8u}%\t1%\u0003\u0002UE\u00059\u0001/Y2lC\u001e,\u0017B\u0001,X\u0005\r\u0019V-\u001d\u0006\u0003)\n\u0002\"!\u0017.\u000e\u0003}J!aW \u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9Q\f\u000fI\u0001\u0002\u0004q\u0016!C8gMN,G/T1q!\u0011\u0001s\fW1\n\u0005\u0001D#aA'baB\u0011\u0011EY\u0005\u0003G\n\u0012A\u0001T8oO\")Q\r\u0001C\u0005M\u0006\u00112M]3bi\u0016\u0004\u0016M\u001d;ji&|g.T1q)\u00119go\u001e=\u0011\t!l\u0007l\\\u0007\u0002S*\u0011!n[\u0001\u0005kRLGNC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'!\u0004'j].,G\rS1tQ6\u000b\u0007\u000f\u0005\u0002qg:\u0011A(]\u0005\u0003ev\nABR3uG\"\u0014V-];fgRL!\u0001^;\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\t\u0011X\bC\u0003JI\u0002\u0007Q\tC\u0003LI\u0002\u0007A\nC\u0004^IB\u0005\t\u0019\u00010\t\u000bi\u0004A\u0011B>\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$HC\u0002?\u0000\u0003\u0007\t9\u0001\u0005\u0002={&\u0011a0\u0010\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\t\r\u0005\u0005\u0011\u00101\u0001F\u0003!aW-\u00193fe&#\u0007BBA\u0003s\u0002\u00071(A\u0004sKF,Xm\u001d;\t\u0013\u0005%\u0011\u0010%AA\u0002\u0005-\u0011a\u0002<feNLwN\u001c\t\u0006C\u00055\u0011\u0011C\u0005\u0004\u0003\u001f\u0011#AB(qi&|g\u000eE\u0002\"\u0003'I1!!\u0006#\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019\tI\u0002\u0001C\u0001k\u0005qC/Z:u\u0005J|7.\u001a:SKN\u0004Xm\u0019;t!\u0006\u0014H/\u001b;j_:\u001cxJ\u001d3fe\u0006sGmU5{K2KW.\u001b;tQ\u0011\t9\"!\b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\u001c\u0003\u0015QWO\\5u\u0013\u0011\t9#!\t\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003W\u0001A\u0011A\u001b\u0002MQ,7\u000f\u001e$fi\u000eD'+Z9vKN$hKM,ji\"|e/\u001a:tSj,G-T3tg\u0006<W\r\u000b\u0003\u0002*\u0005u\u0001bBA\u0019\u0001\u0011%\u00111G\u0001\u000bY><WI\u001c;sS\u0016\u001cH\u0003BA\u001b\u0003\u0007\u0002B!T+\u00028A!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>}\naA]3d_J$\u0017\u0002BA!\u0003w\u0011\u0001\u0002T8h\u000b:$(/\u001f\u0005\t\u0003\u000b\ny\u00031\u0001\u0002H\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004B!!\u0013\u0002P9\u0019A(a\u0013\n\u0007\u00055S(A\u0007GKR\u001c\u0007NU3ta>t7/Z\u0005\u0004i\u0006E#bAA'{!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0013AE2iK\u000e\\g)\u001a;dQJ+7\u000f]8og\u0016$2\u0002LA-\u0003;\n\t'a\u0019\u0002f!9\u00111LA*\u0001\u0004a\u0015AE3ya\u0016\u001cG/\u001a3QCJ$\u0018\u000e^5p]NDq!a\u0018\u0002T\u0001\u0007A0A\u0007gKR\u001c\u0007NU3ta>t7/\u001a\u0005\u0007\u0013\u0006M\u0003\u0019A#\t\r\u0011\u000b\u0019\u00061\u0001F\u0011\u001d\t9'a\u0015A\u0002\u0015\u000bqC\\;n\u001b\u0016\u001c8/Y4fgB+'\u000fU1si&$\u0018n\u001c8\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n\u0005a1M]3bi\u0016$v\u000e]5dgR1\u0011qNA9\u0003k\u0002B\u0001I0Y\u000b\"9\u00111OA5\u0001\u0004)\u0015!\u00038v[R{\u0007/[2t\u0011\u001d\t9(!\u001bA\u0002\u0015\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bbBA>\u0001\u0011%\u0011QP\u0001\faJ|G-^2f\t\u0006$\u0018\r\u0006\u0004\u0002\u0000\u0005\u001d\u0015q\u0012\t\u0005\u001bV\u000b\t\tE\u0003\u0015\u0003\u0007{r$C\u0002\u0002\u0006V\u0011a\u0002\u0015:pIV\u001cWM\u001d*fG>\u0014H\rC\u0004L\u0003s\u0002\r!!#\u0011\t5\u000bY\tW\u0005\u0004\u0003\u001b;&\u0001C%uKJ\f'\r\\3\t\u000f\u0005\u001d\u0014\u0011\u0010a\u0001\u000b\"I\u00111\u0013\u0001\u0012\u0002\u0013%\u0011QS\u0001\u001dGJ,\u0017\r^3GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9JK\u0002_\u00033[#!a'\u0011\t\u0005u\u0015qU\u0007\u0003\u0003?SA!!)\u0002$\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003K\u0013\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011VAP\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003[\u0003\u0011\u0013!C\u0005\u0003+\u000bAd\u0019:fCR,\u0007+\u0019:uSRLwN\\'ba\u0012\"WMZ1vYR$3\u0007C\u0005\u00022\u0002\t\n\u0011\"\u0003\u00024\u0006Q2/\u001a8e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0017\u0016\u0005\u0003\u0017\tI\n")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer = null;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        String x$9 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$10 = 5;
        StringSerializer x$11 = new StringSerializer();
        StringSerializer x$12 = new StringSerializer();
        int x$13 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$14 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$15 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$16 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$17 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$18 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$19 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$20 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$21 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createNewProducer(x$9, x$13, x$14, x$15, x$10, x$16, x$17, x$18, x$19, x$20, x$11, x$12, x$21));
    }

    @Override
    public void tearDown() {
        this.producer().close();
        KafkaServerTestHarness$class.tearDown(this);
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return new FetchRequest(Integer.MAX_VALUE, 0, maxResponseBytes, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap));
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createFetchRequest$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1)new Serializable(this, maxPartitionBytes, offsetMap, partitionMap){
            public static final long serialVersionUID = 0L;
            private final int maxPartitionBytes$1;
            private final scala.collection.immutable.Map offsetMap$1;
            private final LinkedHashMap partitionMap$1;

            public final FetchRequest.PartitionData apply(TopicPartition tp) {
                return this.partitionMap$1.put(tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)this.offsetMap$1.getOrElse((Object)tp, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })), this.maxPartitionBytes$1));
            }
            {
                this.maxPartitionBytes$1 = maxPartitionBytes$1;
                this.offsetMap$1 = offsetMap$1;
                this.partitionMap$1 = partitionMap$1;
            }
        });
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse sendFetchRequest(int leaderId, FetchRequest request, Option<Object> version) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.FETCH, version, this.brokerSocketServer(leaderId), this.send$default$5());
        return FetchResponse.parse((ByteBuffer)response);
    }

    private Option<Object> sendFetchRequest$default$3() {
        return None$.MODULE$;
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6);
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1)new Serializable(this, partitionsWithLargeMessages){
            public static final long serialVersionUID = 0L;
            private final Vector partitionsWithLargeMessages$1;

            public final boolean apply(Object elem) {
                return this.partitionsWithLargeMessages$1.contains(elem);
            }
            {
                this.partitionsWithLargeMessages$1 = partitionsWithLargeMessages$1;
            }
        });
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1, this.sendFetchRequest$default$3());
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2, this.sendFetchRequest$default$3());
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3, this.sendFetchRequest$default$3());
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse3.responseData()).asScala()).values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final int apply(FetchResponse.PartitionData partitionData) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$logEntries(partitionData).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(LogEntry x$1) {
                        return x$1.size();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)partitionData3.errorCode);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$logEntries(partitionData3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogEntry x$2) {
                return x$2.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be smaller than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxPartitionBytes)})), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < MemoryRecords.readableRecords((ByteBuffer)partitionData3.recordSet).sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4, this.sendFetchRequest$default$3());
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$logEntries(partitionData).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(LogEntry x$3) {
                            return x$3.size();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$logEntries(partitionData = (FetchResponse.PartitionData)tuple2._2()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(LogEntry x$3) {
                        return x$3.size();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((long)Errors.NONE.code(), (long)partitionData4.errorCode);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$logEntries(partitionData4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogEntry x$4) {
                return x$4.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size4), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < MemoryRecords.readableRecords((ByteBuffer)partitionData4.recordSet).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = new FetchRequest(Integer.MAX_VALUE, 0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3()));
            FetchResponse fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)2)));
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((long)Errors.NONE.code(), (long)partitionData.errorCode);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes, (long)MemoryRecords.readableRecords((ByteBuffer)partitionData.recordSet).sizeInBytes());
            Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$logEntries(partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogEntry x$6) {
                    return x$6.size();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<LogEntry> kafka$server$FetchRequestTest$$logEntries(FetchResponse.PartitionData partitionData) {
        MemoryRecords memoryRecords = MemoryRecords.readableRecords((ByteBuffer)partitionData.recordSet);
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(memoryRecords.iterator()).asScala()).toIndexedSeq();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1)new Serializable(this, fetchResponse, maxPartitionBytes, numMessagesPerPartition, emptyResponseSeen, responseSize, responseBufferSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final FetchResponse fetchResponse$1;
            private final int maxPartitionBytes$3;
            private final int numMessagesPerPartition$2;
            private final BooleanRef emptyResponseSeen$1;
            private final IntRef responseSize$1;
            private final IntRef responseBufferSize$1;

            public final void apply(TopicPartition tp) {
                FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.fetchResponse$1.responseData().get(tp);
                Assert.assertEquals((long)Errors.NONE.code(), (long)partitionData.errorCode);
                Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
                MemoryRecords memoryRecords = MemoryRecords.readableRecords((ByteBuffer)partitionData.recordSet);
                this.responseBufferSize$1.elem += memoryRecords.sizeInBytes();
                IndexedSeq messages2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(memoryRecords.iterator()).asScala()).toIndexedSeq();
                Assert.assertTrue((messages2.size() < this.numMessagesPerPartition$2 ? 1 : 0) != 0);
                int messagesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)messages2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(LogEntry x$7) {
                        return x$7.size();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.responseSize$1.elem += messagesSize;
                if (messagesSize == 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertEquals((long)0L, (long)memoryRecords.sizeInBytes());
                    this.emptyResponseSeen$1.elem = true;
                } else if (messagesSize != 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertTrue((messagesSize <= this.maxPartitionBytes$3 ? 1 : 0) != 0);
                    Assert.assertEquals((long)this.maxPartitionBytes$3, (long)memoryRecords.sizeInBytes());
                } else {
                    if (messagesSize != 0 && this.emptyResponseSeen$1.elem) {
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)messagesSize)})));
                    }
                    if (memoryRecords.sizeInBytes() != 0 && this.emptyResponseSeen$1.elem) {
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition buffer with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)memoryRecords.sizeInBytes())})));
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResponse$1 = fetchResponse$1;
                this.maxPartitionBytes$3 = maxPartitionBytes$3;
                this.numMessagesPerPartition$2 = numMessagesPerPartition$2;
                this.emptyResponseSeen$1 = emptyResponseSeen$1;
                this.responseSize$1 = responseSize$1;
                this.responseBufferSize$1 = responseBufferSize$1;
            }
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        return ((TraversableOnce)topics.flatMap((Function1)new Serializable(this, numPartitions, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final int numPartitions$1;
            private final Properties topicConfig$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(String topic) {
                scala.collection.immutable.Map<Object, Option<Object>> partitionToLeader = TestUtils$.MODULE$.createTopic(this.$outer.zkUtils(), topic, this.numPartitions$1, 2, (Seq<KafkaServer>)this.$outer.servers(), this.topicConfig$1);
                return (scala.collection.immutable.Map)partitionToLeader.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<Object, Option<Object>> x0$1) {
                        Tuple2<Object, Option<Object>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int partition = tuple2._1$mcI$sp();
                            Option leader = (Option)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic$1, partition)), leader.get());
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numPartitions$1 = numPartitions$1;
                this.topicConfig$1 = topicConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        void var3_3;
        Seq records = (Seq)topicPartitions.toSeq().flatMap((Function1)new Serializable(this, numMessagesPerPartition){
            public static final long serialVersionUID = 0L;
            private final int numMessagesPerPartition$1;

            public final IndexedSeq<ProducerRecord<String, String>> apply(TopicPartition tp) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numMessagesPerPartition$1).map((Function1)new Serializable(this, tp){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition tp$1;

                    public final ProducerRecord<String, String> apply(int messageIndex) {
                        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToInteger((int)messageIndex)}));
                        return new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})));
                    }
                    {
                        this.tp$1 = tp$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numMessagesPerPartition$1 = numMessagesPerPartition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        KafkaProducer<String, String> kafkaProducer = this.producer();
        ((IterableLike)records.map((Function1)new Serializable(this, kafkaProducer){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer eta$0$1$1;

            public final Future<RecordMetadata> apply(ProducerRecord<String, String> x$1) {
                return this.eta$0$1$1.send(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$8) {
                return x$8.get();
            }
        });
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }
}

