/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.PartitionFetchInfo;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageSet;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DU3qY&\u001c\u0017-T1oC\u001e,'/U;pi\u0006\u001cH+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u001d\u0019wN\u001c4jON,\u0012A\u0006\t\u0004/iaR\"\u0001\r\u000b\u0005eQ\u0011AC2pY2,7\r^5p]&\u00111\u0004\u0007\u0002\u0004'\u0016\f\bC\u0001\n\u001e\u0013\tq\"AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002\u0011\u0001A\u0003%a#\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0003A1A\u0005\u0002\r\nA\u0001^5nKV\tA\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u0005)Q\u000f^5mg&\u0011\u0011F\n\u0002\t\u001b>\u001c7\u000eV5nK\"11\u0006\u0001Q\u0001\n\u0011\nQ\u0001^5nK\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0003k)&lW-F\u00010!\t\u0001\u0014(D\u00012\u0015\t9#G\u0003\u00024i\u000511m\\7n_:T!!B\u001b\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003SEBaa\u000f\u0001!\u0002\u0013y\u0013A\u00026US6,\u0007\u0005C\u0004>\u0001\t\u0007I\u0011\u0001 \u0002\u000f5,GO]5dgV\tq\b\u0005\u0002A\u00056\t\u0011I\u0003\u0002>e%\u00111)\u0011\u0002\b\u001b\u0016$(/[2t\u0011\u0019)\u0005\u0001)A\u0005\u007f\u0005AQ.\u001a;sS\u000e\u001c\b\u0005C\u0004H\u0001\t\u0007I\u0011\u0001%\u0002\u000f5,7o]1hKV\t\u0011\n\u0005\u0002K\u00196\t1J\u0003\u0002H\t%\u0011Qj\u0013\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u0019y\u0005\u0001)A\u0005\u0013\u0006AQ.Z:tC\u001e,\u0007\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002%Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g.M\u000b\u0002'B\u0011AKV\u0007\u0002+*\u00111\u0007B\u0005\u0003/V\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u0019I\u0006\u0001)A\u0005'\u0006\u0019Bo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c82A!91\f\u0001b\u0001\n\u0003\u0011\u0016A\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]JBa!\u0018\u0001!\u0002\u0013\u0019\u0016a\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]J\u0002\u0003bB0\u0001\u0005\u0004%\t\u0001Y\u0001\nM\u0016$8\r[%oM>,\u0012!\u0019\t\u0004/i\u0011\u0007\u0003B\u0005d'\u0016L!\u0001\u001a\u0006\u0003\rQ+\b\u000f\\33!\t1\u0017.D\u0001h\u0015\tAG!A\u0002ba&L!A[4\u0003%A\u000b'\u000f^5uS>tg)\u001a;dQ&sgm\u001c\u0005\u0007Y\u0002\u0001\u000b\u0011B1\u0002\u0015\u0019,Go\u00195J]\u001a|\u0007\u0005C\u0004o\u0001\u0001\u0007I\u0011A8\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t\u0001\u000f\u0005\u0002\u0013c&\u0011!O\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u001d!\b\u00011A\u0005\u0002U\f!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0011a/\u001f\t\u0003\u0013]L!\u0001\u001f\u0006\u0003\tUs\u0017\u000e\u001e\u0005\buN\f\t\u00111\u0001q\u0003\rAH%\r\u0005\u0007y\u0002\u0001\u000b\u0015\u00029\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002BQA \u0001\u0005\u0002}\f!f\u001d5pk2$W\t_2mk\u0012,7+\u001e2tKF,XM\u001c;UQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7\u000fF\u0001wQ\ri\u00181\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u001c\u0002\u000b),h.\u001b;\n\t\u00055\u0011q\u0001\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002\u0012\u0001!\ta`\u0001:g\"|W\u000f\u001c3HKRtu.T3tg\u0006<Wm]%g#V|G/Y:Fq\u000e,W\rZ3e\u001f:\u001cVOY:fcV,g\u000e\u001e)beRLG/[8og\"\"\u0011qBA\u0002\u0011\u0019\t9\u0002\u0001C\u0001\u007f\u0006\u00113\u000f[8vY\u0012<U\r\u001e\"pi\"lUm]:bO\u0016\u001c\u0018JZ)v_R\f7/\u00117m_^DC!!\u0006\u0002\u0004!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011AC:fiV\u0003Xj\\2lgR)a/!\t\u0002:!9q,a\u0007A\u0002\u0005\r\u0002#BA\u0013\u0003k\u0011g\u0002BA\u0014\u0003cqA!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[1\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\r\t\u0019DC\u0001\ba\u0006\u001c7.Y4f\u0013\rY\u0012q\u0007\u0006\u0004\u0003gQ\u0001\u0002C$\u0002\u001cA\u0005\t\u0019A%\t\r\u0005u\u0002\u0001\"\u0001\u0000\u0003!!X-\u0019:E_^t\u0007\u0006BA\u001e\u0003\u0003\u0002B!!\u0002\u0002D%!\u0011QIA\u0004\u0005\u0015\te\r^3s\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\n\u0011\"\\8dWF+x\u000e^1\u0015\t\u00055\u00131\u000b\t\u0004%\u0005=\u0013bAA)\u0005\ta!+\u001a9mS\u000e\f\u0017+^8uC\"A\u0011QKA$\u0001\u0004\t9&A\u0003c_VtG\rE\u0002\n\u00033J1!a\u0017\u000b\u0005\u0011auN\\4\t\u0013\u0005}\u0003!%A\u0005\u0002\u0005\u0005\u0014\u0001F:fiV\u0003Xj\\2lg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002d)\u001a\u0011*!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001d\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties x$1) {
            return KafkaConfig$.MODULE$.fromProps(x$1, new Properties());
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final kafka.utils.MockTime time = new kafka.utils.MockTime();
    private final MockTime jTime = new MockTime();
    private final Metrics metrics = new Metrics();
    private final Message message = new Message("some-data-in-a-message".getBytes());
    private final TopicAndPartition topicAndPartition1 = new TopicAndPartition("test-topic", 1);
    private final TopicAndPartition topicAndPartition2 = new TopicAndPartition("test-topic", 2);
    private final Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition1()), (Object)new PartitionFetchInfo(0L, 100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition2()), (Object)new PartitionFetchInfo(0L, 100))}));
    private ReplicaManager replicaManager = null;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public kafka.utils.MockTime time() {
        return this.time;
    }

    public MockTime jTime() {
        return this.jTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Message message() {
        return this.message;
    }

    public TopicAndPartition topicAndPartition1() {
        return this.topicAndPartition1;
    }

    public TopicAndPartition topicAndPartition2() {
        return this.topicAndPartition2;
    }

    public Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2());
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$2) {
                Object object = x$2._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition1();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().size());
        Assert.assertEquals((String)"But we shouldn't get the second", (long)0L, (long)((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$3) {
                Object object = x$3._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition2();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().size());
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2());
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota);
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$4) {
                Object object = x$4._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition1();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().size());
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$5) {
                Object object = x$5._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition2();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().size());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2());
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota);
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$6) {
                Object object = x$6._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition1();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().size());
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicAndPartition, LogReadResult> x$7) {
                Object object = x$7._1();
                TopicAndPartition topicAndPartition = this.$outer.topicAndPartition2();
                return !(object != null ? !object.equals(topicAndPartition) : topicAndPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().messageSet().size());
    }

    public void setUpMocks(Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>> fetchInfo, Message message) {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (MessageSet)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message})), FetchDataInfo$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (MessageSet)new ByteBufferMessageSet((Seq)Nil$.MODULE$), FetchDataInfo$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), zkUtils, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time()).follower(), ReplicaManager$.MODULE$.$lessinit$greater$default$10()));
        fetchInfo.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, PartitionFetchInfo> check$ifrefutable$1) {
                Tuple2<TopicAndPartition, PartitionFetchInfo> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;
            private final Log log$1;

            public final void apply(Tuple2<TopicAndPartition, PartitionFetchInfo> x$9) {
                Tuple2<TopicAndPartition, PartitionFetchInfo> tuple2 = x$9;
                if (tuple2 != null) {
                    TopicAndPartition p = (TopicAndPartition)tuple2._1();
                    Partition partition = this.$outer.replicaManager().getOrCreatePartition(p.topic(), p.partition());
                    Replica replica = new Replica(((KafkaConfig)this.$outer.configs().head()).brokerId(), partition, (kafka.utils.Time)this.$outer.time(), 0L, (Option)new Some((Object)this.log$1));
                    replica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                    partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)replica.brokerId())));
                    List allReplicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{replica}));
                    allReplicas.foreach((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final Partition partition$1;

                        public final Replica apply(Replica x$8) {
                            return this.partition$1.addReplicaIfNotExists(x$8);
                        }
                        {
                            this.partition$1 = partition$1;
                        }
                    });
                    partition.inSyncReplicas_$eq(allReplicas.toSet());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
            }
        });
    }

    public Message setUpMocks$default$2() {
        return this.message();
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicAndPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }
}

