/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

import java.nio.ByteBuffer;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.DirectComparator;
import org.rocksdb.DirectSlice;

public class DirectBytewiseComparator
extends DirectComparator {
    public DirectBytewiseComparator(ComparatorOptions comparatorOptions) {
        super(comparatorOptions);
    }

    @Override
    public String name() {
        return "rocksdb.java.DirectBytewiseComparator";
    }

    @Override
    public int compare(DirectSlice directSlice, DirectSlice directSlice2) {
        return ((ByteBuffer)directSlice.data()).compareTo((ByteBuffer)directSlice2.data());
    }

    @Override
    public String findShortestSeparator(String string, DirectSlice directSlice) {
        byte by;
        int n;
        byte[] byArray = string.getBytes();
        int n2 = Math.min(byArray.length, directSlice.size());
        for (n = 0; n < n2 && byArray[n] == directSlice.get(n); ++n) {
        }
        if (n < n2 && (by = byArray[n]) < 255 && by + 1 < directSlice.get(n)) {
            byte[] byArray2 = new byte[n + 1];
            System.arraycopy(byArray, 0, byArray2, 0, n + 1);
            int n3 = n;
            byArray2[n3] = (byte)(byArray2[n3] + 1);
            assert (ByteBuffer.wrap(byArray2).compareTo((ByteBuffer)directSlice.data()) < 0);
            return new String(byArray2);
        }
        return null;
    }

    @Override
    public String findShortSuccessor(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 255) continue;
            byte[] byArray2 = new byte[i + 1];
            System.arraycopy(byArray, 0, byArray2, 0, i + 1);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] + 1);
            return new String(byArray2);
        }
        return null;
    }
}

