/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WorkerTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkerTask.class);
    protected final ConnectorTaskId id;
    private final AtomicBoolean stopping;
    private final AtomicBoolean cancelled;
    private final CountDownLatch shutdownLatch;
    private final TaskStatus.Listener statusListener;
    private final AtomicReference<TargetState> targetState;

    public WorkerTask(ConnectorTaskId id, TaskStatus.Listener statusListener, TargetState initialState) {
        this.id = id;
        this.stopping = new AtomicBoolean(false);
        this.cancelled = new AtomicBoolean(false);
        this.shutdownLatch = new CountDownLatch(1);
        this.statusListener = statusListener;
        this.targetState = new AtomicReference<TargetState>(initialState);
    }

    public ConnectorTaskId id() {
        return this.id;
    }

    public abstract void initialize(TaskConfig var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerStop() {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            this.stopping.set(true);
            this.notifyAll();
        }
    }

    public void stop() {
        this.triggerStop();
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    public boolean awaitStop(long timeoutMs) {
        try {
            return this.shutdownLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected abstract void execute();

    protected abstract void close();

    protected boolean isStopping() {
        return this.stopping.get();
    }

    private void doClose() {
        try {
            this.close();
        }
        catch (Throwable t) {
            log.error("Task {} threw an uncaught and unrecoverable exception during shutdown", (Object)this.id, (Object)t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        try {
            WorkerTask workerTask = this;
            synchronized (workerTask) {
                block12: {
                    if (!this.stopping.get()) break block12;
                    return;
                }
                if (this.targetState.get() == TargetState.PAUSED) {
                    this.statusListener.onPause(this.id);
                } else {
                    this.statusListener.onStartup(this.id);
                }
            }
            this.execute();
        }
        catch (Throwable t) {
            log.error("Task {} threw an uncaught and unrecoverable exception", (Object)this.id, (Object)t);
            log.error("Task is being killed and will not recover until manually restarted");
            throw t;
        }
        finally {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onShutdown() {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            this.triggerStop();
            if (!this.cancelled.get()) {
                this.statusListener.onShutdown(this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFailure(Throwable t) {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            this.triggerStop();
            if (!this.cancelled.get()) {
                this.statusListener.onFailure(this.id, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.doRun();
            this.onShutdown();
        }
        catch (Throwable t) {
            this.onFailure(t);
            if (t instanceof Error) {
                throw t;
            }
        }
        finally {
            this.shutdownLatch.countDown();
        }
    }

    public boolean shouldPause() {
        return this.targetState.get() == TargetState.PAUSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitUnpause() throws InterruptedException {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            while (this.targetState.get() == TargetState.PAUSED) {
                if (this.stopping.get()) {
                    return false;
                }
                this.wait();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionTo(TargetState state) {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            if (this.stopping.get()) {
                return;
            }
            TargetState oldState = this.targetState.getAndSet(state);
            if (state != oldState) {
                if (state == TargetState.PAUSED) {
                    this.statusListener.onPause(this.id);
                } else if (state == TargetState.STARTED) {
                    this.statusListener.onResume(this.id);
                    this.notifyAll();
                } else {
                    throw new IllegalArgumentException("Unhandled target state " + (Object)((Object)state));
                }
            }
        }
    }
}

