/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

public class ThroughputThrottler {
    private static final long NS_PER_MS = 1000000L;
    private static final long NS_PER_SEC = 1000000000L;
    private static final long MIN_SLEEP_NS = 2000000L;
    long sleepTimeNs;
    long sleepDeficitNs = 0L;
    long targetThroughput = -1L;
    long startMs;
    private boolean wakeup = false;

    public ThroughputThrottler(long targetThroughput, long startMs) {
        this.startMs = startMs;
        this.targetThroughput = targetThroughput;
        this.sleepTimeNs = targetThroughput > 0L ? 1000000000L / targetThroughput : Long.MAX_VALUE;
    }

    public boolean shouldThrottle(long amountSoFar, long sendStartMs) {
        if (this.targetThroughput < 0L) {
            return false;
        }
        float elapsedSec = (float)(sendStartMs - this.startMs) / 1000.0f;
        return elapsedSec > 0.0f && (float)amountSoFar / elapsedSec > (float)this.targetThroughput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttle() {
        block15: {
            if (this.targetThroughput == 0L) {
                try {
                    ThroughputThrottler throughputThrottler = this;
                    synchronized (throughputThrottler) {
                        while (!this.wakeup) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return;
            }
            this.sleepDeficitNs += this.sleepTimeNs;
            if (this.sleepDeficitNs >= 2000000L) {
                long sleepStartNs;
                long currentTimeNs = sleepStartNs = System.nanoTime();
                try {
                    ThroughputThrottler throughputThrottler = this;
                    synchronized (throughputThrottler) {
                        long elapsed = currentTimeNs - sleepStartNs;
                        long remaining = this.sleepDeficitNs - elapsed;
                        while (!this.wakeup && remaining > 0L) {
                            long sleepMs = remaining / 1000000L;
                            long sleepNs = remaining - sleepMs * 1000000L;
                            this.wait(sleepMs, (int)sleepNs);
                            elapsed = System.nanoTime() - sleepStartNs;
                            remaining = this.sleepDeficitNs - elapsed;
                        }
                        this.wakeup = false;
                    }
                    this.sleepDeficitNs = 0L;
                }
                catch (InterruptedException e) {
                    long sleepElapsedNs = System.nanoTime() - sleepStartNs;
                    if (sleepElapsedNs > this.sleepDeficitNs) break block15;
                    this.sleepDeficitNs -= sleepElapsedNs;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        ThroughputThrottler throughputThrottler = this;
        synchronized (throughputThrottler) {
            this.wakeup = true;
            this.notifyAll();
        }
    }
}

