/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.CacheFlushListener;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.ProcessorContext;

class ForwardingCacheFlushListener<K, V>
implements CacheFlushListener<K, V> {
    private final ProcessorContext context;
    private final boolean sendOldValues;

    ForwardingCacheFlushListener(ProcessorContext context, boolean sendOldValues) {
        this.context = context;
        this.sendOldValues = sendOldValues;
    }

    @Override
    public void apply(K key, V newValue, V oldValue) {
        if (this.sendOldValues) {
            this.context.forward(key, new Change<V>(newValue, oldValue));
        } else {
            this.context.forward(key, new Change<Object>(newValue, null));
        }
    }
}

