/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CachedStateStore;

public class KTableSource<K, V>
implements ProcessorSupplier<K, V> {
    public final String storeName;
    private boolean materialized = false;
    private boolean sendOldValues = false;

    public KTableSource(String storeName) {
        this.storeName = storeName;
    }

    @Override
    public Processor<K, V> get() {
        return this.materialized ? new MaterializedKTableSourceProcessor() : new KTableSourceProcessor();
    }

    public void materialize() {
        this.materialized = true;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    private class MaterializedKTableSourceProcessor
    extends AbstractProcessor<K, V> {
        private KeyValueStore<K, V> store;

        private MaterializedKTableSourceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KTableSource.this.storeName);
            ((CachedStateStore)((Object)this.store)).setFlushListener(new ForwardingCacheFlushListener(context, KTableSource.this.sendOldValues));
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                throw new StreamsException("Record key for the source KTable from store name " + KTableSource.this.storeName + " should not be null.");
            }
            this.store.put(key, value);
        }
    }

    private class KTableSourceProcessor
    extends AbstractProcessor<K, V> {
        private KTableSourceProcessor() {
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                throw new StreamsException("Record key for the source KTable from store name " + KTableSource.this.storeName + " should not be null.");
            }
            this.context().forward(key, new Change<Object>(value, null));
        }
    }
}

