/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTopicManager {
    private static final Logger log = LoggerFactory.getLogger(InternalTopicManager.class);
    private static final String ZK_TOPIC_PATH = "/brokers/topics";
    private static final String ZK_BROKER_PATH = "/brokers/ids";
    private static final String ZK_DELETE_TOPIC_PATH = "/admin/delete_topics";
    private static final String ZK_ENTITY_CONFIG_PATH = "/config/topics";
    public static final String CLEANUP_POLICY_PROP = "cleanup.policy";
    public static final String RETENTION_MS = "retention.ms";
    public static final Long WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
    private final ZkClient zkClient;
    private final int replicationFactor;
    private final long windowChangeLogAdditionalRetention;

    public InternalTopicManager() {
        this.zkClient = null;
        this.replicationFactor = 0;
        this.windowChangeLogAdditionalRetention = WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_DEFAULT;
    }

    public InternalTopicManager(String zkConnect, int replicationFactor, long windowChangeLogAdditionalRetention) {
        this.zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)new ZKStringSerializer());
        this.replicationFactor = replicationFactor;
        this.windowChangeLogAdditionalRetention = windowChangeLogAdditionalRetention;
    }

    public void makeReady(InternalTopicConfig topic, int numPartitions) {
        boolean topicNotReady = true;
        while (topicNotReady) {
            Map<Integer, List<Integer>> topicMetadata = this.getTopicMetadata(topic.name());
            if (topicMetadata == null) {
                try {
                    this.createTopic(topic, numPartitions, this.replicationFactor);
                }
                catch (ZkNodeExistsException e) {}
                continue;
            }
            if (topicMetadata.size() > numPartitions) {
                try {
                    this.deleteTopic(topic.name());
                }
                catch (ZkNodeExistsException e) {}
                continue;
            }
            if (topicMetadata.size() < numPartitions) {
                try {
                    this.addPartitions(topic.name(), numPartitions - topicMetadata.size(), this.replicationFactor, topicMetadata);
                }
                catch (ZkNoNodeException e) {}
                continue;
            }
            topicNotReady = false;
        }
    }

    private List<Integer> getBrokers() {
        ArrayList<Integer> brokers = new ArrayList<Integer>();
        for (String broker : this.zkClient.getChildren(ZK_BROKER_PATH)) {
            brokers.add(Integer.parseInt(broker));
        }
        Collections.sort(brokers);
        log.debug("Read brokers {} from ZK in partition assignor.", brokers);
        return brokers;
    }

    private Map<Integer, List<Integer>> getTopicMetadata(String topic) {
        String data = (String)this.zkClient.readData("/brokers/topics/" + topic, true);
        if (data == null) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map dataMap = (Map)mapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Map partitions = (Map)dataMap.get("partitions");
            log.debug("Read partitions {} for topic {} from ZK in partition assignor.", (Object)partitions, (Object)topic);
            return partitions;
        }
        catch (IOException e) {
            throw new StreamsException("Error while reading topic metadata from ZK for internal topic " + topic, e);
        }
    }

    private void createTopic(InternalTopicConfig topic, int numPartitions, int replicationFactor) throws ZkNodeExistsException {
        String data;
        HashMap<String, Serializable> dataMap;
        log.debug("Creating topic {} with {} partitions from ZK in partition assignor.", (Object)topic.name(), (Object)numPartitions);
        ObjectMapper mapper = new ObjectMapper();
        List<Integer> brokers = this.getBrokers();
        int numBrokers = brokers.size();
        if (numBrokers < replicationFactor) {
            log.warn("Not enough brokers found. The replication factor is reduced from " + replicationFactor + " to " + numBrokers);
            replicationFactor = numBrokers;
        }
        HashMap assignment = new HashMap();
        for (int i = 0; i < numPartitions; ++i) {
            ArrayList<Integer> brokerList = new ArrayList<Integer>();
            for (int r = 0; r < replicationFactor; ++r) {
                int shift = r * numBrokers / replicationFactor;
                brokerList.add(brokers.get((i + shift) % numBrokers));
            }
            assignment.put(i, brokerList);
        }
        try {
            dataMap = new HashMap<String, Serializable>();
            dataMap.put("version", Integer.valueOf(1));
            dataMap.put("config", topic.toProperties(this.windowChangeLogAdditionalRetention));
            data = mapper.writeValueAsString(dataMap);
            this.zkClient.createPersistent("/config/topics/" + topic.name(), (Object)data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        }
        catch (JsonProcessingException e) {
            throw new StreamsException("Error while creating topic config in ZK for internal topic " + topic, e);
        }
        try {
            dataMap = new HashMap();
            dataMap.put("version", Integer.valueOf(1));
            dataMap.put("partitions", assignment);
            data = mapper.writeValueAsString(dataMap);
            this.zkClient.createPersistent("/brokers/topics/" + topic.name(), (Object)data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        }
        catch (JsonProcessingException e) {
            throw new StreamsException("Error while creating topic metadata in ZK for internal topic " + topic, e);
        }
    }

    private void deleteTopic(String topic) throws ZkNodeExistsException {
        log.debug("Deleting topic {} from ZK in partition assignor.", (Object)topic);
        this.zkClient.createPersistent("/admin/delete_topics/" + topic, (Object)"", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    private void addPartitions(String topic, int numPartitions, int replicationFactor, Map<Integer, List<Integer>> existingAssignment) {
        log.debug("Adding {} partitions topic {} from ZK with existing partitions assigned as {} in partition assignor.", new Object[]{topic, numPartitions, existingAssignment});
        List<Integer> brokers = this.getBrokers();
        int numBrokers = brokers.size();
        if (numBrokers < replicationFactor) {
            log.warn("Not enough brokers found. The replication factor is reduced from " + replicationFactor + " to " + numBrokers);
            replicationFactor = numBrokers;
        }
        int startIndex = existingAssignment.size();
        HashMap<Integer, List<Integer>> newAssignment = new HashMap<Integer, List<Integer>>(existingAssignment);
        for (int i = 0; i < numPartitions; ++i) {
            ArrayList<Integer> brokerList = new ArrayList<Integer>();
            for (int r = 0; r < replicationFactor; ++r) {
                int shift = r * numBrokers / replicationFactor;
                brokerList.add(brokers.get((i + shift) % numBrokers));
            }
            newAssignment.put(i + startIndex, brokerList);
        }
        try {
            HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>();
            dataMap.put("version", Integer.valueOf(1));
            dataMap.put("partitions", newAssignment);
            ObjectMapper mapper = new ObjectMapper();
            String data = mapper.writeValueAsString(dataMap);
            this.zkClient.writeData("/brokers/topics/" + topic, (Object)data);
        }
        catch (JsonProcessingException e) {
            throw new StreamsException("Error while updating topic metadata in ZK for internal topic " + topic, e);
        }
    }

    private class ZKStringSerializer
    implements ZkSerializer {
        private ZKStringSerializer() {
        }

        public byte[] serialize(Object data) {
            try {
                return ((String)data).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Object deserialize(byte[] bytes) {
            try {
                if (bytes == null) {
                    return null;
                }
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

