/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

public class ProcessorNode<K, V> {
    private final List<ProcessorNode<?, ?>> children;
    private final String name;
    private final Processor<K, V> processor;
    public final Set<String> stateStores;

    public ProcessorNode(String name) {
        this(name, null, null);
    }

    public ProcessorNode(String name, Processor<K, V> processor, Set<String> stateStores) {
        this.name = name;
        this.processor = processor;
        this.children = new ArrayList();
        this.stateStores = stateStores;
    }

    public final String name() {
        return this.name;
    }

    public final Processor<K, V> processor() {
        return this.processor;
    }

    public final List<ProcessorNode<?, ?>> children() {
        return this.children;
    }

    public void addChild(ProcessorNode<?, ?> child) {
        this.children.add(child);
    }

    public void init(ProcessorContext context) {
        try {
            this.processor.init(context);
        }
        catch (Exception e) {
            throw new StreamsException(String.format("failed to initialize processor %s", this.name), e);
        }
    }

    public void close() {
        try {
            this.processor.close();
        }
        catch (Exception e) {
            throw new StreamsException(String.format("failed to close processor %s", this.name), e);
        }
    }

    public void process(K key, V value) {
        this.processor.process(key, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append(this.name + ": ");
        if (this.stateStores != null && !this.stateStores.isEmpty()) {
            sb.append("stateStores [");
            for (String store : this.stateStores) {
                sb.append(store + ",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("] ");
        }
        return sb.toString();
    }
}

