/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ConsumerRecordTimestampExtractor;
import org.apache.kafka.streams.processor.DefaultPartitionGrouper;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.apache.kafka.streams.processor.internals.StreamThread;

public class StreamsConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("application.id", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "An identifier for the stream processing application. Must be unique within the Kafka cluster. It is used as 1) the default client-id prefix, 2) the group-id for membership management, 3) the changelog topic prefix.").define("bootstrap.servers", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("client.id", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.").define("zookeeper.connect", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Zookeeper connect string for Kafka topics management.").define("state.dir", ConfigDef.Type.STRING, (Object)"/tmp/kafka-streams", ConfigDef.Importance.MEDIUM, "Directory location for state store.").define("replication.factor", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, "The replication factor for change log topics and repartition topics created by the stream processing application.").define("timestamp.extractor", ConfigDef.Type.CLASS, (Object)ConsumerRecordTimestampExtractor.class.getName(), ConfigDef.Importance.MEDIUM, "Timestamp extractor class that implements the <code>TimestampExtractor</code> interface.").define("partition.grouper", ConfigDef.Type.CLASS, (Object)DefaultPartitionGrouper.class.getName(), ConfigDef.Importance.MEDIUM, "Partition grouper class that implements the <code>PartitionGrouper</code> interface.").define("key.serde", ConfigDef.Type.CLASS, (Object)Serdes.ByteArraySerde.class.getName(), ConfigDef.Importance.MEDIUM, "Serializer / deserializer class for key that implements the <code>Serde</code> interface.").define("value.serde", ConfigDef.Type.CLASS, (Object)Serdes.ByteArraySerde.class.getName(), ConfigDef.Importance.MEDIUM, "Serializer / deserializer class for value that implements the <code>Serde</code> interface.").define("commit.interval.ms", ConfigDef.Type.LONG, (Object)30000, ConfigDef.Importance.LOW, "The frequency with which to save the position of the processor.").define("poll.ms", ConfigDef.Type.LONG, (Object)100, ConfigDef.Importance.LOW, "The amount of time in milliseconds to block waiting for input.").define("num.stream.threads", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.LOW, "The number of threads to execute stream processing.").define("num.standby.replicas", ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.LOW, "The number of standby replicas for each task.").define("buffered.records.per.partition", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "The maximum number of records to buffer per partition.").define("state.cleanup.delay.ms", ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.LOW, "The amount of time in milliseconds to wait before deleting state when a partition has migrated.").define("metric.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>MetricReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define("metrics.sample.window.ms", ConfigDef.Type.LONG, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.").define("metrics.num.samples", ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define("application.server", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "A host:port pair pointing to an embedded user defined endpoint that can be used for discovering the locations of state stores within a single KafkaStreams application").define("rocksdb.config.setter", ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, "A Rocks DB config setter class that implements the <code>RocksDBConfigSetter</code> interface").define("windowstore.changelog.additional.retention.ms", ConfigDef.Type.LONG, (Object)86400000, ConfigDef.Importance.MEDIUM, "Added to a windows maintainMs to ensure data is not deleted from the log prematurely. Allows for clock drift. Default is 1 day").define("cache.max.bytes.buffering", ConfigDef.Type.LONG, (Object)0xA00000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "Maximum number of memory bytes to be used for buffering across all threads");
    public static final String CONSUMER_PREFIX = "consumer.";
    public static final String PRODUCER_PREFIX = "producer.";
    public static final String STATE_DIR_CONFIG = "state.dir";
    private static final String STATE_DIR_DOC = "Directory location for state store.";
    public static final String ZOOKEEPER_CONNECT_CONFIG = "zookeeper.connect";
    private static final String ZOOKEEPER_CONNECT_DOC = "Zookeeper connect string for Kafka topics management.";
    public static final String COMMIT_INTERVAL_MS_CONFIG = "commit.interval.ms";
    private static final String COMMIT_INTERVAL_MS_DOC = "The frequency with which to save the position of the processor.";
    public static final String POLL_MS_CONFIG = "poll.ms";
    private static final String POLL_MS_DOC = "The amount of time in milliseconds to block waiting for input.";
    public static final String NUM_STREAM_THREADS_CONFIG = "num.stream.threads";
    private static final String NUM_STREAM_THREADS_DOC = "The number of threads to execute stream processing.";
    public static final String NUM_STANDBY_REPLICAS_CONFIG = "num.standby.replicas";
    private static final String NUM_STANDBY_REPLICAS_DOC = "The number of standby replicas for each task.";
    public static final String BUFFERED_RECORDS_PER_PARTITION_CONFIG = "buffered.records.per.partition";
    private static final String BUFFERED_RECORDS_PER_PARTITION_DOC = "The maximum number of records to buffer per partition.";
    public static final String STATE_CLEANUP_DELAY_MS_CONFIG = "state.cleanup.delay.ms";
    private static final String STATE_CLEANUP_DELAY_MS_DOC = "The amount of time in milliseconds to wait before deleting state when a partition has migrated.";
    public static final String TIMESTAMP_EXTRACTOR_CLASS_CONFIG = "timestamp.extractor";
    private static final String TIMESTAMP_EXTRACTOR_CLASS_DOC = "Timestamp extractor class that implements the <code>TimestampExtractor</code> interface.";
    public static final String PARTITION_GROUPER_CLASS_CONFIG = "partition.grouper";
    private static final String PARTITION_GROUPER_CLASS_DOC = "Partition grouper class that implements the <code>PartitionGrouper</code> interface.";
    public static final String APPLICATION_ID_CONFIG = "application.id";
    public static final String APPLICATION_ID_DOC = "An identifier for the stream processing application. Must be unique within the Kafka cluster. It is used as 1) the default client-id prefix, 2) the group-id for membership management, 3) the changelog topic prefix.";
    public static final String REPLICATION_FACTOR_CONFIG = "replication.factor";
    public static final String REPLICATION_FACTOR_DOC = "The replication factor for change log topics and repartition topics created by the stream processing application.";
    public static final String KEY_SERDE_CLASS_CONFIG = "key.serde";
    public static final String KEY_SERDE_CLASS_DOC = "Serializer / deserializer class for key that implements the <code>Serde</code> interface.";
    public static final String VALUE_SERDE_CLASS_CONFIG = "value.serde";
    public static final String VALUE_SERDE_CLASS_DOC = "Serializer / deserializer class for value that implements the <code>Serde</code> interface.";
    public static final String APPLICATION_SERVER_CONFIG = "application.server";
    public static final String APPLICATION_SERVER_DOC = "A host:port pair pointing to an embedded user defined endpoint that can be used for discovering the locations of state stores within a single KafkaStreams application";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String ROCKSDB_CONFIG_SETTER_CLASS_CONFIG = "rocksdb.config.setter";
    public static final String ROCKSDB_CONFIG_SETTER_CLASS_DOC = "A Rocks DB config setter class that implements the <code>RocksDBConfigSetter</code> interface";
    public static final String WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_CONFIG = "windowstore.changelog.additional.retention.ms";
    public static final String WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_DOC = "Added to a windows maintainMs to ensure data is not deleted from the log prematurely. Allows for clock drift. Default is 1 day";
    public static final String CACHE_MAX_BYTES_BUFFERING_CONFIG = "cache.max.bytes.buffering";
    public static final String CACHE_MAX_BYTES_BUFFERING_DOC = "Maximum number of memory bytes to be used for buffering across all threads";
    private static final Map<String, Object> PRODUCER_DEFAULT_OVERRIDES;
    private static final Map<String, Object> CONSUMER_DEFAULT_OVERRIDES;

    public static String consumerPrefix(String consumerProp) {
        return CONSUMER_PREFIX + consumerProp;
    }

    public static String producerPrefix(String producerProp) {
        return PRODUCER_PREFIX + producerProp;
    }

    public StreamsConfig(Map<?, ?> props) {
        super(CONFIG, props);
    }

    public Map<String, Object> getConsumerConfigs(StreamThread streamThread, String groupId, String clientId) throws ConfigException {
        HashMap<String, Object> consumerProps = new HashMap<String, Object>(CONSUMER_DEFAULT_OVERRIDES);
        Map<String, Object> clientProvidedProps = this.getClientPropsWithPrefix(CONSUMER_PREFIX, ConsumerConfig.configNames());
        if (clientProvidedProps.containsKey("enable.auto.commit")) {
            throw new ConfigException("Unexpected user-specified consumer config enable.auto.commit, as the streams client will always turn off auto committing.");
        }
        consumerProps.putAll(clientProvidedProps);
        consumerProps.put(BOOTSTRAP_SERVERS_CONFIG, this.originals().get(BOOTSTRAP_SERVERS_CONFIG));
        consumerProps.put("group.id", groupId);
        consumerProps.put(CLIENT_ID_CONFIG, clientId + "-consumer");
        consumerProps.put("__stream.thread.instance__", streamThread);
        consumerProps.put(REPLICATION_FACTOR_CONFIG, this.getInt(REPLICATION_FACTOR_CONFIG));
        consumerProps.put(NUM_STANDBY_REPLICAS_CONFIG, this.getInt(NUM_STANDBY_REPLICAS_CONFIG));
        consumerProps.put("partition.assignment.strategy", StreamPartitionAssignor.class.getName());
        consumerProps.put(WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_CONFIG, this.getLong(WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_CONFIG));
        if (!this.getString(ZOOKEEPER_CONNECT_CONFIG).equals("")) {
            consumerProps.put(ZOOKEEPER_CONNECT_CONFIG, this.getString(ZOOKEEPER_CONNECT_CONFIG));
        }
        consumerProps.put(APPLICATION_SERVER_CONFIG, this.getString(APPLICATION_SERVER_CONFIG));
        return consumerProps;
    }

    public Map<String, Object> getRestoreConsumerConfigs(String clientId) throws ConfigException {
        HashMap<String, Object> consumerProps = new HashMap<String, Object>(CONSUMER_DEFAULT_OVERRIDES);
        Map<String, Object> clientProvidedProps = this.getClientPropsWithPrefix(CONSUMER_PREFIX, ConsumerConfig.configNames());
        if (clientProvidedProps.containsKey("enable.auto.commit")) {
            throw new ConfigException("Unexpected user-specified consumer config enable.auto.commit, as the streams client will always turn off auto committing.");
        }
        consumerProps.putAll(clientProvidedProps);
        consumerProps.put(BOOTSTRAP_SERVERS_CONFIG, this.originals().get(BOOTSTRAP_SERVERS_CONFIG));
        consumerProps.remove("group.id");
        consumerProps.put(CLIENT_ID_CONFIG, clientId + "-restore-consumer");
        return consumerProps;
    }

    public Map<String, Object> getProducerConfigs(String clientId) {
        HashMap<String, Object> props = new HashMap<String, Object>(PRODUCER_DEFAULT_OVERRIDES);
        props.putAll(this.getClientPropsWithPrefix(PRODUCER_PREFIX, ProducerConfig.configNames()));
        props.put(BOOTSTRAP_SERVERS_CONFIG, this.originals().get(BOOTSTRAP_SERVERS_CONFIG));
        props.put(CLIENT_ID_CONFIG, clientId + "-producer");
        return props;
    }

    private Map<String, Object> getClientPropsWithPrefix(String prefix, Set<String> configNames) {
        Map<String, Object> props = this.clientProps(configNames, this.originals());
        props.putAll(this.originalsWithPrefix(prefix));
        return props;
    }

    public Serde keySerde() {
        try {
            Serde serde = (Serde)this.getConfiguredInstance(KEY_SERDE_CLASS_CONFIG, Serde.class);
            serde.configure(this.originals(), true);
            return serde;
        }
        catch (Exception e) {
            throw new StreamsException(String.format("Failed to configure key serde %s", this.get(KEY_SERDE_CLASS_CONFIG)), e);
        }
    }

    public Serde valueSerde() {
        try {
            Serde serde = (Serde)this.getConfiguredInstance(VALUE_SERDE_CLASS_CONFIG, Serde.class);
            serde.configure(this.originals(), false);
            return serde;
        }
        catch (Exception e) {
            throw new StreamsException(String.format("Failed to configure value serde %s", this.get(VALUE_SERDE_CLASS_CONFIG)), e);
        }
    }

    private Map<String, Object> clientProps(Set<String> configNames, Map<String, Object> originals) {
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        for (String configName : configNames) {
            if (!originals.containsKey(configName)) continue;
            parsed.put(configName, originals.get(configName));
        }
        return parsed;
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtmlTable());
    }

    static {
        HashMap<String, String> tempProducerDefaultOverrides = new HashMap<String, String>();
        tempProducerDefaultOverrides.put("linger.ms", "100");
        PRODUCER_DEFAULT_OVERRIDES = Collections.unmodifiableMap(tempProducerDefaultOverrides);
        HashMap<String, String> tempConsumerDefaultOverrides = new HashMap<String, String>();
        tempConsumerDefaultOverrides.put("max.poll.records", "1000");
        tempConsumerDefaultOverrides.put("auto.offset.reset", "earliest");
        tempConsumerDefaultOverrides.put("enable.auto.commit", "false");
        CONSUMER_DEFAULT_OVERRIDES = Collections.unmodifiableMap(tempConsumerDefaultOverrides);
    }

    public static class InternalConfig {
        public static final String STREAM_THREAD_INSTANCE = "__stream.thread.instance__";
    }
}

