/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.PrintStream;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

class KeyValuePrinter<K, V>
implements ProcessorSupplier<K, V> {
    private final PrintStream printStream;
    private Serde<?> keySerde;
    private Serde<?> valueSerde;
    private String streamName;

    KeyValuePrinter(PrintStream printStream, Serde<?> keySerde, Serde<?> valueSerde, String streamName) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.streamName = streamName;
        this.printStream = printStream == null ? System.out : printStream;
    }

    KeyValuePrinter(PrintStream printStream, String streamName) {
        this(printStream, null, null, streamName);
    }

    KeyValuePrinter(Serde<?> keySerde, Serde<?> valueSerde, String streamName) {
        this(System.out, keySerde, valueSerde, streamName);
    }

    @Override
    public Processor<K, V> get() {
        return new KeyValuePrinterProcessor(this.printStream, this.keySerde, this.valueSerde, this.streamName);
    }

    private class KeyValuePrinterProcessor
    extends AbstractProcessor<K, V> {
        private final PrintStream printStream;
        private Serde<?> keySerde;
        private Serde<?> valueSerde;
        private ProcessorContext processorContext;
        private String streamName;

        private KeyValuePrinterProcessor(PrintStream printStream, Serde<?> keySerde, Serde<?> valueSerde, String streamName) {
            this.printStream = printStream;
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.streamName = streamName;
        }

        @Override
        public void init(ProcessorContext context) {
            this.processorContext = context;
            if (this.keySerde == null) {
                this.keySerde = this.processorContext.keySerde();
            }
            if (this.valueSerde == null) {
                this.valueSerde = this.processorContext.valueSerde();
            }
        }

        @Override
        public void process(K key, V value) {
            Object keyToPrint = this.maybeDeserialize(key, this.keySerde.deserializer());
            Object valueToPrint = this.maybeDeserialize(value, this.valueSerde.deserializer());
            this.printStream.println("[" + this.streamName + "]: " + keyToPrint + " , " + valueToPrint);
            this.processorContext.forward(key, value);
        }

        private Object maybeDeserialize(Object receivedElement, Deserializer<?> deserializer) {
            if (receivedElement == null) {
                return null;
            }
            if (receivedElement instanceof byte[]) {
                return deserializer.deserialize(this.processorContext.topic(), (byte[])receivedElement);
            }
            return receivedElement;
        }

        @Override
        public void close() {
            if (this.printStream == System.out) {
                this.printStream.flush();
            } else {
                this.printStream.close();
            }
        }
    }
}

