/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingWindowIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class MergedSortedCachedWindowStoreIterator<K, V>
implements WindowStoreIterator<V> {
    private final ThreadCache.MemoryLRUCacheBytesIterator cacheIterator;
    private final PeekingWindowIterator<byte[]> storeIterator;
    private final StateSerdes<K, V> serdes;

    public MergedSortedCachedWindowStoreIterator(ThreadCache.MemoryLRUCacheBytesIterator cacheIterator, PeekingWindowIterator<byte[]> storeIterator, StateSerdes<K, V> serdes) {
        this.cacheIterator = cacheIterator;
        this.storeIterator = storeIterator;
        this.serdes = serdes;
    }

    @Override
    public boolean hasNext() {
        return this.cacheIterator.hasNext() || this.storeIterator.hasNext();
    }

    @Override
    public KeyValue<Long, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Long nextCacheTimestamp = null;
        if (this.cacheIterator.hasNext()) {
            nextCacheTimestamp = WindowStoreUtils.timestampFromBinaryKey(this.cacheIterator.peekNextKey());
        }
        Long nextStoreTimestamp = null;
        if (this.storeIterator.hasNext()) {
            nextStoreTimestamp = (Long)this.storeIterator.peekNext().key;
        }
        if (nextCacheTimestamp == null) {
            return this.nextStoreValue();
        }
        if (nextStoreTimestamp == null) {
            return this.nextCacheValue(nextCacheTimestamp);
        }
        int comparison = nextCacheTimestamp.compareTo(nextStoreTimestamp);
        if (comparison > 0) {
            return this.nextStoreValue();
        }
        if (comparison < 0) {
            return this.nextCacheValue(nextCacheTimestamp);
        }
        this.storeIterator.next();
        return this.nextCacheValue(nextCacheTimestamp);
    }

    private KeyValue<Long, V> nextCacheValue(Long timestamp) {
        Object next = this.cacheIterator.next();
        return KeyValue.pair(timestamp, this.serdes.valueFrom(((LRUCacheEntry)((KeyValue)next).value).value));
    }

    private KeyValue<Long, V> nextStoreValue() {
        KeyValue next = (KeyValue)this.storeIterator.next();
        return KeyValue.pair(next.key, this.serdes.valueFrom((byte[])next.value));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public void close() {
        this.cacheIterator.close();
        this.storeIterator.close();
    }
}

