/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.OffsetCheckpoint;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%b!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007!q\u0002%\u0003\u0002 \u0013\t)\u0011I\u001d:bsB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0011!I\u0003A!A!\u0002\u0013i\u0012\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001\\8hgV\tQ\u0006\u0005\u0003\u000f]A2\u0014BA\u0018\u0010\u0005\u0011\u0001vn\u001c7\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\"\u0011AB2p[6|g.\u0003\u00026e\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005]BT\"\u0001\u0002\n\u0005e\u0012!a\u0001'pO\"A1\b\u0001B\u0001B\u0003%Q&A\u0003m_\u001e\u001c\b\u0005C\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0001\u000b\u0005CA\u001c\u0001\u0011\u0015QB\b1\u0001\u001e\u0011\u0015YC\b1\u0001.\u0011\u001d\u0019\u0005A1A\u0005B\u0011\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%%\u0003\u0011a\u0017M\\4\n\u0005);%AB*ue&tw\r\u0003\u0004M\u0001\u0001\u0006I!R\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0005O\u0001\t\u0007I\u0011\u0001\u0002E\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\"1\u0001\u000b\u0001Q\u0001\n\u0015\u000bQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002\u0017\rDWmY6q_&tGo]\u000b\u0002)B!QK\u0017\u0011]\u001b\u00051&BA,Y\u0003%IW.\\;uC\ndWM\u0003\u0002Z\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m3&aA'baB\u0011Q\fY\u0007\u0002=*\u0011q\fB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0005t&\u0001E(gMN,Go\u00115fG.\u0004x.\u001b8u\u0011\u0019\u0019\u0007\u0001)A\u0005)\u0006a1\r[3dWB|\u0017N\u001c;tA!9Q\r\u0001b\u0001\n\u00131\u0017AC5o!J|wM]3tgV\tq\r\u0005\u0003iWBjW\"A5\u000b\u0005)D\u0016aB7vi\u0006\u0014G.Z\u0005\u0003Y&\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u00028]&\u0011qN\u0001\u0002\u0011\u0019><7\t\\3b]&twm\u0015;bi\u0016Da!\u001d\u0001!\u0002\u00139\u0017aC5o!J|wM]3tg\u0002Bqa\u001d\u0001C\u0002\u0013%A/\u0001\u0003m_\u000e\\W#A;\u0011\u0005YlX\"A<\u000b\u0005aL\u0018!\u00027pG.\u001c(B\u0001>|\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003y\u0012\nA!\u001e;jY&\u0011ap\u001e\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\u000f\u0005\u0005\u0001\u0001)A\u0005k\u0006)An\\2lA!I\u0011Q\u0001\u0001C\u0002\u0013%\u0011qA\u0001\u0013a\u0006,8/\u001a3DY\u0016\fg.\u001b8h\u0007>tG-\u0006\u0002\u0002\nA\u0019a/a\u0003\n\u0007\u00055qOA\u0005D_:$\u0017\u000e^5p]\"A\u0011\u0011\u0003\u0001!\u0002\u0013\tI!A\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$\u0007\u0005C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005IB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p+\t\tI\u0002E\u0002\t\u00037I1!!\b\n\u0005\u0019!u.\u001e2mK\"I\u0011\u0011\u0005\u0001A\u0002\u0013%\u00111E\u0001\u001eI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLwn\u0018\u0013fcR!\u0011QEA\u0016!\rA\u0011qE\u0005\u0004\u0003SI!\u0001B+oSRD!\"!\f\u0002 \u0005\u0005\t\u0019AA\r\u0003\rAH%\r\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u0002\u001a\u0005QB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5pA!\"\u0011qFA\u001b!\rA\u0011qG\u0005\u0004\u0003sI!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005)\u0012\r\u001c7DY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXCAA!!\u001d\t\u0019%!\u00131\u0003\u001br1\u0001CA#\u0013\r\t9%C\u0001\u0007!J,G-\u001a4\n\u0007m\u000bYEC\u0002\u0002H%\u00012\u0001CA(\u0013\r\t\t&\u0003\u0002\u0005\u0019>tw\rC\u0004\u0002V\u0001!\t!a\u0016\u00023\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a\u000b\u0005\u00033\n)\u0007E\u0003\t\u00037\ny&C\u0002\u0002^%\u0011aa\u00149uS>t\u0007cA\u001c\u0002b%\u0019\u00111\r\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002h\u0005M\u0003\u0019AA5\u0003\u0011!\u0018.\\3\u0011\u00079\tY'C\u0002\u0002n=\u0011A\u0001V5nK\"9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0014!\u00043fY\u0016$\u0018M\u00197f\u0019><7\u000f\u0006\u0002\u0002vA1\u0011qOAD\u0003\u001bsA!!\u001f\u0002\u0004:!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000m\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0006\n\u0007\u0005\u0015\u0015\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00151\u0012\u0002\t\u0013R,'/\u00192mK*\u0019\u0011QQ\u0005\u0011\u000b!\ty\t\r\u001c\n\u0007\u0005E\u0015B\u0001\u0004UkBdWM\r\u0005\b\u0003+\u0003A\u0011AAL\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011QEAM\u0011\u001d\tY*a%A\u0002A\n\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000bQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\r\u0006\u0003\u0002&\u0005\r\u0006bBAN\u0003;\u0003\r\u0001\r\u0005\b\u0003O\u0003A\u0011AAU\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$B!!\n\u0002,\"9\u00111TAS\u0001\u0004\u0001\u0004bBAX\u0001\u0011%\u0011\u0011W\u0001\u0012SN\u001cE.Z1oS:<\u0017J\\*uCR,GCBAZ\u0003s\u000bY\fE\u0002\t\u0003kK1!a.\n\u0005\u001d\u0011un\u001c7fC:Dq!a'\u0002.\u0002\u0007\u0001\u0007C\u0004\u0002>\u00065\u0006\u0019A7\u0002\u001b\u0015D\b/Z2uK\u0012\u001cF/\u0019;f\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007\fAc\u00195fG.\u001cE.Z1oS:<\u0017IY8si\u0016$G\u0003BA\u0013\u0003\u000bDq!a'\u0002@\u0002\u0007\u0001\u0007C\u0004\u0002J\u0002!\t!a3\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0004\u0002&\u00055\u0017\u0011\u001b\u0005\b\u0003\u001f\f9\r1\u0001!\u0003\u001d!\u0017\r^1ESJD\u0001\"a5\u0002H\u0002\u0007\u0011Q[\u0001\u0007kB$\u0017\r^3\u0011\u000b!\tY&a6\u0011\r!\ty\tMA'\u0011\u001d\tY\u000e\u0001C\u0001\u0003;\fq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u0011\u0005\u0015\u0012q\\Aq\u0003GDq!a4\u0002Z\u0002\u0007\u0001\u0005C\u0004\u0002\u001c\u0006e\u0007\u0019\u0001\u0019\t\u0011\u0005\u0015\u0018\u0011\u001ca\u0001\u0003\u001b\naa\u001c4gg\u0016$\bbBAu\u0001\u0011\u0005\u00111^\u0001\rI>tWm\u00117fC:Lgn\u001a\u000b\t\u0003K\ti/a<\u0002r\"9\u00111TAt\u0001\u0004\u0001\u0004bBAh\u0003O\u0004\r\u0001\t\u0005\t\u0003g\f9\u000f1\u0001\u0002N\u0005IQM\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003o\u0004A\u0011AA}\u00031!wN\\3EK2,G/\u001b8h)\u0011\t)#a?\t\u000f\u0005m\u0015Q\u001fa\u0001a\u001dA\u0011q \u0002\t\u0002\t\u0011\t!A\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\u00042a\u000eB\u0002\r\u001d\t!\u0001#\u0001\u0003\u0005\u000b\u0019BAa\u0001\b\u001b!9QHa\u0001\u0005\u0002\t%AC\u0001B\u0001\u0011!\u0011iAa\u0001\u0005\u0002\t=\u0011AE5t\u0007>l\u0007/Y2u\u0003:$G)\u001a7fi\u0016$B!a-\u0003\u0012!11Aa\u0003A\u0002YB\u0001B!\u0006\u0003\u0004\u0011\u0005!qC\u0001\u0011G2,\u0017M\\1cY\u0016|eMZ:fiN$\"B!\u0007\u0003\u001c\tu!q\u0004B\u0013!\u001dA\u0011qRA'\u0003\u001bBaa\u0001B\n\u0001\u00041\u0004bBAN\u0005'\u0001\r\u0001\r\u0005\t\u0005C\u0011\u0019\u00021\u0001\u0003$\u0005IA.Y:u\u00072,\u0017M\u001c\t\u0006+j\u0003\u0014Q\n\u0005\t\u0005O\u0011\u0019\u00021\u0001\u0002N\u0005\u0019an\\<")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogCleanerManager$$checkpoints;
    private final HashMap<TopicAndPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress;
    private final ReentrantLock lock;
    private final Condition kafka$log$LogCleanerManager$$pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicAndPartition topicAndPartition, scala.collection.immutable.Map<TopicAndPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicAndPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogCleanerManager$$checkpoints() {
        return this.kafka$log$LogCleanerManager$$checkpoints;
    }

    public HashMap<TopicAndPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress() {
        return this.kafka$log$LogCleanerManager$$inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Condition kafka$log$LogCleanerManager$$pausedCleaningCond() {
        return this.kafka$log$LogCleanerManager$$pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    public void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public scala.collection.immutable.Map<TopicAndPartition, Object> allCleanerCheckpoints() {
        return ((TraversableOnce)this.kafka$log$LogCleanerManager$$checkpoints().values().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<TopicAndPartition, Object> apply(OffsetCheckpoint x$1) {
                return x$1.read();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final Time time$1;

            public final Option<LogToClean> apply() {
                None$ none$;
                long now = this.time$1.milliseconds();
                scala.collection.immutable.Map<TopicAndPartition, Object> lastClean = this.$outer.allCleanerCheckpoints();
                Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.$outer.logs().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicAndPartition, Log> x0$1) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Log log = (Log)tuple2._2();
                            boolean bl = log.config().compact();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$grabFilthiestCompactedLog$1 $outer;

                    public final boolean apply(Tuple2<TopicAndPartition, Log> x0$2) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$2;
                        if (tuple2 != null) {
                            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                            boolean bl = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains((Object)topicAndPartition);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).map((Function1)new Serializable(this, now, lastClean){
                    public static final long serialVersionUID = 0L;
                    private final long now$1;
                    private final scala.collection.immutable.Map lastClean$1;

                    public final LogToClean apply(Tuple2<TopicAndPartition, Log> x0$3) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                            Log log = (Log)tuple2._2();
                            Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicAndPartition, (scala.collection.immutable.Map<TopicAndPartition, Object>)this.lastClean$1, this.now$1);
                            if (tuple22 != null) {
                                Tuple2.mcJJ.sp sp2;
                                long firstDirtyOffset = tuple22._1$mcJ$sp();
                                long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                                Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                                long firstDirtyOffset2 = sp3._1$mcJ$sp();
                                long firstUncleanableDirtyOffset2 = sp3._2$mcJ$sp();
                                LogToClean logToClean = new LogToClean(topicAndPartition, log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                                return logToClean;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.now$1 = now$1;
                        this.lastClean$1 = lastClean$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.totalBytes() > 0L;
                    }
                });
                this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
                Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
                    }
                });
                if (cleanableLogs.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                    this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                    none$ = new Some((Object)filthiest);
                }
                return none$;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
    }

    public Iterable<Tuple2<TopicAndPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Tuple2<TopicAndPartition, Log>> apply() {
                void var1_1;
                Iterable toClean = (Iterable)((TraversableLike)this.$outer.logs().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final boolean apply(Tuple2<TopicAndPartition, Log> x0$4) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                            boolean bl = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains((Object)topicAndPartition);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicAndPartition, Log> x0$5) {
                        Tuple2<TopicAndPartition, Log> tuple2 = x0$5;
                        if (tuple2 != null) {
                            Log log = (Log)tuple2._2();
                            boolean bl = LogCleanerManager$.MODULE$.isCompactAndDelete(log);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                toClean.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final Option<LogCleaningState> apply(Tuple2<TopicAndPartition, Log> x) {
                        return this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().put(x._1(), (Object)LogCleaningInProgress$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return var1_1;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.abortAndPauseCleaning(this.topicAndPartition$1);
                this.$outer.resumeCleaning(this.topicAndPartition$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1}));
            }
            {
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        });
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option option;
                block7: {
                    LogCleaningState logCleaningState;
                    block8: {
                        block6: {
                            Option option2;
                            Option option3;
                            block5: {
                                option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicAndPartition$3);
                                if (!None$.MODULE$.equals(option)) break block5;
                                option3 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicAndPartition$3, (Object)LogCleaningPaused$.MODULE$);
                                break block6;
                            }
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            LogCleaningState state = (LogCleaningState)some.x();
                            logCleaningState = state;
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block8;
                            option3 = option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicAndPartition$3, (Object)LogCleaningAborted$.MODULE$);
                        }
                        while (true) {
                            if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicAndPartition$3, LogCleaningPaused$.MODULE$)) {
                                return;
                            }
                            this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
                        }
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$3, logCleaningState})));
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$3}));
            }
            {
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$4;

            public final Option<LogCleaningState> apply() {
                Option option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicAndPartition$4);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$4})));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogCleaningState state = (LogCleaningState)some.x();
                    LogCleaningState logCleaningState = state;
                    if (LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                        Option option2;
                        Option option3 = option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicAndPartition$4);
                        return option3;
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$4, logCleaningState})));
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$4 = topicAndPartition$4;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$4}));
            }
            {
                this.topicAndPartition$4 = topicAndPartition$4;
            }
        });
    }

    public boolean kafka$log$LogCleanerManager$$isCleaningInState(TopicAndPartition topicAndPartition, LogCleaningState expectedState) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                LogCleaningState state;
                block2: {
                    option = this.kafka$log$LogCleanerManager$$inProgress().get((Object)topicAndPartition);
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = false;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogCleaningState logCleaningState = state = (LogCleaningState)some.x();
                LogCleaningState logCleaningState2 = expectedState;
                bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public void checkCleaningAborted(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicAndPartition$5, LogCleaningAborted$.MODULE$)) {
                    throw new LogCleaningAbortedException();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$5 = topicAndPartition$5;
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicAndPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, dataDir, update){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$1;
            private final Option update$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply((Object)this.dataDir$1);
                Map existing = checkpoint.read().filterKeys(this.$outer.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.update$1));
                checkpoint.write((Map<TopicAndPartition, Object>)existing);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$1 = dataDir$1;
                this.update$1 = update$1;
            }
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicAndPartition topicAndPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, dataDir, topicAndPartition, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$2;
            private final TopicAndPartition topicAndPartition$2;
            private final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpoint checkpoint;
                Map<TopicAndPartition, Object> existing;
                if (this.$outer.logs().get(this.topicAndPartition$2).config().compact() && BoxesRunTime.unboxToLong((Object)(existing = (checkpoint = (OffsetCheckpoint)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply((Object)this.dataDir$2)).read()).getOrElse((Object)this.topicAndPartition$2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) > this.offset$1) {
                    checkpoint.write((Map<TopicAndPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicAndPartition$2), (Object)BoxesRunTime.boxToLong((long)this.offset$1))));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$2 = dataDir$2;
                this.topicAndPartition$2 = topicAndPartition$2;
                this.offset$1 = offset$1;
            }
        });
    }

    public void doneCleaning(TopicAndPartition topicAndPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicAndPartition, dataDir, endOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$6;
            private final File dataDir$3;
            private final long endOffset$1;

            public final Object apply() {
                LogCleaningState logCleaningState;
                block4: {
                    BoxedUnit boxedUnit;
                    block3: {
                        block2: {
                            logCleaningState = (LogCleaningState)this.$outer.kafka$log$LogCleanerManager$$inProgress().apply((Object)this.topicAndPartition$6);
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block2;
                            this.$outer.updateCheckpoints(this.dataDir$3, (Option<Tuple2<TopicAndPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicAndPartition$6, (Object)BoxesRunTime.boxToLong((long)this.endOffset$1))));
                            boxedUnit = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicAndPartition$6);
                            break block3;
                        }
                        if (!LogCleaningAborted$.MODULE$.equals(logCleaningState)) break block4;
                        this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicAndPartition$6, (Object)LogCleaningPaused$.MODULE$);
                        this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().signalAll();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$6, logCleaningState})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$6 = topicAndPartition$6;
                this.dataDir$3 = dataDir$3;
                this.endOffset$1 = endOffset$1;
            }
        });
    }

    public void doneDeleting(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicAndPartition topicAndPartition$7;

            public final Option<LogCleaningState> apply() {
                return this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicAndPartition$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$7 = topicAndPartition$7;
            }
        });
    }

    public LogCleanerManager(File[] logDirs, Pool<TopicAndPartition, Log> logs) {
        this.logDirs = logDirs;
        this.logs = logs;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.kafka$log$LogCleanerManager$$checkpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final Tuple2<File, OffsetCheckpoint> apply(File dir) {
                return new Tuple2((Object)dir, (Object)new OffsetCheckpoint(new File(dir, this.$outer.offsetCheckpointFile())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        this.kafka$log$LogCleanerManager$$inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.kafka$log$LogCleanerManager$$pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

