/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import kafka.log.OffsetMap;
import kafka.log.OffsetMap$class;
import kafka.log.SkimpyOffsetMap$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u0001\u001d\u0011qbU6j[BLxJ\u001a4tKRl\u0015\r\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tIqJ\u001a4tKRl\u0015\r\u001d\u0005\t'\u0001\u0011)\u0019!C\u0001)\u00051Q.Z7pef,\u0012!\u0006\t\u0003\u0013YI!a\u0006\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u001diW-\\8ss\u0002B\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u000eQ\u0006\u001c\b.\u00117h_JLG\u000f[7\u0016\u0003u\u0001\"AH\u0011\u000f\u0005%y\u0012B\u0001\u0011\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011!e\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001R\u0001\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u001d!\f7\u000f[!mO>\u0014\u0018\u000e\u001e5nA!)q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"2!\u000b\u0016,!\ty\u0001\u0001C\u0003\u0014M\u0001\u0007Q\u0003C\u0004\u001cMA\u0005\t\u0019A\u000f\t\u000f5\u0002!\u0019!C\u0005]\u0005)!-\u001f;fgV\tq\u0006\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005\u0019a.[8\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bB\u0002\u001d\u0001A\u0003%q&\u0001\u0004csR,7\u000f\t\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0003\u0019!\u0017nZ3tiV\tA\b\u0005\u0002>\u00016\taH\u0003\u0002@g\u0005A1/Z2ve&$\u00180\u0003\u0002B}\tiQ*Z:tC\u001e,G)[4fgRDaa\u0011\u0001!\u0002\u0013a\u0014a\u00023jO\u0016\u001cH\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003\u0015\u0003!A\u0017m\u001d5TSj,\u0007BB$\u0001A\u0003%Q#A\u0005iCND7+\u001b>fA!9\u0011\n\u0001b\u0001\n\u0013Q\u0015!\u00025bg\"\fT#A&\u0011\u0007%ae*\u0003\u0002N\u0015\t)\u0011I\u001d:bsB\u0011\u0011bT\u0005\u0003!*\u0011AAQ=uK\"1!\u000b\u0001Q\u0001\n-\u000ba\u0001[1tQF\u0002\u0003b\u0002+\u0001\u0005\u0004%IAS\u0001\u0006Q\u0006\u001c\bN\r\u0005\u0007-\u0002\u0001\u000b\u0011B&\u0002\r!\f7\u000f\u001b\u001a!\u0011\u001dA\u0006\u00011A\u0005\nQ\tq!\u001a8ue&,7\u000fC\u0004[\u0001\u0001\u0007I\u0011B.\u0002\u0017\u0015tGO]5fg~#S-\u001d\u000b\u00039~\u0003\"!C/\n\u0005yS!\u0001B+oSRDq\u0001Y-\u0002\u0002\u0003\u0007Q#A\u0002yIEBaA\u0019\u0001!B\u0013)\u0012\u0001C3oiJLWm\u001d\u0011\t\u000f\u0011\u0004\u0001\u0019!C\u0005K\u00069An\\8lkB\u001cX#\u00014\u0011\u0005%9\u0017B\u00015\u000b\u0005\u0011auN\\4\t\u000f)\u0004\u0001\u0019!C\u0005W\u0006YAn\\8lkB\u001cx\fJ3r)\taF\u000eC\u0004aS\u0006\u0005\t\u0019\u00014\t\r9\u0004\u0001\u0015)\u0003g\u0003!awn\\6vaN\u0004\u0003b\u00029\u0001\u0001\u0004%I!Z\u0001\u0007aJ|'-Z:\t\u000fI\u0004\u0001\u0019!C\u0005g\u0006Q\u0001O]8cKN|F%Z9\u0015\u0005q#\bb\u00021r\u0003\u0003\u0005\rA\u001a\u0005\u0007m\u0002\u0001\u000b\u0015\u00024\u0002\u000fA\u0014xNY3tA!9\u0001\u0010\u0001a\u0001\n\u0013)\u0017A\u00037bgR|eMZ:fi\"9!\u0010\u0001a\u0001\n\u0013Y\u0018A\u00047bgR|eMZ:fi~#S-\u001d\u000b\u00039rDq\u0001Y=\u0002\u0002\u0003\u0007a\r\u0003\u0004\u007f\u0001\u0001\u0006KAZ\u0001\fY\u0006\u001cHo\u00144gg\u0016$\b\u0005\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0015\u00035\u0011\u0017\u0010^3t!\u0016\u0014XI\u001c;ss\"9\u0011Q\u0001\u0001!\u0002\u0013)\u0012A\u00042zi\u0016\u001c\b+\u001a:F]R\u0014\u0018\u0010\t\u0005\t\u0003\u0013\u0001!\u0019!C\u0001)\u0005)1\u000f\\8ug\"9\u0011Q\u0002\u0001!\u0002\u0013)\u0012AB:m_R\u001c\b\u0005C\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u0007A,H\u000fF\u0003]\u0003+\tI\u0002C\u0004\u0002\u0018\u0005=\u0001\u0019A\u0018\u0002\u0007-,\u0017\u0010C\u0004\u0002\u001c\u0005=\u0001\u0019\u00014\u0002\r=4gm]3u\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\tq![:F[B$\u0018\u0010\u0006\u0003\u0002$\u0005%\u0002cA\u0005\u0002&%\u0019\u0011q\u0005\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u00111FA\u000f\u0001\u0004)\u0012\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\u0005\u0019q-\u001a;\u0015\u0007\u0019\f\u0019\u0004C\u0004\u0002\u0018\u00055\u0002\u0019A\u0018\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:\u0005)1\r\\3beR\tA\f\u0003\u0004\u0002>\u0001!\t\u0005F\u0001\u0005g&TX\rC\u0004\u0002B\u0001!\t!a\u0011\u0002\u001b\r|G\u000e\\5tS>t'+\u0019;f+\t\t)\u0005E\u0002\n\u0003\u000fJ1!!\u0013\u000b\u0005\u0019!u.\u001e2mK\"1\u0011Q\n\u0001\u0005B\u0015\fA\u0002\\1uKN$xJ\u001a4tKRDq!!\u0015\u0001\t\u0013\t\u0019&\u0001\u0006q_NLG/[8o\u001f\u001a$R!FA+\u00033Bq!a\u0016\u0002P\u0001\u00071*\u0001\u0003iCND\u0007bBA.\u0003\u001f\u0002\r!F\u0001\bCR$X-\u001c9u\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\n\u0001\u0002[1tQ&sGo\u001c\u000b\u00069\u0006\r\u0014Q\r\u0005\b\u0003/\ti\u00061\u00010\u0011\u001d\t9'!\u0018A\u0002-\u000baAY;gM\u0016\u0014\bf\u0001\u0001\u0002lA!\u0011QNA:\u001b\t\tyGC\u0002\u0002r\u0011\tQ!\u001e;jYNLA!!\u001e\u0002p\tian\u001c8uQJ,\u0017\rZ:bM\u0016<\u0011\"!\u001f\u0003\u0003\u0003E\t!a\u001f\u0002\u001fM[\u0017.\u001c9z\u001f\u001a47/\u001a;NCB\u00042aDA?\r!\t!!!A\t\u0002\u0005}4cAA?\u0011!9q%! \u0005\u0002\u0005\rECAA>\u0011)\t9)! \u0012\u0002\u0013\u0005\u0011\u0011R\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-%fA\u000f\u0002\u000e.\u0012\u0011q\u0012\t\u0005\u0003#\u000bY*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001a*\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti*a%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class SkimpyOffsetMap
implements OffsetMap {
    private final int memory;
    private final String hashAlgorithm;
    private final ByteBuffer bytes;
    private final MessageDigest digest;
    private final int hashSize;
    private final byte[] hash1;
    private final byte[] hash2;
    private int entries;
    private long lookups;
    private long probes;
    private long lastOffset;
    private final int bytesPerEntry;
    private final int slots;

    public static String $lessinit$greater$default$2() {
        return SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public double utilization() {
        return OffsetMap$class.utilization(this);
    }

    public int memory() {
        return this.memory;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private MessageDigest digest() {
        return this.digest;
    }

    private int hashSize() {
        return this.hashSize;
    }

    private byte[] hash1() {
        return this.hash1;
    }

    private byte[] hash2() {
        return this.hash2;
    }

    private int entries() {
        return this.entries;
    }

    private void entries_$eq(int x$1) {
        this.entries = x$1;
    }

    private long lookups() {
        return this.lookups;
    }

    private void lookups_$eq(long x$1) {
        this.lookups = x$1;
    }

    private long probes() {
        return this.probes;
    }

    private void probes_$eq(long x$1) {
        this.probes = x$1;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(long x$1) {
        this.lastOffset = x$1;
    }

    public int bytesPerEntry() {
        return this.bytesPerEntry;
    }

    @Override
    public int slots() {
        return this.slots;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(ByteBuffer key, long offset) {
        Predef$.MODULE$.require(this.entries() < this.slots(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Attempt to add a new entry to a full offset map.";
            }
        });
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = this.positionOf(this.hash1(), attempt);
        while (true) {
            void var4_3;
            int n;
            if (this.isEmpty(pos)) {
                this.bytes().position(pos);
                this.bytes().put(this.hash1());
                this.bytes().putLong(offset);
                this.lastOffset_$eq(offset);
                this.entries_$eq(this.entries() + 1);
                return;
            }
            this.bytes().position(n);
            this.bytes().get(this.hash2());
            if (Arrays.equals(this.hash1(), this.hash2())) {
                this.bytes().putLong(offset);
                this.lastOffset_$eq(offset);
                return;
            }
            n = this.positionOf(this.hash1(), (int)(++var4_3));
        }
    }

    private boolean isEmpty(int position) {
        return this.bytes().getLong(position) == 0L && this.bytes().getLong(position + 8) == 0L && this.bytes().getLong(position + 16) == 0L;
    }

    @Override
    public long get(ByteBuffer key) {
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = 0;
        int maxAttempts = this.slots() + this.hashSize() - 4;
        do {
            if (attempt >= maxAttempts) {
                return -1L;
            }
            pos = this.positionOf(this.hash1(), attempt);
            this.bytes().position(pos);
            if (this.isEmpty(pos)) {
                return -1L;
            }
            this.bytes().get(this.hash2());
            ++attempt;
        } while (!Arrays.equals(this.hash1(), this.hash2()));
        return this.bytes().getLong();
    }

    @Override
    public void clear() {
        this.entries_$eq(0);
        this.lookups_$eq(0L);
        this.probes_$eq(0L);
        this.lastOffset_$eq(-1L);
        Arrays.fill(this.bytes().array(), this.bytes().arrayOffset(), this.bytes().arrayOffset() + this.bytes().limit(), (byte)0);
    }

    @Override
    public int size() {
        return this.entries();
    }

    public double collisionRate() {
        return (double)(this.probes() - this.lookups()) / (double)this.lookups();
    }

    @Override
    public long latestOffset() {
        return this.lastOffset();
    }

    private int positionOf(byte[] hash, int attempt) {
        int probe = CoreUtils$.MODULE$.readInt(hash, package$.MODULE$.min(attempt, this.hashSize() - 4)) + package$.MODULE$.max(0, attempt - this.hashSize() + 4);
        int slot = Utils.abs((int)probe) % this.slots();
        this.probes_$eq(this.probes() + 1L);
        return slot * this.bytesPerEntry();
    }

    private void hashInto(ByteBuffer key, byte[] buffer) {
        key.mark();
        this.digest().update(key);
        key.reset();
        this.digest().digest(buffer, 0, this.hashSize());
    }

    public SkimpyOffsetMap(int memory, String hashAlgorithm) {
        this.memory = memory;
        this.hashAlgorithm = hashAlgorithm;
        OffsetMap$class.$init$(this);
        this.bytes = ByteBuffer.allocate(memory);
        this.digest = MessageDigest.getInstance(hashAlgorithm);
        this.hashSize = this.digest().getDigestLength();
        this.hash1 = new byte[this.hashSize()];
        this.hash2 = new byte[this.hashSize()];
        this.entries = 0;
        this.lookups = 0L;
        this.probes = 0L;
        this.lastOffset = -1L;
        this.bytesPerEntry = this.hashSize() + 8;
        this.slots = memory / this.bytesPerEntry();
    }
}

