/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.connector;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.connect.data.Schema;

@InterfaceStability.Unstable
public abstract class ConnectRecord {
    private final String topic;
    private final Integer kafkaPartition;
    private final Schema keySchema;
    private final Object key;
    private final Schema valueSchema;
    private final Object value;
    private final Long timestamp;

    public ConnectRecord(String topic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp) {
        this.topic = topic;
        this.kafkaPartition = kafkaPartition;
        this.keySchema = keySchema;
        this.key = key;
        this.valueSchema = valueSchema;
        this.value = value;
        this.timestamp = timestamp;
    }

    public String topic() {
        return this.topic;
    }

    public Integer kafkaPartition() {
        return this.kafkaPartition;
    }

    public Object key() {
        return this.key;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Object value() {
        return this.value;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "ConnectRecord{topic='" + this.topic + '\'' + ", kafkaPartition=" + this.kafkaPartition + ", key=" + this.key + ", value=" + this.value + ", timestamp=" + this.timestamp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectRecord that = (ConnectRecord)o;
        if (this.kafkaPartition != null ? !this.kafkaPartition.equals(that.kafkaPartition) : that.kafkaPartition != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.keySchema != null ? !this.keySchema.equals(that.keySchema) : that.keySchema != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.valueSchema != null ? !this.valueSchema.equals(that.valueSchema) : that.valueSchema != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null);
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + (this.kafkaPartition != null ? this.kafkaPartition.hashCode() : 0);
        result = 31 * result + (this.keySchema != null ? this.keySchema.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.valueSchema != null ? this.valueSchema.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.timestamp.hashCode() : 0);
        return result;
    }
}

