/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.FileOutputStream;
import java.security.Permission;
import java.util.Arrays;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001\u0015\u0011\u0011bS1gW\u0006$Vm\u001d;\u000b\u0003\r\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\rA\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001aDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005A\u0001Q\"\u0001\u0002\t\u000fI\u0001!\u0019!C\u0001'\u00059rN]5hS:\fGnU3dkJLG/_'b]\u0006<WM]\u000b\u0002)A\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0005Y\u0006twMC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\t\ru\u0001\u0001\u0015!\u0003\u0015\u0003ay'/[4j]\u0006d7+Z2ve&$\u00180T1oC\u001e,'\u000f\t\u0004\u0005?\u0001\u0001\u0001E\u0001\u0006Fq&$8)\u00197mK\u0012\u001c\"AH\u0011\u0011\u0005U\u0011\u0013BA\u0012\u0017\u0005E\u0019VmY;sSRLX\t_2faRLwN\u001c\u0005\u0006\u001by!\t!\n\u000b\u0002MA\u0011qEH\u0007\u0002\u0001\u0019!\u0011\u0006\u0001\u0003+\u0005Uqu.\u0012=jiN+7-\u001e:jifl\u0015M\\1hKJ\u001c\"\u0001\u000b\u000b\t\u000b5AC\u0011\u0001\u0017\u0015\u00035\u0002\"a\n\u0015\t\u000b=BC\u0011\t\u0019\u0002\u0013\rDWmY6Fq&$HCA\u00195!\t9!'\u0003\u00024\u0011\t!QK\\5u\u0011\u0015)d\u00061\u00017\u0003\u0019\u0019H/\u0019;vgB\u0011qaN\u0005\u0003q!\u00111!\u00138u\u0011\u0015Q\u0004\u0006\"\u0011<\u0003=\u0019\u0007.Z2l!\u0016\u0014X.[:tS>tGCA\u0019=\u0011\u0015i\u0014\b1\u0001?\u0003\u0011\u0001XM]7\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005C\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\r\u0003%A\u0003)fe6L7o]5p]\")!\b\u000bC!\u000bR\u0019\u0011GR$\t\u000bu\"\u0005\u0019\u0001 \t\u000b!#\u0005\u0019A%\u0002\u000f\r|g\u000e^3yiB\u0011QCS\u0005\u0003\u0017Z\u0011aa\u00142kK\u000e$\b\"B'\u0001\t\u0003q\u0015AE:fiN+7-\u001e:jifl\u0015M\\1hKJ$\u0012!\r\u0015\u0003\u0019B\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000b),h.\u001b;\u000b\u0003U\u000b1a\u001c:h\u0013\t9&K\u0001\u0004CK\u001a|'/\u001a\u0005\u00063\u0002!\tAT\u0001\u001bg\u0016$xJ]5hS:\fGnU3dkJLG/_'b]\u0006<WM\u001d\u0015\u00031n\u0003\"!\u0015/\n\u0005u\u0013&!B!gi\u0016\u0014\b\"B0\u0001\t\u0003q\u0015A\u0007;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001c\bF\u00010b!\t\t&-\u0003\u0002d%\n!A+Z:u\u0011\u0015)\u0007\u0001\"\u0001O\u0003\u001d\"Xm\u001d;HKR\\\u0015MZ6b\u0007>tg-[4Ge>l\u0017I]4t/J|gnZ*fiZ\u000bG.^3)\t\u0011\fw\r[\u0001\tKb\u0004Xm\u0019;fI\u000e\na\u0005C\u0003k\u0001\u0011\u0005a*A\u0015uKN$x)\u001a;LC\u001a\\\u0017mQ8oM&<gI]8n\u0003J<7OT8o\u0003J<7/\u0011;UQ\u0016,e\u000e\u001a\u0015\u0005S\u0006<\u0007\u000eC\u0003n\u0001\u0011\u0005a*A\u0013uKN$x)\u001a;LC\u001a\\\u0017mQ8oM&<gI]8n\u0003J<7OT8o\u0003J<7o\u00148ms\"\"A.Y4i\u0011\u0015\u0001\b\u0001\"\u0001O\u00035\"Xm\u001d;HKR\\\u0015MZ6b\u0007>tg-[4Ge>l\u0017I]4t\u001d>t\u0017I]4t\u0003R$\u0006.\u001a\"fO\u001eLgn\u001a\u0015\u0005_\u0006<\u0007\u000eC\u0003t\u0001\u0011\u0005a*A\u000buKN$8*\u00194lCN\u001bH\u000eU1tg^|'\u000fZ:)\u0005I\f\u0007\"\u0002<\u0001\t\u00039\u0018\u0001\u00069sKB\f'/\u001a#fM\u0006,H\u000e^\"p]\u001aLw\rF\u0001y!\tIHP\u0004\u0002\bu&\u00111\u0010C\u0001\u0007!J,G-\u001a4\n\u0005ut(AB*ue&twM\u0003\u0002|\u0011!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011!\u00049sKB\f'/Z\"p]\u001aLw\rF\u0002y\u0003\u000bAq!a\u0002\u0000\u0001\u0004\tI!A\u0003mS:,7\u000f\u0005\u0003\b\u0003\u0017A\u0018bAA\u0007\u0011\t)\u0011I\u001d:bs\u0002")
public class KafkaTest {
    private final SecurityManager originalSecurityManager = System.getSecurityManager();

    public SecurityManager originalSecurityManager() {
        return this.originalSecurityManager;
    }

    @Before
    public void setSecurityManager() {
        System.setSecurityManager(new NoExitSecurityManager());
    }

    @After
    public void setOriginalSecurityManager() {
        System.setSecurityManager(this.originalSecurityManager());
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)1L, (long)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assert.assertEquals((long)1L, (long)config3.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config4.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test(expected=ExitCalled.class)
    public void testGetKafkaConfigFromArgsWrongSetValue() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "a=b=c"})));
    }

    @Test(expected=ExitCalled.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=ExitCalled.class)
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=ExitCalled.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password"})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.sslKeyPassword().toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.sslKeystorePassword().toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.sslTruststorePassword().toString());
        Assert.assertEquals((Object)"key_password", (Object)config.sslKeyPassword().value());
        Assert.assertEquals((Object)"keystore_password", (Object)config.sslKeystorePassword().value());
        Assert.assertEquals((Object)"truststore_password", (Object)config.sslTruststorePassword().value());
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    public String prepareConfig(String[] lines) {
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        FileOutputStream writer = new FileOutputStream(file);
        Predef$.MODULE$.refArrayOps((Object[])lines).foreach((Function1)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream writer$1;

            public final void apply(String l) {
                this.writer$1.write(l.getBytes());
                this.writer$1.write("\n".getBytes());
            }
            {
                this.writer$1 = writer$1;
            }
        });
        writer.close();
        return file.getAbsolutePath();
    }

    public class ExitCalled
    extends SecurityException {
        public /* synthetic */ KafkaTest kafka$KafkaTest$ExitCalled$$$outer() {
            return KafkaTest.this;
        }

        public ExitCalled() {
            if (KafkaTest.this == null) {
                throw null;
            }
        }
    }

    public class NoExitSecurityManager
    extends SecurityManager {
        @Override
        public void checkExit(int status) {
            throw this.kafka$KafkaTest$NoExitSecurityManager$$$outer().new ExitCalled();
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        public /* synthetic */ KafkaTest kafka$KafkaTest$NoExitSecurityManager$$$outer() {
            return KafkaTest.this;
        }

        public NoExitSecurityManager() {
            if (KafkaTest.this == null) {
                throw null;
            }
        }
    }
}

