/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.util.Arrays;
import kafka.coordinator.MemberMetadata;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u000f\t\u0011R*Z7cKJlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\bOJ|W\u000f]%e+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007'R\u0014\u0018N\\4\t\r\r\u0002\u0001\u0015!\u0003\u001b\u0003!9'o\\;q\u0013\u0012\u0004\u0003bB\u0013\u0001\u0005\u0004%\t!G\u0001\tG2LWM\u001c;JI\"1q\u0005\u0001Q\u0001\ni\t\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u000f%\u0002!\u0019!C\u00013\u0005Q1\r\\5f]RDun\u001d;\t\r-\u0002\u0001\u0015!\u0003\u001b\u0003-\u0019G.[3oi\"{7\u000f\u001e\u0011\t\u000f5\u0002!\u0019!C\u00013\u0005AQ.Z7cKJLE\r\u0003\u00040\u0001\u0001\u0006IAG\u0001\n[\u0016l'-\u001a:JI\u0002Bq!\r\u0001C\u0002\u0013\u0005\u0011$\u0001\u0007qe>$xnY8m)f\u0004X\r\u0003\u00044\u0001\u0001\u0006IAG\u0001\u000eaJ|Go\\2pYRK\b/\u001a\u0011\t\u000fU\u0002!\u0019!C\u0001m\u0005\u0011\"/\u001a2bY\u0006t7-\u001a+j[\u0016|W\u000f^'t+\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$aA%oi\"1a\b\u0001Q\u0001\n]\n1C]3cC2\fgnY3US6,w.\u001e;Ng\u0002Bq\u0001\u0011\u0001C\u0002\u0013\u0005a'\u0001\ttKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\"1!\t\u0001Q\u0001\n]\n\u0011c]3tg&|g\u000eV5nK>,H/T:!\u0011\u0015!\u0005\u0001\"\u0001F\u0003u!Xm\u001d;NCR\u001c\u0007.Z:TkB\u0004xN\u001d;fIB\u0013x\u000e^8d_2\u001cX#\u0001$\u0011\u0005a:\u0015B\u0001%:\u0005\u0011)f.\u001b;)\u0005\rS\u0005CA&N\u001b\u0005a%BA\u0006\u000f\u0013\tqEJ\u0001\u0003UKN$\b\"\u0002)\u0001\t\u0003)\u0015\u0001\b;fgR4v\u000e^3G_J\u0004&/\u001a4feJ,G\r\u0015:pi>\u001cw\u000e\u001c\u0015\u0003\u001f*CQa\u0015\u0001\u0005\u0002\u0015\u000bA\u0002^3ti6+G/\u00193bi\u0006D#A\u0015&\t\u000bY\u0003A\u0011A#\u0002OQ,7\u000f^'fi\u0006$\u0017\r^1SC&\u001cXm](o+:\u001cX\u000f\u001d9peR,G\r\u0015:pi>\u001cw\u000e\u001c\u0015\u0005+*C\u0016,\u0001\u0005fqB,7\r^3eG\u0005Q\u0006CA.d\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`\r\u00051AH]8pizJ\u0011AO\u0005\u0003Ef\nq\u0001]1dW\u0006<W-\u0003\u0002eK\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0005\tL\u0004\"B4\u0001\t\u0003)\u0015\u0001\n;fgR4v\u000e^3SC&\u001cXm](o\u001d>\u001cV\u000f\u001d9peR,G\r\u0015:pi>\u001cw\u000e\\:)\t\u0019T\u0005,\u0017")
public class MemberMetadataTest
extends JUnitSuite {
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final String memberId;
    private final String protocolType;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public String memberId() {
        return this.memberId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    @Test
    public void testMatchesSupportedProtocols() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        Assert.assertTrue((boolean)member.matches(protocols));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()))}))));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
        Assert.assertFalse((boolean)member.matches(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
    }

    @Test
    public void testVoteForPreferredProtocol() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        Assert.assertEquals((Object)"range", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))));
        Assert.assertEquals((Object)"roundrobin", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah", "roundrobin"}))));
    }

    @Test
    public void testMetadata() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()), member.metadata("range")));
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()), member.metadata("roundrobin")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMetadataRaisesOnUnsupportedProtocol() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        member.metadata("blah");
        throw this.fail(new Position("MemberMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVoteRaisesOnNoSupportedProtocols() {
        List protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), protocols);
        member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah"})));
        throw this.fail(new Position("MemberMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public MemberMetadataTest() {
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.memberId = "memberId";
        this.protocolType = "consumer";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

