/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0002\u0002\u001d\u0011ACQ1tKJ+\u0007\u000f\\5dC\u001a+Go\u00195UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\t!A_6\n\u0005]!\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001a\u0001\n\u0003y\u0012a\u00022s_.,'o]\u000b\u0002AA\u0019\u0011e\u000b\u0018\u000f\u0005\tBcBA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003\u0019a$o\\8u}%\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*U\u00059\u0001/Y2lC\u001e,'\"A\u0014\n\u00051j#aA*fc*\u0011\u0011F\u000b\t\u00039=J!\u0001\r\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\be\u0001\u0001\r\u0011\"\u00014\u0003-\u0011'o\\6feN|F%Z9\u0015\u0005QB\u0004CA\u001b7\u001b\u0005Q\u0013BA\u001c+\u0005\u0011)f.\u001b;\t\u000fe\n\u0014\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\rm\u0002\u0001\u0015)\u0003!\u0003!\u0011'o\\6feN\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAP\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\t1\fgn\u001a\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1\u0015I\u0001\u0004TiJLgn\u001a\u0005\u0007\u0011\u0002\u0001\u000b\u0011B \u0002\u000fQ|\u0007/[22A!9!\n\u0001b\u0001\n\u0003q\u0014A\u0002;pa&\u001c'\u0007\u0003\u0004M\u0001\u0001\u0006IaP\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015q\u0005A\"\u0005P\u00039!(/^:u'R|'/\u001a$jY\u0016,\u0012\u0001\u0015\t\u0004kE\u001b\u0016B\u0001*+\u0005\u0019y\u0005\u000f^5p]B\u0011AkV\u0007\u0002+*\u0011akQ\u0001\u0003S>L!\u0001W+\u0003\t\u0019KG.\u001a\u0005\u00065\u00021\tbW\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012\u0001\u0018\t\u0003;\u0016l\u0011A\u0018\u0006\u0003?\u0002\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003C\n\faaY8n[>t'BA\u0003d\u0015\t!g\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Mz\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000b!\u0004A\u0011I5\u0002\u000bM,G/\u00169\u0015\u0003QB#aZ6\u0011\u00051tW\"A7\u000b\u0005-q\u0011BA8n\u0005\u0019\u0011UMZ8sK\")\u0011\u000f\u0001C!S\u0006AA/Z1s\t><h\u000e\u000b\u0002qgB\u0011A\u000e^\u0005\u0003k6\u0014Q!\u00114uKJDQa\u001e\u0001\u0005\u0002%\f\u0001\u0004^3tiJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1eQ\t1\u0018\u0010\u0005\u0002mu&\u001110\u001c\u0002\u0005)\u0016\u001cH\u000f")
public abstract class BaseReplicaFetchTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private Seq<KafkaServer> brokers;
    private final String topic1;
    private final String topic2;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseReplicaFetchTest baseReplicaFetchTest = this;
        synchronized (baseReplicaFetchTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public abstract Option<File> trustStoreFile();

    public abstract SecurityProtocol securityProtocol();

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        int x$4 = 2;
        String x$5 = this.zkConnect();
        Some x$6 = new Some((Object)this.securityProtocol());
        Option<File> x$7 = this.trustStoreFile();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> props = TestUtils$.MODULE$.createBrokerConfigs(x$4, x$5, x$8, x$9, (Option<SecurityProtocol>)x$6, x$7, x$10, x$11, x$12, x$13, x$14, x$15);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)props.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig x$1) {
                return TestUtils$.MODULE$.createServer(x$1, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        this.brokers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.shutdown();
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testReplicaFetcherThread() {
        int partition = 0;
        List testMessageList1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"}));
        List testMessageList2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test5", "test6", "test7", "test8"}));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseReplicaFetchTest $outer;

            public final scala.collection.immutable.Map<Object, Option<Object>> apply(String topic) {
                return TestUtils$.MODULE$.createTopic(this.$outer.zkUtils(), topic, 1, 2, this.$outer.brokers(), TestUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String x$16 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$17 = 5;
        StringSerializer x$18 = new StringSerializer();
        StringSerializer x$19 = new StringSerializer();
        int x$20 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$21 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$22 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$23 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$24 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$25 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$26 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$27 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$28 = TestUtils$.MODULE$.createNewProducer$default$13();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$16, x$20, x$21, x$22, x$17, x$23, x$24, x$25, x$26, x$27, x$18, x$19, x$28);
        List records = (List)((List)testMessageList1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseReplicaFetchTest $outer;

            public final ProducerRecord<String, String> apply(String m) {
                return new ProducerRecord(this.$outer.topic1(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)testMessageList2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseReplicaFetchTest $outer;

            public final ProducerRecord<String, String> apply(String m) {
                return new ProducerRecord(this.$outer.topic2(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        ((List)records.map((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(ProducerRecord<String, String> x$1) {
                return this.producer$1.send(x$1);
            }
            {
                this.producer$1 = producer$1;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                return x$3.get();
            }
        });
        producer.close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseReplicaFetchTest $outer;
            private final int partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$server$BaseReplicaFetchTest$$logsMatch$1(this.partition$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        }, "Broker logs should be identical", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    public final boolean kafka$server$BaseReplicaFetchTest$$logsMatch$1(int partition$1) {
        BooleanRef result = BooleanRef.create((boolean)true);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this, partition$1, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseReplicaFetchTest $outer;
            private final int partition$1;
            private final BooleanRef result$1;

            public final void apply(String topic) {
                TopicAndPartition topicAndPart = new TopicAndPartition(topic, this.partition$1);
                long expectedOffset = ((Log)((KafkaServer)this.$outer.brokers().head()).getLogManager().getLog(topicAndPart).get()).logEndOffset();
                this.result$1.elem = this.result$1.elem && expectedOffset > 0L && this.$outer.brokers().forall((Function1)new Serializable(this, topicAndPart, expectedOffset){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPart$1;
                    private final long expectedOffset$1;

                    public final boolean apply(KafkaServer item) {
                        return this.expectedOffset$1 == ((Log)item.getLogManager().getLog(this.topicAndPart$1).get()).logEndOffset();
                    }
                    {
                        this.topicAndPart$1 = topicAndPart$1;
                        this.expectedOffset$1 = expectedOffset$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.result$1 = result$1;
            }
        });
        return result.elem;
    }

    public BaseReplicaFetchTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.brokers = null;
        this.topic1 = "foo";
        this.topic2 = "bar";
    }
}

