/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.util.ConnectorTaskId;

public class ClusterConfigState {
    public static final ClusterConfigState EMPTY = new ClusterConfigState(-1L, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet());
    private final long offset;
    private final Map<String, Integer> connectorTaskCounts;
    private final Map<String, Map<String, String>> connectorConfigs;
    private final Map<ConnectorTaskId, Map<String, String>> taskConfigs;
    private final Set<String> inconsistentConnectors;

    public ClusterConfigState(long offset, Map<String, Integer> connectorTaskCounts, Map<String, Map<String, String>> connectorConfigs, Map<ConnectorTaskId, Map<String, String>> taskConfigs, Set<String> inconsistentConnectors) {
        this.offset = offset;
        this.connectorTaskCounts = connectorTaskCounts;
        this.connectorConfigs = connectorConfigs;
        this.taskConfigs = taskConfigs;
        this.inconsistentConnectors = inconsistentConnectors;
    }

    public long offset() {
        return this.offset;
    }

    public Set<String> connectors() {
        return this.connectorConfigs.keySet();
    }

    public Map<String, String> connectorConfig(String connector) {
        return this.connectorConfigs.get(connector);
    }

    public Map<String, String> taskConfig(ConnectorTaskId task) {
        return this.taskConfigs.get(task);
    }

    public int taskCount(String connectorName) {
        Integer count = this.connectorTaskCounts.get(connectorName);
        return count == null ? 0 : count;
    }

    public List<ConnectorTaskId> tasks(String connectorName) {
        if (this.inconsistentConnectors.contains(connectorName)) {
            return Collections.emptyList();
        }
        Integer numTasks = this.connectorTaskCounts.get(connectorName);
        if (numTasks == null) {
            return Collections.emptyList();
        }
        ArrayList<ConnectorTaskId> taskIds = new ArrayList<ConnectorTaskId>();
        for (int taskIndex = 0; taskIndex < numTasks; ++taskIndex) {
            ConnectorTaskId taskId = new ConnectorTaskId(connectorName, taskIndex);
            taskIds.add(taskId);
        }
        return taskIds;
    }

    public Set<String> inconsistentConnectors() {
        return this.inconsistentConnectors;
    }

    public String toString() {
        return "ClusterConfigState{offset=" + this.offset + ", connectorTaskCounts=" + this.connectorTaskCounts + ", connectorConfigs=" + this.connectorConfigs + ", taskConfigs=" + this.taskConfigs + ", inconsistentConnectors=" + this.inconsistentConnectors + '}';
    }
}

