/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.standalone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.errors.AlreadyExistsException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.HerderConnectorContext;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneHerder
implements Herder {
    private static final Logger log = LoggerFactory.getLogger(StandaloneHerder.class);
    private final Worker worker;
    private HashMap<String, ConnectorState> connectors = new HashMap();

    public StandaloneHerder(Worker worker) {
        this.worker = worker;
    }

    @Override
    public synchronized void start() {
        log.info("Herder starting");
        log.info("Herder started");
    }

    @Override
    public synchronized void stop() {
        log.info("Herder stopping");
        for (String connName : new HashSet<String>(this.connectors.keySet())) {
            this.removeConnectorTasks(connName);
            try {
                this.worker.stopConnector(connName);
            }
            catch (ConnectException e) {
                log.error("Error shutting down connector {}: ", (Object)connName, (Object)e);
            }
        }
        this.connectors.clear();
        log.info("Herder stopped");
    }

    @Override
    public synchronized void connectors(Callback<Collection<String>> callback) {
        callback.onCompletion(null, new ArrayList<String>(this.connectors.keySet()));
    }

    @Override
    public synchronized void connectorInfo(String connName, Callback<ConnectorInfo> callback) {
        ConnectorState state = this.connectors.get(connName);
        if (state == null) {
            callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
            return;
        }
        callback.onCompletion(null, this.createConnectorInfo(state));
    }

    private ConnectorInfo createConnectorInfo(ConnectorState state) {
        if (state == null) {
            return null;
        }
        ArrayList<ConnectorTaskId> taskIds = new ArrayList<ConnectorTaskId>();
        for (int i = 0; i < state.taskConfigs.size(); ++i) {
            taskIds.add(new ConnectorTaskId(state.name, i));
        }
        return new ConnectorInfo(state.name, state.configOriginals, taskIds);
    }

    @Override
    public void connectorConfig(String connName, final Callback<Map<String, String>> callback) {
        this.connectorInfo(connName, new Callback<ConnectorInfo>(){

            @Override
            public void onCompletion(Throwable error, ConnectorInfo result) {
                if (error != null) {
                    callback.onCompletion(error, null);
                    return;
                }
                callback.onCompletion(null, result.config());
            }
        });
    }

    @Override
    public synchronized void putConnectorConfig(String connName, Map<String, String> config, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback) {
        try {
            boolean created = false;
            if (this.connectors.containsKey(connName)) {
                if (!allowReplace) {
                    callback.onCompletion((Throwable)new AlreadyExistsException("Connector " + connName + " already exists"), null);
                    return;
                }
                if (config == null) {
                    this.removeConnectorTasks(connName);
                }
                this.worker.stopConnector(connName);
                if (config == null) {
                    this.connectors.remove(connName);
                }
            } else {
                if (config == null) {
                    callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found", null), null);
                    return;
                }
                created = true;
            }
            if (config != null) {
                this.startConnector(config);
                this.updateConnectorTasks(connName);
            }
            if (config != null) {
                callback.onCompletion(null, new Herder.Created<ConnectorInfo>(created, this.createConnectorInfo(this.connectors.get(connName))));
            } else {
                callback.onCompletion(null, new Herder.Created<Object>(false, null));
            }
        }
        catch (ConnectException e) {
            callback.onCompletion(e, null);
        }
    }

    @Override
    public synchronized void requestTaskReconfiguration(String connName) {
        if (!this.worker.connectorNames().contains(connName)) {
            log.error("Task that requested reconfiguration does not exist: {}", (Object)connName);
            return;
        }
        this.updateConnectorTasks(connName);
    }

    @Override
    public synchronized void taskConfigs(String connName, Callback<List<TaskInfo>> callback) {
        ConnectorState state = this.connectors.get(connName);
        if (state == null) {
            callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found", null), null);
            return;
        }
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
        for (int i = 0; i < state.taskConfigs.size(); ++i) {
            TaskInfo info = new TaskInfo(new ConnectorTaskId(connName, i), state.taskConfigs.get(i));
            result.add(info);
        }
        callback.onCompletion(null, result);
    }

    @Override
    public void putTaskConfigs(String connName, List<Map<String, String>> configs, Callback<Void> callback) {
        throw new UnsupportedOperationException("Kafka Connect in standalone mode does not support externally setting task configurations.");
    }

    private String startConnector(Map<String, String> connectorProps) {
        ConnectorConfig connConfig = new ConnectorConfig(connectorProps);
        String connName = connConfig.getString("name");
        ConnectorState state = this.connectors.get(connName);
        this.worker.addConnector(connConfig, new HerderConnectorContext(this, connName));
        if (state == null) {
            this.connectors.put(connName, new ConnectorState(connectorProps, connConfig));
        } else {
            state.configOriginals = connectorProps;
            state.config = connConfig;
        }
        return connName;
    }

    private List<Map<String, String>> recomputeTaskConfigs(String connName) {
        ConnectorState state = this.connectors.get(connName);
        return this.worker.connectorTaskConfigs(connName, state.config.getInt("tasks.max"), state.config.getList("topics"));
    }

    private void createConnectorTasks(String connName) {
        ConnectorState state = this.connectors.get(connName);
        int index = 0;
        for (Map<String, String> taskConfigMap : state.taskConfigs) {
            ConnectorTaskId taskId = new ConnectorTaskId(connName, index);
            TaskConfig config = new TaskConfig(taskConfigMap);
            try {
                this.worker.addTask(taskId, config);
            }
            catch (Throwable e) {
                log.error("Failed to add task {}: ", (Object)taskId, (Object)e);
            }
            ++index;
        }
    }

    private void removeConnectorTasks(String connName) {
        ConnectorState state = this.connectors.get(connName);
        for (int i = 0; i < state.taskConfigs.size(); ++i) {
            ConnectorTaskId taskId = new ConnectorTaskId(connName, i);
            try {
                this.worker.stopTask(taskId);
                continue;
            }
            catch (ConnectException e) {
                log.error("Failed to stop task {}: ", (Object)taskId, (Object)e);
            }
        }
        state.taskConfigs = new ArrayList<Map<String, String>>();
    }

    private void updateConnectorTasks(String connName) {
        List<Map<String, String>> newTaskConfigs = this.recomputeTaskConfigs(connName);
        ConnectorState state = this.connectors.get(connName);
        if (!newTaskConfigs.equals(state.taskConfigs)) {
            this.removeConnectorTasks(connName);
            state.taskConfigs = newTaskConfigs;
            this.createConnectorTasks(connName);
        }
    }

    private static class ConnectorState {
        public String name;
        public Map<String, String> configOriginals;
        public ConnectorConfig config;
        List<Map<String, String>> taskConfigs;

        public ConnectorState(Map<String, String> configOriginals, ConnectorConfig config) {
            this.name = config.getString("name");
            this.configOriginals = configOriginals;
            this.config = config;
            this.taskConfigs = new ArrayList<Map<String, String>>();
        }
    }
}

