/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigStorage {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfigStorage.class);
    public static final String CONFIG_TOPIC_CONFIG = "config.storage.topic";
    public static final String CONNECTOR_PREFIX = "connector-";
    public static final String TASK_PREFIX = "task-";
    public static final String COMMIT_TASKS_PREFIX = "commit-";
    public static final Schema CONNECTOR_CONFIGURATION_V0;
    public static final Schema TASK_CONFIGURATION_V0;
    public static final Schema CONNECTOR_TASKS_COMMIT_V0;
    private static final long READ_TO_END_TIMEOUT_MS = 30000L;
    private final Object lock;
    private boolean starting = false;
    private final Converter converter;
    private final Callback<String> connectorConfigCallback;
    private final Callback<List<ConnectorTaskId>> tasksConfigCallback;
    private String topic;
    private KafkaBasedLog<String, byte[]> configLog;
    private Map<String, Integer> connectorTaskCounts = new HashMap<String, Integer>();
    private Map<String, Map<String, String>> connectorConfigs = new HashMap<String, Map<String, String>>();
    private Map<ConnectorTaskId, Map<String, String>> taskConfigs = new HashMap<ConnectorTaskId, Map<String, String>>();
    private Set<String> inconsistent = new HashSet<String>();
    private long offset;
    private Map<String, Map<ConnectorTaskId, Map<String, String>>> deferredTaskUpdates = new HashMap<String, Map<ConnectorTaskId, Map<String, String>>>();
    private final Callback<ConsumerRecord<String, byte[]>> consumedCallback = new Callback<ConsumerRecord<String, byte[]>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Throwable error, ConsumerRecord<String, byte[]> record) {
            SchemaAndValue value;
            if (error != null) {
                log.error("Unexpected in consumer callback for KafkaConfigStorage: ", error);
                return;
            }
            try {
                value = KafkaConfigStorage.this.converter.toConnectData(KafkaConfigStorage.this.topic, (byte[])record.value());
            }
            catch (DataException e) {
                log.error("Failed to convert config data to Kafka Connect format: ", (Throwable)e);
                return;
            }
            KafkaConfigStorage.this.offset = record.offset() + 1L;
            if (((String)record.key()).startsWith(KafkaConfigStorage.CONNECTOR_PREFIX)) {
                String connectorName = ((String)record.key()).substring(KafkaConfigStorage.CONNECTOR_PREFIX.length());
                Object object = KafkaConfigStorage.this.lock;
                synchronized (object) {
                    if (value.value() == null) {
                        KafkaConfigStorage.this.connectorConfigs.remove(connectorName);
                    } else {
                        if (!(value.value() instanceof Map)) {
                            log.error("Found connector configuration (" + (String)record.key() + ") in wrong format: " + value.value().getClass());
                            return;
                        }
                        Object newConnectorConfig = ((Map)value.value()).get("properties");
                        if (!(newConnectorConfig instanceof Map)) {
                            log.error("Invalid data for connector config: properties filed should be a Map but is " + newConnectorConfig.getClass());
                            return;
                        }
                        KafkaConfigStorage.this.connectorConfigs.put(connectorName, (Map)newConnectorConfig);
                    }
                }
                if (!KafkaConfigStorage.this.starting) {
                    KafkaConfigStorage.this.connectorConfigCallback.onCompletion(null, connectorName);
                }
            } else {
                if (((String)record.key()).startsWith(KafkaConfigStorage.TASK_PREFIX)) {
                    Object connectorName = KafkaConfigStorage.this.lock;
                    synchronized (connectorName) {
                        ConnectorTaskId taskId = KafkaConfigStorage.this.parseTaskId((String)record.key());
                        if (taskId == null) {
                            log.error("Ignoring task configuration because " + (String)record.key() + " couldn't be parsed as a task config key");
                            return;
                        }
                        if (!(value.value() instanceof Map)) {
                            log.error("Ignoring task configuration because it is in the wrong format: " + value.value());
                            return;
                        }
                        Object newTaskConfig = ((Map)value.value()).get("properties");
                        if (!(newTaskConfig instanceof Map)) {
                            log.error("Invalid data for task config: properties filed should be a Map but is " + newTaskConfig.getClass());
                            return;
                        }
                        HashMap<ConnectorTaskId, Map> deferred = (HashMap<ConnectorTaskId, Map>)KafkaConfigStorage.this.deferredTaskUpdates.get(taskId.connector());
                        if (deferred == null) {
                            deferred = new HashMap<ConnectorTaskId, Map>();
                            KafkaConfigStorage.this.deferredTaskUpdates.put(taskId.connector(), deferred);
                        }
                        deferred.put(taskId, (Map)newTaskConfig);
                    }
                }
                if (((String)record.key()).startsWith(KafkaConfigStorage.COMMIT_TASKS_PREFIX)) {
                    String connectorName = ((String)record.key()).substring(KafkaConfigStorage.COMMIT_TASKS_PREFIX.length());
                    ArrayList updatedTasks = new ArrayList();
                    Object object = KafkaConfigStorage.this.lock;
                    synchronized (object) {
                        if (!(value.value() instanceof Map)) {
                            log.error("Ignoring connector tasks configuration commit because it is in the wrong format: " + value.value());
                            return;
                        }
                        Map deferred = (Map)KafkaConfigStorage.this.deferredTaskUpdates.get(connectorName);
                        int newTaskCount = KafkaConfigStorage.intValue(((Map)value.value()).get("tasks"));
                        Map updatedConfigIdsByConnector = KafkaConfigStorage.this.taskIdsByConnector(deferred);
                        Set taskIdSet = (Set)updatedConfigIdsByConnector.get(connectorName);
                        if (!KafkaConfigStorage.this.completeTaskIdSet(taskIdSet, newTaskCount)) {
                            KafkaConfigStorage.this.inconsistent.add(connectorName);
                        } else {
                            if (deferred != null) {
                                KafkaConfigStorage.this.taskConfigs.putAll(deferred);
                                updatedTasks.addAll(KafkaConfigStorage.this.taskConfigs.keySet());
                            }
                            KafkaConfigStorage.this.inconsistent.remove(connectorName);
                        }
                        if (deferred != null) {
                            deferred.clear();
                        }
                        KafkaConfigStorage.this.connectorTaskCounts.put(connectorName, newTaskCount);
                    }
                    if (!KafkaConfigStorage.this.starting) {
                        KafkaConfigStorage.this.tasksConfigCallback.onCompletion(null, updatedTasks);
                    }
                } else {
                    log.error("Discarding config update record with invalid key: " + (String)record.key());
                }
            }
        }
    };

    public static String CONNECTOR_KEY(String connectorName) {
        return CONNECTOR_PREFIX + connectorName;
    }

    public static String TASK_KEY(ConnectorTaskId taskId) {
        return TASK_PREFIX + taskId.connector() + "-" + taskId.task();
    }

    public static String COMMIT_TASKS_KEY(String connectorName) {
        return COMMIT_TASKS_PREFIX + connectorName;
    }

    public KafkaConfigStorage(Converter converter, Callback<String> connectorConfigCallback, Callback<List<ConnectorTaskId>> tasksConfigCallback) {
        this.lock = new Object();
        this.converter = converter;
        this.connectorConfigCallback = connectorConfigCallback;
        this.tasksConfigCallback = tasksConfigCallback;
        this.offset = -1L;
    }

    public void configure(Map<String, ?> configs) {
        if (configs.get(CONFIG_TOPIC_CONFIG) == null) {
            throw new ConnectException("Must specify topic for connector configuration.");
        }
        this.topic = (String)configs.get(CONFIG_TOPIC_CONFIG);
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        producerProps.putAll(configs);
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("acks", "all");
        HashMap<String, Object> consumerProps = new HashMap<String, Object>();
        consumerProps.putAll(configs);
        consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("enable.auto.commit", false);
        this.configLog = this.createKafkaBasedLog(this.topic, producerProps, consumerProps, this.consumedCallback);
    }

    public void start() {
        log.info("Starting KafkaConfigStorage");
        this.starting = true;
        this.configLog.start();
        this.starting = false;
        log.info("Started KafkaConfigStorage");
    }

    public void stop() {
        log.info("Closing KafkaConfigStorage");
        this.configLog.stop();
        log.info("Closed KafkaConfigStorage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterConfigState snapshot() {
        Object object = this.lock;
        synchronized (object) {
            return new ClusterConfigState(this.offset, new HashMap<String, Integer>(this.connectorTaskCounts), new HashMap<String, Map<String, String>>(this.connectorConfigs), new HashMap<ConnectorTaskId, Map<String, String>>(this.taskConfigs), new HashSet<String>(this.inconsistent));
        }
    }

    public void putConnectorConfig(String connector, Map<String, String> properties) {
        byte[] serializedConfig;
        if (properties == null) {
            serializedConfig = null;
        } else {
            Struct connectConfig = new Struct(CONNECTOR_CONFIGURATION_V0);
            connectConfig.put("properties", properties);
            serializedConfig = this.converter.fromConnectData(this.topic, CONNECTOR_CONFIGURATION_V0, (Object)connectConfig);
        }
        try {
            this.configLog.send(KafkaConfigStorage.CONNECTOR_KEY(connector), serializedConfig);
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write connector configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing connector configuration to Kafka", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTaskConfigs(Map<ConnectorTaskId, Map<String, String>> configs) {
        byte[] serializedConfig;
        Struct connectConfig;
        try {
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write root configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing root configuration to Kafka", (Throwable)e);
        }
        HashMap<String, Integer> newTaskCounts = new HashMap<String, Integer>();
        Object object = this.lock;
        synchronized (object) {
            Map<String, Set<Integer>> map = this.taskIdsByConnector(configs);
            for (Map.Entry<String, Set<Integer>> taskConfigSetEntry : map.entrySet()) {
                if (!this.completeTaskIdSet(taskConfigSetEntry.getValue(), taskConfigSetEntry.getValue().size())) {
                    log.error("Submitted task configuration contain invalid range of task IDs, ignoring this submission");
                    throw new ConnectException("Error writing task configurations: found some connectors with invalid connectors");
                }
                newTaskCounts.put(taskConfigSetEntry.getKey(), taskConfigSetEntry.getValue().size());
            }
        }
        for (Map.Entry<ConnectorTaskId, Map<String, String>> entry : configs.entrySet()) {
            connectConfig = new Struct(TASK_CONFIGURATION_V0);
            connectConfig.put("properties", entry.getValue());
            serializedConfig = this.converter.fromConnectData(this.topic, TASK_CONFIGURATION_V0, (Object)connectConfig);
            this.configLog.send(KafkaConfigStorage.TASK_KEY(entry.getKey()), serializedConfig);
        }
        try {
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
            for (Map.Entry<ConnectorTaskId, Map<String, String>> entry : newTaskCounts.entrySet()) {
                connectConfig = new Struct(CONNECTOR_TASKS_COMMIT_V0);
                connectConfig.put("tasks", entry.getValue());
                serializedConfig = this.converter.fromConnectData(this.topic, CONNECTOR_TASKS_COMMIT_V0, (Object)connectConfig);
                this.configLog.send(KafkaConfigStorage.COMMIT_TASKS_KEY((String)((Object)entry.getKey())), serializedConfig);
            }
            this.configLog.readToEnd().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write root configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing root configuration to Kafka", (Throwable)e);
        }
    }

    public Future<Void> readToEnd() {
        return this.configLog.readToEnd();
    }

    public void readToEnd(Callback<Void> cb) {
        this.configLog.readToEnd(cb);
    }

    private KafkaBasedLog<String, byte[]> createKafkaBasedLog(String topic, Map<String, Object> producerProps, Map<String, Object> consumerProps, Callback<ConsumerRecord<String, byte[]>> consumedCallback) {
        return new KafkaBasedLog<String, byte[]>(topic, producerProps, consumerProps, consumedCallback, (Time)new SystemTime());
    }

    private ConnectorTaskId parseTaskId(String key) {
        String[] parts = key.split("-");
        if (parts.length < 3) {
            return null;
        }
        try {
            int taskNum = Integer.parseInt(parts[parts.length - 1]);
            String connectorName = Utils.join((Object[])Arrays.copyOfRange(parts, 1, parts.length - 1), (String)"-");
            return new ConnectorTaskId(connectorName, taskNum);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Map<String, Set<Integer>> taskIdsByConnector(Map<ConnectorTaskId, Map<String, String>> configs) {
        HashMap<String, Set<Integer>> connectorTaskIds = new HashMap<String, Set<Integer>>();
        if (configs == null) {
            return connectorTaskIds;
        }
        for (Map.Entry<ConnectorTaskId, Map<String, String>> taskConfigEntry : configs.entrySet()) {
            ConnectorTaskId taskId = taskConfigEntry.getKey();
            if (!connectorTaskIds.containsKey(taskId.connector())) {
                connectorTaskIds.put(taskId.connector(), new TreeSet());
            }
            ((Set)connectorTaskIds.get(taskId.connector())).add(taskId.task());
        }
        return connectorTaskIds;
    }

    private boolean completeTaskIdSet(Set<Integer> idSet, int expectedSize) {
        if (idSet.size() < expectedSize) {
            return false;
        }
        for (int i = 0; i < expectedSize; ++i) {
            if (idSet.contains(i)) continue;
            return false;
        }
        return true;
    }

    private static int intValue(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return (int)((Long)value).longValue();
        }
        throw new ConnectException("Expected integer value to be either Integer or Long");
    }

    static {
        TASK_CONFIGURATION_V0 = CONNECTOR_CONFIGURATION_V0 = SchemaBuilder.struct().field("properties", (Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.OPTIONAL_STRING_SCHEMA)).build();
        CONNECTOR_TASKS_COMMIT_V0 = SchemaBuilder.struct().field("tasks", Schema.INT32_SCHEMA).build();
    }
}

