/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum SecurityProtocol {
    PLAINTEXT(0, "PLAINTEXT", false),
    SSL(1, "SSL", false),
    SASL_PLAINTEXT(2, "SASL_PLAINTEXT", false),
    SASL_SSL(3, "SASL_SSL", false),
    TRACE(Short.MAX_VALUE, "TRACE", true);

    private static final Map<Short, SecurityProtocol> CODE_TO_SECURITY_PROTOCOL;
    private static final List<String> NAMES;
    private static final Set<SecurityProtocol> NON_TESTING_VALUES;
    public final short id;
    public final String name;
    private final boolean isTesting;

    private SecurityProtocol(int id, String name, boolean isTesting) {
        this.id = (short)id;
        this.name = name;
        this.isTesting = isTesting;
    }

    public static String getName(int id) {
        return SecurityProtocol.CODE_TO_SECURITY_PROTOCOL.get((Object)Short.valueOf((short)((short)id))).name;
    }

    public static List<String> getNames() {
        return NAMES;
    }

    public static SecurityProtocol forId(Short id) {
        return CODE_TO_SECURITY_PROTOCOL.get(id);
    }

    public static Set<SecurityProtocol> nonTestingValues() {
        return NON_TESTING_VALUES;
    }

    static {
        SecurityProtocol[] protocols = SecurityProtocol.values();
        ArrayList<String> names = new ArrayList<String>(protocols.length);
        HashMap<Short, SecurityProtocol> codeToSecurityProtocol = new HashMap<Short, SecurityProtocol>(protocols.length);
        EnumSet<SecurityProtocol> nonTestingValues = EnumSet.noneOf(SecurityProtocol.class);
        for (SecurityProtocol proto : protocols) {
            codeToSecurityProtocol.put(proto.id, proto);
            names.add(proto.name);
            if (proto.isTesting) continue;
            nonTestingValues.add(proto);
        }
        CODE_TO_SECURITY_PROTOCOL = Collections.unmodifiableMap(codeToSecurityProtocol);
        NAMES = Collections.unmodifiableList(names);
        NON_TESTING_VALUES = Collections.unmodifiableSet(nonTestingValues);
    }
}

