/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.integration.BaseTopicMetadataTest$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Md!B\u0001\u0003\u0003\u00039!!\u0006\"bg\u0016$v\u000e]5d\u001b\u0016$\u0018\rZ1uCR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\t!A_6\n\u0005]!\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001a\u0001\n\u0013y\u0012aB:feZ,'/M\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0015\u0012#aC&bM.\f7+\u001a:wKJDqa\n\u0001A\u0002\u0013%\u0001&A\u0006tKJ4XM]\u0019`I\u0015\fHCA\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0011)f.\u001b;\t\u000fA2\u0013\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\rI\u0002\u0001\u0015)\u0003!\u0003!\u0019XM\u001d<feF\u0002\u0003b\u0002\u001b\u0001\u0001\u0004%\t!N\u0001\u0010EJ|7.\u001a:F]\u0012\u0004v.\u001b8ugV\ta\u0007E\u00028\u007f\ts!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005m2\u0011A\u0002\u001fs_>$h(C\u0001-\u0013\tq4&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%aA*fc*\u0011ah\u000b\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u0012\tqa\u00197vgR,'/\u0003\u0002H\t\nq!I]8lKJ,e\u000e\u001a)pS:$\bbB%\u0001\u0001\u0004%\tAS\u0001\u0014EJ|7.\u001a:F]\u0012\u0004v.\u001b8ug~#S-\u001d\u000b\u0003S-Cq\u0001\r%\u0002\u0002\u0003\u0007a\u0007\u0003\u0004N\u0001\u0001\u0006KAN\u0001\u0011EJ|7.\u001a:F]\u0012\u0004v.\u001b8ug\u0002Bqa\u0014\u0001A\u0002\u0013\u0005\u0001+\u0001\u0007bI\"{7mQ8oM&<7/F\u0001R!\r9tH\u0015\t\u0003CMK!\u0001\u0016\u0012\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0003A\tG\rS8d\u0007>tg-[4t?\u0012*\u0017\u000f\u0006\u0002*1\"9\u0001'VA\u0001\u0002\u0004\t\u0006B\u0002.\u0001A\u0003&\u0011+A\u0007bI\"{7mQ8oM&<7\u000f\t\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0003)qW/\\\"p]\u001aLwm]\u000b\u0002=B\u0011!fX\u0005\u0003A.\u00121!\u00138u\u0011\u0019\u0011\u0007\u0001)A\u0005=\u0006Ya.^7D_:4\u0017nZ:!\u0011\u0015!\u0007A\"\u0005f\u00039!(/^:u'R|'/\u001a$jY\u0016,\u0012A\u001a\t\u0004U\u001dL\u0017B\u00015,\u0005\u0019y\u0005\u000f^5p]B\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0003S>T\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qW\n!a)\u001b7f\u0011\u0015\u0011\bA\"\u0005t\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001u!\t)X0D\u0001w\u0015\t9\b0\u0001\u0005qe>$xnY8m\u0015\tI(0\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bmT!\u0001 \b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tqhO\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0011!B:fiV\u0003H#A\u0015)\u0007}\f9\u0001\u0005\u0003\u0002\n\u00055QBAA\u0006\u0015\tYa\"\u0003\u0003\u0002\u0010\u0005-!A\u0002\"fM>\u0014X\rC\u0004\u0002\u0014\u0001!\t%a\u0001\u0002\u0011Q,\u0017M\u001d#po:DC!!\u0005\u0002\u0018A!\u0011\u0011BA\r\u0013\u0011\tY\"a\u0003\u0003\u000b\u00053G/\u001a:\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005AB/Z:u)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0016\u0003%BC!!\b\u0002&A!\u0011\u0011BA\u0014\u0013\u0011\tI#a\u0003\u0003\tQ+7\u000f\u001e\u0005\b\u0003[\u0001A\u0011AA\u0011\u0003Y!Xm\u001d;CCNL7\rV8qS\u000elU\r^1eCR\f\u0007\u0006BA\u0016\u0003KAq!a\r\u0001\t\u0003\t\t#A\fuKN$x)\u001a;BY2$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\"\"\u0011\u0011GA\u0013\u0011\u001d\tI\u0004\u0001C\u0001\u0003C\t1\u0003^3ti\u0006+Ho\\\"sK\u0006$X\rV8qS\u000eDC!a\u000e\u0002&!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0012\u0001\t;fgR\fU\u000f^8De\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u0007>dG.[:j_:DC!!\u0010\u0002&!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0013\u0001C2iK\u000e\\\u0017j\u001d:\u0015\u0007%\nI\u0005\u0003\u0005\u0002L\u0005\r\u0003\u0019AA'\u0003\u001d\u0019XM\u001d<feN\u00042aN !\u0011\u001d\t\t\u0006\u0001C\u0001\u0003C\ta\u0005^3ti&\u001b(/\u00114uKJ\u0014%o\\6feNCW\u000f\u001e#po:\fe\u000e\u001a&pS:\u001c()Y2lQ\u0011\ty%!\n\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005i1\r[3dW6+G/\u00193bi\u0006$R!KA.\u0003;B\u0001\"a\u0013\u0002V\u0001\u0007\u0011Q\n\u0005\b\u0003?\n)\u00061\u0001_\u0003Q)\u0007\u0010]3di\u0016$'I]8lKJ\u001c8i\\;oi\"9\u00111\r\u0001\u0005\u0002\u0005\u0005\u0012a\b;fgR\fE.\u001b<f\u0005J|7.\u001a:MSN$x+\u001b;i\u001d>$v\u000e]5dg\"\"\u0011\u0011MA\u0013\u0011\u001d\tI\u0007\u0001C\u0001\u0003C\tQ\u0007^3ti\u0006c\u0017N^3Ce>\\WM]:MSN$x+\u001b;i\u001d>$v\u000e]5dg\u00063G/\u001a:OK^\u0014%o\\6feN#\u0018M\u001d;va\"\"\u0011qMA\u0013\u0011\u001d\ty\u0007\u0001C\u0001\u0003C\tA\u0007^3ti\u0006c\u0017N^3Ce>\\WM]:MSN$x+\u001b;i\u001d>$v\u000e]5dg\u00063G/\u001a:B\u0005J|7.\u001a:TQV$Hm\\<oQ\u0011\ti'!\n")
public abstract class BaseTopicMetadataTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private KafkaServer server1;
    private Seq<BrokerEndPoint> brokerEndPoints;
    private Seq<KafkaConfig> adHocConfigs;
    private final int numConfigs;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseTopicMetadataTest baseTopicMetadataTest = this;
        synchronized (baseTopicMetadataTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    private KafkaServer server1() {
        return this.server1;
    }

    private void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public Seq<BrokerEndPoint> brokerEndPoints() {
        return this.brokerEndPoints;
    }

    public void brokerEndPoints_$eq(Seq<BrokerEndPoint> x$1) {
        this.brokerEndPoints = x$1;
    }

    public Seq<KafkaConfig> adHocConfigs() {
        return this.adHocConfigs;
    }

    public void adHocConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.adHocConfigs = x$1;
    }

    public int numConfigs() {
        return this.numConfigs;
    }

    public abstract Option<File> trustStoreFile();

    public abstract SecurityProtocol securityProtocol();

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        int x$3 = this.numConfigs();
        String x$4 = this.zkConnect();
        Some x$5 = new Some((Object)this.securityProtocol());
        Option<File> x$6 = this.trustStoreFile();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        Seq<Properties> props = TestUtils$.MODULE$.createBrokerConfigs(x$3, x$4, x$7, x$8, (Option<SecurityProtocol>)x$5, x$6, x$9, x$10, x$11, x$12);
        Seq configs = (Seq)props.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.adHocConfigs_$eq((Seq<KafkaConfig>)((Seq)configs.takeRight(configs.size() - 1)));
        this.server1_$eq(TestUtils$.MODULE$.createServer((KafkaConfig)configs.head(), TestUtils$.MODULE$.createServer$default$2()));
        this.brokerEndPoints_$eq((Seq<BrokerEndPoint>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{new BrokerEndPoint(this.server1().config().brokerId(), this.server1().config().hostName(), this.server1().boundPort(SecurityProtocol.PLAINTEXT))}))));
    }

    @Override
    @After
    public void tearDown() {
        this.server1().shutdown();
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testTopicMetadataRequest() {
        String topic = "test";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), 0);
        ByteBuffer serializedMetadataRequest = ByteBuffer.allocate(topicMetadataRequest.sizeInBytes() + 2);
        topicMetadataRequest.writeTo(serializedMetadataRequest);
        serializedMetadataRequest.rewind();
        TopicMetadataRequest deserializedMetadataRequest = TopicMetadataRequest$.MODULE$.readFrom(serializedMetadataRequest);
        Assert.assertEquals((Object)topicMetadataRequest, (Object)deserializedMetadataRequest);
    }

    @Test
    public void testBasicTopicMetadata() {
        String topic = "test";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).errorCode());
        Assert.assertEquals((String)"Expecting metadata only for 1 topic", (long)1L, (long)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for the test topic", (Object)"test", (Object)((TopicMetadata)topicsMetadata.head()).topic());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadata.head()).replicas().size());
    }

    @Test
    public void testGetAllTopicMetadata() {
        String topic1 = "testGetAllTopicMetadata1";
        String topic2 = "testGetAllTopicMetadata2";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), this.brokerEndPoints(), "TopicMetadataTest-testGetAllTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((long)2L, (long)topicsMetadata.size());
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).errorCode());
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((PartitionMetadata)((TopicMetadata)topicsMetadata.last()).partitionsMetadata().head()).errorCode());
        Seq partitionMetadataTopic1 = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Seq partitionMetadataTopic2 = ((TopicMetadata)topicsMetadata.last()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadataTopic1.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadataTopic1.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadataTopic1.head()).replicas().size());
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadataTopic2.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadataTopic2.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadataTopic2.head()).replicas().size());
    }

    @Test
    public void testAutoCreateTopic() {
        String topic = "testAutoCreateTopic";
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokerEndPoints(), "TopicMetadataTest-testAutoCreateTopic", 2000, 0).topicsMetadata();
        Assert.assertEquals((long)ErrorMapping$.MODULE$.LeaderNotAvailableCode(), (long)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((String)"Expecting metadata only for 1 topic", (long)1L, (long)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for the test topic", (Object)topic, (Object)((TopicMetadata)topicsMetadata.head()).topic());
        Assert.assertEquals((long)0L, (long)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().size());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).errorCode());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadata.head()).replicas().size());
        Assert.assertTrue((boolean)((PartitionMetadata)partitionMetadata.head()).leader().isDefined());
    }

    @Test
    public void testAutoCreateTopicWithCollision() {
        String topic1 = "testAutoCreate_Topic";
        String topic2 = "testAutoCreate.Topic";
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.brokerEndPoints(), "TopicMetadataTest-testAutoCreateTopic", 2000, 0).topicsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 2 topics", (long)2L, (long)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for topic1", (Object)topic1, (Object)((TopicMetadata)topicsMetadata.head()).topic());
        Assert.assertEquals((long)ErrorMapping$.MODULE$.LeaderNotAvailableCode(), (long)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((String)"Expecting metadata for topic2", (Object)topic2, (Object)((TopicMetadata)topicsMetadata.apply(1)).topic());
        Assert.assertEquals((String)"Expecting InvalidTopicCode for topic2 metadata", (long)ErrorMapping$.MODULE$.InvalidTopicCode(), (long)((TopicMetadata)topicsMetadata.apply(1)).errorCode());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic1, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), topic1, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1})), this.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((long)ErrorMapping$.MODULE$.NoError(), (long)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).errorCode());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (long)1L, (long)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (long)0L, (long)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((long)1L, (long)((PartitionMetadata)partitionMetadata.head()).replicas().size());
        Assert.assertTrue((boolean)((PartitionMetadata)partitionMetadata.head()).leader().isDefined());
    }

    private void checkIsr(Seq<KafkaServer> servers) {
        Seq activeBrokers = (Seq)servers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x) {
                return x.brokerState().currentState() != NotRunning$.MODULE$.state();
            }
        });
        Seq expectedIsr = (Seq)activeBrokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(KafkaServer x) {
                return new BrokerEndPoint(x.config().brokerId(), new StringOps(Predef$.MODULE$.augmentString(x.config().hostName())).nonEmpty() ? x.config().hostName() : "localhost", x.boundPort(x.boundPort$default$1()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        activeBrokers.foreach((Function1)new Serializable(this, expectedIsr){
            public static final long serialVersionUID = 0L;
            public final Seq expectedIsr$1;

            public final boolean apply(KafkaServer x) {
                ObjectRef metadata = ObjectRef.create((Object)new TopicMetadataResponse((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), -1));
                return TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, metadata, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkIsr$1 $outer;
                    private final ObjectRef metadata$1;
                    private final KafkaServer x$13;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.metadata$1.elem = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{new BrokerEndPoint(this.x$13.config().brokerId(), new StringOps(Predef$.MODULE$.augmentString(this.x$13.config().hostName())).nonEmpty() ? this.x$13.config().hostName() : "localhost", this.x$13.boundPort(this.x$13.boundPort$default$1()))})), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0);
                        return ((TopicMetadataResponse)this.metadata$1.elem).topicsMetadata().nonEmpty() && ((TopicMetadata)((TopicMetadataResponse)this.metadata$1.elem).topicsMetadata().head()).partitionsMetadata().nonEmpty() && BoxesRunTime.equals((Object)this.$outer.expectedIsr$1.sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(BrokerEndPoint x$1) {
                                return x$1.id();
                            }
                        }, (Ordering)Ordering.Int$.MODULE$), (Object)((PartitionMetadata)((TopicMetadata)((TopicMetadataResponse)this.metadata$1.elem).topicsMetadata().head()).partitionsMetadata().head()).isr().sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(BrokerEndPoint x$2) {
                                return x$2.id();
                            }
                        }, (Ordering)Ordering.Int$.MODULE$));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metadata$1 = metadata$1;
                        this.x$13 = x$13;
                    }
                }, new StringBuilder().append((Object)"Topic metadata is not correctly updated for broker ").append((Object)x).append((Object)".\n").append((Object)"Expected ISR: ").append((Object)this.expectedIsr$1).append((Object)"\n").append((Object)"Actual ISR  : ").append(((TopicMetadataResponse)metadata.elem).topicsMetadata().nonEmpty() && ((TopicMetadata)((TopicMetadataResponse)metadata.elem).topicsMetadata().head()).partitionsMetadata().nonEmpty() ? ((PartitionMetadata)((TopicMetadata)((TopicMetadataResponse)metadata.elem).topicsMetadata().head()).partitionsMetadata().head()).isr() : "").toString(), 8000L);
            }
            {
                this.expectedIsr$1 = expectedIsr$1;
            }
        });
    }

    @Test
    public void testIsrAfterBrokerShutDownAndJoinsBack() {
        int numBrokers = 2;
        Seq adHocServers = (Seq)((TraversableLike)this.adHocConfigs().take(numBrokers - 1)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig p) {
                return TestUtils$.MODULE$.createServer(p, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq allServers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))).$plus$plus((GenTraversableOnce)adHocServers, Seq$.MODULE$.canBuildFrom());
        String topic = "test";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, numBrokers, AdminUtils$.MODULE$.createTopic$default$5());
        ((KafkaServer)adHocServers.last()).shutdown();
        ((KafkaServer)adHocServers.last()).awaitShutdown();
        ((KafkaServer)adHocServers.last()).startup();
        this.checkIsr((Seq<KafkaServer>)allServers);
        adHocServers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer p) {
                p.shutdown();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void checkMetadata(Seq<KafkaServer> servers, int expectedBrokersCount) {
        ObjectRef topicMetadata = ObjectRef.create((Object)new TopicMetadataResponse((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), -1));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expectedBrokersCount, topicMetadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseTopicMetadataTest $outer;
            private final int expectedBrokersCount$1;
            private final ObjectRef topicMetadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.topicMetadata$1.elem = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), this.$outer.brokerEndPoints(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0);
                return ((TopicMetadataResponse)this.topicMetadata$1.elem).brokers().size() == this.expectedBrokersCount$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedBrokersCount$1 = expectedBrokersCount$1;
                this.topicMetadata$1 = topicMetadata$1;
            }
        }, "Alive brokers list is not correctly propagated by coordinator to brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((IterableLike)servers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x) {
                return x.brokerState().currentState() != NotRunning$.MODULE$.state();
            }
        })).foreach((Function1)new Serializable(this, topicMetadata){
            public static final long serialVersionUID = 0L;
            public final ObjectRef topicMetadata$1;

            public final boolean apply(KafkaServer x) {
                return TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkMetadata$3 $outer;
                    private final KafkaServer x$14;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        TopicMetadataResponse topicMetadataResponse = (TopicMetadataResponse)this.$outer.topicMetadata$1.elem;
                        TopicMetadataResponse topicMetadataResponse2 = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{new Broker(this.x$14.config().brokerId(), this.x$14.config().hostName(), this.x$14.boundPort(this.x$14.boundPort$default$1()), Broker$.MODULE$.$lessinit$greater$default$4()).getBrokerEndPoint(SecurityProtocol.PLAINTEXT)})), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0);
                        return !(topicMetadataResponse != null ? !topicMetadataResponse.equals(topicMetadataResponse2) : topicMetadataResponse2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$14 = x$14;
                    }
                }, "Topic metadata is not correctly updated", TestUtils$.MODULE$.waitUntilTrue$default$3());
            }
            {
                this.topicMetadata$1 = topicMetadata$1;
            }
        });
    }

    @Test
    public void testAliveBrokerListWithNoTopics() {
        this.checkMetadata((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), 1);
    }

    @Test
    public void testAliveBrokersListWithNoTopicsAfterNewBrokerStartup() {
        Seq adHocServers = (Seq)((TraversableLike)this.adHocConfigs().takeRight(this.adHocConfigs().size() - 1)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig p) {
                return TestUtils$.MODULE$.createServer(p, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.checkMetadata((Seq<KafkaServer>)adHocServers, this.numConfigs() - 1);
        adHocServers = (Seq)adHocServers.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{TestUtils$.MODULE$.createServer((KafkaConfig)this.adHocConfigs().head(), TestUtils$.MODULE$.createServer$default$2())})), Seq$.MODULE$.canBuildFrom());
        this.checkMetadata((Seq<KafkaServer>)adHocServers, this.numConfigs());
        adHocServers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer p) {
                p.shutdown();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testAliveBrokersListWithNoTopicsAfterABrokerShutdown() {
        Seq adHocServers = (Seq)this.adHocConfigs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig p) {
                return TestUtils$.MODULE$.createServer(p, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.checkMetadata((Seq<KafkaServer>)adHocServers, this.numConfigs());
        ((KafkaServer)adHocServers.last()).shutdown();
        ((KafkaServer)adHocServers.last()).awaitShutdown();
        this.checkMetadata((Seq<KafkaServer>)adHocServers, this.numConfigs() - 1);
        adHocServers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer p) {
                p.shutdown();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BaseTopicMetadataTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.server1 = null;
        this.brokerEndPoints = null;
        this.adHocConfigs = null;
        this.numConfigs = 4;
    }
}

