/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.integration.ProducerConsumerTestHarness;
import kafka.integration.ProducerConsumerTestHarness$class;
import kafka.log.Log;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.StaticPartitioner;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\t\u0001\u0002K]5nSRLg/Z!qSR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A!C\u0006\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!a\u0007)s_\u0012,8-\u001a:D_:\u001cX/\\3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\t\u0005\u0011!p[\u0005\u00037a\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0019\u0002\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002)I,\u0017/^3ti\"\u000bg\u000e\u001a7fe2{wmZ3s+\u0005\u0019\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0015awn\u001a\u001bk\u0015\tAc\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003U\u0015\u0012a\u0001T8hO\u0016\u0014\bB\u0002\u0017\u0001A\u0003%1%A\u000bsKF,Xm\u001d;IC:$G.\u001a:M_\u001e<WM\u001d\u0011\t\u000b9\u0002A\u0011A\u0018\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON$\u0012\u0001\r\t\u0004caRT\"\u0001\u001a\u000b\u0005M\"\u0014!C5n[V$\u0018M\u00197f\u0015\t)d'\u0001\u0006d_2dWm\u0019;j_:T\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sI\u0012A\u0001T5tiB\u00111HP\u0007\u0002y)\u0011Q\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005}b$aC&bM.\f7i\u001c8gS\u001eDQ!\u0011\u0001\u0005\u0002\t\u000bA\u0005^3ti\u001a+Go\u00195SKF,Xm\u001d;DC:\u0004&o\u001c9fe2L8+\u001a:jC2L'0\u001a\u000b\u0002\u0007B\u0011A)R\u0007\u0002m%\u0011aI\u000e\u0002\u0005+:LG\u000f\u000b\u0002A\u0011B\u0011\u0011jS\u0007\u0002\u0015*\u00111BD\u0005\u0003\u0019*\u0013A\u0001V3ti\")a\n\u0001C\u0001\u0005\u0006)B/Z:u\u000b6\u0004H/\u001f$fi\u000eD'+Z9vKN$\bFA'I\u0011\u0015\t\u0006\u0001\"\u0001C\u0003\t\"Xm\u001d;EK\u001a\fW\u000f\u001c;F]\u000e|G-\u001a:Qe>$WoY3s\u0003:$g)\u001a;dQ\"\u0012\u0001\u000b\u0013\u0005\u0006)\u0002!\tAQ\u00012i\u0016\u001cH\u000fR3gCVdG/\u00128d_\u0012,'\u000f\u0015:pIV\u001cWM]!oI\u001a+Go\u00195XSRD7i\\7qe\u0016\u001c8/[8oQ\t\u0019\u0006\nC\u0003X\u0001\u0011%\u0001,\u0001\u000bqe>$WoY3B]\u0012lU\u000f\u001c;j\r\u0016$8\r\u001b\u000b\u0003\u0007fCQA\u0017,A\u0002m\u000b\u0001\u0002\u001d:pIV\u001cWM\u001d\t\u00059z\u0003\u0007-D\u0001^\u0015\tQF!\u0003\u0002`;\nA\u0001K]8ek\u000e,'\u000f\u0005\u0002bI:\u0011AIY\u0005\u0003GZ\na\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111M\u000e\u0005\u0006Q\u0002!\tAQ\u0001\u0019i\u0016\u001cH\u000f\u0015:pIV\u001cW-\u00118e\u001bVdG/\u001b$fi\u000eD\u0007FA4I\u0011\u0015Y\u0007\u0001\"\u0003m\u00031iW\u000f\u001c;j!J|G-^2f)\t\u0019U\u000eC\u0003[U\u0002\u00071\fC\u0003p\u0001\u0011\u0005!)\u0001\tuKN$X*\u001e7uSB\u0013x\u000eZ;dK\"\u0012a\u000e\u0013\u0005\u0006e\u0002!\tAQ\u0001\u0017i\u0016\u001cHoQ8ogVlWM]#naRLHk\u001c9jG\"\u0012\u0011\u000f\u0013\u0005\u0006k\u0002!\tAQ\u0001\u001di\u0016\u001cH\u000fU5qK2Lg.\u001a3Qe>$WoY3SKF,Xm\u001d;tQ\t!\b\n")
public class PrimitiveApiTest
extends JUnitSuite
implements ProducerConsumerTestHarness {
    private final Logger requestHandlerLogger;
    private final String host;
    private Producer<String, String> producer;
    private SimpleConsumer consumer;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public Producer<String, String> producer() {
        return this.producer;
    }

    @Override
    public void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public SimpleConsumer consumer() {
        return this.consumer;
    }

    @Override
    public void consumer_$eq(SimpleConsumer x$1) {
        this.consumer = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$_setter_$host_$eq(String x$1) {
        this.host = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ProducerConsumerTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ProducerConsumerTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    @TraitSetter
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    @TraitSetter
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PrimitiveApiTest primitiveApiTest = this;
        synchronized (primitiveApiTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14()))}));
    }

    @Test
    public void testFetchRequestCanProperlySerialize() {
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").maxWait(10001).minBytes(4444).addFetch("topic1", 0, 0L, 10000).addFetch("topic2", 1, 1024L, 9999).addFetch("topic1", 1, 256L, 444).build();
        ByteBuffer serializedBuffer = ByteBuffer.allocate(request.sizeInBytes());
        request.writeTo(serializedBuffer);
        serializedBuffer.rewind();
        FetchRequest deserializedRequest = FetchRequest$.MODULE$.readFrom(serializedBuffer);
        Assert.assertEquals((Object)request, (Object)deserializedRequest);
    }

    @Test
    public void testEmptyFetchRequest() {
        scala.collection.immutable.Map partitionRequests;
        scala.collection.immutable.Map x$12 = partitionRequests = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        short x$13 = FetchRequest$.MODULE$.$lessinit$greater$default$1();
        int x$14 = FetchRequest$.MODULE$.$lessinit$greater$default$2();
        String x$15 = FetchRequest$.MODULE$.$lessinit$greater$default$3();
        int x$16 = FetchRequest$.MODULE$.$lessinit$greater$default$4();
        int x$17 = FetchRequest$.MODULE$.$lessinit$greater$default$5();
        int x$18 = FetchRequest$.MODULE$.$lessinit$greater$default$6();
        FetchRequest request = new FetchRequest(x$13, x$14, x$15, x$16, x$17, x$18, x$12);
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertTrue((!fetched.hasError() && fetched.data().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultEncoderProducerAndFetch() {
        String topic = "test-topic";
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        ReplicaManager qual$1 = ((KafkaServer)this.servers().head()).replicaManager();
        String x$19 = topic;
        int x$20 = 0;
        int x$21 = qual$1.getReplica$default$3();
        Replica replica = (Replica)qual$1.getReplica(x$19, x$20, x$21).get();
        Assert.assertTrue((String)"HighWatermark should equal logEndOffset with just 1 replica", (replica.logEndOffset().messageOffset() > 0L && replica.logEndOffset().equals((Object)replica.highWatermark()) ? 1 : 0) != 0);
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").addFetch(topic, 0, 0L, 10000).build();
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertEquals((String)"Returned correlationId doesn't match that in request.", (long)0L, (long)fetched.correlationId());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((Object)"test-message", (Object)TestUtils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    @Test
    public void testDefaultEncoderProducerAndFetchWithCompression() {
        String topic = "test-topic";
        Properties props = new Properties();
        props.put("compression.codec", "gzip");
        Producer stringProducer1 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        stringProducer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        FetchResponse fetched = this.consumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((Object)"test-message", (Object)TestUtils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    private void produceAndMultiFetch(Producer<String, String> producer) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final scala.collection.immutable.Map<Object, Option<Object>> apply(String topic) {
                ZkUtils x$22 = this.$outer.zkUtils();
                String x$23 = topic;
                Buffer<KafkaServer> x$24 = this.$outer.servers();
                int x$25 = TestUtils$.MODULE$.createTopic$default$3();
                int x$26 = TestUtils$.MODULE$.createTopic$default$4();
                Properties x$27 = TestUtils$.MODULE$.createTopic$default$6();
                return TestUtils$.MODULE$.createTopic(x$22, x$23, x$25, x$26, (Seq<KafkaServer>)x$24, x$27);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, producer, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final Producer producer$1;
            private final HashMap messages$1;
            private final FetchRequestBuilder builder$1;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;

                        public final KeyedMessage<String, String> apply(String x$1) {
                            return new KeyedMessage(this.topic$1, (Object)this.topic$1, (Object)x$1);
                        }
                        {
                            this.topic$1 = topic$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.producer$1.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$1.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producer$1 = producer$1;
                this.messages$1 = messages$1;
                this.builder$1 = builder$1;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$1;
            private final FetchResponse response$1;

            public final void apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$1.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$1.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$1 = messages$1;
                this.response$1 = response$1;
            }
        });
        this.requestHandlerLogger().setLevel(Level.FATAL);
        FetchRequestBuilder builder2 = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$3) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, builder2){
            public static final long serialVersionUID = 0L;
            private final FetchRequestBuilder builder$2;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$4) {
                Tuple2<String, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    FetchRequestBuilder fetchRequestBuilder = this.builder$2.addFetch(topic, partition, -1L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        try {
            FetchRequest request2 = builder2.build();
            FetchResponse response2 = this.consumer().fetch(request2);
            response2.data().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FetchResponsePartitionData pdata) {
                    ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                }
            });
            throw this.fail("Expected exception when fetching message with invalid offset");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            FetchRequestBuilder builder3 = new FetchRequestBuilder();
            topics.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$4) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$4;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, builder3){
                public static final long serialVersionUID = 0L;
                private final FetchRequestBuilder builder$3;

                public final FetchRequestBuilder apply(Tuple2<String, Object> x$5) {
                    Tuple2<String, Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        String topic = (String)tuple2._1();
                        FetchRequestBuilder fetchRequestBuilder = this.builder$3.addFetch(topic, -1, 0L, 10000);
                        return fetchRequestBuilder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.builder$3 = builder$3;
                }
            });
            try {
                FetchRequest request3 = builder3.build();
                FetchResponse response3 = this.consumer().fetch(request3);
                response3.data().values().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FetchResponsePartitionData pdata) {
                        ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                    }
                });
                throw this.fail("Expected exception when fetching message with invalid partition");
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                this.requestHandlerLogger().setLevel(Level.ERROR);
                return;
            }
        }
    }

    @Test
    public void testProduceAndMultiFetch() {
        this.produceAndMultiFetch(this.producer());
    }

    private void multiProduce(Producer<String, String> producer) {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        topics.keys().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final scala.collection.immutable.Map<Object, Option<Object>> apply(String topic) {
                ZkUtils x$28 = this.$outer.zkUtils();
                String x$29 = topic;
                Buffer<KafkaServer> x$30 = this.$outer.servers();
                int x$31 = TestUtils$.MODULE$.createTopic$default$3();
                int x$32 = TestUtils$.MODULE$.createTopic$default$4();
                Properties x$33 = TestUtils$.MODULE$.createTopic$default$6();
                return TestUtils$.MODULE$.createTopic(x$28, x$29, x$31, x$32, (Seq<KafkaServer>)x$30, x$33);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$5) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$5;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, producer, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final Producer producer$2;
            private final HashMap messages$2;
            private final FetchRequestBuilder builder$4;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$7) {
                Tuple2<String, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final KeyedMessage<String, String> apply(String x$6) {
                            return new KeyedMessage(this.topic$2, (Object)this.topic$2, (Object)x$6);
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.producer$2.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$4.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producer$2 = producer$2;
                this.messages$2 = messages$2;
                this.builder$4 = builder$4;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$6) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$6;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$2;
            private final FetchResponse response$2;

            public final void apply(Tuple2<String, Object> x$8) {
                Tuple2<String, Object> tuple2 = x$8;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$2.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$2.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$2 = messages$2;
                this.response$2 = response$2;
            }
        });
    }

    @Test
    public void testMultiProduce() {
        this.multiProduce(this.producer());
    }

    @Test
    public void testConsumerEmptyTopic() {
        String newTopic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), newTopic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        FetchResponse fetchResponse = this.consumer().fetch(new FetchRequestBuilder().addFetch(newTopic, 0, 0L, 10000).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(newTopic, 0).iterator().hasNext());
    }

    @Test
    public void testPipelinedProduceRequests() {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        topics.keys().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final scala.collection.immutable.Map<Object, Option<Object>> apply(String topic) {
                ZkUtils x$34 = this.$outer.zkUtils();
                String x$35 = topic;
                Buffer<KafkaServer> x$36 = this.$outer.servers();
                int x$37 = TestUtils$.MODULE$.createTopic$default$3();
                int x$38 = TestUtils$.MODULE$.createTopic$default$4();
                Properties x$39 = TestUtils$.MODULE$.createTopic$default$6();
                return TestUtils$.MODULE$.createTopic(x$34, x$35, x$37, x$38, (Seq<KafkaServer>)x$36, x$39);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Properties props = new Properties();
        props.put("request.required.acks", "0");
        Producer pipelinedProducer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$7) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$7;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, pipelinedProducer, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final Producer pipelinedProducer$1;
            private final HashMap messages$3;
            private final FetchRequestBuilder builder$5;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$10) {
                Tuple2<String, Object> tuple2 = x$10;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final KeyedMessage<String, String> apply(String x$9) {
                            return new KeyedMessage(this.topic$3, (Object)this.topic$3, (Object)x$9);
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.pipelinedProducer$1.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$5.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pipelinedProducer$1 = pipelinedProducer$1;
                this.messages$3 = messages$3;
                this.builder$5 = builder$5;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test1", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test2", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test3", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test4", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        int replicaId = ((KafkaServer)this.servers().head()).config().brokerId();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test1", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test2", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test3", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test4", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$8) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$8;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$3;
            private final FetchResponse response$3;

            public final void apply(Tuple2<String, Object> x$11) {
                Tuple2<String, Object> tuple2 = x$11;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$3.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$3.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$3 = messages$3;
                this.response$3 = response$3;
            }
        });
    }

    public PrimitiveApiTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        ProducerConsumerTestHarness$class.$init$(this);
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

