/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import kafka.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001\u001d\u00111b\u00117fC:,'\u000fV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\u0007i6\u0004H-\u001b:\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0005%|'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011AAR5mK\"11\u0005\u0001Q\u0001\ni\tq\u0001^7qI&\u0014\b\u0005C\u0004&\u0001\t\u0007I\u0011A\r\u0002\u0007\u0011L'\u000f\u0003\u0004(\u0001\u0001\u0006IAG\u0001\u0005I&\u0014\b\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\u0002\u00111|w\r\u0015:paN,\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]y\tA!\u001e;jY&\u0011\u0001'\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002\u001a\u0001A\u0003%1&A\u0005m_\u001e\u0004&o\u001c9tA!9A\u0007\u0001b\u0001\n\u0003)\u0014!\u00037pO\u000e{gNZ5h+\u00051\u0004C\u0001\f8\u0013\tA$AA\u0005M_\u001e\u001cuN\u001c4jO\"1!\b\u0001Q\u0001\nY\n!\u0002\\8h\u0007>tg-[4!\u0011\u001da\u0004A1A\u0005\u0002u\nA\u0001^5nKV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\t\u0005)Q\u000f^5mg&\u00111\t\u0011\u0002\t\u001b>\u001c7\u000eV5nK\"1Q\t\u0001Q\u0001\ny\nQ\u0001^5nK\u0002Bqa\u0012\u0001C\u0002\u0013\u0005\u0001*A\u0005uQJ|G\u000f\u001e7feV\t\u0011\n\u0005\u0002@\u0015&\u00111\n\u0011\u0002\n)\"\u0014x\u000e\u001e;mKJDa!\u0014\u0001!\u0002\u0013I\u0015A\u0003;ie>$H\u000f\\3sA!)q\n\u0001C\u0001!\u0006AA/Z1sI><h\u000eF\u0001R!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u0011)f.\u001b;)\u00059C\u0006CA-\\\u001b\u0005Q&BA\u0006\u000f\u0013\ta&LA\u0003BMR,'\u000fC\u0003_\u0001\u0011\u0005\u0001+A\tuKN$8\t\\3b]N+w-\\3oiND#!\u00181\u0011\u0005e\u000b\u0017B\u00012[\u0005\u0011!Vm\u001d;\t\u000b\u0011\u0004A\u0011\u0001)\u0002/Q,7\u000f^\"mK\u0006t\u0017N\\4XSRDG)\u001a7fi\u0016\u001c\bFA2a\u0011\u00159\u0007\u0001\"\u0001i\u00039!Xm\u001d;M_\u001e$vn\u00117fC:,\u0012!\u0015\u0015\u0003M\u0002DQa\u001b\u0001\u0005\u0002!\fq\u0004^3ti\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5V].,\u00170\u001a3NKN\u001c\u0018mZ3tQ\tQ\u0007\rC\u0003o\u0001\u0011\u0005q.A\u0005lKf\u001c\u0018J\u001c'pOR\u0011\u0001/\u001f\t\u0004cR4X\"\u0001:\u000b\u0005M\u001c\u0016AC2pY2,7\r^5p]&\u0011QO\u001d\u0002\t\u0013R,'/\u00192mKB\u0011!k^\u0005\u0003qN\u00131!\u00138u\u0011\u0015\u0019Q\u000e1\u0001{!\t120\u0003\u0002}\u0005\t\u0019Aj\\4\t\u000by\u0004A\u0011A@\u00021Ut7.Z=fI6+7o]1hK\u000e{WO\u001c;J]2{w\rF\u0002w\u0003\u0003AQaA?A\u0002iDq!!\u0002\u0001\t\u0003\t9!\u0001\bbE>\u0014Ho\u00115fG.$uN\\3\u0015\u0007E\u000bI\u0001\u0003\u0005\u0002\f\u0005\r\u0001\u0019AA\u0007\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0003\u0002\r\r|W.\\8o\u0013\u0011\t9\"!\u0005\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\u001c\u0001!\t\u0001U\u0001\u001bi\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001cx+\u001b;i\u0003\n|'\u000f\u001e\u0015\u0004\u00033\u0001\u0007BBA\u0011\u0001\u0011\u0005\u0001+A\nuKN$8+Z4nK:$xI]8va&tw\rK\u0002\u0002 \u0001Da!a\n\u0001\t\u0003\u0001\u0016\u0001\n;fgR\u001cVmZ7f]R<%o\\;qS:<w+\u001b;i'B\f'o]3PM\u001a\u001cX\r^:)\u0007\u0005\u0015\u0002\rC\u0004\u0002.\u0001!I!a\f\u0002#\rDWmY6TK\u001elWM\u001c;Pe\u0012,'\u000fF\u0002R\u0003cA\u0001\"a\r\u0002,\u0001\u0007\u0011QG\u0001\u0007OJ|W\u000f]:\u0011\u000bE\f9$a\u000f\n\u0007\u0005e\"OA\u0002TKF\u0004R!]A\u001c\u0003{\u00012AFA \u0013\r\t\tE\u0001\u0002\u000b\u0019><7+Z4nK:$\bBBA#\u0001\u0011\u0005\u0001+\u0001\nuKN$()^5mI>3gm]3u\u001b\u0006\u0004\bfAA\"A\"1\u00111\n\u0001\u0005\u0002A\u000ba\u0003^3tiJ+7m\u001c<fef\fe\r^3s\u0007J\f7\u000f\u001b\u0015\u0004\u0003\u0013\u0002\u0007bBA)\u0001\u0011\u0005\u00111K\u0001\b[\u0006\\W\rT8h)\u0015Q\u0018QKA,\u0011!)\u0013q\nI\u0001\u0002\u0004Q\u0002\"CA-\u0003\u001f\u0002\n\u00111\u00017\u0003\u0019\u0019wN\u001c4jO\"9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013!\u00048p\u001fB\u001c\u0005.Z2l\t>tW\rF\u0002R\u0003CB\u0001\"a\u0003\u0002\\\u0001\u0007\u0011Q\u0002\u0005\b\u0003K\u0002A\u0011AA4\u0003-i\u0017m[3DY\u0016\fg.\u001a:\u0015\r\u0005%\u0014qNA:!\r1\u00121N\u0005\u0004\u0003[\u0012!aB\"mK\u0006tWM\u001d\u0005\b\u0003c\n\u0019\u00071\u0001w\u0003!\u0019\u0017\r]1dSRL\bBCA;\u0003G\u0002\n\u00111\u0001\u0002x\u0005I1\r[3dW\u0012{g.\u001a\t\u0007%\u0006e\u0014QB)\n\u0007\u0005m4KA\u0005Gk:\u001cG/[8oc!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015AC<sSR,Gk\u001c'pOR1\u00111QAF\u0003\u001b\u0003B!\u001d;\u0002\u0006B\u0019!+a\"\n\u0007\u0005%5K\u0001\u0003M_:<\u0007BB\u0002\u0002~\u0001\u0007!\u0010\u0003\u0005\u0002\u0010\u0006u\u0004\u0019AAI\u0003\r\u0019X-\u001d\t\u0005cR\f\u0019\nE\u0003S\u0003+3h/C\u0002\u0002\u0018N\u0013a\u0001V;qY\u0016\u0014\u0004bBAN\u0001\u0011\u0005\u0011QT\u0001\u0004W\u0016LH\u0003BAP\u0003W\u0003B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003Ks\u0012a\u00018j_&!\u0011\u0011VAR\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003[\u000bI\n1\u0001w\u0003\tIG\rC\u0004\u00022\u0002!\t!a-\u0002\u000f5,7o]1hKR1\u0011QWA`\u0003\u0003\u0004B!a.\u0002<6\u0011\u0011\u0011\u0018\u0006\u0004\u0003c#\u0011\u0002BA_\u0003s\u0013ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bbBAN\u0003_\u0003\rA\u001e\u0005\b\u0003\u0007\fy\u000b1\u0001w\u0003\u00151\u0018\r\\;f\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\fa\"\u001e8lKf,G-T3tg\u0006<W\r\u0006\u0003\u00026\u0006-\u0007bBAb\u0003\u000b\u0004\rA\u001e\u0005\b\u0003\u001f\u0004A\u0011AAi\u00035!W\r\\3uK6+7o]1hKR!\u0011QWAj\u0011\u001d\tY*!4A\u0002YD\u0011\"a6\u0001#\u0003%\t!!7\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001c\u0016\u0005\u0003o\nin\u000b\u0002\u0002`B!\u0011\u0011]Av\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018!C;oG\",7m[3e\u0015\r\tIoU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAw\u0003G\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\t\u0010AI\u0001\n\u0003\t\u00190A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uIE*\"!!>+\u0007i\ti\u000eC\u0005\u0002z\u0002\t\n\u0011\"\u0001\u0002|\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u(f\u0001\u001c\u0002^\u0002")
public class CleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        CoreUtils$.MODULE$.rm(this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$21 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        Log log = this.makeLog(x$22, x$21);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$1));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$25 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$26 = this.makeLog$default$1();
        Log log = this.makeLog(x$26, x$25);
        while (log.numberOfSegments() < 2) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$1;

            public final LogAppendInfo apply(int key) {
                return this.log$1.append(this.$outer.deleteMessage(key), this.log$1.append$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
            }
        });
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$2;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$2 = keys$2;
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$29 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$30 = this.makeLog$default$1();
        Log log = this.makeLog(x$30, x$29);
        byte[] x$31 = (byte[])Array$.MODULE$.fill(50, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte());
        byte[] x$32 = ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes();
        CompressionCodec x$33 = TestUtils$.MODULE$.singleMessageSet$default$2();
        ByteBufferMessageSet messageSet = TestUtils$.MODULE$.singleMessageSet(x$31, x$33, x$32);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log, messageSet){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final ByteBufferMessageSet messageSet$1;

            public final LogAppendInfo apply(int i) {
                return this.log$2.append(this.messageSet$1, true);
            }
            {
                this.log$2 = log$2;
                this.messageSet$1 = messageSet$1;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicAndPartition("test", 0), log, log.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - log.activeSegment().size()));
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$34 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$35 = this.makeLog$default$1();
        Log log = this.makeLog(x$35, x$34);
        while (log.numberOfSegments() < 2) {
            log.append(this.unkeyedMessage((int)log.logEndOffset()), log.append$default$2());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
        Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)cleaner.stats().invalidMessagesRead());
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$3) {
                        return !x$3.message().isNull();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$4) {
                        return x$4.message().hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MessageAndOffset m) {
                        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(m.message().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$5) {
                        return !x$5.message().isNull();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset m) {
                        return !m.message().hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicAndPartition topicAndPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicAndPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.abortCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$36 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$37 = this.makeLog$default$1();
        Log log = this.makeLog(x$37, x$36);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$3;
            private final FakeOffsetMap map$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$3, ((TraversableOnce)this.log$3.logSegments().take(3)).toSeq(), (OffsetMap)this.map$2, 0L);
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$3 = log$3;
                this.map$2 = map$2;
            }
        }, ManifestFactory$.MODULE$.classType(LogCleaningAbortedException.class));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$38 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$39 = this.makeLog$default$1();
        Log log = this.makeLog(x$39, x$38);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            byte[] x$40 = "hello".getBytes();
            byte[] x$41 = "hello".getBytes();
            CompressionCodec x$42 = TestUtils$.MODULE$.singleMessageSet$default$2();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$40, x$42, x$41), log.append$default$2());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log.numberOfSegments(), (long)((SeqLike)groups.apply(0)).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$6) {
                return x$6.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$7) {
                return x$7.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = (int)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$9) {
                return x$9.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$10) {
                return x$10.index().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$11) {
                return x$11.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$43 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$44 = this.makeLog$default$1();
        Log log = this.makeLog(x$44, x$43);
        while (log.numberOfSegments() == 1) {
            byte[] x$45 = "hello".getBytes();
            byte[] x$46 = "hello".getBytes();
            CompressionCodec x$47 = TestUtils$.MODULE$.singleMessageSet$default$2();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$45, x$47, x$46), log.append$default$2());
        }
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new AtomicLong(0x7FFFFFFEL), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), "hello".getBytes())}));
        log.append(messageSet, false);
        byte[] x$48 = "hello".getBytes();
        byte[] x$49 = "hello".getBytes();
        CompressionCodec x$50 = TestUtils$.MODULE$.singleMessageSet$default$2();
        log.append(TestUtils$.MODULE$.singleMessageSet(x$48, x$50, x$49), log.append$default$2());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().index().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        byte[] x$51 = "hello".getBytes();
        byte[] x$52 = "hello".getBytes();
        CompressionCodec x$53 = TestUtils$.MODULE$.singleMessageSet$default$2();
        log.append(TestUtils$.MODULE$.singleMessageSet(x$51, x$53, x$52), log.append$default$2());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            byte[] x$54 = "hello".getBytes();
            byte[] x$55 = "hello".getBytes();
            CompressionCodec x$56 = TestUtils$.MODULE$.singleMessageSet$default$2();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$54, x$56, x$55), log.append$default$2());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).index().lastOffset() - ((LogSegment)group.head()).index().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$12) {
                return (Seq)x$12.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$13) {
                        return x$13.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        int start = 0;
        int end = 500;
        Iterable<Object> offsets = this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$59 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$60 = this.makeLog$default$1();
        Log log = this.makeLog(x$60, x$59);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            Log qual$1 = log;
            ByteBufferMessageSet x$61 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$62 = qual$1.append$default$2();
            qual$1.append(x$61, x$62);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        Iterable<Object> cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), "")));
            }
        });
        log = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), "")));
            }
        });
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$2 = log;
            ByteBufferMessageSet x$63 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$64 = qual$2.append$default$2();
            qual$2.append(x$63, x$64);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$3 = log;
            ByteBufferMessageSet x$65 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$66 = qual$3.append$default$2();
            qual$3.append(x$65, x$66);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        this.recoverAndCheck$1(config, cleanedKeys);
    }

    public Log makeLog(File dir, LogConfig config) {
        return new Log(dir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
    }

    public File makeLog$default$1() {
        return this.dir();
    }

    public LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    public void noOpCheckDone(TopicAndPartition topicAndPartition) {
    }

    public Cleaner makeCleaner(int capacity, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), 65536, 65536, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    public Function1<TopicAndPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.noOpCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$5;

            public final long apply(Tuple2<Object, Object> x$14) {
                Tuple2<Object, Object> tuple2 = x$14;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$5.append(this.$outer.message(key, value), this.log$5.append$default$2()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$5 = log$5;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public ByteBufferMessageSet message(int key, int value) {
        Message[] messageArray = new Message[1];
        byte[] x$23 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$24 = ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes();
        messageArray[0] = new Message(x$24, x$23);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    public ByteBufferMessageSet unkeyedMessage(int value) {
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())}));
    }

    public ByteBufferMessageSet deleteMessage(int key) {
        Message[] messageArray = new Message[1];
        byte[] x$27 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$28 = null;
        messageArray[0] = new Message(x$28, x$27);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Log log$4, Cleaner cleaner$2) {
        long endOffset = cleaner$2.buildOffsetMap(log$4, (long)start, (long)end, (OffsetMap)map) + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$3.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_5;
        LogConfig x$57 = config;
        File x$58 = this.makeLog$default$1();
        Log recoveredLog = this.makeLog(x$58, x$57);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
            }
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_5;
    }

    public CleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime();
        double x$15 = Double.MAX_VALUE;
        long x$16 = Long.MAX_VALUE;
        MockTime x$17 = this.time();
        boolean x$18 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$19 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$20 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$15, x$16, x$18, x$19, x$20, (Time)x$17);
    }
}

