/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.net.InetAddress;
import java.util.Properties;
import java.util.UUID;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001%\u0011qcU5na2,\u0017i\u00197BkRDwN]5{KJ$Vm\u001d;\u000b\u0005\r!\u0011\u0001B1vi\"T!!\u0002\u0004\u0002\u0011M,7-\u001e:jifT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0002\u0006\t\u0003\u0017Ii\u0011\u0001\u0004\u0006\u0003\u001b9\tQA[;oSRT!a\u0004\t\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\t\u0002\u0007=\u0014x-\u0003\u0002\u0014\u0019\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011A\u0001>l\u0013\tIbC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%A\ntS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'/F\u0001#!\tq2%\u0003\u0002%\u0005\t\u00192+[7qY\u0016\f5\r\\!vi\"|'/\u001b>fe\"1a\u0005\u0001Q\u0001\n\t\nAc]5na2,\u0017i\u00197BkRDwN]5{KJ\u0004\u0003b\u0002\u0015\u0001\u0005\u0004%\t!K\u0001\u000ei\u0016\u001cH\u000f\u0015:j]\u000eL\u0007/\u00197\u0016\u0003)\u0002\"aK\u001a\u000e\u00031R!aA\u0017\u000b\u0005\u0015q#BA\u00181\u0003\u0019\u0019w.\\7p]*\u0011q!\r\u0006\u0003eA\ta!\u00199bG\",\u0017B\u0001\u001b-\u00059Y\u0015MZ6b!JLgnY5qC2DaA\u000e\u0001!\u0002\u0013Q\u0013A\u0004;fgR\u0004&/\u001b8dSB\fG\u000e\t\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u00031!Xm\u001d;I_N$h*Y7f+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\rqW\r\u001e\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEHA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\bBB\"\u0001A\u0003%!(A\u0007uKN$\bj\\:u\u001d\u0006lW\r\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0003\u001d\u0019Xm]:j_:,\u0012a\u0012\t\u0003\u0011Rs!!S)\u000f\u0005){eBA&O\u001b\u0005a%BA'\t\u0003\u0019a$o\\8u}%\tq!\u0003\u0002Q\r\u00059a.\u001a;x_J\\\u0017B\u0001*T\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2T!\u0001\u0015\u0004\n\u0005U3&aB*fgNLwN\u001c\u0006\u0003%NCa\u0001\u0017\u0001!\u0002\u00139\u0015\u0001C:fgNLwN\u001c\u0011\t\u000fi\u0003\u0001\u0019!C\u00017\u0006A!/Z:pkJ\u001cW-F\u0001]!\tqR,\u0003\u0002_\u0005\tA!+Z:pkJ\u001cW\rC\u0004a\u0001\u0001\u0007I\u0011A1\u0002\u0019I,7o\\;sG\u0016|F%Z9\u0015\u0005\tD\u0007CA2g\u001b\u0005!'\"A3\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d$'\u0001B+oSRDq![0\u0002\u0002\u0003\u0007A,A\u0002yIEBaa\u001b\u0001!B\u0013a\u0016!\u0003:fg>,(oY3!\u0011\u001di\u0007A1A\u0005\u00029\f!b];qKJ,6/\u001a:t+\u0005y\u0007C\u00019t\u001b\u0005\t(B\u0001:?\u0003\u0011a\u0017M\\4\n\u0005Q\f(AB*ue&tw\r\u0003\u0004w\u0001\u0001\u0006Ia\\\u0001\fgV\u0004XM]+tKJ\u001c\b\u0005C\u0004y\u0001\t\u0007I\u0011\u00018\u0002\u0011U\u001cXM\u001d8b[\u0016DaA\u001f\u0001!\u0002\u0013y\u0017!C;tKJt\u0017-\\3!\u0011\u001da\b\u00011A\u0005\u0002u\faaY8oM&<W#\u0001@\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0004\u0002\rM,'O^3s\u0013\u0011\t9!!\u0001\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\n\u0003\u0017\u0001\u0001\u0019!C\u0001\u0003\u001b\t!bY8oM&<w\fJ3r)\r\u0011\u0017q\u0002\u0005\tS\u0006%\u0011\u0011!a\u0001}\"9\u00111\u0003\u0001!B\u0013q\u0018aB2p]\u001aLw\r\t\u0005\b\u0003/\u0001A\u0011IA\r\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0007\u0006BA\u000b\u0003;\u0001B!a\b\u0002$5\u0011\u0011\u0011\u0005\u0006\u0003\u001bAIA!!\n\u0002\"\t1!)\u001a4pe\u0016Dq!!\u000b\u0001\t\u0003\nI\"\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t9#!\f\u0011\t\u0005}\u0011qF\u0005\u0005\u0003c\t\tCA\u0003BMR,'\u000fC\u0004\u00026\u0001!\t!!\u0007\u0002\u0019Q,7\u000f\u001e+pa&\u001c\u0017i\u00197)\t\u0005M\u0012\u0011\b\t\u0005\u0003?\tY$\u0003\u0003\u0002>\u0005\u0005\"\u0001\u0002+fgRDq!!\u0011\u0001\t\u0003\tI\"A\fuKN$H)\u001a8z)\u0006\\Wm\u001d)sK\u000e,G-\u001a8dK\"\"\u0011qHA\u001d\u0011\u001d\t9\u0005\u0001C\u0001\u00033\t!\u0003^3ti\u0006cGn\\<BY2\f5mY3tg\"\"\u0011QIA\u001d\u0011\u001d\ti\u0005\u0001C\u0001\u00033\ta\u0003^3tiN+\b/\u001a:Vg\u0016\u0014\b*Y:BG\u000e,7o\u001d\u0015\u0005\u0003\u0017\nI\u0004C\u0004\u0002T\u0001!\t!!\u0007\u0002!Q,7\u000f^,jY\u0012\u001c\u0015M\u001d3BG2\u001c\b\u0006BA)\u0003sAq!!\u0017\u0001\t\u0003\tI\"\u0001\buKN$hj\\!dY\u001a{WO\u001c3)\t\u0005]\u0013\u0011\b\u0005\b\u0003?\u0002A\u0011AA\r\u0003Y!Xm\u001d;O_\u0006\u001bGNR8v]\u0012|e/\u001a:sS\u0012,\u0007\u0006BA/\u0003sAq!!\u001a\u0001\t\u0003\tI\"A\u000buKN$\u0018i\u00197NC:\fw-Z7f]R\f\u0005+S:)\t\u0005\r\u0014\u0011\b\u0005\b\u0003W\u0002A\u0011AA\r\u00035!Xm\u001d;M_\u0006$7)Y2iK\"\"\u0011\u0011NA\u001d\u0011\u001d\t\t\b\u0001C\u0005\u0003g\n!c\u00195b]\u001e,\u0017i\u00197B]\u00124VM]5gsRQ\u0011QOAE\u0003\u001b\u000b\t*!&\u0011\r\u0005]\u0014QPAB\u001d\r\u0019\u0017\u0011P\u0005\u0004\u0003w\"\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\u0005\u0005%aA*fi*\u0019\u00111\u00103\u0011\u0007y\t))C\u0002\u0002\b\n\u00111!Q2m\u0011!\tY)a\u001cA\u0002\u0005U\u0014\u0001D8sS\u001eLg.\u00197BG2\u001c\b\u0002CAH\u0003_\u0002\r!!\u001e\u0002\u0013\u0005$G-\u001a3BG2\u001c\b\u0002CAJ\u0003_\u0002\r!!\u001e\u0002\u0017I,Wn\u001c<fI\u0006\u001bGn\u001d\u0005\t5\u0006=\u0004\u0013!a\u00019\"I\u0011\u0011\u0014\u0001\u0012\u0002\u0013%\u00111T\u0001\u001dG\"\fgnZ3BG2\fe\u000e\u001a,fe&4\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tiJK\u0002]\u0003?[#!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003W#\u0017AC1o]>$\u0018\r^5p]&!\u0011qVAS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SimpleAclAuthorizerTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final SimpleAclAuthorizer simpleAclAuthorizer;
    private final KafkaPrincipal testPrincipal;
    private final InetAddress testHostName;
    private final RequestChannel.Session session;
    private Resource resource;
    private final String superUsers;
    private final String username;
    private KafkaConfig config;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SimpleAclAuthorizerTest simpleAclAuthorizerTest = this;
        synchronized (simpleAclAuthorizerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public SimpleAclAuthorizer simpleAclAuthorizer() {
        return this.simpleAclAuthorizer;
    }

    public KafkaPrincipal testPrincipal() {
        return this.testPrincipal;
    }

    public InetAddress testHostName() {
        return this.testHostName;
    }

    public RequestChannel.Session session() {
        return this.session;
    }

    public Resource resource() {
        return this.resource;
    }

    public void resource_$eq(Resource x$1) {
        this.resource = x$1;
    }

    public String superUsers() {
        return this.superUsers;
    }

    public String username() {
        return this.username;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
        this.resource_$eq(new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString()));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleAclAuthorizer().close();
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        Acl acl5 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl acl6 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        Acl acl7 = new Acl(user3, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session(user1, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Alter$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Alter$.MODULE$, this.resource()));
        RequestChannel.Session user2Session = new RequestChannel.Session(user2, host1);
        RequestChannel.Session user3Session = new RequestChannel.Session(user3, host1);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestChannel.Session session = new RequestChannel.Session(user, host);
        Acl allowAll = Acl$.MODULE$.AllowAllAcl();
        Acl denyAcl = new Acl(user, (PermissionType)Deny$.MODULE$, host.getHostAddress(), (Operation)All$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAll, denyAcl}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testAllowAllAccess() {
        Acl allowAllAcl = Acl$.MODULE$.AllowAllAcl();
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session1 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        RequestChannel.Session session2 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session1, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session2, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        Acl readAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Resource wildCardResource = new Resource(this.resource().resourceType(), Resource$.MODULE$.WildCardResource());
        Set<Acl> acls = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{readAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), wildCardResource);
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Assert.assertTrue((String)"User1 should have Read access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Acl writeAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Acl denyWriteOnWildCardResourceAcl = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify(acls, (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyWriteOnWildCardResourceAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), wildCardResource);
        Assert.assertFalse((String)"User1 should not have Write access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        SimpleAclAuthorizer testAuthoizer = new SimpleAclAuthorizer();
        testAuthoizer.configure(cfg.originals());
        Assert.assertTrue((String)"when acls = null or [],  authorizer should fail open with allow.everyone = true.", (boolean)testAuthoizer.authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Write$.MODULE$);
        Acl acl3 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Write$.MODULE$);
        ObjectRef acls = ObjectRef.create(this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4()));
        Acl acl5 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl5}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user1, acl1, acl2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final KafkaPrincipal user1$1;
            private final Acl acl1$1;
            private final Acl acl2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl1$1, this.acl2$1})))}));
                Map map = this.$outer.simpleAclAuthorizer().getAcls(this.user1$1);
                return !(genMap != null ? !genMap.equals(map) : map != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.user1$1 = user1$1;
                this.acl1$1 = acl1$1;
                this.acl2$1 = acl2$1;
            }
        }, "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user2, acl3, acl4, acl5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final KafkaPrincipal user2$1;
            private final Acl acl3$1;
            private final Acl acl4$1;
            private final Acl acl5$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl3$1, this.acl4$1, this.acl5$1})))}));
                Map map = this.$outer.simpleAclAuthorizer().getAcls(this.user2$1);
                return !(genMap != null ? !genMap.equals(map) : map != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.user2$1 = user2$1;
                this.acl3$1 = acl3$1;
                this.acl4$1 = acl4$1;
                this.acl5$1 = acl5$1;
            }
        }, "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Topic$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Cluster$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)((Set)acls.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, "test-ConsumerGroup")), (Object)((Set)acls.elem))}));
        resourceToAcls.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;

            public final Set<Acl> apply(Tuple2<Resource, Set<Acl>> x0$1) {
                Tuple2<Resource, Set<Acl>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Resource key = (Resource)tuple2._1();
                    Set value = (Set)tuple2._2();
                    Set<Acl> set = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)value, (Set<Acl>)Predef$.MODULE$.Set().empty(), key);
                    return set;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, acls, resourceToAcls){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final ObjectRef acls$1;
            private final Map resourceToAcls$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map map = this.resourceToAcls$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.resource()), (Object)((Set)this.acls$1.elem)));
                Map map2 = this.$outer.simpleAclAuthorizer().getAcls();
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.acls$1 = acls$1;
                this.resourceToAcls$1 = resourceToAcls$1;
            }
        }, "changes not propagated in timeout period.", TestUtils$.MODULE$.waitUntilTrue$default$3());
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        Assert.assertTrue((!this.zkUtils().pathExists(this.simpleAclAuthorizer().toResourcePath(this.resource())) ? 1 : 0) != 0);
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)acls.elem), this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkUtils().pathExists(this.simpleAclAuthorizer().toResourcePath(this.resource())) ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, "host-1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}));
        this.simpleAclAuthorizer().addAcls(acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, "test-2");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, "host3", (Operation)Read$.MODULE$);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2}));
        this.simpleAclAuthorizer().addAcls(acls1, resource1);
        this.zkUtils().deletePathRecursive(SimpleAclAuthorizer$.MODULE$.AclChangedZkPath());
        SimpleAclAuthorizer authorizer = new SimpleAclAuthorizer();
        authorizer.configure(this.config().originals());
        Assert.assertEquals((Object)acls, (Object)authorizer.getAcls(this.resource()));
        Assert.assertEquals((Object)acls1, (Object)authorizer.getAcls(resource1));
    }

    public Set<Acl> kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify(Set<Acl> originalAcls, Set<Acl> addedAcls, Set<Acl> removedAcls, Resource resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().addAcls(addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().removeAcls(removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.simpleAclAuthorizer(), resource);
        return acls;
    }

    private Resource changeAclAndVerify$default$4() {
        return this.resource();
    }

    public SimpleAclAuthorizerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.simpleAclAuthorizer = new SimpleAclAuthorizer();
        this.testPrincipal = Acl$.MODULE$.WildCardPrincipal();
        this.testHostName = InetAddress.getByName("192.168.0.1");
        this.session = new RequestChannel.Session(this.testPrincipal(), this.testHostName());
        this.resource = null;
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
        this.config = null;
    }
}

