/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.util.List;
import kafka.consumer.ConsumerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkPath$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.config.ConfigException;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u000f\tQ!l\u0013)bi\"$Vm\u001d;\u000b\u0005\r!\u0011A\u0001>l\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!\u0011\u0002CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001bB\u000e\u0001\u0005\u0004%\t\u0001H\u0001\u0005a\u0006$\b.F\u0001\u001e!\tqBE\u0004\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003%\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u0019\u0012aa\u0015;sS:<'BA\u0012!\u0011\u0019A\u0003\u0001)A\u0005;\u0005)\u0001/\u0019;iA!9!\u0006\u0001b\u0001\n\u0003Y\u0013A\u0005>l'\u0016\u001c8/[8o)&lWm\\;u\u001bN,\u0012\u0001\f\t\u0003?5J!A\f\u0011\u0003\u0007%sG\u000f\u0003\u00041\u0001\u0001\u0006I\u0001L\u0001\u0014u.\u001cVm]:j_:$\u0016.\\3pkRl5\u000f\t\u0005\u0006e\u0001!\t\u0001H\u0001\u0019u.\u001cuN\u001c8fGR<\u0016\u000e\u001e5J]Z\fG.\u001b3S_>$\b\"\u0002\u001b\u0001\t\u0003)\u0014a\n;fgR\u001c%/Z1uKB+'o]5ti\u0016tG\u000fU1uQRC'o\\<t\u000bb\u001cW\r\u001d;j_:,\u0012A\u000e\t\u0003?]J!\u0001\u000f\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0003gi\u0002\"aO\u001f\u000e\u0003qR!a\u0003\b\n\u0005yb$\u0001\u0002+fgRDQ\u0001\u0011\u0001\u0005\u0002U\n\u0001\u0004^3ti\u000e\u0013X-\u0019;f!\u0016\u00148/[:uK:$\b+\u0019;iQ\ty$\bC\u0003D\u0001\u0011\u0005Q'A\u0017uKN$X*Y6f'V\u0014X\rU3sg&\u001cHo\u001d)bi\",\u00050[:ugRC'o\\<t\u000bb\u001cW\r\u001d;j_:D#A\u0011\u001e\t\u000b\u0019\u0003A\u0011A\u001b\u0002=Q,7\u000f^'bW\u0016\u001cVO]3QKJ\u001c\u0018n\u001d;t!\u0006$\b.\u0012=jgR\u001c\bFA#;\u0011\u0015I\u0005\u0001\"\u00016\u0003\u0019\"Xm\u001d;De\u0016\fG/Z#qQ\u0016lWM]1m!\u0006$\b\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0003\u0011jBQ\u0001\u0014\u0001\u0005\u0002U\nQ\u0004^3ti\u000e\u0013X-\u0019;f\u000bBDW-\\3sC2\u0004\u0016\r\u001e5Fq&\u001cHo\u001d\u0015\u0003\u0017jBQa\u0014\u0001\u0005\u0002U\nQ\u0006^3ti\u000e\u0013X-\u0019;f!\u0016\u00148/[:uK:$8+Z9vK:$\u0018.\u00197UQJ|wo]#yG\u0016\u0004H/[8oQ\tq%\bC\u0003S\u0001\u0011\u0005Q'\u0001\u0013uKN$8I]3bi\u0016\u0004VM]:jgR,g\u000e^*fcV,g\u000e^5bY\u0016C\u0018n\u001d;tQ\t\t&\b")
public class ZKPathTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final String path;
    private final int zkSessionTimeoutMs;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZKPathTest zKPathTest = this;
        synchronized (zKPathTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String path() {
        return this.path;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public String zkConnectWithInvalidRoot() {
        return new StringBuilder().append((Object)this.zkConnect()).append((Object)"/ghost").toString();
    }

    @Test
    public void testCreatePersistentPathThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$1 = zkUtils;
            String x$1 = this.path();
            String x$2 = qual$1.createPersistentPath$default$2();
            List x$3 = qual$1.createPersistentPath$default$3();
            qual$1.createPersistentPath(x$1, x$2, x$3);
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            return;
        }
    }

    @Test
    public void testCreatePersistentPath() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$2 = zkUtils;
            String x$4 = this.path();
            String x$5 = qual$2.createPersistentPath$default$2();
            List x$6 = qual$2.createPersistentPath$default$3();
            qual$2.createPersistentPath(x$4, x$5, x$6);
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create persistent path");
        }
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(this.path()));
    }

    @Test
    public void testMakeSurePersistsPathExistsThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$3 = zkUtils;
            String x$7 = this.path();
            List x$8 = qual$3.makeSurePersistentPathExists$default$2();
            qual$3.makeSurePersistentPathExists(x$7, x$8);
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            return;
        }
    }

    @Test
    public void testMakeSurePersistsPathExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$4 = zkUtils;
            String x$9 = this.path();
            List x$10 = qual$4.makeSurePersistentPathExists$default$2();
            qual$4.makeSurePersistentPathExists(x$9, x$10);
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create persistent path");
        }
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(this.path()));
    }

    @Test
    public void testCreateEphemeralPathThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$5 = zkUtils;
            String x$11 = this.path();
            String x$12 = "somedata";
            List x$13 = qual$5.createEphemeralPathExpectConflict$default$3();
            qual$5.createEphemeralPathExpectConflict(x$11, x$12, x$13);
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            return;
        }
    }

    @Test
    public void testCreateEphemeralPathExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$6 = zkUtils;
            String x$14 = this.path();
            String x$15 = "somedata";
            List x$16 = qual$6.createEphemeralPathExpectConflict$default$3();
            qual$6.createEphemeralPathExpectConflict(x$14, x$15, x$16);
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create ephemeral path");
        }
        Assert.assertTrue((String)"Failed to create ephemeral path", (boolean)zkUtils.pathExists(this.path()));
    }

    @Test
    public void testCreatePersistentSequentialThrowsException() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnectWithInvalidRoot(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnectWithInvalidRoot(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$7 = zkUtils;
            String x$17 = this.path();
            String x$18 = qual$7.createSequentialPersistentPath$default$2();
            List x$19 = qual$7.createSequentialPersistentPath$default$3();
            qual$7.createSequentialPersistentPath(x$17, x$18, x$19);
            throw this.fail("Failed to throw ConfigException for missing zookeeper root node");
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown ConfigException");
        }
        catch (ConfigException configException) {
            return;
        }
    }

    @Test
    public void testCreatePersistentSequentialExists() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        String actualPath = "";
        try {
            ZkPath$.MODULE$.resetNamespaceCheckedState();
            ZkUtils qual$8 = zkUtils;
            String x$20 = this.path();
            String x$21 = qual$8.createSequentialPersistentPath$default$2();
            List x$22 = qual$8.createSequentialPersistentPath$default$3();
            actualPath = qual$8.createSequentialPersistentPath(x$20, x$21, x$22);
        }
        catch (Throwable throwable) {
            throw this.fail("Failed to create persistent path");
        }
        Assert.assertTrue((String)"Failed to create persistent path", (boolean)zkUtils.pathExists(actualPath));
    }

    public ZKPathTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.path = "/some_dir";
        this.zkSessionTimeoutMs = 1000;
    }
}

