/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;

public interface Schema {
    public static final Schema INT8_SCHEMA = SchemaBuilder.int8().build();
    public static final Schema INT16_SCHEMA = SchemaBuilder.int16().build();
    public static final Schema INT32_SCHEMA = SchemaBuilder.int32().build();
    public static final Schema INT64_SCHEMA = SchemaBuilder.int64().build();
    public static final Schema FLOAT32_SCHEMA = SchemaBuilder.float32().build();
    public static final Schema FLOAT64_SCHEMA = SchemaBuilder.float64().build();
    public static final Schema BOOLEAN_SCHEMA = SchemaBuilder.bool().build();
    public static final Schema STRING_SCHEMA = SchemaBuilder.string().build();
    public static final Schema BYTES_SCHEMA = SchemaBuilder.bytes().build();
    public static final Schema OPTIONAL_INT8_SCHEMA = SchemaBuilder.int8().optional().build();
    public static final Schema OPTIONAL_INT16_SCHEMA = SchemaBuilder.int16().optional().build();
    public static final Schema OPTIONAL_INT32_SCHEMA = SchemaBuilder.int32().optional().build();
    public static final Schema OPTIONAL_INT64_SCHEMA = SchemaBuilder.int64().optional().build();
    public static final Schema OPTIONAL_FLOAT32_SCHEMA = SchemaBuilder.float32().optional().build();
    public static final Schema OPTIONAL_FLOAT64_SCHEMA = SchemaBuilder.float64().optional().build();
    public static final Schema OPTIONAL_BOOLEAN_SCHEMA = SchemaBuilder.bool().optional().build();
    public static final Schema OPTIONAL_STRING_SCHEMA = SchemaBuilder.string().optional().build();
    public static final Schema OPTIONAL_BYTES_SCHEMA = SchemaBuilder.bytes().optional().build();

    public Type type();

    public boolean isOptional();

    public Object defaultValue();

    public String name();

    public Integer version();

    public String doc();

    public Map<String, String> parameters();

    public Schema keySchema();

    public Schema valueSchema();

    public List<Field> fields();

    public Field field(String var1);

    public Schema schema();

    public static enum Type {
        INT8,
        INT16,
        INT32,
        INT64,
        FLOAT32,
        FLOAT64,
        BOOLEAN,
        STRING,
        BYTES,
        ARRAY,
        MAP,
        STRUCT;

        private String name = this.name().toLowerCase();

        public String getName() {
            return this.name;
        }

        public boolean isPrimitive() {
            switch (this) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    return true;
                }
            }
            return false;
        }
    }
}

