/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.tools.ThroughputThrottler;

public class ProducerPerformance {
    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ProducerPerformance.argParser();
        try {
            Namespace res = parser.parseArgs(args);
            String topicName = res.getString("topic");
            long numRecords = res.getLong("numRecords");
            int recordSize = res.getInt("recordSize");
            int throughput = res.getInt("throughput");
            List producerProps = res.getList("producerConfig");
            Properties props = new Properties();
            if (producerProps != null) {
                for (String prop : producerProps) {
                    String[] pieces = prop.split("=");
                    if (pieces.length != 2) {
                        throw new IllegalArgumentException("Invalid property: " + prop);
                    }
                    props.put(pieces[0], pieces[1]);
                }
            }
            props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            KafkaProducer producer = new KafkaProducer(props);
            byte[] payload = new byte[recordSize];
            Arrays.fill(payload, (byte)1);
            ProducerRecord record = new ProducerRecord(topicName, (Object)payload);
            Stats stats = new Stats(numRecords, 5000);
            long startMs = System.currentTimeMillis();
            ThroughputThrottler throttler = new ThroughputThrottler(throughput, startMs);
            int i = 0;
            while ((long)i < numRecords) {
                long sendStartMs = System.currentTimeMillis();
                Callback cb = stats.nextCompletion(sendStartMs, payload.length, stats);
                producer.send(record, cb);
                if (throttler.shouldThrottle(i, sendStartMs)) {
                    throttler.throttle();
                }
                ++i;
            }
            producer.close();
            stats.printTotal();
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                System.exit(0);
            }
            parser.handleError(e);
            System.exit(1);
        }
    }

    private static ArgumentParser argParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"producer-performance").defaultHelp(true).description("This tool is used to verify the producer performance.");
        parser.addArgument(new String[]{"--topic"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).metavar(new String[]{"TOPIC"}).help("produce messages to this topic");
        parser.addArgument(new String[]{"--num-records"}).action((ArgumentAction)Arguments.store()).required(true).type(Long.class).metavar(new String[]{"NUM-RECORDS"}).dest("numRecords").help("number of messages to produce");
        parser.addArgument(new String[]{"--record-size"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"RECORD-SIZE"}).dest("recordSize").help("message size in bytes");
        parser.addArgument(new String[]{"--throughput"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"THROUGHPUT"}).help("throttle maximum message throughput to *approximately* THROUGHPUT messages/sec");
        parser.addArgument(new String[]{"--producer-props"}).nargs("+").required(true).metavar(new String[]{"PROP-NAME=PROP-VALUE"}).type(String.class).dest("producerConfig").help("kafka producer related configuaration properties like bootstrap.servers,client.id etc..");
        return parser;
    }

    private static final class PerfCallback
    implements Callback {
        private final long start;
        private final int iteration;
        private final int bytes;
        private final Stats stats;

        public PerfCallback(int iter, long start, int bytes, Stats stats) {
            this.start = start;
            this.stats = stats;
            this.iteration = iter;
            this.bytes = bytes;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = System.currentTimeMillis();
            int latency = (int)(now - this.start);
            this.stats.record(this.iteration, latency, this.bytes, now);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    private static class Stats {
        private long start = System.currentTimeMillis();
        private long windowStart = System.currentTimeMillis();
        private int[] latencies;
        private int sampling;
        private int iteration = 0;
        private int index = 0;
        private long count;
        private long bytes;
        private int maxLatency;
        private long totalLatency;
        private long windowCount;
        private int windowMaxLatency;
        private long windowTotalLatency;
        private long windowBytes;
        private long reportingInterval;

        public Stats(long numRecords, int reportingInterval) {
            this.sampling = (int)(numRecords / Math.min(numRecords, 500000L));
            this.latencies = new int[(int)(numRecords / (long)this.sampling) + 1];
            this.index = 0;
            this.maxLatency = 0;
            this.totalLatency = 0L;
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
            this.totalLatency = 0L;
            this.reportingInterval = reportingInterval;
        }

        public void record(int iter, int latency, int bytes, long time) {
            ++this.count;
            this.bytes += (long)bytes;
            this.totalLatency += (long)latency;
            this.maxLatency = Math.max(this.maxLatency, latency);
            ++this.windowCount;
            this.windowBytes += (long)bytes;
            this.windowTotalLatency += (long)latency;
            this.windowMaxLatency = Math.max(this.windowMaxLatency, latency);
            if (iter % this.sampling == 0) {
                this.latencies[this.index] = latency;
                ++this.index;
            }
            if (time - this.windowStart >= this.reportingInterval) {
                this.printWindow();
                this.newWindow();
            }
        }

        public Callback nextCompletion(long start, int bytes, Stats stats) {
            PerfCallback cb = new PerfCallback(this.iteration, start, bytes, stats);
            ++this.iteration;
            return cb;
        }

        public void printWindow() {
            long ellapsed = System.currentTimeMillis() - this.windowStart;
            double recsPerSec = 1000.0 * (double)this.windowCount / (double)ellapsed;
            double mbPerSec = 1000.0 * (double)this.windowBytes / (double)ellapsed / 1048576.0;
            System.out.printf("%d records sent, %.1f records/sec (%.2f MB/sec), %.1f ms avg latency, %.1f max latency.\n", this.windowCount, recsPerSec, mbPerSec, (double)this.windowTotalLatency / (double)this.windowCount, (double)this.windowMaxLatency);
        }

        public void newWindow() {
            this.windowStart = System.currentTimeMillis();
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
        }

        public void printTotal() {
            long elapsed = System.currentTimeMillis() - this.start;
            double recsPerSec = 1000.0 * (double)this.count / (double)elapsed;
            double mbPerSec = 1000.0 * (double)this.bytes / (double)elapsed / 1048576.0;
            int[] percs = Stats.percentiles(this.latencies, this.index, 0.5, 0.95, 0.99, 0.999);
            System.out.printf("%d records sent, %f records/sec (%.2f MB/sec), %.2f ms avg latency, %.2f ms max latency, %d ms 50th, %d ms 95th, %d ms 99th, %d ms 99.9th.\n", this.count, recsPerSec, mbPerSec, (double)this.totalLatency / (double)this.count, (double)this.maxLatency, percs[0], percs[1], percs[2], percs[3]);
        }

        private static int[] percentiles(int[] latencies, int count, double ... percentiles) {
            int size = Math.min(count, latencies.length);
            Arrays.sort(latencies, 0, size);
            int[] values = new int[percentiles.length];
            for (int i = 0; i < percentiles.length; ++i) {
                int index = (int)(percentiles[i] * (double)size);
                values[i] = latencies[index];
            }
            return values;
        }
    }
}

