/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

public class ThroughputThrottler {
    private static final long NS_PER_MS = 1000000L;
    private static final long NS_PER_SEC = 1000000000L;
    private static final long MIN_SLEEP_NS = 2000000L;
    long sleepTimeNs;
    long sleepDeficitNs = 0L;
    long targetThroughput = -1L;
    long startMs;

    public ThroughputThrottler(long targetThroughput, long startMs) {
        this.startMs = startMs;
        this.targetThroughput = targetThroughput;
        this.sleepTimeNs = targetThroughput > 0L ? 1000000000L / targetThroughput : Long.MAX_VALUE;
    }

    public boolean shouldThrottle(long amountSoFar, long sendStartMs) {
        if (this.targetThroughput < 0L) {
            return false;
        }
        float elapsedMs = (float)(sendStartMs - this.startMs) / 1000.0f;
        return elapsedMs > 0.0f && (float)amountSoFar / elapsedMs > (float)this.targetThroughput;
    }

    public void throttle() {
        block6: {
            if (this.targetThroughput == 0L) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            this.sleepDeficitNs += this.sleepTimeNs;
            if (this.sleepDeficitNs >= 2000000L) {
                long sleepMs = this.sleepDeficitNs / 1000000L;
                long sleepNs = this.sleepDeficitNs - sleepMs * 1000000L;
                long sleepStartNs = System.nanoTime();
                try {
                    Thread.sleep(sleepMs, (int)sleepNs);
                    this.sleepDeficitNs = 0L;
                }
                catch (InterruptedException e) {
                    long sleepElapsedNs = System.nanoTime() - sleepStartNs;
                    if (sleepElapsedNs > this.sleepDeficitNs) break block6;
                    this.sleepDeficitNs -= sleepElapsedNs;
                }
            }
        }
    }
}

