/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminZkClientTest$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u000f\t\t\u0012\tZ7j]j[7\t\\5f]R$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001a\u0001\n\u0003q\u0012aB:feZ,'o]\u000b\u0002?A\u0019\u0001EK\u0017\u000f\u0005\u0005:cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0007\u0003\u0019a$o\\8u}%\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)S\u00059\u0001/Y2lC\u001e,'\"\u0001\u0014\n\u0005-b#aA*fc*\u0011\u0001&\u000b\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001a0\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fQ\u0002\u0001\u0019!C\u0001k\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\t1$\b\u0005\u00028q5\t\u0011&\u0003\u0002:S\t!QK\\5u\u0011\u001dY4'!AA\u0002}\t1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005?\u0005A1/\u001a:wKJ\u001c\b\u0005C\u0003@\u0001\u0011\u0005\u0003)\u0001\u0005uK\u0006\u0014Hi\\<o)\u00051\u0004F\u0001 C!\t\u0019\u0005*D\u0001E\u0015\t)e)A\u0003kk:LGOC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0012\u0013Q!\u00114uKJDQa\u0013\u0001\u0005\u0002\u0001\u000b1\u0004^3ti6\u000bg.^1m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bF\u0001&N!\t\u0019e*\u0003\u0002P\t\n!A+Z:u\u0011\u0015\t\u0006\u0001\"\u0001A\u0003U!Xm\u001d;U_BL7m\u0011:fCRLwN\\%o5.C#\u0001U'\t\u000bQ\u0003A\u0011\u0001!\u0002=Q,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ\u000e{G\u000e\\5tS>t\u0007FA*N\u0011\u00159\u0006\u0001\"\u0001A\u0003\u0005\"Xm\u001d;N_\u000e\\W\rZ\"p]\u000e,(O]3oiR{\u0007/[2De\u0016\fG/[8oQ\t1V\nC\u0003[\u0001\u0011\u0005\u0001)A\u000euKN$8i\u001c8dkJ\u0014XM\u001c;U_BL7m\u0011:fCRLwN\u001c\u0015\u000336CQ!\u0018\u0001\u0005\u0002\u0001\u000bQ\u0003^3tiR{\u0007/[2D_:4\u0017nZ\"iC:<W\r\u000b\u0002]\u001b\")\u0001\r\u0001C\u0001\u0001\u0006\u00193\u000f[8vY\u0012\u0004&o\u001c9bO\u0006$X\rR=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\bFA0N\u0011\u0015\u0019\u0007\u0001\"\u0001A\u0003m!Xm\u001d;C_>$8\u000f\u001e:ba\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jO\"\u0012!-\u0014\u0005\u0006M\u0002!\t\u0001Q\u0001\u0017i\u0016\u001cHoR3u\u0005J|7.\u001a:NKR\fG-\u0019;bg\"\u0012Q-\u0014")
public class AdminZkClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$1 = this.$outer.adminZkClient();
                String x$8 = "test";
                Map x$9 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))}));
                Properties x$10 = qual$1.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
                boolean x$11 = qual$1.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
                qual$1.createOrUpdateTopicPartitionAssignmentPathInZK(x$8, x$9, x$10, x$11);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$2 = this.$outer.adminZkClient();
                String x$12 = "test";
                Map x$13 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
                Properties x$14 = qual$2.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
                boolean x$15 = qual$2.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
                qual$2.createOrUpdateTopicPartitionAssignmentPathInZK(x$12, x$13, x$14, x$15);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        Map assignment2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminZkClient qual$3 = this.adminZkClient();
        String x$16 = "test";
        Map x$17 = assignment2;
        Properties x$18 = qual$3.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$19 = qual$3.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$3.createOrUpdateTopicPartitionAssignmentPathInZK(x$16, x$17, x$18, x$19);
        scala.collection.immutable.Map found = this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment2, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminZkClient qual$4 = this.adminZkClient();
        String x$20 = topic;
        Map x$21 = expectedReplicaAssignment;
        Properties x$22 = qual$4.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$23 = qual$4.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$4.createOrUpdateTopicPartitionAssignmentPathInZK(x$20, x$21, x$22, x$23);
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaMap = ((TraversableOnce)leaderForPartitionMap.keys().map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final String topic$1;

            public final Tuple2<Object, Seq<Object>> apply(int p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p)), (Object)this.$outer.zkClient().getReplicasForPartition(new TopicPartition(this.topic$1, p)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaMap.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaMap.size()).foreach$mVc$sp((Function1)new Serializable(this, expectedReplicaAssignment, actualReplicaMap){
            public static final long serialVersionUID = 0L;
            private final Map expectedReplicaAssignment$1;
            private final scala.collection.immutable.Map actualReplicaMap$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)this.expectedReplicaAssignment$1.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)this.actualReplicaMap$1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.actualReplicaMap$1 = actualReplicaMap$1;
            }
        });
        this.intercept((Function0)new Serializable(this, expectedReplicaAssignment, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final Map expectedReplicaAssignment$1;
            private final String topic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$5 = this.$outer.adminZkClient();
                String x$24 = this.topic$1;
                Map x$25 = this.expectedReplicaAssignment$1;
                Properties x$26 = qual$5.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
                boolean x$27 = qual$5.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
                qual$5.createOrUpdateTopicPartitionAssignmentPathInZK(x$24, x$25, x$26, x$27);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.topic$1 = topic$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminZkClient qual$6 = this.adminZkClient();
        String x$28 = topic;
        int x$29 = 3;
        int x$30 = 1;
        Properties x$31 = qual$6.createTopic$default$4();
        RackAwareMode x$32 = qual$6.createTopic$default$5();
        qual$6.createTopic(x$28, x$29, x$30, x$31, x$32);
        this.intercept((Function0)new Serializable(this, collidingTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final String collidingTopic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient qual$7 = this.$outer.adminZkClient();
                String x$33 = this.collidingTopic$1;
                int x$34 = 3;
                int x$35 = 1;
                Properties x$36 = qual$7.createTopic$default$4();
                RackAwareMode x$37 = qual$7.createTopic$default$5();
                qual$7.createTopic(x$33, x$34, x$35, x$36, x$37);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.collidingTopic$1 = collidingTopic$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }

    @Test
    public void testMockedConcurrentTopicCreation() {
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.topicExists(topic))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)zkMock.getAllTopicsInCluster()).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        EasyMock.replay((Object[])new Object[]{zkMock});
        AdminZkClient adminZkClient = new AdminZkClient(zkMock);
        this.intercept((Function0)new Serializable(this, topic, adminZkClient){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final AdminZkClient adminZkClient$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.adminZkClient$1.validateCreateOrUpdateTopic(this.topic$2, (Map)Map$.MODULE$.empty(), new Properties(), false);
            }
            {
                this.topic$2 = topic$2;
                this.adminZkClient$1 = adminZkClient$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test-concurrent-topic-creation";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this, topic, props){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final String topic$3;
            private final Properties props$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$AdminZkClientTest$$createTopic$1(this.topic$3, this.props$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.props$1 = props$1;
            }
        }, new Serializable(this, topic, props){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final String topic$3;
            private final Properties props$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$AdminZkClientTest$$createTopic$1(this.topic$3, this.props$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.props$1 = props$1;
            }
        }}))), (int)15000L);
    }

    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$10 = this.adminZkClient();
        String x$45 = topic;
        int x$46 = partitions;
        int x$47 = 1;
        Properties x$48 = this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$49 = qual$10.createTopic$default$5();
        qual$10.createTopic(x$45, x$46, x$47, x$48, x$49);
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        this.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assert.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig x$1) {
                return TestUtils$.MODULE$.createServer(x$1, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        long limit = 1000000L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString())})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString())})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)new Serializable(this, newLimit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final long newLimit$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                Properties configInZk = this.$outer.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()))).toInt());
                Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()))).toInt());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newLimit$1 = newLimit$1;
            }
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Client(), clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overriden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.apis().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.apis().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkClient());
        AdminZkClient qual$11 = this.adminZkClient();
        RackAwareMode.Disabled$ x$50 = RackAwareMode.Disabled$.MODULE$;
        Option x$51 = qual$11.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$11.getBrokerMetadatas((RackAwareMode)x$50, x$51);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$2) {
                return x$2.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$3) {
                return x$3.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        AdminZkClient qual$12 = this.adminZkClient();
        RackAwareMode.Safe$ x$52 = RackAwareMode.Safe$.MODULE$;
        Option x$53 = qual$12.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$12.getBrokerMetadatas((RackAwareMode)x$52, x$53);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$4) {
                return x$4.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$5) {
                return x$5.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;

            public final Seq<BrokerMetadata> apply() {
                AdminZkClient qual$13 = this.$outer.adminZkClient();
                RackAwareMode.Enforced$ x$54 = RackAwareMode.Enforced$.MODULE$;
                Option x$55 = qual$13.getBrokerMetadatas$default$2();
                return qual$13.getBrokerMetadatas((RackAwareMode)x$54, x$55);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$6) {
                return x$6.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(BrokerMetadata x$7) {
                return Option$.MODULE$.option2Iterable(x$7.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        AdminZkClient qual$14 = this.adminZkClient();
        String x$56 = "foo";
        int x$57 = numPartitions;
        int x$58 = 2;
        RackAwareMode.Safe$ x$59 = RackAwareMode.Safe$.MODULE$;
        Properties x$60 = qual$14.createTopic$default$4();
        qual$14.createTopic(x$56, x$57, x$58, x$60, (RackAwareMode)x$59);
        scala.collection.immutable.Map assignment2 = this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((long)numPartitions, (long)assignment2.size());
    }

    public final void kafka$admin$AdminZkClientTest$$createTopic$1(String topic$3, Properties props$1) {
        try {
            AdminZkClient qual$8 = this.adminZkClient();
            String x$38 = topic$3;
            int x$39 = 3;
            int x$40 = 1;
            Properties x$41 = props$1;
            RackAwareMode x$42 = qual$8.createTopic$default$5();
            qual$8.createTopic(x$38, x$39, x$40, x$41, x$42);
        }
        catch (TopicExistsException topicExistsException) {}
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$3}))).head();
        if (tuple2 != null) {
            scala.collection.immutable.Map partitionAssignment;
            scala.collection.immutable.Map map;
            scala.collection.immutable.Map partitionAssignment2 = map = (partitionAssignment = (scala.collection.immutable.Map)tuple2._2());
            Assert.assertEquals((long)3L, (long)partitionAssignment2.size());
            partitionAssignment2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, Seq<Object>> x0$1) {
                    Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int partition = tuple2._1$mcI$sp();
                        Seq replicas = (Seq)tuple2._2();
                        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected replication factor for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition)})), (long)1L, (long)replicas.size());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            Properties savedProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topic$3);
            Assert.assertEquals((Object)props$1, (Object)savedProps);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), ((Object)BoxesRunTime.boxToLong((long)retentionMs)).toString());
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    public final void kafka$admin$AdminZkClientTest$$checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Assert.assertTrue((boolean)actual.isEmpty());
        } else {
            Assert.assertEquals((Object)Predef$.MODULE$.refArrayOps((Object[])expected.split(",")).toSeq(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
        }
    }

    private final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$4, KafkaServer server$1) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, partitions$1, topic$4, server$1, messageSize, retentionMs, throttledLeaders, throttledFollowers, quotaManagerIsThrottled){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            private final int partitions$1;
            public final String topic$4;
            public final KafkaServer server$1;
            public final int messageSize$1;
            public final long retentionMs$1;
            public final String throttledLeaders$1;
            public final String throttledFollowers$1;
            public final boolean quotaManagerIsThrottled$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitions$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$1$1 $outer;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        TopicPartition tp = new TopicPartition(this.$outer.topic$4, part);
                        LogManager qual$9 = this.$outer.server$1.logManager();
                        TopicPartition x$43 = tp;
                        boolean x$44 = qual$9.getLog$default$2();
                        Option log2 = qual$9.getLog(x$43, x$44);
                        Assert.assertTrue((boolean)log2.isDefined());
                        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)this.$outer.retentionMs$1), (Object)((Log)log2.get()).config().retentionMs());
                        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.$outer.messageSize$1), (Object)((Log)log2.get()).config().maxMessageSize());
                        this.$outer.kafka$admin$AdminZkClientTest$$anonfun$$$outer().kafka$admin$AdminZkClientTest$$checkList$1(((Log)log2.get()).config().LeaderReplicationThrottledReplicas(), this.$outer.throttledLeaders$1);
                        this.$outer.kafka$admin$AdminZkClientTest$$anonfun$$$outer().kafka$admin$AdminZkClientTest$$checkList$1(((Log)log2.get()).config().FollowerReplicationThrottledReplicas(), this.$outer.throttledFollowers$1);
                        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.server$1.quotaManagers().leader().isThrottled(tp)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ AdminZkClientTest kafka$admin$AdminZkClientTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitions$1 = partitions$1;
                this.topic$4 = topic$4;
                this.server$1 = server$1;
                this.messageSize$1 = messageSize$1;
                this.retentionMs$1 = retentionMs$1;
                this.throttledLeaders$1 = throttledLeaders$1;
                this.throttledFollowers$1 = throttledFollowers$1;
                this.quotaManagerIsThrottled$1 = quotaManagerIsThrottled$1;
            }
        });
    }

    private final void checkConfig$2(long limit) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, limit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClientTest $outer;
            public final long limit$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.servers().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$2$1 $outer;

                    public final void apply(KafkaServer server) {
                        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().leader().upperBound());
                        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().follower().upperBound());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.limit$1 = limit$1;
            }
        });
    }

    public AdminZkClientTest() {
        RackAwareTest$class.$init$(this);
        this.servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

