/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001\u001d\u0011qbU5na2,g)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\u0014e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A\u0001T8oO\"1!\u0004\u0001Q\u0001\nY\tAC]3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005q\u0002CA\u0005 \u0013\t\u0001#BA\u0002J]RDaA\t\u0001!\u0002\u0013q\u0012A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\t\u000f\u0011\u0002!\u0019!C\u0001+\u0005)\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\bB\u0002\u0014\u0001A\u0003%a#\u0001\fsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:!\u0011\u001dA\u0003A1A\u0005\u0002%\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005kRLGNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#A\u0003)s_B,'\u000f^5fg\"11\u0007\u0001Q\u0001\n)\n\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\t\u000fU\u0002!\u0019!C\u0001m\u000591m\u001c8gS\u001e\u001cX#A\u001c\u0011\u0007aZT(D\u0001:\u0015\tQ$\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001P\u001d\u0003\u0007M+\u0017\u000f\u0005\u0002\u0013}%\u0011qH\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004B\u0001\u0001\u0006IaN\u0001\tG>tg-[4tA!91\t\u0001b\u0001\n\u0003!\u0015\u0001\u0002;j[\u0016,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\tQ!\u001e;jYNL!AS$\u0003\u00115{7m\u001b+j[\u0016Da\u0001\u0014\u0001!\u0002\u0013)\u0015!\u0002;j[\u0016\u0004\u0003b\u0002(\u0001\u0005\u0004%\taT\u0001\b[\u0016$(/[2t+\u0005\u0001\u0006CA)[\u001b\u0005\u0011&B\u0001(T\u0015\t!V+\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bYS!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111L\u0015\u0002\b\u001b\u0016$(/[2t\u0011\u0019i\u0006\u0001)A\u0005!\u0006AQ.\u001a;sS\u000e\u001c\b\u0005C\u0004`\u0001\t\u0007I\u0011A\u000b\u0002\u00131,\u0017\rZ3s\u0019\u0016{\u0005BB1\u0001A\u0003%a#\u0001\u0006mK\u0006$WM\u001d'F\u001f\u0002Bqa\u0019\u0001C\u0002\u0013\u0005Q#A\u0006g_2dwn^3s\u0019\u0016{\u0005BB3\u0001A\u0003%a#\u0001\u0007g_2dwn^3s\u0019\u0016{\u0005\u0005C\u0004h\u0001\t\u0007I\u0011A\u000f\u0002\u0017A\f'\u000f^5uS>t\u0007j\u0016\u0005\u0007S\u0002\u0001\u000b\u0011\u0002\u0010\u0002\u0019A\f'\u000f^5uS>t\u0007j\u0016\u0011\t\u000f-\u0004!\u0019!C\u0001;\u0005Ia-\u001a;dQNK'0\u001a\u0005\u0007[\u0002\u0001\u000b\u0011\u0002\u0010\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0004p\u0001\t\u0007I\u0011\u00019\u0002\u0015I,7m\u001c:e)>Du+F\u0001r!\t\u0011X/D\u0001t\u0015\t!8+\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003mN\u0014AbU5na2,'+Z2pe\u0012Da\u0001\u001f\u0001!\u0002\u0013\t\u0018a\u0003:fG>\u0014H\rV8I/\u0002BqA\u001f\u0001C\u0002\u0013\u0005\u0001/A\u0006sK\u000e|'\u000f\u001a+p\u0019\u0016{\u0005B\u0002?\u0001A\u0003%\u0011/\u0001\u0007sK\u000e|'\u000f\u001a+p\u0019\u0016{\u0005\u0005C\u0004\u007f\u0001\t\u0007I\u0011A@\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da&\u0001\u0003mC:<\u0017\u0002BA\u0006\u0003\u000b\u0011aa\u0015;sS:<\u0007\u0002CA\b\u0001\u0001\u0006I!!\u0001\u0002\rQ|\u0007/[2!\u0011!\t\u0019\u0002\u0001b\u0001\n\u0003i\u0012a\u00039beRLG/[8o\u0013\u0012Dq!a\u0006\u0001A\u0003%a$\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007\u0005C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0001\u0002\u001e\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u0010!\u0011\t\t#a\t\u000e\u0003MK1!!\nT\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"!\u000b\u0001A\u0003%\u0011qD\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u0011qF\u0001\nM\u0016$8\r[%oM>,\"!!\r\u0011\taZ\u00141\u0007\t\b\u0013\u0005U\u0012qDA\u001d\u0013\r\t9D\u0003\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005m\u0012q\f\b\u0005\u0003{\tIF\u0004\u0003\u0002@\u0005Uc\u0002BA!\u0003'rA!a\u0011\u0002R9!\u0011QIA(\u001d\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&\r\u00051AH]8pizJ\u0011!W\u0005\u0003/bK!!\u0002,\n\u0005Q+\u0016bAA,'\u0006A!/Z9vKN$8/\u0003\u0003\u0002\\\u0005u\u0013\u0001\u0004$fi\u000eD'+Z9vKN$(bAA,'&!\u0011\u0011MA2\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u00111LA/\u0011!\t9\u0007\u0001Q\u0001\n\u0005E\u0012A\u00034fi\u000eD\u0017J\u001c4pA!Y\u00111\u000e\u0001A\u0002\u0003\u0007I\u0011AA7\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!a\u001c\u0011\u0007I\t\t(C\u0002\u0002t\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0006\u0002x\u0001\u0001\r\u00111A\u0005\u0002\u0005e\u0014A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!a\u001f\u0002\u0002B\u0019\u0011\"! \n\u0007\u0005}$B\u0001\u0003V]&$\bBCAB\u0003k\n\t\u00111\u0001\u0002p\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005\u001d\u0005\u0001)Q\u0005\u0003_\nqB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\t\u0005\b\u0003\u0017\u0003A\u0011AAG\u0003\u0015\u0019X\r^+q)\t\tY\b\u000b\u0003\u0002\n\u0006E\u0005\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]\u0005,A\u0003kk:LG/\u0003\u0003\u0002\u001c\u0006U%A\u0002\"fM>\u0014X\rC\u0004\u0002 \u0002!\t!!$\u0002\u0011Q,\u0017M\u001d#po:DC!!(\u0002$B!\u00111SAS\u0013\u0011\t9+!&\u0003\u000b\u00053G/\u001a:\t\u000f\u0005-\u0006\u0001\"\u0001\u0002\u000e\u0006yA/Z:u%\u0016\fGM\u0012:p[2{w\r\u000b\u0003\u0002*\u0006=\u0006\u0003BAJ\u0003cKA!a-\u0002\u0016\n!A+Z:u\u0001")
public class SimpleFetchTest {
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final long replicaLagMaxMessages;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final MockTime time;
    private final Metrics metrics;
    private final long leaderLEO;
    private final long followerLEO;
    private final int partitionHW;
    private final int fetchSize;
    private final SimpleRecord recordToHW;
    private final SimpleRecord recordToLEO;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo;
    private ReplicaManager replicaManager;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public long leaderLEO() {
        return this.leaderLEO;
    }

    public long followerLEO() {
        return this.followerLEO;
    }

    public int partitionHW() {
        return this.partitionHW;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public SimpleRecord recordToHW() {
        return this.recordToHW;
    }

    public SimpleRecord recordToLEO() {
        return this.recordToLEO;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        EasyMock.replay((Object[])new Object[]{scheduler});
        Log log2 = (Log)EasyMock.createNiceMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLEO())).anyTimes();
        EasyMock.expect((Object)log2.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        EasyMock.expect((Object)log2.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(this.leaderLEO(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log2.read(0L, this.fetchSize(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)this.partitionHW())), true, IsolationLevel.READ_UNCOMMITTED)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.recordToHW()}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log2.read(0L, this.fetchSize(), (Option)None$.MODULE$, true, IsolationLevel.READ_UNCOMMITTED)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.recordToLEO()}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log2});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(this.topicPartition(), false)).andReturn((Object)new Some((Object)log2)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        Partition partition = this.replicaManager().getOrCreatePartition(new TopicPartition(this.topic(), this.partitionId()));
        Replica leaderReplica = new Replica(((KafkaConfig)this.configs().head()).brokerId(), partition.topicPartition(), (Time)this.time(), 0L, (Option)new Some((Object)log2));
        leaderReplica.highWatermark_$eq(new LogOffsetMetadata((long)this.partitionHW(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderReplica.brokerId())));
        Replica followerReplica = new Replica(((KafkaConfig)this.configs().apply(1)).brokerId(), partition.topicPartition(), (Time)this.time(), Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
        LogOffsetMetadata leo = new LogOffsetMetadata(this.followerLEO(), 0L, (int)this.followerLEO());
        followerReplica.updateLogReadResult(new LogReadResult(new FetchDataInfo(leo, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leo.messageOffset(), 0L, leo.messageOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
        List allReplicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica, followerReplica}));
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica replica) {
                return this.partition$1.addReplicaIfNotExists(replica);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq(allReplicas.toSet());
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testReadFromLog() {
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        long initialTopicCount = brokerTopicStats.topicStats(this.topic()).totalFetchRequestRate().count();
        long initialAllTopicsCount = brokerTopicStats.allTopicsStats().totalFetchRequestRate().count();
        Option readCommittedRecords = this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, true, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, IsolationLevel.READ_UNCOMMITTED).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$2) {
                Object object = x$2._1();
                TopicPartition topicPartition = this.$outer.topicPartition();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Record firstReadRecord = (Record)((LogReadResult)((Tuple2)readCommittedRecords.get())._2()).info().records().records().iterator().next();
        Assert.assertEquals((String)"Reading committed data should return messages only up to high watermark", (Object)this.recordToHW(), (Object)new SimpleRecord(firstReadRecord));
        Option readAllRecords = this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, false, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, IsolationLevel.READ_UNCOMMITTED).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$3) {
                Object object = x$3._1();
                TopicPartition topicPartition = this.$outer.topicPartition();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Record firstRecord = (Record)((LogReadResult)((Tuple2)readAllRecords.get())._2()).info().records().records().iterator().next();
        Assert.assertEquals((String)"Reading any data can return messages up to the end of the log", (Object)this.recordToLEO(), (Object)new SimpleRecord(firstRecord));
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialTopicCount + 2L), (long)brokerTopicStats.topicStats(this.topic()).totalFetchRequestRate().count());
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialAllTopicsCount + 2L), (long)brokerTopicStats.allTopicsStats().totalFetchRequestRate().count());
    }

    public SimpleFetchTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.replicaLagMaxMessages = 10L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.leaderLEO = 20L;
        this.followerLEO = 15L;
        this.partitionHW = 5;
        this.fetchSize = 100;
        this.recordToHW = new SimpleRecord("recordToHW".getBytes());
        this.recordToLEO = new SimpleRecord("recordToLEO".getBytes());
        this.topic = "test-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new FetchRequest.PartitionData(0L, 0L, this.fetchSize()))}));
    }
}

