/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.LinkedList;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.DelegationTokenCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenCommand$
implements Logging {
    public static final DelegationTokenCommand$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DelegationTokenCommand$();
    }

    private Logger logger$lzycompute() {
        DelegationTokenCommand$ delegationTokenCommand$ = this;
        synchronized (delegationTokenCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        DelegationTokenCommand.DelegationTokenCommandOptions opts = new DelegationTokenCommand.DelegationTokenCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Tool to create, renew, expire, or describe delegation tokens.");
        }
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.renewOpt(), opts.expiryOpt(), opts.describeOpt()}))).count((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final DelegationTokenCommand.DelegationTokenCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        });
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --create, --renew, --expire or --describe");
        }
        opts.checkArgs();
        AdminClient adminClient = this.createAdminClient(opts);
        int exitCode = 0;
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createToken(adminClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.renewOpt())) {
                    this.renewToken(adminClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.expiryOpt())) {
                    this.expireToken(adminClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeToken(adminClient, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing delegation token command : ").append((Object)throwable.getMessage()).toString());
                this.error((Function0<String>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final String apply() {
                        return Utils.stackTrace((Throwable)this.e$1);
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                exitCode = 1;
            }
        }
        finally {
            adminClient.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
    }

    public DelegationToken createToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        java.util.List renewerPrincipals = (java.util.List)this.getPrincipals(opts, opts.renewPrincipalsOpt()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LinkedList<KafkaPrincipal> apply() {
                return new LinkedList<KafkaPrincipal>();
            }
        });
        long maxLifeTimeMs = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.maxLifeTimeOpt())));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Calling create token operation with renewers :").append((Object)renewerPrincipals).append((Object)" , max-life-time-period :").append((Object)BoxesRunTime.boxToLong((long)maxLifeTimeMs)).toString());
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions().maxlifeTimeMs(maxLifeTimeMs).renewers(renewerPrincipals);
        CreateDelegationTokenResult createResult = adminClient.createDelegationToken(createDelegationTokenOptions);
        DelegationToken token = (DelegationToken)createResult.delegationToken().get();
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Created delegation token with tokenId : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{token.tokenInfo().tokenId()})));
        this.printToken((List<DelegationToken>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelegationToken[]{token})));
        return token;
    }

    public void printToken(List<DelegationToken> tokens) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"TOKENID", "HMAC", "OWNER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE"})));
        tokens.foreach((Function1)new Serializable(dateFormat){
            public static final long serialVersionUID = 0L;
            private final SimpleDateFormat dateFormat$1;

            public final void apply(DelegationToken token) {
                TokenInformation tokenInfo = token.tokenInfo();
                Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokenInfo.tokenId(), token.hmacAsBase64String(), tokenInfo.owner(), tokenInfo.renewersAsString(), this.dateFormat$1.format(BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp())), this.dateFormat$1.format(BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp())), this.dateFormat$1.format(BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp()))})));
                Predef$.MODULE$.println();
            }
            {
                this.dateFormat$1 = dateFormat$1;
            }
        });
    }

    private Option<java.util.List<KafkaPrincipal>> getPrincipals(DelegationTokenCommand.DelegationTokenCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? new Some(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final KafkaPrincipal apply(String s) {
                return SecurityUtils.parseKafkaPrincipal((String)s.trim());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).asJava()) : None$.MODULE$;
    }

    public long renewToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long renewTimePeriodMs = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.renewTimePeriodOpt())));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Calling renew token operation with hmac :").append((Object)hmac).append((Object)" , renew-time-period :").append((Object)BoxesRunTime.boxToLong((long)renewTimePeriodMs)).toString());
        RenewDelegationTokenResult renewResult = adminClient.renewDelegationToken(Base64.getDecoder().decode(hmac), new RenewDelegationTokenOptions().renewTimePeriodMs(renewTimePeriodMs));
        Long expiryTimeStamp = (Long)renewResult.expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Completed renew operation. New expiry date : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(expiryTimeStamp)})));
        return Predef$.MODULE$.Long2long(expiryTimeStamp);
    }

    public long expireToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long expiryTimePeriodMs = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.expiryTimePeriodOpt())));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Calling expire token operation with hmac :").append((Object)hmac).append((Object)" , expire-time-period : ").append((Object)BoxesRunTime.boxToLong((long)expiryTimePeriodMs)).toString());
        ExpireDelegationTokenResult expireResult = adminClient.expireDelegationToken(Base64.getDecoder().decode(hmac), new ExpireDelegationTokenOptions().expiryTimePeriodMs(expiryTimePeriodMs));
        Long expiryTimeStamp = (Long)expireResult.expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Completed expire operation. New expiry date : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(expiryTimeStamp)})));
        return Predef$.MODULE$.Long2long(expiryTimeStamp);
    }

    public List<DelegationToken> describeToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Option<java.util.List<KafkaPrincipal>> ownerPrincipals = this.getPrincipals(opts, opts.ownerPrincipalsOpt());
        if (ownerPrincipals.isEmpty()) {
            Predef$.MODULE$.println((Object)"Calling describe token operation for current user.");
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Calling describe token operation for owners :").append(ownerPrincipals.get()).toString());
        }
        DescribeDelegationTokenResult describeResult = adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners((java.util.List)ownerPrincipals.orNull(Predef$.MODULE$.$conforms())));
        List tokens = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)describeResult.delegationTokens().get()).asScala()).toList();
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Total number of tokens : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tokens.size())})));
        this.printToken((List<DelegationToken>)tokens);
        return tokens;
    }

    private AdminClient createAdminClient(DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Properties props = Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())));
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient.create((Properties)props);
    }

    private DelegationTokenCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

